/*
 * Wohnraumuhr 2 mit 4-stelliger 7-Segment-Anzeige und optionaler 2-stelliger 16-Segment-Anzeige, Scott-Falk Hhn, "tables.h"
 * Segment-Tabellen fr 7-Segment- und 16-Segment-Anzeigen, verschiedene Tabellen
 */

#ifndef TABLES_H_
#define TABLES_H_

// Konvertierungsliste fr 7-Segment-Anzeigen

const uint8_t seg7_list[] PROGMEM =
{
  // B7  B6  B5  B4  B3  B2  B1  B0
  // DP   g   f   e   d   c   b   a

  0b00000000, 0b00000000, 0b00000000, 0b01100011, 0b00000000, 0b00000000, 0b00000000, 0b00000000,   // Zeichen ' !"#$%&''   # ist Gradzeichen
  0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b01000000, 0b00000000, 0b00000000,   // Zeichen '()*+,-./'
  0b00111111, 0b00000110, 0b01011011, 0b01001111, 0b01100110, 0b01101101, 0b01111101, 0b00000111,   // Zeichen '01234567'
  0b01111111, 0b01101111, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b01010011,   // Zeichen '89:;<=>?'
  0b00000000, 0b01110111, 0b01111100, 0b00111001, 0b01011110, 0b01111001, 0b01110001, 0b00111101,   // Zeichen '@ABCDEFG'
  0b01110110, 0b00000110, 0b00001110, 0b00000000, 0b00111000, 0b00110111, 0b01010100, 0b00111111,   // Zeichen 'HIJKLMNO'
  0b01110011, 0b00000000, 0b01010000, 0b01101101, 0b01111000, 0b00111110, 0b00000000, 0b00000000,   // Zeichen 'PQRSTUVW'
  0b00000000, 0b01101110, 0b00000000, 0b00000000, 0b01011101, 0b00011101, 0b00000000, 0b00001000,   // Zeichen 'XYZ^_'
  0b00000000, 0b01110111, 0b01111100, 0b01011000, 0b01011110, 0b01111001, 0b01110001, 0b00111101,   // Zeichen '`abcdefg'
  0b01110100, 0b00000100, 0b00001110, 0b00000000, 0b00111000, 0b00110111, 0b01010100, 0b01011100,   // Zeichen 'hijklmno'
  0b01110011, 0b00000000, 0b01010000, 0b01101101, 0b01111000, 0b00011100, 0b00000000, 0b00000000,   // Zeichen 'pqrstuvw'
  0b00000000, 0b01101110, 0b00000000, 0b00000000, 0b01011101, 0b00011101, 0b00000000, 0b00000000,   // Zeichen 'xyz '
};

const uint8_t seg16_list[] PROGMEM =
{
  // B7  B6  B5  B4  B3  B2  B1  B0      B7  B6  B5  B4  B3  B2  B1  B0
  //  u   t   s   r   p   n   m   k       h   g   f   e   d   c   b   a

  0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b10001000, 0b10000111,   // Zeichen ' !"#'   # ist Gradzeichen
  0b00000000, 0b00000000, 0b11101110, 0b10011001, 0b00000000, 0b00000000, 0b00000000, 0b00000000,   // Zeichen '$%&''
  0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b11011101, 0b00000000, 0b10101010, 0b00000000,   // Zeichen '()*+'
  0b00000000, 0b00000000, 0b10001000, 0b00000000, 0b00000000, 0b00000000, 0b01000100, 0b00000000,   // Zeichen ',-./'
  0b00000000, 0b11111111, 0b00000000, 0b00001100, 0b10001000, 0b01110111, 0b10001000, 0b00111111,   // Zeichen '0123'
  0b10001000, 0b10001100, 0b10001000, 0b10111011, 0b10001000, 0b11111011, 0b00000000, 0b00001111,   // Zeichen '4567'
  0b10001000, 0b11111111, 0b10001000, 0b10111111, 0b00000000, 0b00000000, 0b00000000, 0b00000000,   // Zeichen '89:;'
  0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00101000, 0b00000111,   // Zeichen '<=>?'
  0b00101000, 0b11011111, 0b10001000, 0b11001111, 0b00101010, 0b00111111, 0b00000000, 0b11110011,   // Zeichen '@ABC'
  0b00100010, 0b00111111, 0b10001000, 0b11110011, 0b10001000, 0b11000011, 0b00001000, 0b11111011,   // Zeichen 'DEFG'
  0b10001000, 0b11001100, 0b00100010, 0b00110011, 0b00000000, 0b01111100, 0b10010100, 0b11000000,   // Zeichen 'HIJK'
  0b00000000, 0b11110000, 0b00100101, 0b11001100, 0b00010001, 0b11001100, 0b00000000, 0b11111111,   // Zeichen 'LMNO'
  0b10001000, 0b11000111, 0b00010000, 0b11111111, 0b10011000, 0b11000111, 0b10001000, 0b10111011,   // Zeichen 'PQRS'
  0b00100010, 0b00000011, 0b00000000, 0b11111100, 0b01000100, 0b11000000, 0b01010000, 0b11001100,   // Zeichen 'TUVW'
  0b01010101, 0b00000000, 0b00100101, 0b00000000, 0b01000100, 0b00110011, 0b10100000, 0b01110011,   // Zeichen 'XYZ'
  0b10001000, 0b01111011, 0b00000000, 0b01111011, 0b00000000, 0b00000000, 0b00000000, 0b00110000,   // Zeichen '^_'
  0b00000000, 0b00000000, 0b10100000, 0b01110000, 0b10001000, 0b11111000, 0b10001000, 0b01110000,   // Zeichen '`abc'
  0b10001000, 0b01111100, 0b10001000, 0b11110011, 0b10101010, 0b00000010, 0b00001000, 0b11111011,   // Zeichen 'defg'
  0b10001000, 0b11001000, 0b00100000, 0b00000000, 0b00000000, 0b01111100, 0b10010100, 0b11000000,   // Zeichen 'hijk'
  0b00000000, 0b11110000, 0b10101000, 0b01001000, 0b10001000, 0b01001000, 0b10001000, 0b01111000,   // Zeichen 'lmno'
  0b10001000, 0b11000111, 0b00010000, 0b11111111, 0b10000000, 0b01000000, 0b10001000, 0b10111011,   // Zeichen 'pqrs'
  0b10101010, 0b00010000, 0b00000000, 0b01111000, 0b01000000, 0b01000000, 0b01010000, 0b01001000,   // Zeichen 'tuvw'
  0b01010101, 0b00000000, 0b00100101, 0b00000000, 0b01000100, 0b00110011, 0b10100000, 0b01110011,   // Zeichen 'xyz'
  0b10001000, 0b01111011, 0b00000000, 0b01111011, 0b00001000, 0b11011111, 0b00000000, 0b00000000,   // Zeichen ' '
};

// Konvertierungtabelle fr Umlaute

const char conv_tab[] PROGMEM =
{
  // interner Kode, externer Kode

  0x7b, 'a', 'e',   // Zeichen ''
  0x7c, 'o', 'e',   // Zeichen ''
  0x7d, 'u', 'e',   // Zeichen ''
  0x7e, 's', 's',   // Zeichen ''
};

// Tagestabellen fr die Zeitzhlung, normale Jahre mit 365 Tagen und Schaltjahre mit 366 Tagen

const uint8_t daytab1[] PROGMEM = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
const uint8_t daytab2[] PROGMEM = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

// Matrix fr die Anzeigesteuerung, die 10 Werte jeder Zeile enthalten den Anzeigemodus zur Sekunde 0, 1, 2 bis 9

const uint8_t dispmatr[] PROGMEM =
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // Keine Anzeige des Datums, keine Sensorwerte vorhanden
  0, 0, 2, 2, 0, 0, 0, 2, 2, 0,   // Keine Anzeige des Datums, nur Sensorwert 1 anzeigen
  0, 0, 3, 3, 0, 0, 0, 3, 3, 0,   // Keine Anzeige des Datums, nur Sensorwert 2 anzeigen
  0, 0, 2, 2, 2, 3, 3, 3, 0, 0,   // Keine Anzeige des Datums, beide Sensorwerte anzeigen
  0, 0, 1, 1, 0, 0, 0, 1, 1, 0,   // Anzeige des Datums, keine Sensorwerte vorhanden
  0, 0, 1, 1, 1, 2, 2, 2, 0, 0,   // Anzeige des Datums, nur Sensor 1 anzeigen
  0, 0, 1, 1, 1, 3, 3, 3, 0, 0,   // Anzeige des Datums, nur Sensor 2 anzeigen
  0, 0, 1, 1, 2, 2, 3, 3, 0, 0,   // Anzeige des Datums, beide Sensorwerte anzeigen
};

// Helligkeitstabelle fr den Wert brithr

const uint8_t britab[] PROGMEM = { 1, 2, 3, 5, 8, 12, 17, 23, 30, 38, 47};

// Zeichenvorrat fr die Eingabe der Sensornamen, die Reihenfolge kann gendert werden
// einige Zeichen haben eine andere Darstellung:
//
// # -> Grad-Zeichen
// { -> 
// | -> 
// } -> 
// ~ -> 

const char charlist[] PROGMEM = " #%*+-/0123456789?@ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz{|}~";

// Scrolltext-Tabelle, enthlt die zum aktuellen Konfigurationsmodus passende Scrolltext-Nummer

const uint8_t scrtab[] PROGMEM = {72, 73, 74, 75, 76, 77, 78, 79, 80, 0, 0, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94};

#endif /* TABLES_H_ */
