/*
 * Wohnraumuhr 2 mit 4-stelliger 7-Segment-Anzeige und optionaler 2-stelliger 16-Segment-Anzeige, Scott-Falk Hhn, "interrupt.h"
 * Interrupt-Routinen
 */

#ifndef INTERRUPT_H_
#define INTERRUPT_H_

ISR(USART0_RX_vect, ISR_BLOCK)                                        // Zeichen ber USART0 empfangen, Routine nicht unterbrechbar
{
  usbbuff[usbwrite ++] = UDR0;                                        // empfangenes Zeichen auf Zeigerposition in den USB-RX-Puffer schreiben und Schreib-Zeiger erhhen
}

ISR(USART1_RX_vect, ISR_BLOCK)                                        // Zeichen ber RS-232 empfangen, Routine nicht unterbrechbar
{
  rxbuff[rxwrite ++] = UDR1;                                          // empfangenes Zeichen auf Zeigerposition in den RX-Puffer schreiben und Schreib-Zeiger erhhen
}

ISR(TIMER0_OVF_vect, ISR_BLOCK)                                       // Timer0: Overflow Interrupt, schaltet die Anzeige nach Ausgabe der Segmente ab (fr PWM-Steuerung), Routine nicht
{                                                                     // unterbrechbar, Takt: 1024Hz
  if (PINF & _BV(PINF4)) {                                            // wenn Invertierung der Anzeigestelle 1-4 ausgeschaltet ist
    PORTA = 0b11111111;                                               // Anzeigestelle 1 ausschalten
    PORTC = 0b11111111;                                               // Anzeigestelle 2 ausschalten
    PORTD |= 0b11111011;                                              // Anzeigestelle 3 ausschalten (auer Segment c)
    PORTE |= 0b11111100;                                              // Anzeigestelle 4 ausschalten (auer Segmente a-b)
    PORTG = 0b00000111;                                               // Anzeigestelle 3-4 ausschalten (nur Segmente c bzw. a-b)
    PORTB |= _BV(PINB0);                                              // Doppelpunkt ausschalten
  }
  else {                                                              // wenn Invertierung der Anzeigestelle 1-4 eingeschaltet ist
    PORTA = 0b00000000;                                               // Anzeigestelle 1 ausschalten
    PORTC = 0b00000000;                                               // Anzeigestelle 2 ausschalten
    PORTD &= 0b00000100;                                              // Anzeigestelle 3 ausschalten (auer Segment c)
    PORTE &= 0b00000011;                                              // Anzeigestelle 4 ausschalten (auer Segmente a-b)
    PORTG = 0b00000000;                                               // Anzeigestelle 3-4 ausschalten (nur Segmente c bzw. a-b)
    PORTB &= ~_BV(PINB0);                                             // Doppelpunkt ausschalten
  }
  if (PINF & _BV(PINF5)) {                                            // wenn Invertierung der Anzeigestelle 5-6 ausgeschaltet ist
    PORTF = (PORTF & 0b00111111) | _BV(PINF6) | _BV(PINF7);           // Dezimalpunkte der Anzeigestellen 5-6 ausschalten
  }
  else {                                                              // wenn Invertierung der Anzeigestelle 5-6 eingeschaltet ist
    PORTF &= 0b00111111;                                              // Dezimalpunkte der Anzeigestellen 5-6 ausschalten
  }
  PORTB |= _BV(PINB3);                                                // Anzeigestellen 5 und 6 ausschalten (ENA auf High setzen)
  TIMSK &= ~_BV(TOV0);                                                // Timer0: Overflow Interrupt wieder deaktivieren
}

ISR(TIMER1_COMPA_vect, ISR_BLOCK)                                     // Timer1 Output Compare A Match Interrupt, Ausgabe der Segmentbelegung an die Anzeige
{
  uint8_t i;                                                          // Zhlervariable
  uint8_t j;                                                          // Zhlervariable
  uint8_t s;                                                          // Zwischenspeicher fr Segmentbelegung
  uint8_t a;                                                          // Zwischenspeicher fr PortA
  uint8_t b;                                                          // Zwischenspeicher fr PortB
  uint8_t c;                                                          // Zwischenspeicher fr PortC
  uint8_t d;                                                          // Zwischenspeicher fr PortD
  uint8_t e;                                                          // Zwischenspeicher fr PortE
  uint8_t f;                                                          // Zwischenspeicher fr PortF
  uint8_t g;                                                          // Zwischenspeicher fr PortG

                                                                      // --- zuerst serielle Daten an Sekunden-Anzeige ausgeben ---
  if (dispactv) {                                                     // wenn Anzeige aktiv ist
    for (j = 7; j > 3; j --) {                                        // Segmentbelegungen fr die Anzeigestellen 5-6 ausgeben, 4 Bytes in umgekehrter Reihenfolge
      s = segbuf[j];                                                  // Segment-Byte holen
      if (!(PINF & _BV(PINF5))) s = ~s;                               // wenn Invertierung der Anzeigestelle 5-6 eingeschaltet ist -> Segment-Byte invertieren
      for (i = 0; i < 8; i ++) {                                      // 8 Bits seriell ausgeben
        PORTB = (PORTB & ~_BV(PINB4)) | ((s > 127) << 4);             // aktuellen Status von PortB lesen und MSB des Segment-Bytes einfgen
        PORTB |= _BV(PINB5);                                          // Takt fr Schieberegister (SCK) auf High setzen
        PORTB &= ~_BV(PINB5);                                         // Takt fr Schieberegister (SCK) wieder auf Low setzen
        s += s;                                                       // Segment-Byte verdoppeln (nchstes Bit verschiebt sich an MSB-Stelle)
      }
    }
    PORTB |= _BV(PINB6);                                              // Takt fr Datenbernahme des Schieberegisters (RCK) auf High setzen
    PORTB &= ~_BV(PINB6);                                             // Takt fr Datenbernahme des Schieberegisters (RCK) wieder auf Low setzen
    if (PINF & _BV(PINF5)) {                                                    // wenn Invertierung der Anzeigestelle 5-6 ausgeschaltet ist
      f = (PORTF & 0b00111111) | !dots[4] * _BV(PINF6) | !dots[5] * _BV(PINF7); // Dezimalpunkte der Anzeigestellen 5-6 vorbereiten
    }
    else {                                                                      // wenn Invertierung der Anzeigestelle 5-6 eingeschaltet ist
      f = (PORTF & 0b00111111) | dots[4] * _BV(PINF6) | dots[5] * _BV(PINF7);   // Dezimalpunkte der Anzeigestellen 5-6 vorbereiten
    }
  }
  else {                                                              // wenn Anzeige nicht aktiv ist
    if (!(PORTB & _BV(PINB2))) {                                      // wenn LED-Spannung noch eingeschaltet ist
      if (PINF & _BV(PINF5)) PORTB |= _BV(PINB4);                     // wenn Invertierung der Anzeigestelle 5-6 ausgeschaltet ist -> serielle Datenleitung auf High setzen (1-Bit)
      else PORTB &= ~_BV(PINB4);                                      // wenn Invertierung der Anzeigestelle 5-6 eingeschaltet ist -> serielle Datenleitung auf Low setzen (0-Bit)
      for (i = 0; i < 32; i ++) {                                     // 32 Bits seriell ausgeben
        PORTB |= _BV(PINB5);                                          // Takt fr Schieberegister (SCK) auf High setzen
        PORTB &= ~_BV(PINB5);                                         // Takt fr Schieberegister (SCK) wieder auf Low setzen
      }
      PORTB |= _BV(PINB6);                                            // Takt fr Datenbernahme des Schieberegisters (RCK) auf High setzen
      PORTB &= ~_BV(PINB6);                                           // Takt fr Datenbernahme des Schieberegisters (RCK) wieder auf Low setzen
    }
    if (PINF & _BV(PINF5)) {                                          // wenn Invertierung der Anzeigestelle 5-6 ausgeschaltet ist
      f = (PORTF & 0b01111111) | dcflstat * _BV(PINF7);               // Dezimalpunkt der Anzeigestelle 6 lschen und DCF77-Status ber den Dezimalpunkt der Anzeigestelle 6 vorbereiten
    }
    else {                                                            // wenn Invertierung der Anzeigestelle 5-6 eingeschaltet ist
      f = (PORTF & 0b01111111) | !dcflstat * _BV(PINF7);              // Dezimalpunkt der Anzeigestelle 6 lschen und DCF77-Status ber den Dezimalpunkt der Anzeigestelle 6 vorbereiten
    }
  }
                                                                      // --- Portausgaben fr Stunden- und Minuten-Anzeige vorbereiten ---
  if (dispactv) {                                                     // wenn Anzeige aktiv ist
    if (PINF & _BV(PINF4)) {                                          // wenn Invertierung der Anzeigestellen 1-4 ausgeschaltet ist
      a = segbuf[0] | !dots[0] * _BV(PINA7);                          // Segmentbelegung fr Anzeigestelle 1 inklusive Dezimalpunkt vorbereiten
      c = segbuf[1] | !dots[1] * _BV(PINC7);                                       // Segmentbelegung fr Anzeigestelle 2 inklusive Dezimalpunkt vorbereiten
      d = (PORTD & 0b00000100) | (segbuf[2] & 0b11111011) | !dots[2] * _BV(PIND7); // Segmentbelegung fr Anzeigestelle 3 inklusive Dezimalpunkt vorbereiten (auer Segment c)
      e = (PORTE & 0b00000011) | (segbuf[3] & 0b11111100) | !dots[3] * _BV(PINE7); // Segmentbelegung fr Anzeigestelle 4 inklusive Dezimalpunkt vorbereiten (auer Segmente a-b)
      g = (segbuf[2] & 0b00000100) | (segbuf[3] & 0b00000011);                     // Segmentbelegung fr Anzeigestellen 3-4 vorbereiten (nur Segmente c bzw. a-b)
      b = (PORTB & ~_BV(PINB0)) | !dots[6] * _BV(PINB0);              // Doppelpunkt vorbereiten
    }
    else {                                                            // wenn Invertierung der Anzeigestellen 1-4 eingeschaltet ist
      a = (~segbuf[0] & 0x7f) | dots[0] * _BV(PINA7);                 // Segmentbelegung fr Anzeigestelle 1 inklusive Dezimalpunkt vorbereiten
      c = (~segbuf[1] & 0x7f) | dots[1] * _BV(PINC7);                              // Segmentbelegung fr Anzeigestelle 2 inklusive Dezimalpunkt vorbereiten
      d = (PORTD & 0b00000100) | (~segbuf[2] & 0b01111011) | dots[2] * _BV(PIND7); // Segmentbelegung fr Anzeigestelle 3 inklusive Dezimalpunkt vorbereiten (auer Segment c)
      e = (PORTE & 0b00000011) | (~segbuf[3] & 0b01111100) | dots[3] * _BV(PINE7); // Segmentbelegung fr Anzeigestelle 4 inklusive Dezimalpunkt vorbereiten (auer Segmente a-b)
      g = (~segbuf[2] & 0b00000100) | (~segbuf[3] & 0b00000011);                   // Segmentbelegung fr Anzeigestellen 3-4 vorbereiten (nur Segmente c bzw. a-b)
      b = (PORTB & ~_BV(PINB0)) | dots[6] * _BV(PINB0);               // Doppelpunkt vorbereiten
    }
  }
  else {                                                              // wenn Anzeige inaktiv ist
    if (PINF & _BV(PINF4)) {                                          // wenn Invertierung der Anzeigestellen 1-4 ausgeschaltet ist
      a = 0b11111111;                                                 // Anzeigestelle 1 ausschalten (vorbereiten)
      c = 0b11111111;                                                 // Anzeigestelle 2 ausschalten (vorbereiten)
      d = PORTD | 0b11111011;                                         // Anzeigestelle 3 ausschalten (vorbereiten, auer Segment c)
      e = PORTE | 0b11111100;                                         // Anzeigestelle 4 ausschalten (vorbereiten, auer Segmente a-b)
      g = 0b00000111;                                                 // Anzeigestelle 3-4 ausschalten (vorbereiten, nur Segmente c bzw. a-b)
      b = PORTB | _BV(PINB0);                                         // Doppelpunkt ausschalten (vorbereiten)
    }
    else {                                                            // wenn Invertierung der Anzeigestellen 1-4 eingeschaltet ist
      a = 0b00000000;                                                 // Anzeigestelle 1 ausschalten (vorbereiten)
      c = 0b00000000;                                                 // Anzeigestelle 2 ausschalten (vorbereiten)
      d = PORTD & 0b00000100;                                         // Anzeigestelle 3 ausschalten (vorbereiten, auer Segment c)
      e = PORTE & 0b00000011;                                         // Anzeigestelle 4 ausschalten (vorbereiten, auer Segmente a-b)
      g = 0b00000000;                                                 // Anzeigestelle 3-4 ausschalten (vorbereiten, nur Segmente c bzw. a-b)
      b = PORTB & ~_BV(PINB0);                                        // Doppelpunkt ausschalten (vorbereiten)
    }
  }
                                                                      // --- erst jetzt vorbereitete LED-Daten ausgeben ---
  PORTA = a;                                                          // vorbereitete Segmentbelegung an PORTA ausgeben
  PORTC = c;                                                          // vorbereitete Segmentbelegung an PORTC ausgeben
  PORTD = d;                                                          // vorbereitete Segmentbelegung an PORTD ausgeben
  PORTE = e;                                                          // vorbereitete Segmentbelegung an PORTE ausgeben
  PORTG = g;                                                          // vorbereitete Segmentbelegung an PORTG ausgeben
  PORTB = b;                                                          // vorbereitete Segmentbelegung an PORTB ausgeben
  PORTF = f;                                                          // vorbereitete Segmentbelegung an PORTF ausgeben
  PORTB &= ~_BV(PINB3);                                               // Anzeigestellen 5 und 6 einschalten (ENA auf Low setzen)
  if (dispactv) PORTB &= ~_BV(PINB2);                                 // wenn Anzeige aktiv -> LED-Spannung einschalten
  else PORTB |= _BV(PINB2);                                           // sonst LED-Spannung ausschalten

                                                                      // --- PWM-Helligkeitssteuerung ---
  if (bright > 23) {                                                  // wenn Helligkeitswert > 23 -> Leuchtdauer der Anzeige wird durch Timer0 gesteuert
    SFIOR = _BV(PSR0);                                                // Timer0, Vorteiler zurcksetzen
    if (bright < 32) {                                                // wenn Helligkeitswert < 32
      TCCR0 = _BV(CS01) | _BV(CS00);                                  // Timer0, Mode 0, Vorteiler = 32
      TCNT0 = 17 - bright;                                            // Durchschnittswert von 273 subtrahieren und als Zhler fr Timer0 setzen (bertrag wird ignoriert)
    }
    else {                                                            // wenn Helligkeitswert > 31
      TCCR0 = _BV(CS02);                                              // Timer0, Mode 0, Vorteiler = 64
      TCNT0 = 24 - bright;                                            // Durchschnittswert von 280 subtrahieren und als Zhler fr Timer0 setzen (bertrag wird ignoriert)
    }      
    TIMSK |= _BV(TOIE0);                                              // Timer0 Overflow Interrupt aktivieren 
    TIFR = _BV(TOV0);                                                 // Timer0 Overflow Interrupt Flag lschen
  }
  else {                                                              // wenn Helligkeitswert < 24 -> Leuchtdauer der Anzeige wird direkt gesteuert
    switch(bright) {                                                  // weiterer Programmablauf ist vom Heligkeitswert abhngig
      case 0 ... 3:                                                   // wenn Helligkeitswert im Bereich von 0-3
        for (i = 0; i < bright; i ++) {                               // Warteschleife
          asm volatile ("nop");                                       // ASM-NOP fr Zeitverzgerung
        }
        break;
      case 4 ... 11:                                                  // wenn Helligkeitswert im Bereich von 4-11
        for (i = 2; i < bright; i ++) {                               // Warteschleife
          asm volatile ("nop");                                       // ASM-NOPs fr Zeitverzgerung
          asm volatile ("nop");
          asm volatile ("nop");
          asm volatile ("nop");
        }
        break;
      case 12 ... 23:                                                 // wenn Helligkeitswert im Bereich von 12-23
        for (i = 5; i < bright; i ++) {                               // Warteschleife
          asm volatile ("nop");                                       // ASM-NOPs fr Zeitverzgerung
          asm volatile ("nop");
          asm volatile ("nop");
          asm volatile ("nop");
          asm volatile ("nop");
          asm volatile ("nop");
          asm volatile ("nop");
          asm volatile ("nop");
          asm volatile ("nop");
        }
        break;
    }                                                                 // nach Wartezeit...
    if (PINF & _BV(PINF4)) {                                          // wenn Invertierung der Anzeigestelle 1-4 ausgeschaltet ist
      PORTA = 0b11111111;                                             // Anzeigestelle 1 ausschalten
      PORTC = 0b11111111;                                             // Anzeigestelle 2 ausschalten
      PORTD |= 0b11111011;                                            // Anzeigestelle 3 ausschalten (auer Segment c)
      PORTE |= 0b11111100;                                            // Anzeigestelle 4 ausschalten (auer Segmente a-b)
      PORTG = 0b00000111;                                             // Anzeigestelle 3-4 ausschalten (nur Segmente c bzw. a-b)
      PORTB |= _BV(PINB0);                                            // Doppelpunkt ausschalten
    }
    else {                                                            // wenn Invertierung der Anzeigestelle 1-4 eingeschaltet ist
      PORTA = 0b00000000;                                             // Anzeigestelle 1 ausschalten
      PORTC = 0b00000000;                                             // Anzeigestelle 2 ausschalten
      PORTD &= 0b00000100;                                            // Anzeigestelle 3 ausschalten (auer Segment c)
      PORTE &= 0b00000011;                                            // Anzeigestelle 4 ausschalten (auer Segmente a-b)
      PORTG = 0b00000000;                                             // Anzeigestelle 3-4 ausschalten (nur Segmente c bzw. a-b)
      PORTB &= ~_BV(PINB0);                                           // Doppelpunkt ausschalten
    }
    if (PINF & _BV(PINF5)) {                                          // wenn Invertierung der Anzeigestelle 5-6 ausgeschaltet ist
      PORTF = (PORTF & 0b00111111) | _BV(PINF6) | _BV(PINF7);         // Dezimalpunkte der Anzeigestellen 5-6 ausschalten
    }
    else {                                                            // wenn Invertierung der Anzeigestelle 5-6 eingeschaltet ist
      PORTF &= 0b00111111;                                            // Dezimalpunkte der Anzeigestellen 5-6 ausschalten
    }
    PORTB |= _BV(PINB3);                                              // Anzeigestellen 5 und 6 ausschalten (ENA auf High setzen)
  }
}

ISR(TIMER3_COMPA_vect, ISR_NOBLOCK)                                   // Timer3 Output Compare A Match Interrupt, DCF77-Empfang, Zeitzhlung und Tasterabfage, Routine unterbrechbar, Takt: 50Hz / 20ms
{
  uint8_t bitval;                                                     // Wert eines empfangenen DCF77-Bits (0 oder 1)
  uint8_t dcfstat;                                                    // Zwischenspeicher fr DCF77-Status
  uint8_t dcftemp;                                                    // Zwischenspeicher fr die Bearbeitung der DCF77-Tabelle
  int8_t i;                                                           // Schleifenzhler
  uint8_t j;                                                          // Schleifenzhler
  uint8_t t;                                                          // Zwischenspeicher fr Tasterabfrage
  uint8_t mflag = 0;                                                  // Merker fr Monatswechsel lschen
  uint16_t h;                                                         // Summe fr Helligkeitsmittelwert-Berechnung

                                                                      // --- DCF77-Signal einlesen und bearbeiten ---
  dcfcnt ++;                                                          // DCF77-Zhler erhhen
  if (PINF & _BV(PINF3)) dcfstat = 1;                                 // wenn aktueller DCF77-Status = High -> Statuswert = 1 setzen
  else dcfstat = 0;                                                   // sonst Statuswert = 0 setzen
  if (dcfinv) dcfstat = 1 - dcfstat;                                  // wenn Invertierung aktiviert -> invertieren
  if (!dcflstat) {                                                    // wenn vorheriges DCF77-Signal Low
    if (dcfstat) {                                                    // wenn aktuelles DCF77-Signal High (entspricht Impuls-Start)
      if ((dcfcnt > 2) && (dcfcnt < 13)) {                            // wenn Impulslnge 60-260ms -> gltiger Impuls
        dcfimp ++;                                                    // Impulsanzahl erhhen
        if (dcfcnt > 7) bitval = 1;                                   // wenn Impulslnge > 140ms -> 1-Bit
        else bitval = 0;                                              // sonst -> 0-Bit
        for (i = 41; i >= 0; i --) {                                  // 42 Pufferbytes bearbeiten (von hinten beginnend)
          dcftemp = dcftab[i];                                        // Pufferbyte holen und merken
          dcftab[i] = bitval;                                         // neues Pufferbyte setzen
          bitval = dcftemp;                                           // bertrag fr nchstes Pufferbyte
        }
      }
    }
  }
  else {                                                              // wenn vorheriges DCF77-Signal High
    if (!dcfstat) {                                                   // wenn aktuelles DCF77-Signal Low (entspricht Impuls-Ende)
      if (dcfcnt > 75) dcfflag = 1;                                   // wenn Impulslnge > 1,5s -> neuer Minutenbeginn
      if (dcfcnt > 45) dcfcnt = 0;                                    // wenn Imuplslnge > 900ms -> Zhler auf 0 setzen
    }
  }
  dcflstat = dcfstat;                                                 // neuen DCF77-Status speichern

                                                                      // --- Helligkeitswert lesen, puffern und Mittelwert berechnen ---
  bribuf[bripos ++] = ADCH;                                           // neuen Helligkeitswert in Puffer schreiben, Position erhhen
  if (bripos > 127) bripos = 0;
  
  h = 0;                                                              // Summe lschen
  j = 0;                                                              // Positionszhler lschen
  do {                                                                // Schleife
    h += bribuf[j ++];                                                // Wert aus Puffer addieren, Position erhhen
  } while (j < 128);                                                  // solange das Pufferende noch nicht ereicht ist
  j = h >> 7;                                                         // 
  if (brmode && (dispmode < 4)) {                                     // wenn Helligkeitsmodus 1 (Verzgert) und normaler Anzeigemodus
    if (intcnt == 49) bright = j;                                     // wenn Interrupt-Zhler 49 (Sekundenwechsel) -> neuen Helligkeitswert setzen
  }
  else bright = j;                                                    // wenn Helligkeitsmodus = 0 (Direkt) -> neuen Helligkeitswert setzen
  if (bright >= pgm_read_byte(&britab[brithr])) dayflag = 1;          // wenn Tag-Helligkeit erreicht -> Tag-Flag setzen
  else dayflag = 0;                                                   // sonst Tag-Flag lschen

  if ((intcnt % 2) == 0) {                                            // wenn Interrupt-Zhler geradzahlig (Taster-Abfragen erfolgen alle 40ms)
                                                                      // --- Taster abfragen und auswerten ---
    t = ~PINF & _BV(PINF1);                                           // Status von Taster 1 lesen, invertieren und filtern
    if (t == t1sold) {                                                // wenn aktueller Status identisch mit Status beim letzten Interrupt
      if (t) {                                                        // wenn Taster 1 gedrckt
        t1stat = 1;                                                   // aktuellen Status auf "Gedrckt" setzen
        if (t1long < KEYLONG) t1long++;                               // wenn Endwert fr langen Tastendruck noch nicht erreicht -> Zhler erhhen
      }
      else {                                                          // wenn Taster 1 losgelassen
        t1stat = 0;                                                   // aktuellen Status auf "Losgelassen" setzen
        t1quit = 0;                                                   // Quittierungs-Status lschen
        t1long = 0;                                                   // Zhler fr langen Tastendruck lschen
      }
    }
    t1sold = t;                                                       // Status von Taster 1 fr nchsten Interrupt speichern

    t = ~PINF & _BV(PINF2);                                           // Status von Taster 2 lesen, invertieren und filtern
    if (t == t2sold) {                                                // wenn aktueller Status identisch mit Status beim letzten Interrupt
      if (t) {                                                        // wenn Taster 2 gedrckt
        t2stat = 1;                                                   // aktuellen Status auf "Gedrckt" setzen
        if (t2long < KEYLONG) t2long++;                               // wenn Endwert fr langen Tastendruck noch nicht erreicht -> Zhler erhhen
      }
      else {                                                          // wenn Taster 2 losgelassen
        t2stat = 0;                                                   // aktuellen Status auf "Losgelassen" setzen
        t2quit = 0;                                                   // Quittierungs-Status lschen
        t2long = 0;                                                   // Zhler fr langen Tastendruck lschen
      }
    }
    t2sold = t;                                                       // Status von Taster 2 fr nchsten Interrupt speichern
  }

  if (scrtxt) {                                                       // wenn ein Scrolltext ausgegeben werden soll
    scrcnt ++;                                                        // Scrollzhler erhhen
    if (scrcnt >= SCROLLT) {                                          // wenn Endwert des Scrollzhlers erreicht
      scrcnt = 0;                                                     // Scrollzhler wieder auf 0 setzen
      scrpos ++;                                                      // auf nchste Zeichenposition setzen
    }
  }

  intcnt ++;                                                          // Interrupt-Zhler erhhen
  if (intcnt > 49) {                                                  // wenn Endwert berschritten
    intcnt = 0;                                                       // Interrupt-Zhler zurcksetzen

                                                                      // --- der folgende Abschnitt wird alle 1s (1Hz) ausgefhrt ---
    second ++;                                                        // Sekunden erhhen
    if ((second % 10) == 0) t10sflag = 1;                             // wenn neues 10s-Intervall beginnt -> 10s-Flag setzen
    if (second > 59) {                                                // wenn berlauf
      second = 0;                                                     // Sekunden zurcksetzen

                                                                      // --- der folgende Abschnitt wird alle 1min ausgefhrt ---
      minute ++;                                                      // Minuten erhhen
      if (minute > 59) {                                              // wenn berlauf
        minute = 0;                                                   // Minuten zurcksetzen
        hour ++;                                                      // Stunden erhhen
        if (autosumt) {                                               // wenn Sommerzeit-Automatik eingeschaltet
          if ((day > 24) && (wday == 7)) {                            // wenn Wechsel-Zeitraum und Sonntag
            if ((month == 3) && (hour == 2) && (timezone == 0)) {     // wenn Mrz, 2:00 Uhr und noch Normalzeit
              hour ++;                                                // eine Stunde vorstellen
              timezone = 1;                                           // Zeitzone auf MESZ setzen
              saveflag = 1;                                           // genderte Zeitzone speichern
            }
            if ((month == 10) && (hour == 3) && (timezone == 1)) {    // wenn Oktober, 3:00 Uhr und noch Sommerzeit
              hour --;                                                // eine Stunde zurckstellen
              timezone = 0;                                           // Zeitzone auf MEZ setzen
              saveflag = 1;                                           // genderte Zeitzone speichern
            }
          }
        }
        if (hour > 23) {                                              // wenn berlauf
          hour = 0;                                                   // Stunden zurcksetzen
          wday ++;                                                    // Wochentag erhhen
          if (wday > 7) wday = 1;                                     // wenn Wochentagberlauf -> Wochentag zurcksetzen
          day ++;                                                     // Tag erhhen
          if ((year % 4) == 0) {                                      // wenn Schaltjahr
            if (day > pgm_read_byte_far(&daytab2[month - 1])) mflag = 1; // wenn Tag > Schaltjahr-Tabelle -> Monatswechsel
          }
          else {                                                      // wenn kein Schaltjahr
            if (day > pgm_read_byte_far(&daytab1[month - 1])) mflag = 1; // wenn Tag > Normaljahr-Tabelle -> Monatswechsel
          }
          if (mflag) {                                                // wenn Monatswechsel erforderlich
            day = 1;                                                  // Tag zurcksetzen
            month ++;                                                 // Monat erhhen
            if (month > 12) {                                         // wenn berlauf
              month = 1;                                              // Monat zurcksetzen
              year ++;                                                // Jahr erhhen
            }
          }
        }
      }
    }
  }

  count1 ++;                                                          // frei laufenden Zhler 1 erhhen (Vorteiler)
  if (count1 > 49) {                                                  // wenn Endwert berschritten
    count1 = 0;                                                       // frei laufenden Zhler 1 zurcksetzen

                                                                      // --- der folgende Abschnitt wird alle 1s (1Hz) ausgefhrt ---
    if (vertout < 255) {                                              // wenn Versions-Timeout-Zhler aktiv
      if (vertout > 0) vertout --;                                    // wenn Versions-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
    }
    if (sentout1 < 255) {                                             // wenn Sensor-1-Timeout-Zhler aktiv
      if (sentout1 > 0) sentout1 --;                                  // wenn Sensor-1-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
    }
    if (sentout2 < 255) {                                             // wenn Sensor-2-Timeout-Zhler aktiv
      if (sentout2 > 0) sentout2 --;                                  // wenn Sensor-2-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
    }
    if (usbtout < 255) {                                              // wenn USB-Timeout-Zhler aktiv
      if (usbtout > 0) usbtout --;                                    // wenn USB-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
    }
    if (boottout < 255) {                                             // wenn Bootloader-Timeout-Zhler aktiv
      if (boottout > 0) boottout --;                                  // wenn Bootloader-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
    }
    if (conftout < 255) {                                             // wenn Konfigurations-Timeout-Zhler aktiv
      if (conftout > 0) conftout --;                                  // wenn Konfigurations-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
    }

    count2 ++;                                                        // frei laufenden Zhler 2 erhhen (Sekunden)
    if (count2 > 59) {                                                // wenn Endwert berschritten
      count2 = 0;                                                     // frei laufenden Zhler 2 zurcksetzen

                                                                      // --- der folgende Abschnitt wird alle 1min ausgefhrt ---
      if (dcftout < 255) {                                            // wenn DCF-Synchronisierungs-Timeout-Zhler aktiv
        if (dcftout > 0) dcftout --;                                  // wenn DCF-Synchronisierungs-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
      }
      count3 ++;                                                      // frei laufenden Zhler 3 erhhen (Minuten)
      if (count3 > 59) {                                              // wenn Endwert berschritten
        count3 = 0;                                                   // frei laufenden Zhler 3 zurcksetzen

                                                                      // --- der folgende Abschnitt wird alle 1h ausgefhrt ---
        if (synctout < 255) {                                         // wenn Synchronisierungs-Timeout-Zhler aktiv
          if (synctout > 0) synctout--;                               // wenn Synchronisierungs-Timeout-Zhler noch nicht abgelaufen -> Timeout-Zhler vermindern
        }
      }
    }
  }
}

#endif /* INTERRUPT_H_ */
