// Sound-Daten fr die Alarmton-Ausgabe im Flash-Speicher =============================================================================================================================================

// Frequenztabelle ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// enthlt 73 Notenwerte im Bereich von C bis c"" als 16-Bit-Werte mit einer Genauigkeit von 0,1Hz

const uint16_t freqdata_array[] PROGMEM =
{
   F_CPU*10/16/654-1,   F_CPU*10/16/693-1,   F_CPU*10/16/734-1,   F_CPU*10/16/778-1,    // C   Cis   D   Dis   (00-03)
   F_CPU*10/16/824-1,   F_CPU*10/16/873-1,   F_CPU*10/16/925-1,   F_CPU*10/16/980-1,    // E   F   Fis   G     (04-07)
   F_CPU*10/16/1038-1,  F_CPU*10/16/1100-1,  F_CPU*10/16/1165-1,  F_CPU*10/16/1235-1,   // Gis   A   Ais   H   (08-11)

   F_CPU*10/16/1308-1,  F_CPU*10/16/1386-1,  F_CPU*10/16/1468-1,  F_CPU*10/16/1556-1,   // c   cis   d   dis   (12-15)
   F_CPU*10/16/1648-1,  F_CPU*10/16/1746-1,  F_CPU*10/16/1850-1,  F_CPU*10/16/1960-1,   // e  f  fis  g        (16-19)
   F_CPU*10/16/2077-1,  F_CPU*10/16/2200-1,  F_CPU*10/16/2331-1,  F_CPU*10/16/2469-1,   // gis   a   ais   h   (20-23)

   F_CPU*10/16/2616-1,  F_CPU*10/16/2772-1,  F_CPU*10/16/2937-1,  F_CPU*10/16/3111-1,   // c'  cis'  d'  dis'  (24-27)
   F_CPU*10/16/3296-1,  F_CPU*10/16/3492-1,  F_CPU*10/16/3700-1,  F_CPU*10/16/3920-1,   // e'  f'  fis'  g'    (28-31)
   F_CPU*10/16/4153-1,  F_CPU*10/16/4400-1,  F_CPU*10/16/4662-1,  F_CPU*10/16/4939-1,   // gis'  a'  ais'  h'  (32-35)

   F_CPU*10/16/5233-1,  F_CPU*10/16/5544-1,  F_CPU*10/16/5873-1,  F_CPU*10/16/6223-1,   // c"  cis"  d"  dis"  (36-39)
   F_CPU*10/16/6593-1,  F_CPU*10/16/6985-1,  F_CPU*10/16/7400-1,  F_CPU*10/16/7840-1,   // e"  f"  fis"  g"    (40-43)
   F_CPU*10/16/8306-1,  F_CPU*10/16/8800-1,  F_CPU*10/16/9323-1,  F_CPU*10/16/9878-1,   // gis"  a"  ais"  h"  (44-47)

   F_CPU*10/16/10465-1, F_CPU*10/16/11087-1, F_CPU*10/16/11747-1, F_CPU*10/16/12445-1,  // c"  cis"  d"  dis"  (48-51)
   F_CPU*10/16/13185-1, F_CPU*10/16/13969-1, F_CPU*10/16/14800-1, F_CPU*10/16/15680-1,  // e"  f"  fis"  g"    (52-55)
   F_CPU*10/16/16612-1, F_CPU*10/16/17600-1, F_CPU*10/16/18647-1, F_CPU*10/16/19755-1,  // gis"  a"  ais"  h"  (56-59)

   F_CPU*10/16/20930-1, F_CPU*10/16/22175-1, F_CPU*10/16/23493-1, F_CPU*10/16/24890-1,  // c'" cis'" d'" dis'" (60-63)
   F_CPU*10/16/26370-1, F_CPU*10/16/27938-1, F_CPU*10/16/29600-1, F_CPU*10/16/31360-1,  // e'" f'" fis'" g'"   (64-67)
   F_CPU*10/16/33224-1, F_CPU*10/16/35200-1, F_CPU*10/16/37293-1, F_CPU*10/16/39511-1,  // gis'" a'" ais'" h'" (68-71)

   F_CPU*10/16/41860-1                                                                  // c""                 (72)
};

// Sound-Listen ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// eine Liste besteht aus Gruppen von 3 Bytes, die folgende Bedeutung haben:
// Byte 0: Tonhhe als Notenwert 0-72, 254=Pause, 255=Ende
// Byte 1: Tonlnge in 20ms-Einheiten
// Byte 2: Decay-Wert in 20ms-Einheiten, alle 20ms wird der Lautstrkewert um den Decay-Wert vermindert

// Sound 0: Buzzer (4 kurze Signaltne)

const char sound00[] PROGMEM =
{
   48, 4, 0,      254, 4, 255,   48, 4, 0,      254, 4, 255,   48, 4, 0,      254, 4, 255,   48, 4, 0,      254, 22, 255,  255
};

// Sound 1: Unheimliche Begegnung der dritten Art (Close Encounters of the Third Kind)

const char sound01[] PROGMEM =
{
   46, 20, 2,     48, 20, 2,     44, 25, 2,     32, 30, 2,     39, 200, 1,    255
};

// Sound 2: Westminster (Big Ben)

const char sound02[] PROGMEM =
{
   28, 36, 1,     32, 36, 1,     30, 36, 1,     23, 108, 1,    28, 36, 1,     30, 36, 1,     32, 36, 1,     28, 108, 1,    32, 36, 1,     28, 36, 1,     30, 36, 1,     23, 108, 1,    23, 36, 1,
   30, 36, 1,     32, 36, 1,     28, 107, 1,    255
};

// Sound 3: Crockett's Theme (Jan Hammer)

const char sound03[] PROGMEM =
{
   50, 16, 2,     48, 16, 2,     45, 32, 2,     41, 16, 2,     43, 48, 2,     41, 16, 2,     43, 80, 2,     43, 32, 2,     41, 16, 2,     43, 64, 2,     41, 16, 2,     43, 32, 2,     41, 16, 2,
   38, 111, 2,    50, 16, 2,     48, 16, 2,     45, 32, 2,     41, 16, 2,     43, 48, 2,     41, 16, 2,     43, 80, 2,     43, 32, 2,     41, 16, 2,     43, 64, 2,     41, 16, 2,     43, 32, 2,
   43, 16, 2,     41, 16, 2,     43, 2, 2,      45, 14, 2,     43, 16, 2,     41, 16, 2,     38, 48, 2,     254, 255, 2,   255
};

// Sound 4: Axel F. (Harold Faltermeyer)

const char sound04[] PROGMEM =
{
   29, 28, 3,     32, 21, 3,     29, 14, 3,     29, 7, 3,      34, 14, 3,     29, 14, 3,     27, 14, 3,     29, 28, 3,     36, 21, 3,     29, 14, 3,     29, 7, 3,      37, 14, 3,     36, 14, 3,
   32, 14, 3,     29, 14, 3,     36, 14, 3,     41, 14, 3,     29, 7, 3,      27, 14, 3,     27, 7, 3,      24, 14, 3,     31, 14, 3,     29, 125, 3,    255
};

// Sound 5: Popcorn (Hot Butter)

const char sound05[] PROGMEM =
{
   35, 11, 15,    33, 11, 15,    35, 11, 15,    30, 11, 15,    26, 11, 15,    30, 11, 15,    23, 22, 15,    35, 11, 15,    33, 11, 15,    35, 11, 15,    30, 11, 15,    26, 11, 15,    30, 11, 15,
   23, 22, 15,    35, 11, 15,    37, 11, 15,    38, 11, 15,    37, 11, 15,    38, 11, 15,    35, 11, 15,    37, 11, 15,    35, 11, 15,    37, 11, 15,    33, 11, 15,    35, 11, 15,    33, 11, 15,
   35, 11, 15,    31, 11, 15,    35, 22, 15,

   35, 11, 15,    33, 11, 15,    35, 11, 15,    30, 11, 15,    26, 11, 15,    30, 11, 15,    23, 22, 15,    35, 11, 15,    33, 11, 15,    35, 11, 15,    30, 11, 15,    26, 11, 15,    30, 11, 15,
   23, 22, 15,    35, 11, 15,    37, 11, 15,    38, 11, 15,    37, 11, 15,    38, 11, 15,    35, 11, 15,    37, 11, 15,    35, 11, 15,    37, 11, 15,    33, 11, 15,    35, 11, 15,    33, 11, 15,
   35, 11, 15,    37, 11, 15,    38, 22, 15,

   42, 11, 15,    40, 11, 15,    42, 11, 15,    38, 11, 15,    33, 11, 15,    38, 11, 15,    30, 22, 15,    42, 11, 15,    40, 11, 15,    42, 11, 15,    38, 11, 15,    33, 11, 15,    38, 11, 15,
   30, 22, 15,    42, 11, 15,    44, 11, 15,    45, 11, 15,    44, 11, 15,    45, 11, 15,    42, 11, 15,    44, 11, 15,    42, 11, 15,    44, 11, 15,    40, 11, 15,    42, 11, 15,    40, 11, 15,
   42, 11, 15,    38, 11, 15,    42, 22, 15,

   42, 11, 15,    40, 11, 15,    42, 11, 15,    38, 11, 15,    33, 11, 15,    38, 11, 15,    30, 22, 15,    42, 11, 15,    40, 11, 15,    42, 11, 15,    38, 11, 15,    33, 11, 15,    38, 11, 15,
   30, 22, 15,    42, 11, 15,    44, 11, 15,    45, 11, 15,    44, 11, 15,    45, 11, 15,    42, 11, 15,    44, 11, 15,    42, 11, 15,    44, 11, 15,    40, 11, 15,    42, 11, 15,    40, 11, 15,
   37, 11, 15,    40, 11, 15,    42, 21, 15,    255
};

// Sound 6: Blue Peter (Mike Oldfield)

const char sound06[] PROGMEM =
{
   36, 8, 5,      38, 8, 5,      41, 16, 5,     41, 16, 2,     41, 8, 5,      43, 8, 5,      45, 8, 5,      46, 8, 5,      48, 16, 5,     48, 16, 5,     48, 16, 2,     50, 8, 5,      52, 8, 5,
   53, 8, 5,      55, 8, 5,      53, 8, 5,      50, 8, 5,      48, 8, 5,      50, 8, 5,      48, 8, 5,      45, 8, 5,      43, 8, 5,      41, 8, 5,      38, 8, 5,      41, 8, 5,      43, 16, 2,
   36, 8, 5,      38, 8, 5,      41, 16, 5,     41, 16, 2,     41, 8, 5,      43, 8, 5,      45, 8, 5,      46, 8, 5,      48, 16, 5,     48, 16, 5,     48, 16, 2,     53, 8, 5,      50, 8, 5,
   52, 8, 5,      55, 8, 5,      52, 8, 5,      48, 8, 5,      45, 8, 5,      50, 8, 5,      47, 8, 5,      43, 8, 5,      48, 8, 5,      47, 8, 5,      48, 8, 5,      47, 8, 5,      48, 16, 2,
   36, 8, 5,      38, 8, 5,      41, 16, 5,     41, 16, 2,     41, 8, 5,      43, 8, 5,      45, 8, 5,      46, 8, 5,      48, 16, 5,     48, 16, 5,     48, 16, 2,     50, 8, 5,      52, 8, 5,
   53, 8, 5,      55, 8, 5,      53, 8, 5,      50, 8, 5,      48, 8, 5,      50, 8, 5,      48, 8, 5,      45, 8, 5,      43, 8, 5,      41, 8, 5,      38, 8, 5,      41, 8, 5,      43, 16, 2,
   36, 8, 5,      38, 8, 5,      41, 8, 5,      43, 8, 5,      41, 8, 5,      43, 8, 5,      41, 8, 5,      50, 8, 5,      48, 8, 5,      45, 8, 5,      45, 8, 5,      43, 8, 5,      43, 8, 5,
   45, 8, 5,      41, 16, 2,     50, 16, 2,     48, 8, 5,      50, 8, 5,      48, 8, 5,      45, 8, 5,      41, 8, 5,      43, 8, 5,      45, 8, 5,      46, 8, 5,      48, 16, 5,     43, 2, 5,
   45, 14, 5,     41, 16, 2,     255
};

// Sound 7: Around The World (ATC)

const char sound07[] PROGMEM =
{
   52, 11, 2,     45, 11, 2,     48, 11, 2,     52, 11, 2,     47, 11, 2,     40, 11, 2,     43, 11, 2,     47, 11, 2,     48, 11, 2,     41, 11, 2,     45, 11, 2,     48, 11, 2,     50, 11, 2,
   43, 11, 2,     47, 11, 2,     50, 10, 2,     255
};

// Sound 8: Fr Elise (Ludwig van Beethoven)

const char sound08[] PROGMEM =
{
   40, 10, 2,     39, 10, 2,     40, 10, 2,     39, 10, 2,     40, 10, 2,     35, 10, 2,     38, 10, 2,     36, 10, 2,     33, 30, 2,     24, 10, 2,     28, 10, 2,     33, 10, 2,     35, 30, 2,
   28, 10, 2,     32, 10, 2,     35, 10, 2,     36, 30, 2,     28, 10, 2,     40, 10, 2,     39, 10, 2,     40, 10, 2,     39, 10, 2,     40, 10, 2,     35, 10, 2,     38, 10, 2,     36, 10, 2,
   33, 30, 2,     24, 10, 2,     28, 10, 2,     33, 10, 2,     35, 30, 2,     28, 10, 2,     36, 10, 2,     35, 10, 2,     33, 40, 2,     255
};

// Sound 9: Happy Birthday

const char sound09[] PROGMEM =
{
   31, 21, 2,     31, 7, 2,      33, 28, 2,     31, 28, 2,     36, 28, 2,     35, 56, 2,     31, 21, 2,     31, 7, 2,      33, 28, 2,     31, 28, 2,     38, 28, 2,     36, 56, 2,     31, 21, 2,
   31, 7, 2,      43, 28, 2,     40, 28, 2,     36, 14, 2,     36, 14, 2,     35, 28, 2,     33, 28, 2,     41, 21, 2,     41, 7, 2,      40, 28, 2,     36, 28, 2,     38, 28, 2,     36, 55, 2,
   255
};

// Sound 10: Gong 1

const char sound10[] PROGMEM =
{
	45, 255, 1,   255
};

// Sound 11: Gong 2

const char sound11[] PROGMEM =
{
	45, 34, 1,   42, 255, 1,     255
};

// Sound 12: Gong 3

const char sound12[] PROGMEM =
{
	45, 34, 1,   42, 34, 1,    38, 255, 1,    255
};

// Pointerliste erstellen -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

PGM_P const sounds[] PROGMEM =
{
   sound00, sound01, sound02, sound03, sound04, sound05, sound06, sound07, sound08, sound09, sound10, sound11, sound12
};
