// Zeichensatz-Daten im Flash-Speicher ================================================================================================================================================================

// Standard-Zeichensatz proportional ------------------------------------------------------------------------------------------------------------------------------------------------------------------

// ASCII Zeichentabelle, jedes Zeichen wird mit 12 Bytes definiert, Byte 0 enthlt die Zeichenbreite (0-8), die restlichen Bytes enthalten zeilenweise die Bitmap des Zeichens, Beispiel Prozentzeichen

// Byte  0 = 6 (Zeichen ist 6 Pixel breit)
// Byte  1 = 0          . . . . . . . .            (Zeile fr Umlaute)
// Byte  2 = 0x10       . . . o . . . .
// Byte  3 = 0x29       . . o . o . . o
// Byte  4 = 0x12       . . . o . . o .
// Byte  5 = 4          . . . . . o . .
// Byte  6 = 8          . . . . o . . .
// Byte  7 = 0x12       . . . o . . o .
// Byte  8 = 0x25       . . o . . o . o
// Byte  9 = 2          . . . . . . o .
// Byte 10 = 0          . . . . . . . .            (Zeile fr Unterlngen)
// Byte 11 = 0          . . . . . . . .            (Zeile fr Unterlngen)

const uint8_t charset_array[] PROGMEM =
{

// ASCII 0x20 - 0x7f (normaler Zeichensatz)

   5,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x20 ' '
   1,0,1,1,1,1,1,1,0,1,0,0,                                     // Code 0x21 '!'
   5,0,0x1b,0x1b,9,0x12,0,0,0,0,0,0,                            // Code 0x22 '"'
   5,0,0,0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0,0,                // Code 0x23 '#'
   5,0,4,0x0e,0x14,0x0e,5,0x15,0x0e,4,0,0,                      // Code 0x24 '$'
   6,0,0x10,0x29,0x12,4,8,0x12,0x25,2,0,0,                      // Code 0x25 '%'
   5,0,0x0c,0x12,0x12,0x14,8,0x15,0x12,0x0d,0,0,                // Code 0x26 '&'
   2,0,3,3,1,2,0,0,0,0,0,0,                                     // Code 0x27 '''
   3,0,1,2,4,4,4,4,2,1,0,0,                                     // Code 0x28 '('
   3,0,4,2,1,1,1,1,2,4,0,0,                                     // Code 0x29 ')'
   5,0,0,0,0x0a,4,0x1f,4,0x0a,0,0,0,                            // Code 0x2a '*'
   5,0,0,0,4,4,0x1f,4,4,0,0,0,                                  // Code 0x2b '+'
   2,0,0,0,0,0,0,0,3,3,1,2,                                     // Code 0x2c ','
   5,0,0,0,0,0,0x1f,0,0,0,0,0,                                  // Code 0x2d '-'
   2,0,0,0,0,0,0,0,3,3,0,0,                                     // Code 0x2e '.'
   4,0,1,1,2,2,4,4,8,8,0,0,                                     // Code 0x2f '/'

   5,0,0x0e,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0,0,             // Code 0x30 '0'
   5,0,2,6,0x0a,2,2,2,2,2,0,0,                                  // Code 0x31 '1'
   5,0,0x0e,0x11,1,2,4,8,0x10,0x1f,0,0,                         // Code 0x32 '2'
   5,0,0x0e,0x11,1,6,1,1,0x11,0x0e,0,0,                         // Code 0x33 '3'
   5,0,2,6,0x0a,0x12,0x1f,2,2,2,0,0,                            // Code 0x34 '4'
   5,0,0x1f,0x10,0x10,0x1e,1,1,0x11,0x0e,0,0,                   // Code 0x35 '5'
   5,0,0x0e,0x11,0x10,0x1e,0x11,0x11,0x11,0x0e,0,0,             // Code 0x36 '6'
   5,0,0x1f,1,1,2,2,4,4,4,0,0,                                  // Code 0x37 '7'
   5,0,0x0e,0x11,0x11,0x0e,0x11,0x11,0x11,0x0e,0,0,             // Code 0x38 '8'
   5,0,0x0e,0x11,0x11,0x11,0x0f,1,0x11,0x0e,0,0,                // Code 0x39 '9'
   2,0,0,0,0,3,3,0,3,3,0,0,                                     // Code 0x3a ':'
   2,0,0,0,0,3,3,0,3,3,1,2,                                     // Code 0x3b ';'
   4,0,0,1,2,4,8,4,2,1,0,0,                                     // Code 0x3c '<'
   5,0,0,0,0,0x1f,0,0x1f,0,0,0,0,                               // Code 0x3d '='
   4,0,0,8,4,2,1,2,4,8,0,0,                                     // Code 0x3e '>'
   5,0,0x0e,0x11,1,2,4,4,0,4,0,0,                               // Code 0x3f '?'

   7,0,0x1e,0x21,0x4d,0x55,0x55,0x4e,0x20,0x1e,0,0,             // Code 0x40 '@'
   5,0,0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x11,0,0,             // Code 0x41 'A'
   5,0,0x1e,0x11,0x11,0x1e,0x11,0x11,0x11,0x1e,0,0,             // Code 0x42 'B'
   5,0,0x0e,0x11,0x10,0x10,0x10,0x10,0x11,0x0e,0,0,             // Code 0x43 'C'
   5,0,0x1c,0x12,0x11,0x11,0x11,0x11,0x12,0x1c,0,0,             // Code 0x44 'D'
   5,0,0x1f,0x10,0x10,0x1e,0x10,0x10,0x10,0x1f,0,0,             // Code 0x45 'E'
   5,0,0x1f,0x10,0x10,0x1e,0x10,0x10,0x10,0x10,0,0,             // Code 0x46 'F'
   5,0,0x0e,0x11,0x10,0x10,0x13,0x11,0x11,0x0e,0,0,             // Code 0x47 'G'
   5,0,0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x11,0,0,             // Code 0x48 'H'
   1,0,1,1,1,1,1,1,1,1,0,0,                                     // Code 0x49 'I'
   4,0,1,1,1,1,1,1,9,6,0,0,                                     // Code 0x4a 'J'
   5,0,0x11,0x12,0x14,0x18,0x18,0x14,0x12,0x11,0,0,             // Code 0x4b 'K'
   5,0,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0,0,             // Code 0x4c 'L'
   5,0,0x11,0x1b,0x15,0x15,0x11,0x11,0x11,0x11,0,0,             // Code 0x4d 'M'
   5,0,0x11,0x19,0x19,0x15,0x15,0x13,0x13,0x11,0,0,             // Code 0x4e 'N'
   5,0,0x0e,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0,0,             // Code 0x4f '0'

   5,0,0x1e,0x11,0x11,0x11,0x1e,0x10,0x10,0x10,0,0,             // Code 0x50 'P'
   5,0,0x0e,0x11,0x11,0x11,0x11,0x15,0x12,0x0d,0,0,             // Code 0x51 'Q'
   5,0,0x1e,0x11,0x11,0x11,0x1e,0x14,0x12,0x11,0,0,             // Code 0x52 'R'
   5,0,0x0e,0x11,0x10,0x0e,1,1,0x11,0x0e,0,0,                   // Code 0x53 'S'
   5,0,0x1f,4,4,4,4,4,4,4,0,0,                                  // Code 0x54 'T'
   5,0,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0,0,             // Code 0x55 'U'
   5,0,0x11,0x11,0x11,0x11,0x0a,0x0a,4,4,0,0,                   // Code 0x56 'V'
   5,0,0x11,0x11,0x11,0x11,0x15,0x15,0x15,0x0a,0,0,             // Code 0x57 'W'
   5,0,0x11,0x11,0x0a,4,0x0a,0x11,0x11,0x11,0,0,                // Code 0x58 'X'
   5,0,0x11,0x11,0x11,0x0a,4,4,4,4,0,0,                         // Code 0x59 'Y'
   6,0,0x3f,1,2,4,8,0x10,0x20,0x3f,0,0,                         // Code 0x5a 'Z'
   3,0,7,4,4,4,4,4,4,7,0,0,                                     // Code 0x5b '['
   4,0,8,8,4,4,2,2,1,1,0,0,                                     // Code 0x5c '\'
   3,0,7,1,1,1,1,1,1,7,0,0,                                     // Code 0x5d ']'
   5,0,4,0x0a,0x11,0,0,0,0,0,0,0,                               // Code 0x5e '^'
   5,0,0,0,0,0,0,0,0,0x1f,0,0,                                  // Code 0x5f '_'

   3,0,4,2,1,0,0,0,0,0,0,0,                                     // Code 0x60 '`'
   5,0,0,0,0,0x0e,1,0x0f,0x11,0x0f,0,0,                         // Code 0x61 'a'
   5,0,0x10,0x10,0x10,0x1e,0x11,0x11,0x11,0x1e,0,0,             // Code 0x62 'b'
   4,0,0,0,0,7,8,8,8,7,0,0,                                     // Code 0x63 'c'
   5,0,1,1,1,0x0f,0x11,0x11,0x11,0x0f,0,0,                      // Code 0x64 'd'
   5,0,0,0,0,0x0e,0x11,0x1f,0x10,0x0e,0,0,                      // Code 0x65 'e'
   3,0,1,2,2,7,2,2,2,2,0,0,                                     // Code 0x66 'f'
   5,0,0,0,0,0x0f,0x11,0x11,0x11,0x0f,1,0x0e,                   // Code 0x67 'g'
   5,0,0x10,0x10,0x10,0x1e,0x11,0x11,0x11,0x11,0,0,             // Code 0x68 'h'
   1,0,0,1,0,1,1,1,1,1,0,0,                                     // Code 0x69 'i'
   2,0,0,1,0,1,1,1,1,1,1,2,                                     // Code 0x6a 'j'
   4,0,8,8,8,9,0x0a,0x0c,0x0a,9,0,0,                            // Code 0x6b 'k'
   2,0,2,2,2,2,2,2,2,1,0,0,                                     // Code 0x6c 'l'
   5,0,0,0,0,0x1a,0x15,0x15,0x15,0x15,0,0,                      // Code 0x6d 'm'
   5,0,0,0,0,0x16,0x19,0x11,0x11,0x11,0,0,                      // Code 0x6e 'n'
   5,0,0,0,0,0x0e,0x11,0x11,0x11,0x0e,0,0,                      // Code 0x6f 'o'

   5,0,0,0,0,0x1e,0x11,0x11,0x11,0x1e,0x10,0x10,                // Code 0x70 'p'
   5,0,0,0,0,0x0f,0x11,0x11,0x11,0x0f,1,1,                      // Code 0x71 'q'
   4,0,0,0,0,0x0a,0x0d,8,8,8,0,0,                               // Code 0x72 'r'
   5,0,0,0,0,0x0e,0x10,0x0e,1,0x1e,0,0,                         // Code 0x73 's'
   3,0,2,2,2,7,2,2,2,1,0,0,                                     // Code 0x74 't'
   5,0,0,0,0,0x11,0x11,0x11,0x11,0x0e,0,0,                      // Code 0x75 'u'
   5,0,0,0,0,0x11,0x11,0x11,0x0a,4,0,0,                         // Code 0x76 'v'
   5,0,0,0,0,0x11,0x11,0x15,0x15,0x0a,0,0,                      // Code 0x77 'w'
   5,0,0,0,0,0x11,0x0a,4,0x0a,0x11,0,0,                         // Code 0x78 'x'
   5,0,0,0,0,0x11,0x11,0x11,0x11,0x0f,1,0x0e,                   // Code 0x79 'y'
   5,0,0,0,0,0x1f,2,4,8,0x1f,0,0,                               // Code 0x7a 'z'
   3,0,1,2,2,4,2,2,2,1,0,0,                                     // Code 0x7b '{'
   1,0,1,1,1,0,1,1,1,1,0,0,                                     // Code 0x7c '|'
   3,0,4,2,2,1,2,2,2,4,0,0,                                     // Code 0x7d '}'
   5,0,8,0x15,2,0,0,0,0,0,0,0,                                  // Code 0x7e '~'
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x7f Endezeichen

// ASCII 0x80 - 0x8f (fr Umlaute und Sonderzeichen)

   5,0x11,4,0x0a,0x11,0x11,0x1f,0x11,0x11,0x11,0,0,             // Code 0x80 ''
   5,0x0a,0,0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0,0,             // Code 0x81 ''
   5,0x0a,0,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0,0,             // Code 0x82 ''
   5,0,0,0x0a,0,0x0e,1,0x0f,0x11,0x0f,0,0,                      // Code 0x83 ''
   5,0,0,0x0a,0,0x0e,0x11,0x11,0x11,0x0e,0,0,                   // Code 0x84 ''
   5,0,0,0x0a,0,0x11,0x11,0x11,0x11,0x0e,0,0,                   // Code 0x85 ''
   5,0,0x0e,0x11,0x11,0x16,0x11,0x11,0x11,0x16,0,0,             // Code 0x86 ''
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x87 frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x88 frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x89 frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x8a frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x8b frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x8c frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x8d frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x8e frei
   0,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x8f frei

// ASCII 0x90 - 0x9f (fr Symbole)

   3,0,0,0,0,0,0,0,0,0,0,0,                                     // Code 0x90 schmales Leerzeichen
   7,8,0x14,0x14,0x22,0x22,0x22,0x41,0x7f,0x10,0x30,0x30,       // Code 0x91 Symbol "Alarm aus"
   7,8,0x1c,0x1c,0x3e,0x3e,0x3e,0x7f,0x7f,0x10,0x30,0x30,       // Code 0x92 Symbol "Alarm ein"
   8,0x14,0x3a,0x3a,0x7d,0x7d,0x7d,0xfe,0xfe,0x20,0x60,0x60,    // Code 0x93 Symbol "Alarm-Serie", linker Teil
   1,0,0,0,0,0,0,1,1,0,0,0,                                     // Code 0x94 Symbol "Alarm-Serie", rechter Teil
   7,8,0x0c,0x0c,0x0a,9,9,9,0x0a,0x38,0x78,0x70,                // Code 0x95 Symbol "Note"
   6,1,3,7,0x3d,0x25,0x25,0x25,0x3d,7,3,1,                      // Code 0x96 Symbol "Lautsprecher"
   5,0,4,2,9,5,0x15,5,9,2,4,0,                                  // Code 0x97 Symbol "ein"
   4,0,0,1,3,7,0x0f,7,3,1,0,0,                                  // Code 0x98 Symbol "Zeichen lschen"
   4,0,6,9,9,6,0,0x0a,0x0c,0x0a,9,0,                            // Code 0x99 Symbol "OK"
   8,0,0,0xc0,0xf0,0xfc,0xff,0xfc,0xf0,0xc0,0,0,                // Code 0x9a Symbol "Pfeil" fr aktiven Geburtstag
};

// Kleinziffern fr Tag und Monat im Format 4x5 Pixel -------------------------------------------------------------------------------------------------------------------------------------------------

const uint8_t digit0_array[] PROGMEM =
{
   6,9,9,9,6,      2,6,2,2,2,      15,1,15,8,15,   14,1,6,1,14,    10,10,15,2,2,        // Kleinziffern 0-4
   15,8,15,1,15,   6,8,14,9,6,     15,1,2,4,4,     6,9,6,9,6,      6,9,7,1,6            // Kleinziffern 5-9
};

// Groziffern fr Stunden und Minuten ----------------------------------------------------------------------------------------------------------------------------------------------------------------

// Jede Groziffer hat eine feste Gre von 26x14 Pixeln und wird mit 52 Bytes definiert (26 Zeilen mit je 2 Byte)

const uint8_t digit1_array[] PROGMEM =
{
   3,0xf0,7,0xf8,0x0f,0xfc,0x1e,0x1e,0x1c,0x0e,0x3c,0x0f,0x38,7,0x38,7,0x38,7,0x38,7,              // Groziffer '0'
   0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,0x3c,0x0f,
   0x1c,0x0e,0x1e,0x1e,0x0f,0xfc,7,0xf8,3,0xf0,

   0,0x0c,0,0x1c,0,0x3c,0,0x7c,0,0xfc,1,0xfc,3,0xdc,7,0x9c,0x0f,0x1c,0x0e,0x1c,                    // Groziffer '1'
   0x0c,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,
   0,0x1c,0,0x1c,0,0x1c,0,0x1c,0,0x1c,

   3,0xf0,0x0f,0xfc,0x1f,0xfe,0x1e,0x1e,0x3c,0x0f,0x38,7,0,7,0,7,0,7,0,7,                          // Groziffer '2'
   0,0x0f,0,0x0e,0,0x1e,0,0x3c,0,0x78,0,0xf0,1,0xe0,3,0xc0,7,0x80,0x0f,0,0x1e,0,
   0x3c,0,0x3c,0,0x3f,0xff,0x3f,0xff,0x3f,0xff,

   3,0xf0,0x0f,0xfc,0x1f,0xfe,0x1e,0x1e,0x3c,0x0f,0x38,7,0,7,0,7,0,7,0,0x0f,                       // Groziffer '3'
   0,0x1e,1,0xfe,1,0xfc,1,0xfe,0,0x1e,0,0x0f,0,7,0,7,0,7,0,7,0x38,7,0x3c,0x0f,
   0x1e,0x1e,0x1f,0xfe,0x0f,0xfc,3,0xf0,

   0,0x18,0,0x38,0,0x38,0,0x78,0,0x78,0,0xf8,0,0xf8,1,0xf8,1,0xf8,3,0xf8,3,0xb8,                   // Groziffer '4'
   7,0xb8,7,0x38,0x0f,0x38,0x0e,0x38,0x1e,0x38,0x1c,0x38,0x3f,0xff,0x3f,0xff,0x3f,0xff,
   0,0x38,0,0x38,0,0x38,0,0x38,0,0x38,0,0x38,

   7,0xfe,0x0f,0xfe,0x0f,0xfe,0x0e,0,0x0e,0,0x0e,0,0x1e,0,0x1c,0,0x1c,0,0x1c,0,                    // Groziffer '5'
   0x1f,0xf0,0x3f,0xfc,0x3f,0xfe,0x3e,0x1e,0x3c,0x0f,0,7,0,7,0,7,0,7,0,7,0x38,7,
   0x3c,0x0f,0x1e,0x1e,0x1f,0xfe,0x0f,0xfc,3,0xf0,

   0,0x70,0,0xf0,1,0xe0,3,0xc0,7,0x80,7,0,0x0f,0,0x0e,0,0x1e,0,0x1c,0,0x1f,0xf0,                   // Groziffer '6'
   0x3f,0xfc,0x3f,0xfe,0x3e,0x1e,0x3c,0x0f,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,
   0x3c,0x0f,0x1e,0x1e,0x1f,0xfe,0x0f,0xfc,3,0xf0,

   0x3f,0xff,0x3f,0xff,0x3f,0xff,0,0x0e,0,0x0e,0,0x1c,0,0x1c,0,0x38,0,0x38,0,0x70,                 // Groziffer '7'
   0,0x70,0,0xe0,0,0xe0,0,0xe0,1,0xe0,1,0xc0,1,0xc0,1,0xc0,3,0xc0,3,0x80,3,0x80,
   3,0x80,3,0x80,3,0x80,3,0x80,3,0x80,

   3,0xf0,0x0f,0xfc,0x1f,0xfe,0x1e,0x1e,0x3c,0x0f,0x38,7,0x38,7,0x38,7,0x38,7,0x3c,0x0f,           // Groziffer '8'
   0x1e,0x1e,0x1f,0xfe,0x0f,0xfc,0x1f,0xfe,0x1e,0x1e,0x3c,0x0f,0x38,7,0x38,7,0x38,7,
   0x38,7,0x38,7,0x3c,0x0f,0x1e,0x1e,0x1f,0xfe,0x0f,0xfc,3,0xf0,

   3,0xf0,0x0f,0xfc,0x1f,0xfe,0x1e,0x1e,0x3c,0x0f,0x38,7,0x38,7,0x38,7,0x38,7,0x38,7,              // Groziffer '9'
   0x38,7,0x3c,0x0f,0x1e,0x1f,0x1f,0xff,0x0f,0xff,3,0xfe,0,0x0e,0,0x1e,0,0x1c,0,0x3c,
   0,0x38,0,0x78,0,0xf0,1,0xe0,3,0xc0,3,0x80   
};

// Groziffern fr Sekunden ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// Jede Groziffer hat eine feste Gre von 18x10 Pixeln und wird mit 36 Bytes definiert (18 Zeilen mit je 2 Byte)

const uint8_t digit2_array[] PROGMEM =
{
   0,0xfc,1,0xfe,1,0x86,3,0x87,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,                                    // Groziffer '0'
   3,3,3,3,3,0x87,1,0x86,1,0xfe,0,0xfc,

   0,4,0,0x0c,0,0x1c,0,0x3c,0,0x7c,0,0xec,0,0xcc,0,0x0c,0,0x0c,0,0x0c,0,0x0c,0,0x0c,               // Groziffer '1'
   0,0x0c,0,0x0c,0,0x0c,0,0x0c,0,0x0c,0,0x0c,

   0,0xfc,1,0xfe,3,0x87,3,3,0,3,0,3,0,3,0,7,0,6,0,0x0e,0,0x1c,0,0x38,                              // Groziffer '2'
   0,0x70,0,0xe0,1,0xc0,3,0x80,3,0xff,3,0xff,

   0,0xfc,1,0xfe,3,0x87,3,3,0,3,0,3,0,3,0,7,0,0x3e,0,0x3e,0,7,0,3,                                 // Groziffer '3'
   0,3,0,3,3,3,3,0x87,1,0xfe,0,0xfc,

   0,0x0c,0,0x0c,0,0x1c,0,0x1c,0,0x3c,0,0x3c,0,0x6c,0,0x6c,0,0xcc,0,0xcc,1,0x8c,1,0x8c,            // Groziffer '4'
   3,0xff,3,0xff,0,0x0c,0,0x0c,0,0x0c,0,0x0c,

   0,0xfe,1,0xfe,1,0x80,1,0x80,1,0x80,3,0,3,0,3,0xfc,3,0xfe,3,0x87,0,3,0,3,                        // Groziffer '5'
   0,3,0,3,3,3,3,0x87,1,0xfe,0,0xfc,

   0,0x18,0,0x38,0,0x70,0,0xe0,0,0xc0,1,0xc0,1,0x80,3,0xfc,3,0xfe,3,0x87,3,3,3,3,                  // Groziffer '6'
   3,3,3,3,3,3,3,0x87,1,0xfe,0,0xfc,

   3,0xff,3,0xff,0,3,0,7,0,6,0,0x0c,0,0x0c,0,0x18,0,0x18,0,0x30,0,0x30,0,0x30,                     // Groziffer '7'
   0,0x60,0,0x60,0,0x60,0,0x60,0,0x60,0,0x60,

   0,0xfc,1,0xfe,3,0x87,3,3,3,3,3,3,3,3,3,0x87,1,0xfe,1,0xfe,3,0x87,3,3,                           // Groziffer '8'
   3,3,3,3,3,3,3,0x87,1,0xfe,0,0xfc,

   0,0xfc,1,0xfe,3,0x87,3,3,3,3,3,3,3,3,3,3,3,0x87,1,0xff,0,0xff,0,6,                              // Groziffer '9'
   0,0x0e,0,0x0c,0,0x1c,0,0x38,0,0x70,0,0x60
};

// Grosymbole (DCF77-Empfang, Lautsprecher, Winter-/Sommerzeit und USB) ------------------------------------------------------------------------------------------------------------------------------

// Jedes Symbol hat eine feste Gre von 16x16 Pixeln und wird mit 32 Bytes definiert (16 Zeilen mit je 2 Byte)

const uint8_t symbol_array[] PROGMEM =
{
   0,0,0,0,0,0x11,0,0x0a,0xc0,4,0xb0,0x0a,0xc8,0x91,0x45,0,                                        // Symbol 0 "kein DCF77-Empfang"
   0x62,0,0x35,0,0x18,0x80,0x3c,0x40,0x76,0x40,0xe3,0xa0,0xe0,0xe0,0xe0,0,

   3,0x80,0,0x60,3,0x10,0,0xc8,0xc0,0x24,0xb0,0x14,0xc8,0x92,0x45,0x0a,                            // Symbol 1 "DCF77-Empfang ok"
   0x62,0x0a,0x35,0,0x18,0x80,0x3c,0x40,0x76,0x40,0xe3,0xa0,0xe0,0xe0,0xe0,0,

   1,0,5,0x40,0x23,0x88,0xa1,0x0a,0x61,0x0c,0x51,0x14,0x8d,0x62,3,0x80,                            // Symbol 2 "Winterzeit"
   3,0x80,0x8d,0x62,0x51,0x14,0x61,0x0c,0xa1,0x0a,0x23,0x88,5,0x40,1,0,

   0,0x80,0x11,4,0x11,8,0x0b,0xd0,0x0c,0x30,0x88,0x13,0x70,0x0c,0x10,8,                            // Symbol 3 "Sommerzeit"
   0x10,8,0x30,0x0e,0xc8,0x11,0x0c,0x30,0x0b,0xd0,0x10,0x88,0x20,0x88,1,0,

   1,0,3,0x80,2,0x80,6,0xc0,0x0c,0x40,0xfc,0x51,0x95,0x4a,0x95,0x44,                               // Symbol 4 "Lautsprecher aus"
   0x95,0x4a,0x95,0x51,0xfc,0x40,0x0c,0x40,6,0xc0,2,0x80,3,0x80,1,0,

   1,0,3,0x84,2,0x82,6,0xca,0x0c,0x49,0xfc,0x45,0x95,0x45,0x95,0x45,                               // Symbol 5 "Lautsprecher ein"
   0x95,0x45,0x95,0x45,0xfc,0x45,0x0c,0x49,6,0xca,2,0x82,3,0x84,1,0,

   1,0xc0,2,0,0xe4,2,0xff,0xff,0xe1,2,0,0x80,0,0x78,0,0x18,                                        // Symbol 6 "USB aktiv"
   0,0,0,0,0x89,0xce,0x8a,9,0x89,0xce,0x88,0x29,0x8a,0x29,0x71,0xce,

   3,0xc0,0x0c,0x30,0x31,0x8c,0x23,0xc4,0x43,0xc2,0x43,0xc2,0x83,0xc1,0x81,                        // Symbol 7 "Uhr nicht gestellt"
   0x81,0x81,0x81,0x80,1,0x41,0x82,0x43,0xc2,0x23,0xc4,0x31,0x8c,0x0c,0x30,3,0xc0
};

// Zeichenvorrat fr die Eingabe der Geburtstage (Vorname und Nachname), die Reihenfolge kann gendert werden aktueller Zeichenvorrat:
// "-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"

const uint8_t charlist[] PROGMEM =
{
   45,46,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,               // Liste mit Sonder-Zeichen,
   80,81,82,83,84,85,86,87,88,89,90,128,129,130,97,98,99,100,101,102,103,104,105,106,              // Ziffern, Grobuchstaben,
   107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,131,132,133,134                 // Kleinbuchstaben und Umlauten
};

// Sonstiges: Tagestabellen fr normale Jahre mit 365 Tagen und fr Schaltjahre mit 366 Tagen

const uint8_t daytab1[] PROGMEM = {31,28,31,30,31,30,31,31,30,31,30,31};
const uint8_t daytab2[] PROGMEM = {31,29,31,30,31,30,31,31,30,31,30,31};
