; -----------------------------------------------------------------------------
; EEPROM-Werte fr eine Beispielkonfiguration zum Test der Sensoren 17-24 (i-p)
; -----------------------------------------------------------------------------
;
.eseg
;
;  --------------------------
; | Position 1    Position 5 |	Die Sensor-Tabelle enthlt die 8 Sensornummern (im Bereich 1-31) in der Reihenfolge, wie sie auf dem Display angezeigt werden sollen. Anzeigepositionen, die nicht
; | Position 2    Position 6 |	genutzt werden, mssen eine 0 enthalten. Sind die letzten 4 Sensornummern auf 0 gesetzt, dann arbeitet das Anzeigemodul im 4-Sensor-Modus mit verlngerten Sensornamen.
; | Position 3    Position 7 |
; | Position 4    Position 8 |	Das nebenstehende Bild zeigt die 8 Anzeigepositionen.
;  --------------------------
;
esentb:	.db	17			;Anzeigeposition 1: Sensornummer 17 [i] (Temperatur)
	.db	18			;Anzeigeposition 2: Sensornummer 18 [j] (Temperatur)
	.db	19			;Anzeigeposition 3: Sensornummer 19 [k] (Temperatur)
	.db	20			;Anzeigeposition 4: Sensornummer 20 [l] (Temperatur)
	.db	21			;Anzeigeposition 5: Sensornummer 21 [m] (Temperatur)
	.db	22			;Anzeigeposition 6: Sensornummer 22 [n] (Temperatur)
	.db	23			;Anzeigeposition 7: Sensornummer 23 [o] (Temperatur)
	.db	24			;Anzeigeposition 8: Sensornummer 24 [p] (Temperatur)
;
; ber die folgende Liste kann fr Temperatursensoren ein unteres Temperaturlimit eingestellt werden, bei Unterschreitung des Limits blinkt ein Symbol hinter dem Wert und ein Alarm wird ausgelst.
; Alle Werte mssen in Grad Celsius angegeben werden, auch negative Werte sind mglich. Ein Wert von 128 schaltet die Alarmberwachung aus. Die Reihenfolge entspricht der Anzeigeposition 1-8:
;
elim_l:	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 1 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 2 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 3 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 4 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 5 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 6 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 7 (Alarm ausgeschaltet)
	.db	128			;Unteres Temperaturlimit fr Anzeigeposition 8 (Alarm ausgeschaltet)
;
; ber die folgende Liste kann fr Temperatursensoren ein oberes Temperaturlimit eingestellt werden, bei berschreitung des Limits blinkt ein Symbol hinter dem Wert und ein Alarm wird ausgelst.
; Alle Werte mssen in Grad Celsius angegeben werden, auch negative Werte sind mglich. Ein Wert von 128 schaltet die Alarmberwachung aus. Die Reihenfolge entspricht der Anzeigeposition 1-8:
;
elim_h:	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 1 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 2 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 3 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 4 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 5 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 6 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 7 (Alarm ausgeschaltet)
	.db	128			;Oberes Temperaturlimit fr Anzeigeposition 8 (Alarm ausgeschaltet)
;
; Hier knnen die Sensornamen festgelegt werden. Wird das Anzeigemodul im 8-Sensor-Modus verwendet, dann gelangen nur die ersten 4 Zeichen auf die Anzeige. Im 4-Sensor-Modus werden alle 14 Zeichen
; genutzt, allerdings nur bei den Zeilen 1-4. Diese Struktur verschwendet zwar Speicherplatz, vereinfacht aber die Programmierung. Umlaute mssen entsprechend des LCD-Zeichensatzes kodiert werden:
; = 0xe1, = 0xef, = 0xf5, = 0xe2 (gilt fr die meisten LCD mit HD44780, im Zweifelsfall bitte im Datenblatt nachschauen)
;
esentx:	.db	"SenI          "		;Display-Text fr Anzeigeposition 1 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"SenJ          "		;Display-Text fr Anzeigeposition 2 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"SenK          "		;Display-Text fr Anzeigeposition 3 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"SenL          "		;Display-Text fr Anzeigeposition 4 (4 Zeichen im 8-Sensor-Modus, 14 Zeichen im 4-Sensor-Modus)
	.db	"SenM          "		;Display-Text fr Anzeigeposition 5 (4 Zeichen im 8-Sensor-Modus, ungenutzt im 4-Sensor-Modus)
	.db	"SenN          "		;Display-Text fr Anzeigeposition 6 (4 Zeichen im 8-Sensor-Modus, ungenutzt im 4-Sensor-Modus)
	.db	"SenO          "		;Display-Text fr Anzeigeposition 7 (4 Zeichen im 8-Sensor-Modus, ungenutzt im 4-Sensor-Modus)
	.db	"SenP          "		;Display-Text fr Anzeigeposition 8 (4 Zeichen im 8-Sensor-Modus, ungenutzt im 4-Sensor-Modus)
;
; In der Alarm-Invertierungs-Tabelle wird festgelegt, wie die Alarmmeldungen auszuwerten sind: 0 = normal, 1 = invertiert. Bei einem Arbeitskontakt am Sensormodul ist hier 0 und bei einem Ruhekontakt
; 1 einzutragen:
;
ealmin:	.db	0			;Invertierung fr Alarm 1 (Alarm-Kontakt geffnet)
	.db	0			;Invertierung fr Alarm 2 (Alarm-Kontakt geffnet)
	.db	0			;Invertierung fr Alarm 3 (Alarm-Kontakt geffnet)
	.db	0			;Invertierung fr Alarm 4 (Alarm-Kontakt geffnet)
;
; Hier knnen die Alarmnamen festgelegt werden (4 Texte mit je 12 Zeichen). Werden weniger als 12 Zeichen verwendet, dann ist der Name mit Leerzeichen aufzufllen:
;
ealmtx:	.db	"Eingang 1   "		;Display-Text bei Alarm 1 (12 Zeichen)
	.db	"Eingang 2   "		;Display-Text bei Alarm 2 (12 Zeichen)
	.db	"Eingang 3   "		;Display-Text bei Alarm 3 (12 Zeichen)
	.db	"Eingang 4   "		;Display-Text bei Alarm 4 (12 Zeichen)
;
eprsth:	.db	4			;Schwellwert fr Luftdruck-Tendenz-Anzeige, ab dem hier eingestellten Differenzwert wird eine fallende oder steigende Tendenz angezeigt (Wertebereich 2-9)
;
epoint:	.db	7			;selbst definiertes Zeichen (Komma) zwischen Einer und Zehntel bei Temperaturwerten (alternativ jedes ASCII-Zeichen ab 0x20 mglich, z.B. '.' oder ',')
;
