; ------------------------------------------------------------
; EEPROM-Werte fr eine Beispielkonfiguration 1 (Sensoren 1-8)
; ------------------------------------------------------------
;
.eseg
;
edummy:	.db	0xff,0xff	;Bytes 0/1 werden nicht genutzt
;
;
; Anzeige-Tabelle, enthlt die 8 Sensornummern (im Bereich 1-16) in der
; Reihenfolge, wie sie auf dem LCD angezeigt werden sollen. An den
; Positionen, die nicht genutzt werden, muss eine 0 eingetragen werden.
; Die LCD-Positionen sind folgendermaen definiert:
;
;  ---------------------
; | Pos. 1       Pos. 5 |	Beispiel: Soll auf der LCD-Position 6
; | Pos. 2       Pos. 6 |	der Temperaturwert von Sensor 12 ange-
; | Pos. 3       Pos. 7 |	zeigt werden, dann muss in "etempm" an
; | Pos. 4       Pos. 8 |	6. Stelle eine 12 stehen.
;  ---------------------
;
etempm:	.db	1,2,3,4,5,6,7,8	;8 Werte, siehe oben
;
;
; Alarm-Werte-Tabelle, hier wird festgelegt, wie die Alarmmeldungen
; auszuwerten sind: 0=normal, 1=invertiert. Bei einem Arbeitskontakt am
; Sensormodul ist hier 0 und bei einem Ruhekontakt 1 einzutragen
;
ealmin:	.db	0,0,0,0		;hier keine Invertierung
;
;
; Temperaturtexte, diese werden unabhngig von der oben beschriebenen
; Anzeige-Tabelle  der Reihe nach auf die LCD-Positionen 1-8 geschrie-
; ben. (8 Texte mit je 4 Zeichen), Umlaute mssen entsprechend des LCD-
; Zeichensatzes kodiert werden:
; = 0xe1, = 0xef, = 0xf5, = 0xe2 (gilt fr die meisten LCD mit
; HD44780, im Zweifelsfall bitte im Datenblatt nachschauen)
;
etempt: .db     "T-01"		;Display-Text fr Temperatur 1
        .db     "T-02"		;Display-Text fr Temperatur 2
        .db     "T-03"		;Display-Text fr Temperatur 3
        .db     "T-04"		;Display-Text fr Temperatur 4
        .db     "T-05"		;Display-Text fr Temperatur 5
        .db     "T-06"		;Display-Text fr Temperatur 6
        .db     "T-07"		;Display-Text fr Temperatur 7
        .db     "T-08"		;Display-Text fr Temperatur 8
;
;
; Alarmtexte, diese werden bei einem Alarm auf dem LCD angezeigt
; (4 Texte mit je 12 Zeichen)
;
ealmtx:	.db	"Test-Alarm 1"	;Display-Text bei Alarm 1 (12 Zeichen)
	.db	"Test-Alarm 2"	;Display-Text bei Alarm 2 (12 Zeichen)
	.db	"Test-Alarm 3"	;Display-Text bei Alarm 3 (12 Zeichen)
	.db	"Test-Alarm 4"	;Display-Text bei Alarm 4 (12 Zeichen)
;
;
; Unteres Temperaturlimit, bei Unterschreitung blinkt der Temperatur-
; wert und ein Alarm wird ausgelst. Alle Werte mssen in Grad Celsius
; angegeben werden, auch negative Werte sind mglich. Ein Wert von 128
; schaltet die Alarmberwachung aus. Die Reihenfolge der Werte ent-
; spricht der Anzeigeposition 1-8
;
eliml:	.db	15,15,15,15,15,15,15,15	;Alarm wenn Temp. unter 15 Grad
;
;
; Oberes Temperaturlimit, bei berschreitung blinkt der Temperaturwert
; und ein Alarm wird ausgelst. Alle Werte mssen in Grad Celsius
; angegeben werden, auch negative Werte sind mglich. Ein Wert von 128
; schaltet die Alarmberwachung aus. Die Reihenfolge der Werte ent-
; spricht der Anzeigeposition 1-8
;
elimh:	.db	35,35,35,35,35,35,35,35	;Alarm wenn Temp. ber 35 Grad
;
