;	--------------------------------------------------
;	Gong fr Multifunktionsuhr, ATmega8 mit 4,00 MHz
;	Gong-Steuerung, Steuerung des Infrarot-Empfangs
;	(RC5-Code), RC5-Routinen stammen aus AVR410.asm
;	--------------------------------------------------
;
;	Version 1.00, letzte Bearbeitung am 24.02.2006
;
;
;	Einstellung der Fuse-Bits:
;
;	CKSEL3, CKSEL2, CKSEL1, CKSEL0 = 1111 (unprogrammiert)
;	SUT1, SUT0		       = 11   (unprogrammiert)
;	BODLEVEL, BODEN		       = 00   (programmiert)
;
;
;	Belegung der Ports
;	------------------
;	PortB0: Ausgang, Adresse 14 fr EPROM
;	PortB1: Eingang, Gongsteuerung (vom Hauptprozessor)
;	PortB2: Eingang, Infrarot-Empfnger (mit Pull-up)
;	PortB3: Ausgang, zur Taste 1 (ber 4,7k)
;	PortB4: Ausgang, zur Taste 2 (ber 4,7k)
;		wird in den ersten 3 Sekunden nach Systemstart als
;		Eingang verwendet (Abfrage von Taste 2 zur RC5-
;		Programmierung)
;	PortB5:	Ausgang, zum LED-Treiber fr Dezimalpunkt
;	PortC0: Ausgang, Adresse 08 fr EPROM
;	PortC1: Ausgang, Adresse 09 fr EPROM
;	PortC2: Ausgang, Adresse 10 fr EPROM
;	PortC3: Ausgang, Adresse 11 fr EPROM
;	PortC4: Ausgang, Adresse 12 fr EPROM
;	PortC5: Ausgang, Adresse 13 fr EPROM
;	PortD0: Ausgang, Adresse 00 fr EPROM
;	PortD1: Ausgang, Adresse 01 fr EPROM
;	PortD2: Ausgang, Adresse 02 fr EPROM
;	PortD3: Ausgang, Adresse 03 fr EPROM
;	PortD4: Ausgang, Adresse 04 fr EPROM
;	PortD5: Ausgang, Adresse 05 fr EPROM
;	PortD6: Ausgang, Adresse 06 fr EPROM
;	PortD7: Ausgang, Adresse 07 fr EPROM
;
;	Belegung der Timer
;	------------------
;	Timer0: Interrupt alle 64s (Vorteiler 1, Overflow)
;	Timer1: Interrupt alle 10ms (Vorteiler 1, Compare bei 40000)
;
.nolist
.include "m8def.inc"
.list
;
.def	inttmp	=r1
.def	ref1	=r2
.def	ref2	=r3
.def	timerl	=r22
.def	timerh	=r23
.def	syscod	=r24
.def	comcod	=r25
.def	bitcnt	=r26
.def	timerx	=r27
.def	timery	=r28
;
.dseg
.org	0x60
;
t1cmem:	.byte	1		;Puffer fr Taste1-Code (aus EEPROM)
t2cmem:	.byte	1		;Puffer fr Taste2-Code (aus EEPROM)
lastrc:	.byte	1		;Puffer fr letzten empfangenen Code
t1temp:	.byte	1		;Zwischenspeicher Taste 1 (Lernmodus)
t2temp:	.byte	1		;Zwischenspeicher Taste 2 (Lernmodus)
gngtmp:	.byte	1		;Gongstart wird whrend Wartescheifen
				;bei Tastenausgabe gelesen und gepuffert
;
.cseg
.org	0x0000
;
reset:	rjmp	start			;Programmstart
;
.org	oc1aaddr
	rjmp	tim1in			;Timer1a-Interrupt
;
.org	ovf0addr
	rjmp	tim0in			;Timer0-Interrupt
;
.org	spmraddr+1
;
;	Initialisierung
;
start:	cli				;Interrupts sperren
	wdr				;Watchdog zurcksetzen
	ldi	r16,0b00001000		;Watchdog aktivieren (15ms)
	out	wdtcr,r16
	ldi	r16,low(ramend)
	out	spl,r16			;Stackpointer setzen
	ldi	r17,high(ramend)
	out	sph,r17			;Stackpointer setzen
	ldi	r16,0xff
	out	ddrd,r16		;PortD, alles Ausgnge (8)
	ldi	r16,0x3f
	out	ddrc,r16		;PortC, alles Ausgnge (6)
	ldi	r16,0b00101001
	out	ddrb,r16		;PortB, Bit 0,3,5=A; Bit 1,2,4=E
	clr	r16
	out	portd,r16		;PortD, alle Ausgnge auf 0
	out	portc,r16		;PortC, alle Ausgnge auf 0
	ldi	r16,0b00011100		;PortB, Ausgnge und Pullups
	out	portb,r16		;setzen
;
	ldi	r16,1			;Timer0, Vorteiler=1
	out	tccr0,r16
	ldi	r16,0x09		;Timer1, Vorteiler=1
	out	tccr1b,r16
	ldi	r16,high(40000)		;Teiler (H) fr 10ms-Interrupt
	out	ocr1ah,r16
	ldi	r16,low(40000)		;Teiler (L) fr 10ms-Interrupt
	out	ocr1al,r16
	ldi	r16,(1<<ocie1a)+(1<<toie0);Timer0 Overflow-Interrupt,
	out	timsk,r16		;Timer1 Output Compare Interrupt
	sei				;Interrupt aktivieren
;
	ldi	r16,t1code		;EEPROM-Adresse von Taste1-Code
	out	eearl,r16		;setzen
	ldi	r16,1<<eere		;EEPROM Lesebefehl
	out	eecr,r16
	in	r17,eedr		;Datenbyte holen
	sts	t1cmem,r17		;und speichern
	ldi	r16,t2code		;EEPROM-Adresse von Taste1-Code
	out	eearl,r16		;setzen
	ldi	r16,1<<eere		;EEPROM Lesebefehl
	out	eecr,r16
	in	r17,eedr		;Datenbyte holen
	sts	t2cmem,r17		;und speichern
	ser	r16			;Puffer fr letzten empfangenen
	sts	lastrc,r16		;RC5-Code initialisieren (0xff)
	clr	r16			;Puffer fr Gongstart
	sts	gngtmp,r16		;lschen
;
;	Warteschleife 5,12 Sekunden, nach Ablauf der Wartezeit wird die
;	Taste 2 abgefragt, wenn gedrckt -> Sprung in den Lernmodus
;
	clr	timerx
	clr	timery
wait5:	cpi	timery,2		;5,12 Sekunden erreicht?
	brlo	wait5			;nein -> Schleife
;
;	Taste 2 abfragen (Start der RC5-Programmierung wenn gedrckt)
;
	in	r17,pinb		;Taste 2 einlesen
	ldi	r16,0b00111001		;Port fr Taste 2 wird jetzt
	out	ddrb,r16		;als Ausgang gesetzt
	bst	r17,4			;war Taste 2 gedrckt?
	brts	input			;nein -> Hauptschleife
	rjmp	setrc5			;sonst zur RC5-Programmierung
;
;	Hauptschleife, Warten auf RC5-Signale und Gong-Startsignal
;
input:	rcall	detect			;RC5-Empfang starten
	cpi	syscod,0xff		;gltiger System-Code?
	breq	inp010			;nein -> weiter mit Gong
	cpi	comcod,0xff		;gltiger Command-Code?
	brne	chkrc5			;ja -> auswerten
inp010:	sts	lastrc,comcod		;sonst letzen RC5-Wert lschen
	lds	r16,gngtmp		;gepufferten Gongstart holen
	bst	r16,1			;Bit 1 gesetzt (Gongstart)?
	clr	r16			;Gongstart-Puffer
	sts	gngtmp,r16		;lschen
	brts	gong			;ja -> Gong starten
	in	r16,pinb		;PortB einlesen
	bst	r16,1			;Bit 1 gesetzt (Gongstart)?
	brtc	input			;nein -> Schleife
;
;	Gongausgabe, Zykluszeit=90,75s (11019 Hz), ideal: 11025 Hz
;
gong:	cli				;Interrupts sperren
	clr	r16			;Low-Zhler=0
	clr	r17			;High-Zhler=0
	ldi	r18,1			;Wert zur Zhlererhhung (L)
	clr	r19			;Wert zur Zhlererhhung (H)
	ldi	r20,0x1c		;PortB Standardwerte
loop1:	bst	r17,6			;High-Bit 6 (Bit 14) holen
	bld	r20,0			;und fr PortB vorbereiten
	out	portd,r16		;Bits 0-7 ausgeben
	out	portc,r17		;Bits 8-13 ausgeben
	out	portb,r20		;Bit 14 ausgeben
	add	r16,r18			;L-Zhler erhhen
	adc	r17,r19			;H-Zhler erhhen (bertrag)
	wdr				;Watchdog zurcksetzen
	nop
	ldi	r21,117
loop2:	dec	r21			;Warteschleife fr Ausgabe-
	brne	loop2			;Frequenz von ca. 11025 Hz
	bst	r17,7			;Ende erreicht?
	brtc	loop1			;ja -> Schleife
;
;	Alle Portpins zurcksetzen, Hauptschleife
;
	clr	r16
	ldi	r17,0x1c		;PortB, Ausgang 0 auf 0,
	out	portd,r16		;PortD, alle Ausgnge auf 0
	out	portc,r16		;PortC, alle Ausgnge auf 0
	out	portb,r17		;Eingang 1 auf 0, Rest auf 1
	sei				;Interrupts wieder aktivieren
	rjmp	input			;Ende
;
;	Empfangene Infrarot-Daten (RC5) auswerten
;
chkrc5:	andi	comcod,0x3f		;Toggle-Bit lschen
	lds	r18,lastrc		;letzten RC5-Wert holen
	cp	comcod,r18		;wurde der Wert bereits empfangen?
	breq	input			;ja -> zurck in die Hauptschleife
	sts	lastrc,comcod		;sonst neues Zeichen speichern
	lds	r17,t1cmem		;Wert fr Taste 1 holen
	cp	comcod,r17		;Zeichen fr Taste 1?
	brne	chk010			;nein -> weiter testen
	ldi	r16,0x14		;Portwert fr Taste 1 setzen
	rjmp	chk020			;weiter
chk010:	lds	r17,t2cmem		;Wert fr Taste 2 holen
	cp	comcod,r17		;Zeichen fr Taste 2?
	brne	input			;nein -> Hauptschleife
	ldi	r16,0x0c		;Portwert fr Taste 2 setzen
chk020:	out	portb,r16		;Portausgabe (Taste aktivieren)
	clr	timerx			;10ms-Timer lschen
chk030:	in	r16,pinb		;PortB einlesen
	bst	r16,1			;Bit 1 gesetzt (Gongstart)?
	brtc	chk040			;nein -> weiter
	sts	gngtmp,r16		;sonst Gongstart puffern
chk040:	cpi	timerx,5		;Zeit (50ms) abgelaufen?
	brlo	chk030			;nein -> warten
	ldi	r16,0x1c		;Tasten wieder deaktivieren
	out	portb,r16		;Portausgabe
	clr	timerx			;10ms-Timer lschen
chk050:	in	r16,pinb		;PortB einlesen
	bst	r16,1			;Bit 1 gesetzt (Gongstart)?
	brtc	chk060			;nein -> weiter
	sts	gngtmp,r16		;sonst Gongstart puffern
chk060:	cpi	timerx,4		;Zeit (40ms) abgelaufen?
	brlo	chk050			;nein -> warten
	rjmp	input
;
;	Lernmodus, 2 Infrarot-Werte einlesen und im EEPROM speichern
;
setrc5:	ldi	r29,2			;2 Werte einlesen und speichern
set010:	ldi	r16,0x3c		;LED-Ausgang aktivieren
	out	portb,r16		;Portausgabe
	clr	timerx			;10ms-Timer lschen
	clr	timery			;2,56s-Timer lschen
set020:	cpi	timery,4		;10,24s Wartezeit vorber?
	brlo	set030			;nein -> auf RC5-Zeichen warten
	ldi	r16,0x1c		;sonst LED-Ausgang deaktivieren
	out	portb,r16		;Portausgabe
	rjmp	input			;Sprung zur Hauptschleife
set030:	rcall	detect			;RC5-Empfang starten
	cpi	syscod,0xff		;gltiger System-Code?
	breq	set020			;nein -> wiederholen
	cpi	comcod,0xff		;gltiger Command-Code?
	breq	set020			;nein -> wiederholen
	andi	comcod,0x3f		;Toggle-Bit lschen
	cpi	r29,2			;erstes Zeichen?
	brne	set040			;nein -> zweites Zeichen
	sts	t1temp,comcod		;erstes Zeichen zwischenspeichern
	rjmp	set050
set040:	lds	r16,t1temp		;sonst erstes Zeichen holen
	cp	r16,comcod		;erstes = zweites Zeichen?
	breq	set020			;ja -> Zeichen 2 neu einlesen
	sts	t2temp,comcod		;zweites Zeichen zwischenspeichern
set050:	ldi	r16,0x1c		;LED-Ausgang deaktivieren
	out	portb,r16		;Portausgabe
	clr	timerx			;10ms-Timer lschen
set060:	cpi	timerx,50		;Zeit (500ms) abgelaufen?
	brlo	set060			;nein -> Schleife
	dec	r29			;alle Zeichen empfangen?
	brne	set010			;nein -> nchstes Zeichen
;
	lds	r16,t1temp		;gepuffertes Zeichen 1 holen
	sts	t1cmem,r16		;und speichern
	lds	r17,t2temp		;gepuffertes Zeichen 2 holen
	sts	t2cmem,r17		;und speichern
set100:	sbic	eecr,eewe		;EEPROM-Write bereit?
	rjmp	set100			;nein -> Schleife
	ldi	r18,t1code		;EEPROM-Adresse von Zeichen 1
	out	eearl,r18		;Adresse setzen
	out	eedr,r16		;Daten von Zeichen 1
	sbi	eecr,eemwe		;EEPROM-Schreiben freigeben
	sbi	eecr,eewe		;Daten in EEPROM schreiben
set110:	sbic	eecr,eewe		;EEPROM-Write bereit?
	rjmp	set110			;nein -> Schleife
	ldi	r18,t2code		;EEPROM-Adresse von Zeichen 2
	out	eearl,r18		;Adresse setzen
	out	eedr,r17		;Daten von Zeichen 2
	sbi	eecr,eemwe		;EEPROM-Schreiben freigeben
	sbi	eecr,eewe		;Daten in EEPROM schreiben
	rjmp	input			;zur Hauptschleife
;
;	RC5-Empfang (entspricht der Application Note AVR410)
;
detect:	clr	inttmp			;temporren Timer lschen
	clr	timerh
detct1:	clr	timerl
detct2:	cpi	timerh,8		;Leerlauf fr 131ms?
	brlo	dl1			;nein -> weiter
	rjmp	fault			;sonst Fehler
dl1:	cpi	timerl,55		;Aktiv fr 3,5ms?
	brge	start1			;ja -> auf Startbit warten
	sbis	pinb,2			;Pegelabfrage
	rjmp	detct1			;low -> Sprung zu detect1
	rjmp	detct2			;high -> Sprung zu detect2
start1:	cpi	timerh,8		;Startbit innerhalb 131ms?
	brge	fault			;nein -> Ende
	sbic	pinb,2			;auf Startbit warten
	rjmp	start1
	clr	timerl			;Startbit-Lnge messen
start2:	cpi	timerl,17		;Startbit lnger als 1,1ms?
	brge	fault			;ja - Ende
	sbis	pinb,2
	rjmp	start2			;positive Flanke vom Startbit
	mov	r16,timerl		;Timer enthlt 1/2 Bitzeit
	clr	timerl
	mov	ref1,r16
	lsr	ref1
	mov	ref2,ref1
	add	ref1,r16		;ref1 = 3/4 Bitzeit
	lsl	r16
	add	ref2,r16		;ref2 = 5/4 Bitzeit
start3:	cp	timerl,ref1		;High lnger als > 3/4 Bitzeit?
	brge	fault			;ja -> Ende
	sbic	pinb,2			;auf fallende Flanke warten
	rjmp	start3
	clr	timerl
	ldi	bitcnt,12		;12 Bits empfangen
	clr	comcod
	clr	syscod
sample:	cp	timerl,ref1		;Eingang eine 1/4 Bitzeit lesen
	brlo	sample
	sbic	pinb,2
	rjmp	bit1			;Leitung High
bit0:	clc				;eine '0' speichern
	rol	comcod
	rol	syscod			;Timing synchronisieren
bit0a:	cp	timerl,ref2		;Flanke innerhalb 3/4 Bitzeit?
	brge	fault			;ja -> Ende
	sbis	pinb,2			;in der Bitmitte auf
	rjmp	bit0a			;steigende Flanke warten
	clr	timerl
	rjmp	nexbit
bit1:	sec				;eine '1' speichern
	rol	comcod
	rol	syscod			;Timing synchronisieren
bit1a:	cp	timerl,ref2		;Flanke innerhalb 3/4 Bitzeit?
	brge	fault			;ja -> Ende
	sbic	pinb,2			;in der Bitmitte auf
	rjmp	bit1a			;fallende Flanke warten
	clr	timerl
nexbit:	dec	bitcnt			;alle Bits empfangen?
	brne	sample			;nein -> nchstes Bit holen
;
	mov	r16,comcod		;System-Code-Bits speichern
	rol	r16
	rol	syscod
	rol	r16
	rol	syscod
	bst	syscod,5		;Toggle-Bit in
	bld	comcod,6		;Command-Byte legen
	andi	comcod,0b01111111	;relevante Bits filtern
	andi	syscod,0x1f		;relevante Bits filtern
	ret
;
fault:	ser	comcod			;Command-Code und System-Code
	ser	syscod			;0xFF setzen
	ret
;
;	Interrupt Timer0 Overflow
;	erhht timerl alle 64s und timerh alle 16,384ms
;
tim0in:	in	r0,sreg			;S-Register sichern
	inc	timerl			;TimerL erhhen (64s)
	inc	inttmp			;temporren Timer erhhen
	brne	t0exit			;bertrag? nein -> Ende
	inc	timerh			;sonst TimerH erhhen
t0exit:	out	sreg,r0			;S-Register wiederherstellen
	reti
;
tim1in:	in	r0,sreg			;S-Register sichern
	wdr				;Watchdog zurcksetzen
	inc	timerx			;TimerX erhhen (10ms)
	brne	t1exit			;bertrag? nein -> Ende
	inc	timery			;sonst TimerY erhhen (2,56s)
t1exit:	out	sreg,r0			;S-Register wiederherstellen
	reti
;
.eseg
;
versnr:	.db	0			;erstes Byte nicht verwenden
	.db	1			;Versions-Nummer (3 Byte)
	.db	0
	.db	0
;
t1code:	.db	0xff			;RC5-Code fr Taste 1
t2code:	.db	0xff			;RC5-Code fr Taste 2
