; ===============================================
; Multifunktionsuhr mit AT90S8535 oder ATmega8535
; ===============================================
;
; Version 1.28, letzte Bearbeitung am 30.09.2007
;		- Die automatische Anzeige wechselt jetzt alle 4 Sekun-
;		  den (und nicht mehr alle 6 Sekunden)
;		- Datumszhlung ergnzt: Beim Tageswechsel wird jetzt
;		  sofort das neue Datum angezeigt und nicht mehr auf
;		  eine DCF/HBG-Synchronisierung gewartet
;
; Version 1.27, letzte Bearbeitung am 04.03.2007
;		- Verbesserung der DCF/HBG-Dekodierung durch zustzli-
;		  chen Zwischenspeicher, jetzt mssen 3 (anstatt 2 wie
;		  bisher) Minutenzyklen genau stimmen, damit die Uhr
;		  synchronisiert wird
;
; Version 1.26, letzte Bearbeitung am 07.05.2005
;		- Anpassung an HBG75 (Schweizer Zeitzeichensender),
;		  die Uhr kann jetzt wahlweise mit DCF77 oder HBG75
;		  Empfnger betrieben werden
;
; Version 1.25, letzte Bearbeitung am 04.01.2003
;		- Zeichensatz fr Kleinbuchstaben verbessert (i,r,z)
;		- bei 2-stelligen Minus-Temperaturen "C" entfernt
;
; Version 1.24, letzte Bearbeitung am 25.12.2002
;		- Kompaktmodus-Anzeige jetzt mit Wochentag
;		- Fehler Timer beseitigt (Uhr ging nach)
;
; Version 1.23, letzte Bearbeitung am 02.11.2002
;		- Anzeige auch fr Temperaturen unter 0C
;		- DCF-Statusanzeige korrigiert
;
; Version 1.22, letzte Bearbeitung am 04.08.2002
;		- Impuls auf Gongausgang auf 2 s verlngert
;		- Dezimalpunkt zeigt DCF-Signal, wenn die Uhr noch
;		  nicht synchronisiert wurde
;		- DCF-Auswertung verbessert
;		- DCF-Ausfallanzeige, wenn ber 2 Stunden kein verwert-
;		  bares Signal empfangen wird (Dezimalpunkt 0 leuchtet)
;
;	----------------------
;	Belegung der I/O-Ports
;	----------------------
;
;	A0: Steuerausgang fr Temperatur-Sensor DS1620 - 3Wire (Rst)
;	A1: Digitaleingang (Pull-up) fr DCF77-Empfnger
;	A2: Digitaleingang (Pull-up) fr Taste 1 (Men/+)
;	A3: Digitaleingang (Pull-up) fr Taste 2 (OK/Sleep)
;	A4: Anodentreiber Textdisplay D0 (H-aktiv)
;	A5: Anodentreiber Textdisplay D1 (H-aktiv)
;	A6: Anodentreiber Textdisplay D2 (H-aktiv)
;	A7: Anodentreiber Textdisplay D3 (H-aktiv)
;
;	B0: Digitausgang Zeitdisplay D0 (H-aktiv)
;	B1: Digitausgang Zeitdisplay D1 (H-aktiv)
;	B2: Digitausgang Zeitdisplay D2 (H-aktiv)
;	B3: Digitausgang Zeitdisplay D3 (H-aktiv)
;	B4: Anodentreiber Zeitdisplay D0 (H-aktiv)
;	B5: Anodentreiber Zeitdisplay D1 (H-aktiv)
;	B6: Dezimalpunkttreiber Zeitdisplay (H-aktiv)
;	B7: Steuerausgang fr Stundengong (H-aktiv)
;
;	C0: Kathodentreiber Textdisplay Ka (H-aktiv) - 3Wire (DQ)
;	C1: Kathodentreiber Textdisplay Kb (H-aktiv) - 3Wire (Clk)
;	C2: Kathodentreiber Textdisplay Kc (H-aktiv)
;	C3: Kathodentreiber Textdisplay Kd (H-aktiv)
;	C4: Kathodentreiber Textdisplay Ke+f (H-aktiv)
;	C5: Kathodentreiber Textdisplay Kg (H-aktiv)
;	C6: Kathodentreiber Textdisplay Kh (H-aktiv)
;	C7: Kathodentreiber Textdisplay Ki (H-aktiv)
;
;	D0: Kathodentreiber Textdisplay Kj (H-aktiv)
;	D1: Kathodentreiber Textdisplay Kk (H-aktiv)
;	D2: Kathodentreiber Textdisplay Kl (H-aktiv)
;	D3: Kathodentreiber Textdisplay Km (H-aktiv)
;	D4: Kathodentreiber Textdisplay Kn (H-aktiv)
;	D5: Kathodentreiber Textdisplay Ko (H-aktiv)
;	D6: Kathodentreiber Textdisplay Kp (H-aktiv)
;	D7: Kathodentreiber Textdisplay Kx (H-aktiv)
;
;	------------------
;	Belegung der Timer
;	------------------
;
;	Timer1:	Multiplexsteuerung der Displays
;		Zeitzhlung (mit IRQ Compare A)
;
;	-----------------------------------
;	Standard-Definitionen fr AT90S8535
;	-----------------------------------
;
.include "8535def.inc"
;
;	---------------------------------
;	Zustzliche Register-Definitionen
;	---------------------------------
;
.def	tflag=	r15	;Zwischenspeicher fr Statusregister bei IRQ
.def	temp=	r25	;temporrer Zwischenspeicher fr Hauptprogramm
;
;	--------------------
;	Konstanten festlegen
;	--------------------
;
.equ	tm1end=	4095	;Timer1 Vergleichswert (1024 Interrupts/s)
.equ	year2=	'0'	;Jahr Hunderter (ASCII 0)
.equ	year3=	'2'	;Jahr Tausender (ASCII 2)
.equ	bdays=	24	;Anzahl der Geburtstage
.equ	dtimeo=	120	;DCF77-Timeout (120 Minuten)
;
;	------------------------
;	Speicheradressen im SRAM
;	------------------------
;
.dseg
.org	0x60
;
segbuf:	.byte	20	;Anzeigespeicher fr Textdisplay
			;Byte  0: Segmente a-i Anzeige 0 (rechts)
			;Byte  9: Segmente a-i Anzeige 9 (links)
			;Byte 10: Segmente j-x Anzeige 0 (rechts)
			;Byte 19: Segmente j-x Anzeige 9 (links)
texbuf:	.byte	10	;Zwischenspeicher fr Textdisplay-ASCII
timbuf:	.byte	4	;Anzeigespeicher fr Zeitdisplay
			;Byte 0: Anzeige 0 (rechts)
			;Byte 3: Anzeige 3 (links)
timept:	.byte	1	;Zwischenspeicher fr Dezimalpunkte
			;Bit 0: Dezimalpunkt Anzeige 0
			;Bit 3: Dezimalpunkt Anzeige 3
muxtex:	.byte	1	;Multiplexzhler fr Textdisplay (0-9)
muxtim:	.byte	1	;Multiplexzhler fr Zeitdisplay (0-3)
pcoun1:	.byte	1	;Vorteiler 1 (0-16) \ Vorteiler 1 und 2 zhlen
pcoun2:	.byte	1	;Vorteiler 2 (0-64) / zusammen bis 1024
second:	.byte	1	;Uhr-Sekundenzhler (0-59)
minutl:	.byte	1	;Uhr-Minutenzhler Einer (0-9)
minuth:	.byte	1	;Uhr-Minutenzhler Zehner (0-5)
hourl:	.byte	1	;Uhr-Stundenzhler Einer (0-9)  \ zhlen zusam-
hourh:	.byte	1	;Uhr-Stundenzhler Zehner (0-2) / men bis 24
dayw:	.byte	1	;Wochentag (1-7)
dayl:	.byte	1	;Kalendertag Einer (0-9)
dayh:	.byte	1	;Kalendertag Zehner (0-3)
monthl:	.byte	1	;Monat Einer (0-9)
monthh:	.byte	1	;Monat Zehner (0-1)
yearl:	.byte	1	;Jahr Einer (0-9)
yearh:	.byte	1	;Jahr Zehner (0-9)
tzone:	.byte	1	;Zeitzone (0=Winterzeit, 1=Sommerzeit)
xflags:	.byte	1	;verschiedene Flags
			;Bit 0: Taste 1 gedrckt   \
			;Bit 1: Taste 2 gedrckt    \ wird von Timer-
			;Bit 2: Taste 1 entprellt   / Int. gesteuert
			;Bit 3: Taste 2 entprellt  /
			;Bit 4: Taste 1 bearbeitet \ wird von Timer-
			;Bit 5: Taste 2 bearbeitet / Interrupt gelscht
			;Bit 6: Gong auslsen (Rcksetzen durch Timer)
			;Bit 7: Sleep (Display in Sparmodus)
gngcnt:	.byte	1	;Gong-Zhler, wird beim Auslsen des Gongs auf
			;128 Vorteilerzyklen (=2s) gesetzt und auf 0
			;heruntergezhlt
dcfcnt:	.byte	1	;DCF77-Zhler, Impuls-Zhlung (Zyklen)
dcftab:	.byte	6	;DCF77-Tabelle, enthlt empfangene Bits
			;eingehende Bits werden in Byte 5, Bit 7 ein-
			;geschoben und alle weiteren Bits um eine
			;Position weitergerckt, Byte/Bit-Positionen
			;nach einem kompletten Minutenzyklus:
			;0/6-7: Zeitzone (6=1 Sommer, 7=1 Winter)
			;1/2-5: Minute Einer
			;1/6-7: Minute Zehner LSB
			;2/0:   Minute Zehner MSB
			;2/1:   Prfbit 1 (Minuten)
			;2/2-5: Stunde Einer
			;2/6-7: Stunde Zehner
			;3/0:   Prfbit 2 (Stunden)
			;3/1-4: Kalendertag Einer
			;3/5-6: Kalendertag Zehner
			;3/7:   Wochentag LSB
			;4/0-1: Wochentag MSB
			;4/2-5: Monat Einer
			;4/6:   Monat Zehner
			;4/7:   Jahr Einer LSB
			;5/0-2: Jahr Einer MSB
			;5/3-6: Jahr Zehner
			;5/7:   Prfbit 3 (Datum)
dcflag:	.byte	1	;DCF77-Flags
			;Bit 0: akueller DCF77-Zustand
			;Bit 1: vorheriger DCF77-Zustand
			;Bit 2: Uhr luft mit DCF77 synchron
			;Bit 3: Uhr wurde mind. einmal synchronisiert
			;Bit 4: Gongtest-Flag (fr Geburtstag ntig)
			;Bit 5: LED-Test-Flag
			;Bit 6: Beginn eines neuen Anzeige-Zyklus (wird
			;	durch Timer alle 6 Sekunden gesetzt,
			;	[beginnend mit Sekunde 3] und vom
			;	Hauptprogramm zurckgesetzt)
			;Bit 7: Beginn einer neuen Minute (wird durch
			;	Timer gesetzt und vom Hauptprogramm
			;	zurckgesetzt)
dcfcn1:	.byte	1	;DCF77-Zhlerstand 1 - Impulsabstand
dcfcn2:	.byte	1	;DCF77-Zhlerstand 2 - Impulslnge
dcfcn3:	.byte	1	;DCF77-Zhlerstand 3 - Impulsnummer
dcftim:	.byte	1	;DCF77-Timeout-Zhler, zhlt im Minutenabstand
			;rckwrts auf 0, wenn keine DCF-Synchronisa-
			;tion erfolgt
dcbuf1:	.byte	12	;DCF-Puffer 1, aktuelle decodierte Uhrzeit
			;Byte  0: Zeitzone
			;Byte  1: Minute Einer
			;Byte  2: Minute Zehner
			;Byte  3: Stunde Einer
			;Byte  4: Stunde Zehner
			;Byte  5: Kalendertag Einer
			;Byte  6: Kalendertag Zehner
			;Byte  7: Wochentag
			;Byte  8: Monat Einer
			;Byte  9: Monat Zehner
			;Byte 10: Jahr Einer
			;Byte 11: Jahr Zehner
dcbuf2:	.byte	12	;DCF-Puffer 2, vorherige decodierte Uhrzeit
			;+1 Minute, Aufbau wie dcbuf1
dcbuf3:	.byte	12	;DCF-Puffer 3, vorherige decodierte Uhrzeit
			;+2 Minuten, Aufbau wie dcbuf1
tempxa:	.byte	2	;Zwischenspeicher fr Temperaturberechnung
			;Wert des DS1620 Temperature-Registers
tempxb:	.byte	2	;Zwischenspeicher fr Temperaturberechnung
			;Wert des DS1620 Counter-Registers
tempxc:	.byte	2	;Zwischenspeicher fr Temperaturberechnung
			;Wert des DS1620 Slope-Registers
dimode:	.byte	1	;Anzeigemodus fr Textdisplay
			;0: Automatik (Datum,Wochentag,Temperatur)
			;1: Kompakt    'Di31 235C'
			;2: Sekunden   'SEKUNDE 59'
			;3: DCF77-Test 'Y  0640622'
			;4: Datum      '31-12-2002'
			;5: Wochentag  '  MONTAG  '
			;6: Temperatur 'TEMP 235C'
dicoun:	.byte	1	;Moduszhler fr Automatikmodus
			;zhlt von 4-6
			;4: Datum      '31-12-2000'
			;5: Wochentag  '  MONTAG  '
			;6: Temperatur 'TEMP 235C'
menmod:	.byte	1	;Men-Modus
			;0: Ende
			;1: Automatik? (Automatik-Anzeige)
			;2: Kompakt?   (Kompakt-Anzeige)
			;3: Sekunden?  (Sekunden-Anzeige)
			;4: DCF-Test?  (DCF77-Status-Anzeige)
			;5: Nachtzeit? (Standby-Zeiten einstellen)
			;6: Gongzeit?  (Gong-Zeiten einstellen)
			;7: Gongtest?  (Gong auslsen)
mencn1:	.byte	1	;Men-Timeout-Zhler
mencn2:	.byte	1	;Men-Eingabe-Zhler
menpos:	.byte	1	;Position fr blinkendes Zeichen
mench1: .byte	1	;blinkendes Zeichen 1
mench2:	.byte	1	;blinkendes Zeichen 2
sleept:	.byte	4	;Sleep-Aktivierungszeiten
			;0: Endezeit Stunden Einer
			;1: Endezeit Stunden Zehner
			;2: Beginnzeit Stunden Einer
			;3: Beginnzeit Stunden Zehner
gongtm:	.byte	4	;Gong-Aktivierungszeiten
			;0: Endezeit Stunden Einer
			;1: Endezeit Stunden Zehner
			;2: Beginnzeit Stunden Einer
			;3: Beginnzeit Stunden Zehner
bdayfl:	.byte	1	;Geburtstags-Flag, wird an Geburtstagen bei
			;Gongaktivierung durch EEPROM-Adresse L er-
			;setzt, nach Textausgabe wieder auf 0 gesetzt
bdayfh:	.byte	1	;wie bdayfl fr EEPROM-Adresse H
bdayyl:	.byte	1	;Zwischenspeicher fr Geburtsjahr L
bdayyh:	.byte	1	;Zwischenspeicher fr Geburtsjahr H
bdaytb:	.byte	bdays*6	;Geburtstagstabelle
			;Byte  0: Tag		      \
			;Byte  1: Monat		       \
			;Byte  2: Jahrhundert		\ 1. Eintrag
			;Byte  3: Jahr			/ in Tabelle
			;Byte  4: Adresse L im EEPROM  /
			;Byte  5: Adresse H im EEPROM /
			;Byte  6: Tag                 \
			;Byte  7: Monat		       \
			;Byte  8: Jahrhundert		\ 2. Eintrag
			;Byte  9: Jahr			/ in Tabelle
			;Byte 10: Adresse L im EEPROM  /
			;Byte 11: Adresse H im EEPROM /
bdaytx:	.byte	100	;Beginn des Puffers fr Geburtstagstext
;
;	---------------------------------
;	Prgrammbeginn, Interrupt-Vektoren
;	---------------------------------
;
.cseg
.org	0x0000
;
reset:	rjmp	start			;Programmstart
exint0:	reti				;nicht genutzt
exint1:	reti				;nicht genutzt
t2comp:	reti				;nicht genutzt
t2ovfl:	reti				;nicht genutzt
t1icap:	reti				;nicht genutzt
t1coma:	rjmp	timint			;Multiplexer und Zeitzhler
t1comb:	reti				;nicht genutzt
t1ovfl:	reti				;nicht genutzt
t0ovfl:	reti				;nicht genutzt
spiint:	reti				;nicht genutzt
uartrx:	reti				;nicht genutzt
uartem:	reti				;nicht genutzt
uarttx:	reti				;nicht genutzt
adccom:	reti				;nicht genutzt
eeprom:	reti				;nicht genutzt
ancomp:	reti				;nicht genutzt
;
;	Initialisierung von Watchdog, RAM, I/O und Interrupt
;
start:	cli				;Interrupts sperren
	wdr				;Watchdog zurcksetzen
	ldi	temp,0b00001000		;Watchdog aktivieren, 15ms
	out	wdtcr,temp		;ausgeben
	ldi	temp,low(ramend)	;Stackpointer setzen
	out	spl,temp
	ldi	temp,high(ramend)
	out	sph,temp
	clr	temp
	ldi	xl,0x60			;Beginn des RAM-Bereiches Low
	ldi	xh,0			;Beginn des RAM-Bereiches High
ramclr:	st	x+,temp			;Speicherzelle lschen
	cpi	xl,low(ramend+1)	;RAM-Ende (Low) erreicht?
	brne	ramclr			;nein -> Schleife
	cpi	xh,high(ramend+1)	;RAM-Ende (High) erreicht?
	brne	ramclr			;nein -> Schleife
;
	ldi	temp,0b11110001		;PortA 1-3 als Eingang
	out	ddra,temp		;ausgeben
	ldi	temp,0b11111110		;PortA 1-3 mit Pullup und
	out	porta,temp		;Textdisplay-Mux=15 ausgeben
	ser	temp
	out	ddrb,temp		;PortB alles Ausgnge
	out	ddrc,temp		;PortC alles Ausgnge
	out	ddrd,temp		;PortD alles Ausgnge
	clr	temp
	out	portb,temp		;PortB alles auf 0
	out	portc,temp		;PortC alles auf 0
	out	portd,temp		;PortD alles auf 0
	out	tccr1a,temp		;Timer1 kein PWM, kein Compare
	ldi	temp,0b00001001		;Timer1 Lschen nach Vergleich
	out	tccr1b,temp		;und Vorteiler=1 setzen
	ldi	temp,high(tm1end)	;Timer1 Endwert1 H
	out	ocr1ah,temp		;ausgeben
	ldi	temp,low(tm1end)	;Timer1 Endwert1 L
	out	ocr1al,temp		;ausgeben
;
;	- gespeicherte Werte aus EEPROM holen (Anzeige, Nacht, Gong)
;
eep000:	ldi	r18,low(edimod)		;EEPROM-Adresse Anzeige-Modus
	ldi	r19,high(edimod)
	rcall	readee			;EEPROM-Daten lesen
	sts	dimode,r20		;und speichern
;
	ldi	r18,low(esleep)		;EEPROM-Adresse Nachtzeit ein
	ldi	r19,high(esleep)
	rcall	readee			;EEPROM-Daten lesen
	cpi	r20,24			;gltiger Wert (<24)?
	brcs	eep010			;ja -> weiter
	clr	r20			;sonst durch 0 ersetzen
eep010:	rcall	hexbcd			;in BCD wandeln
	sts	sleept+3,r21		;Nachtzeit ein (H) speichern
	sts	sleept+2,r20		;Nachtzeit ein (L) speichern
	ldi	r18,low(esleep+1)	;EEPROM-Adresse Nachtzeit aus
	ldi	r19,high(esleep+1)
	rcall	readee			;EEPROM-Daten lesen
	cpi	r20,24			;gltiger Wert (<24)?
	brcs	eep020			;ja -> weiter
	clr	r20			;sonst durch 0 ersetzen
eep020:	rcall	hexbcd			;in BCD wandeln
	sts	sleept+1,r21		;Nachtzeit aus (H) speichern
	sts	sleept,r20		;Nachtzeit aus (L) speichern
;
	ldi	r18,low(egong)		;EEPROM-Adresse Gongzeit ein
	ldi	r19,high(egong)
	rcall	readee			;EEPROM-Daten lesen
	cpi	r20,24			;gltiger Wert (<24)?
	brcs	eep030			;ja -> weiter
	clr	r20			;sonst durch 0 ersetzen
eep030:	rcall	hexbcd			;in BCD wandeln
	sts	gongtm+3,r21		;Gongzeit ein (H) speichern
	sts	gongtm+2,r20		;Gongzeit ein (L) speichern
	ldi	r18,low(egong+1)	;EEPROM-Adresse Gongzeit aus
	ldi	r19,high(egong+1)
	rcall	readee			;EEPROM-Daten lesen
	cpi	r20,24			;gltiger Wert (<24)?
	brcs	eep040			;ja -> weiter
	clr	r20			;sonst durch 0 ersetzen
eep040:	rcall	hexbcd			;in BCD wandeln
	sts	gongtm+1,r21		;Gongzeit aus (H) speichern
	sts	gongtm,r20		;Gongzeit aus (L) speichern
;
;	- gespeicherte Werte aus EEPROM holen (Geburtstagsdaten)
;
	ldi	r18,low(ebtext)		;EEPROM-Adresse fr Geburtstage
	ldi	r19,high(ebtext)
	ldi	r22,bdays		;bdays Datenstze lesen
	ldi	zl,low(bdaytb)		;Zeiger auf Geburtstagstabelle
	ldi	zh,high(bdaytb)
eep050:	rcall	readee			;EEPROM-Daten lesen
	st	z+,r20			;Geburts-Tag speichern
	inc	r18			;EEPROM-Adresse erhhen
	brne	eep060			;bertrag? nein -> weiter
	inc	r19			;sonst H-Byte erhhen
eep060:	rcall	readee			;EEPROM-Daten lesen
	st	z+,r20			;Geburts-Monat speichern
	inc	r18			;EEPROM-Adresse erhhen
	brne	eep070			;bertrag? nein -> weiter
	inc	r19			;sonst H-Byte erhhen
eep070:	rcall	readee			;EEPROM-Daten lesen
	st	z+,r20			;Geburts-Jahr H speichern
	inc	r18			;EEPROM-Adresse erhhen
	brne	eep080			;bertrag? nein -> weiter
	inc	r19			;sonst H-Byte erhhen
eep080:	rcall	readee			;EEPROM-Daten lesen
	st	z+,r20			;Geburts-Jahr L speichern
	inc	r18			;EEPROM-Adresse erhhen
	brne	eep090			;bertrag? nein -> weiter
	inc	r19			;sonst H-Byte erhhen
eep090:	st	z+,r18			;Adresse L des Namens speichern
	st	z+,r19			;Adresse H des Namens speichern
eep100:	rcall	readee			;Textzeichen lesen
	inc	r18			;EEPROM-Adresse erhhen
	brne	eep110			;bertrag? nein -> weiter
	inc	r19			;sonst H-Byte erhhen
eep110:	cpi	r19,2			;EEPROM-Ende erreicht?
	breq	eep120			;ja -> Abbruch
	cpi	r20,0xff		;Endezeichen?
	brne	eep100			;nein -> weiter suchen
	dec	r22			;alle Datenstze gelesen?
	brne	eep050			;nein -> Schleife
	rjmp	tmin10			;sonst fertig
;
eep120:	ldi	r22,bdays*6		;bdays*4 Bytes lschen
	clr	r21
	ldi	zl,low(bdaytb)		;Zeiger auf Geburtstagstabelle
	ldi	zh,high(bdaytb)
eep130:	st	z+,r21			;Tabellenplatz lschen
	dec	r22			;alle Bytes bearbeitet?
	brne	eep130			;nein -> Schleife
;
;	Temperatursensor (DS1620) initialisieren
;
tmin10:	rcall	w3actv			;3Wire-Interface aktivieren
	ldi	r22,0xac		;Kommando "Read Config"
	rcall	w3send			;Kommando senden
	rcall	w3rec8			;8 Datenbits empfangen
	rcall	w3deac			;3Wire-Interface deaktivieren
	andi	r22,0x0f		;Bits 0-3 filtern
	cpi	r22,0x0b		;DS1620 richtig konfiguriert?
					;(CPU=1, 1Shot=1)
	breq	tmin20			;ja -> weiter, sonst
	rcall	w3actv			;3Wire-Interface aktivieren
	ldi	r22,0x0c		;Kommando "Write Config"
	rcall	w3send			;Kommando senden
	ldi	r22,0x03		;Config-Byte (CPU=1, 1Shot=1)
	rcall	w3send			;Datenbyte senden
	rcall	w3deac			;3Wire-Interface deaktivieren
	rcall	waityy			;50 ms (DS1620 EEPROM Write)
tmin20:	rcall	w3actv			;3Wire-Interface aktivieren
	ldi	r22,0xee		;Kommando "Start Conversion T"
	rcall	w3send			;Kommando senden
	rcall	w3deac			;3Wire-Interface deaktivieren
;
;	- Interrupt aktivieren
;
	clr	temp
	out	gimsk,temp		;externe Interrupts sperren
	ldi	temp,0b00010000
	out	timsk,temp		;Timer1 Vergleich1 freigeben
	ldi	temp,0x0f		;Stunden Zehner dunkeltasten
	sts	timbuf+3,temp		;ausgeben
	ldi	temp,dtimeo		;DCF-Timeout-Wert laden
	sts	dcftim,temp		;und setzen
	sei
;
;	- Copyright-Meldung ausgeben
;
copyrt:	ldi	r18,20			;1 Sekunde warten
	rcall	waitnn
	ldi	zl,low(copstr*2)	;Zeiger auf Copyright-Text
	ldi	zh,high(copstr*2)
	rcall	copytx			;Text in Puffer kopieren
	rcall	outeff			;Ausgabe mit Effekt
	ldi	r18,100			;5 Sekunden warten
	rcall	waitnn
;
;	--------------------------------------------------
;	Hauptprogrammschleife, Steuerung des Sleep-Modus,
;	des Gongs, der Synchronisation und der Textanzeige
;	--------------------------------------------------
;
main:	lds	r23,dcflag		;DCF77-Flags holen
	bst	r23,3			;Uhr schon synchronisiert?
	brts	mai010			;ja -> weiter
	rjmp	mai200			;sonst weiter zur Anzeige
;
;	- Test auf Minuten=0 und Sekunden=0; wenn ok, dann
;	  Steuerung von Synchronisation, Sleep und Gong
;
mai010:	lds	r22,second		;Sekunden holen
	lds	r21,minutl		;Minuten Einer holen
	add	r22,r21			;addieren
	lds	r21,minuth		;Minuten Zehner holen
	add	r22,r21			;addieren
	tst	r22			;waren alle Werte 0?
	breq	mai030			;ja -> Sync/Sleep/Gong steuern
	rjmp	mai200			;sonst weiter mit der Anzeige
;
;	- Sleep-Steuerung
;
mai030:	lds	r20,sleept		;Endezeit Einer holen
	lds	r21,sleept+1		;Endezeit Zehner holen
	lds	r22,sleept+2		;Anfangszeit Einer holen
	lds	r23,sleept+3		;Anfangszeit Zehner holen
	cp	r20,r22			;sind Einer gleich?
	brne	mai040			;nein -> zur Nachtsteuerung
	cp	r21,r23			;sind Zehner auch gleich?
	breq	mai060			;ja -> zur Gong-Steuerung
mai040:	lds	r22,hourl		;Stunden Einer holen
	lds	r23,hourh		;Stunden Zehner holen
	swap	r23			;Zehner in oberes Nibble
	or	r22,r23			;Uhrzeit verknpfen
	lds	r21,sleept		;Sleep-Endezeit Einer holen
	lds	r23,sleept+1		;Sleep-Endezeit Zehner holen
	swap	r23			;Zehner in oberes Nibble
	or	r21,r23			;Endezeit verknpfen
	lds	r20,sleept+2		;Sleep-Anfangszeit Einer holen
	lds	r23,sleept+3		;Sleep-Anfangszeit Zehner holen
	swap	r23			;Zehner in oberes Nibble
	or	r20,r23			;Anfangszeit verknpfen
	cp	r22,r21			;Endezeit erreicht?
	brne	mai050			;nein -> weiter
	lds	r23,xflags		;Flags holen
	bst	r23,7			;Sleep-Flag schon gelscht?
	brtc	mai050			;ja -> weiter
	cbr	r23,0x80		;Sleep-Flag lschen
	sts	xflags,r23		;Flags wieder speichern
mai050:	cp	r22,r20			;Anfangszeit erreicht?
	brne	mai060			;nein -> weiter
	lds	r23,xflags		;Flags holen
	bst	r23,7			;Sleep-Flag schon gesetzt?
	brts	mai060			;ja -> weiter
	sbr	r23,0x80		;Sleep-Flag setzen
	sts	xflags,r23		;Flags wieder speichern
;
;	- Gong-Steuerung
;
mai060:	lds	r23,xflags		;Flags holen
	bst	r23,7			;Sleep-Flag gesetzt?
	brtc	mai070			;nein -> zur Gongsteuerung
	rjmp	mai200			;sonst Gongausgabe berspringen
mai070:	clr	r22			;Anfansgwert=0
	ldi	xl,low(gongtm)		;Zeiger auf Gong-Daten
	ldi	xh,high(gongtm)
	ldi	r23,4			;4 Werte addieren
mai080:	ld	r21,x+			;Gong-Wert holen
	add	r22,r21			;Zeitwert addieren
	dec	r23			;alle Werte verrechnet?
	brne	mai080			;nein -> Schleife
	tst	r22			;waren alle Werte 0?
	brne	mai090			;nein -> weiter
	rjmp	mai200			;sonst weiter zur Anzeige
mai090:	lds	r22,hourl		;Stunden Einer holen
	lds	r23,hourh		;Stunden Zehner holen
	swap	r23			;Zehner in oberes Nibble
	or	r22,r23			;Uhrzeit verknpfen
	lds	r21,gongtm		;Gong-Endezeit Einer holen
	lds	r23,gongtm+1		;Gong-Endezeit Zehner holen
	swap	r23			;Zehner in oberes Nibble
	or	r21,r23			;Endezeit verknpfen
	lds	r20,gongtm+2		;Gong-Anfangszeit Einer holen
	lds	r23,gongtm+3		;Gong-Anfangszeit Zehner holen
	swap	r23			;Zehner in oberes Nibble
	or	r20,r23			;Anfangszeit verknpfen
	cp	r21,r20			;Endezeit < Anfangszeit?
	brcc	mai100			;nein -> weiter
	cp	r22,r20			;aktuelle Zeit >= Anfangszeit?
	brcs	mai110			;nein -> weiter
	rjmp	mai120			;sonst Gong aktivieren
mai100: cp	r22,r20			;aktuelle Zeit >= Anfangszeit?
	brcs	mai200			;nein -> kein Gong
mai110:	cp	r21,r22			;Endezeit < aktuelle Zeit?
	brcs	mai200			;ja -> kein Gong
mai120:	lds	r23,xflags		;Flags holen
	bst	r23,6			;Gong-Flag bereits gesetzt?
	brts	mai200			;ja -> weiter
	sbr	r23,0x40		;sonst Gong-Flag setzen
	sts	xflags,r23		;und Flags wieder speichern
	ldi	r23,128			;Gongzhler auf 128 Zyklen
	sts	gngcnt,r23		;setzen und speichern
;
;	- Geburtstags-Steuerung
;
maibdy:	lds	r22,bdayfl		;Geburtstags-Text-Flag L holen
	lds	r23,bdayfh		;Geburtstags-Text-Flag H holen
	or	r23,r22			;Geburtstags-Text schon aktiv?
	brne	mai200			;ja -> alles berspringen
	lds	r22,dayl		;aktuellen Tag (L) holen
	lds	r23,dayh		;aktuellen Tag (H) holen
	rcall	bcdhex			;in Hex-Wert umrechnen
	mov	r20,r22			;und sichern
	lds	r22,monthl		;aktuellen Monat (L) holen
	lds	r23,monthh		;aktuellen Monat (H) holen
	rcall	bcdhex			;in Hex-Wert umrechnen
	mov	r21,r22			;und sichern
	ldi	r19,bdays		;bdays Geburtstage vergleichen
	ldi	zl,low(bdaytb)		;Zeiger auf Geburtstagstabelle
	ldi	zh,high(bdaytb)
mai130:	ld	r22,z+			;Geburts-Tag aus Tabelle holen
	ld	r23,z+			;Geburts-Monat holen
	cp	r20,r22			;stimmt Geburts-Tag?
	brne	mai140			;nein -> Rest berspringen
	cp	r21,r23			;stimmt Geburts-Monat?
	breq	mai150			;ja -> zum Geburtstagstext
mai140:	ld	r23,z+			;Geburtsjahr H berlesen
	ld	r23,z+			;Geburtsjahr L berlesen
	ld	r23,z+			;EEPROM-Adresse L berlesen
	ld	r23,z+			;EEPROM-Adresse H berlesen
	dec	r19			;alle Daten verglichen?
	brne	mai130			;nein -> Schleife
	rjmp	mai200			;weiter mit Textausgabe
mai150:	ld	r23,z+			;Geburtsjahr H lesen
	ld	r22,z+			;Geburtsjahr L lesen
	sts	bdayyl,r22		;Geburtsjahr L zwischenspeich.
	sts	bdayyh,r23		;Geburtsjahr H zwischenspeich.
	ld	r22,z+			;EEPROM-Adresse L holen
	ld	r23,z+			;EEPROM-Adresse H holen
	sts	bdayfl,r22		;Adresse in Flag L speichern
	sts	bdayfh,r23		;Adresse in Flag H speichern
;
;	- Steuerung der Textanzeige
;
mai200:	lds	r23,dcflag		;DCF77-Flags holen
	sbrc	r23,5			;LED-Test-Flag gesetzt?
	rjmp	ledtst			;ja -> Sprung zum LED-Test
	bst	r23,2			;luft Uhr synchron mit DCF77?
	brtc	mai300			;nein -> weiter
	lds	r23,dimode		;sonst Anzeige-Modus holen
	tst	r23			;Automatik-Modus?
	brne	mai300			;nein -> weiter
	lds	r23,dcflag		;sonst DCF77-Flags holen
	bst	r23,7			;Beginn einer neuen Minute?
	brtc	mai210			;nein -> weiter
	cbr	r23,0x80		;Minuten-Flag lschen
	sts	dcflag,r23		;DCF77-Flags wieder speichern
	rcall	mdcprc			;DCF77-Auswertung
	tst	r19			;DCF77 ok?
	brne	mai210			;nein -> weiter
	rcall	mtsync			;sonst Uhr synchronisieren
mai210:	lds	r23,xflags		;Flags holen
	bst	r23,2			;Taste 1 gedrckt?
	brtc	mai220			;nein -> weiter
	bst	r23,4			;Taste 1 bereits bearbeitet?
	brts	mai220			;ja -> weiter
	rjmp	menu			;sonst Sprung ins Men
mai220:	bst	r23,3			;Taste 2 gedrckt?
	brtc	mai230			;nein -> weiter
	bst	r23,5			;Taste 2 bereits bearbeitet?
	brts	mai230			;ja -> weiter
	rjmp	menu			;sonst Sprung ins Men
mai230:	lds	r23,dcflag		;DCF77-Flags holen
	bst	r23,6			;Anzeige-Flag gesetzt?
	brts	mai240			;ja -> weiter
	rjmp	main			;sonst Ende
mai240:	cbr	r23,0x40		;Anzeige-Flag lschen
	sts	dcflag,r23		;DCF77-Flags wieder speichern
	lds	r23,dicoun		;letzten Anzeige-Modus holen
	cpi	r23,4			;war Anzeige-Modus <4?
	brcc	mai250			;nein -> weiter
	ldi	r23,3			;sonst Startmodus neu setzen
mai250:	inc	r23			;Modus erhhen
	sts	dicoun,r23		;und wieder speichern
	cpi	r23,7			;Endwert erreicht?
	brcs	mai260			;nein -> weiter
	ldi	r23,4			;sonst Modus zurcksetzen
	sts	dicoun,r23		;und wieder speichern
mai260:	rcall	callmo			;Anzeige entsprechend Modus
	rcall	outeff			;Ausgabe mit Effekt
	rjmp	main			;Ende
;
mai300:	lds	r23,dcflag		;DCF77-Flags holen
	bst	r23,7			;Beginn einer neuen Minute?
	brtc	mai310			;nein -> weiter
	cbr	r23,0x80		;Minuten-Flag lschen
	sts	dcflag,r23		;DCF77-Flags wieder speichern
	rcall	mdcprc			;DCF77-Auswertung
	tst	r19			;DCF77 ok?
	brne	mai310			;nein -> weiter
	rcall	mtsync			;sonst Uhr synchronisieren
mai310:	lds	r23,xflags		;Flags holen
	bst	r23,2			;Taste 1 gedrckt?
	brtc	mai320			;nein -> weiter
	bst	r23,4			;Taste 1 bereits bearbeitet?
	brtc	menu			;nein -> Sprung ins Men
mai320:	bst	r23,3			;Taste 2 gedrckt?
	brtc	mai330			;nein -> weiter
	bst	r23,5			;Taste 2 bereits bearbeitet?
	brtc	menu			;nein -> Sprung ins Men
mai330:	lds	r23,dimode		;Anzeige-Modus holen
	tst	r23			;Automatik-Modus?
	brne	mai340			;nein -> weiter
	ldi	r23,6			;sonst Modus=6 setzen (Temp)
mai340:	cpi	r23,1			;Modus =1?
	breq	mai350			;ja - auf Anzeige-Flag warten
	cpi	r23,6			;Modus =6?
	breq	mai350			;ja - auf Anzeige-Flag warten
	rjmp	mai370			;sonst sofort anzeigen
mai350:	lds	r22,dcflag		;sonst DCF77-Flags holen
	bst	r22,6			;Anzeige-Flag?
	brts	mai360			;ja -> weiter
	rjmp	main			;sonst Ende
mai360:	cbr	r22,0x40		;Anzeige-Flag lschen
	sts	dcflag,r22		;DCF77-Flags wieder speichern
mai370:	rcall	callmo			;Anzeige entsprechend Modus
	rcall	outtxt			;Text ausgeben
	rjmp	main
;
;	--------------------------------------------
;	Men-Steuerung, Steuerung der Tasteneingaben
;	--------------------------------------------
;
menu:	clr	r23
	sts	menmod,r23		;Men-Modus auf 0 setzen
	sts	mencn1,r23		;Men-Timeout-Zhler lschen
	sts	mencn2,r23		;Men-Eingabe-Zhler lschen
men010:	lds	r23,xflags		;Flags holen
	bst	r23,2			;Taste 1 gedrckt?
	brtc	men020			;nein -> weiter
	bst	r23,4			;Taste 1 schon bearbeitet?
	brts	men020			;ja -> weiter
	sbr	r23,0b00010000		;Bearbeitungs-Flag setzen
	sts	xflags,r23		;und Flags wieder speichern
	clr	r23
	sts	mencn1,r23		;Men-Timeout-Zhler lschen
	rcall	men100			;Taste 1 bearbeiten
men020:	bst	r23,3			;Taste 2 gedrckt?
	brtc	men030			;nein -> weiter
	bst	r23,5			;Taste 2 schon bearbeitet?
	brts	men030			;ja -> weiter
	sbr	r23,0b00100000		;Bearbeitungs-Flag setzen
	sts	xflags,r23		;und Flags wieder speichern
	clr	r23
	sts	mencn1,r23		;Men-Timeout-Zhler lschen
	rcall	men500			;Taste 2 bearbeiten
men030:	lds	r23,menmod		;Men-Modus holen
	tst	r23			;Men-Modus 0?
	brne	men040			;nein -> weiter
	ldi	zl,low(okstrg*2)	;Zeiger auf OK-Text
	ldi	zh,high(okstrg*2)
	rcall	copytx			;Text ausgeben
	rcall	outtxt			;und anzeigen
	ldi	r18,20			;Pause 1 s
	rcall	waitnn
	rjmp	men070			;Ende
;
men040:	ldi	r18,8			;Pause 400 ms
	rcall	waitnn
	lds	yl,menpos		;Zeiger auf blinkendes Zeichen
	ldi	yh,high(texbuf)		;im Textpuffer
	ldi	r23,' '			;Leerzeichen
	st	y+,r23			;ausgeben
	lds	r22,mench2		;zweites Zeichen holen
	cpi	r22,0x80		;gltiges Zeichen?
	brcc	men050			;nein -> weiter
	st	y,r23			;sonst Leerzeichen ausgeben
men050:	rcall	outtxt			;Text anzeigen
	ldi	r18,2			;Pause 100 ms
	rcall	waitnn
	lds	yl,menpos		;Zeiger auf blinkendes Zeichen
	ldi	yh,high(texbuf)		;im Textpuffer
	lds	r23,mench1		;Zeichen holen
	st	y+,r23			;und ausgeben
	lds	r23,mench2		;zweites Zeichen holen
	cpi	r23,0x80		;gltiges Zeichen?
	brcc	men060			;nein -> weiter
	st	y,r23			;sonst Zeichen ausgeben
men060:	rcall	outtxt			;Text anzeigen
	lds	r23,mencn1		;Men-Timeout-Zhler holen
	cpi	r23,10			;Zeit berschritten (10s)?
	brcc	men070			;ja -> Ende
	rjmp	men010			;sonst Schleife
men070:	rcall	clrtxt			;Textanzeige lschen
	ldi	zl,low(nodast*2)	;Zeiger auf Moment-Text
	ldi	zh,high(nodast*2)
	rcall	copytx			;Text ausgeben
	rcall	outtxt			;und anzeigen
	clr	r23
	sts	menmod,r23		;Men-Modus auf 0 setzen
	lds	r23,dcflag		;DCF-Flags holen
	cbr	r23,0b11000000		;Minuten/Anzeige-Bit lschen
	sts	dcflag,r23		;und wieder speichern
	lds	r23,dcflag		;DCF77-Flags holen
	sbrs	r23,4			;Gong-Flag gesetzt?
	rjmp	main			;nein -> Ende
	cbr	r23,0x10		;sonst Gong-Flag lschen
	sts	dcflag,r23		;und Flags wieder speichern
	sbrs	r23,3			;luft Uhr schon synchron?
	rjmp	main			;nein -> Ende
	rjmp	maibdy			;sonst Geburtstagstext starten
;
;	- Taste 1 bearbeiten
;
men100:	lds	r23,xflags		;Flags holen
	bst	r23,7			;Sleep-Modus?
	brtc	men110			;nein -> weiter
	cbr	r23,0x80		;sonst Sleep-Modus beenden
	sts	xflags,r23		;Flags wieder speichern
men110:	lds	r23,menmod		;Men-Modus holen
	cpi	r23,5			;Men-Modus > 4?
	brcs	men120			;nein -> weiter
	rjmp	men300			;sonst weiter in Ebene 2
men120:	inc	r23			;erhhen
	cpi	r23,9			;hchster Modus erreicht?
	brcs	men130			;nein -> weiter
	ldi	r23,1			;sonst Modus=1 setzen
men130:	sts	menmod,r23		;Modus wieder speichern
	cpi	r23,1			;Men-Modus 1 (Automatik)?
	brne	men140			;nein -> weiter testen
	ldi	zl,low(men1st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men1st*2)	;den Men-Text setzen
	rjmp	men210
men140:	cpi	r23,2			;Men-Modus 2 (Kompakt)?
	brne	men150			;nein -> weiter testen
	ldi	zl,low(men2st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men2st*2)	;den Men-Text setzen
	rjmp	men210
men150:	cpi	r23,3			;Men-Modus 3 (Sekunden)?
	brne	men160			;nein -> weiter testen
	ldi	zl,low(men3st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men3st*2)	;den Men-Text setzen
	rjmp	men210
men160:	cpi	r23,4			;Men-Modus 4 (DCF-Test)?
	brne	men170			;nein -> weiter testen
	ldi	zl,low(men4st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men4st*2)	;den Men-Text setzen
	rjmp	men210
men170:	cpi	r23,5			;Men-Modus 5 (Nachtzeit)?
	brne	men180			;nein -> weiter testen
	ldi	zl,low(men5st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men5st*2)	;den Men-Text setzen
	rjmp	men210
men180:	cpi	r23,6			;Men-Modus 6 (Gongzeit)?
	brne	men190			;nein -> weiter testen
	ldi	zl,low(men6st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men6st*2)	;den Men-Text setzen
	rjmp	men210
men190:	cpi	r23,7			;Men-Modus 7 (Gongtest)?
	brne	men200			;nein -> weiter mit LED-Test
	ldi	zl,low(men7st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men7st*2)	;den Men-Text setzen
	rjmp	men210
men200:	ldi	zl,low(men8st*2)	;sonst Zeiger auf entsprechen-
	ldi	zh,high(men8st*2)	;den Men-Text setzen
men210:	rcall	copytx			;Text in Puffer kopieren
	rcall	outtxt			;und anzeigen
	ldi	yl,low(texbuf)		;Fragezeichen-Position suchen
	ldi	yh,high(texbuf)		;Zeiger auf Textpuffer setzen
	ldi	r22,10			;10 Zeichen durchsuchen
men220:	ld	r23,y+			;Zeichen holen
	cpi	r23,'?'			;Fragezeichen?
	breq	men230			;ja -> auswerten
	dec	r22			;alle Zeichen durchsucht?
	brne	men220			;nein -> Schleife
men230:	dec	yl			;Position korrigieren
	sts	menpos,yl		;und speichern
	sts	mench1,r23		;Fragezeichen-Code speichern
	ldi	r23,0xff		;zweites Zeichen wird nicht
	sts	mench2,r23		;verwendet
	ret
;
men300:	lds	r22,mencn2		;Men-Eingabe-Zhler holen
	tst	r22			;Zhler=0?
	brne	men310			;nein -> weiter
	rjmp	men120			;sonst zurck zur Ebene 1
men310:	lds	r22,mench1		;Zeichen 1 holen (L)
	lds	r23,mench2		;Zeichen 2 holen (H)
	inc	r22			;erhhen
	cpi	r22,'9'+1		;Zeichen>9?
	brcs	men320			;nein -> weiter
	ldi	r22,'0'			;sonst zurcksetzen
	inc	r23			;Zeichen 2 erhhen
	cpi	r23,'2'+1		;Zeichen>2?
	brcs	men320			;nein -> weiter
	ldi	r23,'0'			;sonst zurcksetzen
men320:	cpi	r22,'4'			;beide Werte=24?
	brne	men330			;nein -> weiter
	cpi	r23,'2'			;beide Werte=24?
	brne	men330			;nein -> weiter
	ldi	r23,'0'			;sonst beide Werte
	ldi	r22,'0'			;zurcksetzen
men330:	sts	mench1,r22		;Zeichen 1 speichern
	sts	mench2,r23		;Zeichen 2 speichern
	lds	yl,menpos		;Zeiger auf blinkendes Zeichen
	ldi	yh,high(texbuf)		;im Textpuffer
	st	y+,r22			;Zeichen 1 sofort ausgeben
	st	y,r23			;Zeichen 2 sofort ausgeben
	rcall	outtxt			;anzeigen
	ret
;
;	- Taste 2 bearbeiten
;
men500:	lds	r23,menmod		;Men-Modus holen
	tst	r23			;Men-Modus=0?
	brne	men510			;nein -> weiter
	lds	r23,xflags		;Flags holen
	ldi	r22,0x80		;Bit-Position von Sleep
	eor	r23,r22			;Sleep-Modus wechseln
	sts	xflags,r23		;Flags wieder speichern
	ret				;Ende
men510:	cpi	r23,5			;Men-Modus>4?
	brcc	men530			;ja -> weiter
	dec	r23			;Men-Modus -> Anzeige-Modus
	sts	dimode,r23		;neuen Anzeige-Modus speichern
	ldi	r18,low(edimod)		;EEPROM-Adresse vorbereiten
	ldi	r19,high(edimod)
	mov	r20,r23			;EEPROM-Daten vorbereiten
	rcall	writee			;in EEPROM schreiben
men520:	clr	r23			;Men-Modus=0 setzen
	sts	menmod,r23		;speichern
	ret
men530:	cpi	r23,7			;Men-Modus=7 (Gongtest)
	brne	men540			;nein -> weiter
	lds	r23,xflags		;Flags holen
	sbr	r23,0x40		;Gong-Bit setzen
	sts	xflags,r23		;und Flags wieder speichern
	ldi	r23,128			;Gongzhler auf 128 Zyklen
	sts	gngcnt,r23		;setzen und speichern
	lds	r23,dcflag		;DCF77-Flags holen
	sbr	r23,0x10		;Gong-Flag setzen
	sts	dcflag,r23		;und Flags wieder speichern
	rjmp	men520			;Ende
;
men540:	cpi	r23,8			;Men-Modus=8 (LED-Test)
	brne	men550			;nein -> weiter
	lds	r23,dcflag		;DCF77-Flags holen
	sbr	r23,0x20		;LED-Test-Bit setzen
	sts	dcflag,r23		;und Flags wieder speichern
	rjmp	men520			;Ende
;
men550:	lds	r22,mencn2		;Men-Eingabe-Zhler holen
	tst	r22			;Zhler2=0 (Beginn d. Eingabe)?
	brne	men600			;nein -> weiter
	inc	r22			;erhhen
	sts	mencn2,r22		;Eingabe-Zhler speichern
	cpi	r23,5			;Men-Modus 5 (Nachtzeit)?
	brne	men560			;nein -> weiter
	ldi	zl,low(nachst*2)	;Zeiger auf entsprechenden
	ldi	zh,high(nachst*2)	;Men-Text setzen
	ldi	xl,low(sleept)		;Zeiger auf Sleepzeiten
	ldi	xh,high(sleept)
	rjmp	men570
men560:	ldi	zl,low(gongst*2)	;Zeiger auf entsprechenden
	ldi	zh,high(gongst*2)	;Men-Text setzen
	ldi	xl,low(gongtm)		;Zeiger auf Sleepzeiten
	ldi	xh,high(gongtm)
men570:	rcall	copytx			;Text in Puffer kopieren
	ldi	yl,low(texbuf)		;Zeiger auf Textpuffer
	ldi	yh,high(texbuf)
	ld	r23,x+			;Endezeit Stunden Einer holen
	ori	r23,0x30		;in ASCII wandeln
	st	y+,r23			;in Textpuffer speichern
	ld	r23,x+			;Endezeit Stunden Zehner holen
	ori	r23,0x30		;in ASCII wandeln
	st	y+,r23			;in Textpuffer speichern
	inc	yl			;Zeiger korrigieren
	sts	menpos,yl		;Blinkposition speichern
	ld	r23,x+			;Anfangszeit Stunden Einer
	ori	r23,0x30		;in ASCII wandeln
	sts	mench1,r23		;als Zeichen 1 und
	st	y+,r23			;in Textpuffer speichern
	ld	r23,x+			;Anfangszeit Stunden Zehner
	ori	r23,0x30		;in ASCII wandeln
	sts	mench2,r23		;als Zeichen 2 und
	st	y+,r23			;in Textpuffer speichern
	rcall	outtxt			;und anzeigen
	ret
;
men600:	cpi	r22,1			;Zhler2=1 (erste Eingabe)?
	brne	men700			;nein -> weiter
	inc	r22			;erhhen
	sts	mencn2,r22		;Eingabe-Zhler speichern
	lds	r23,mench1		;Men-Zeichen 1 holen
	sts	texbuf+3,r23		;in Textpuffer legen
	lds	r23,mench2		;Men-Zeichen 2 holen
	sts	texbuf+4,r23		;in Textpuffer legen
	lds	r23,texbuf		;Endezeit aus Textpuffer holen
	sts	mench1,r23		;als Men-Zeichen 1 speichern
	lds	r23,texbuf+1		;Endzeit Zehner holen
	sts	mench2,r23		;als Men-Zeichen 2 speichern
	ldi	r23,low(texbuf)		;Blinkposition festlegen
	sts	menpos,r23		;und speichern
	ret
;
men700:	cpi	r23,5			;Men-Modus 5 (Nachtzeit)?
	brne	men710			;nein -> weiter
	ldi	xl,low(sleept+4)	;Zeiger auf Nachtzeitwerte
	ldi	xh,high(sleept+4)	;(Tabellen-Ende)
	rjmp	men720
men710:	ldi	xl,low(gongtm+4)	;Zeiger auf Gongzeitwerte
	ldi	xh,high(gongtm+4)	;(Tabellen-Ende)
men720:	lds	r22,texbuf+4		;Anfangszeit Zehner holen
	andi	r22,0x0f		;Zahl filtern
	st	-x,r22			;Anfangszeit Zehner speichern
	lds	r22,texbuf+3		;Anfangszeit Einer holen
	andi	r22,0x0f		;Zahl filtern
	st	-x,r22			;Anfangszeit Einer speichern
	lds	r22,mench2		;Men-Zeichen 2 holen
	andi	r22,0x0f		;Zahl filtern
	st	-x,r22			;Endezeit Zehner speichern
	lds	r22,mench1		;Men-Zeichen 1 holen
	andi	r22,0x0f		;Zahl filtern
	st	-x,r22			;Endezeit Einer speichern
;
	cpi	r23,5			;Men-Modus 5 (Nachtzeit)?
	brne	men730			;nein -> weiter mit Gongzeit
	ld	r22,x+			;Endezeit Einer holen
	ld	r23,x+			;Endezeit Zehner holen
	rcall	bcdhex			;in Hex wandeln
	mov	r20,r22
	ldi	r18,low(esleep+1)	;EEPROM-Adresse Nachtzeit aus
	ldi	r19,high(esleep+1)
	rcall	writee			;Nachtzeit aus speichern
	ld	r22,x+			;Anfangszeit Einer holen
	ld	r23,x+			;Anfangszeit Zehner holen
	rcall	bcdhex			;in Hex wandeln
	mov	r20,r22
	ldi	r18,low(esleep)		;EEPROM-Adresse Nachtzeit aus
	ldi	r19,high(esleep)
	rcall	writee			;Nachtzeit ein speichern
	rjmp	men740
;
men730:	ld	r22,x+			;Endezeit Einer holen
	ld	r23,x+			;Endezeit Zehner holen
	rcall	bcdhex			;in Hex wandeln
	mov	r20,r22
	ldi	r18,low(egong+1)	;EEPROM-Adresse Gongzeit aus
	ldi	r19,high(egong+1)
	rcall	writee			;Gongzeit aus speichern
	ld	r22,x+			;Anfangszeit Einer holen
	ld	r23,x+			;Anfangszeit Zehner holen
	rcall	bcdhex			;in Hex wandeln
	mov	r20,r22
	ldi	r18,low(egong)		;EEPROM-Adresse Gongzeit aus
	ldi	r19,high(egong)
	rcall	writee			;Gongzeit ein speichern
;
men740:	clr	r23			;Men-Modus zurcksetzen
	sts	menmod,r23
	ret				;Ende
;
;	----------------------------------------------
;	DCF77-Auswertung, Kontrolle der Prfbits 1-3,
;	Ablegen der Zeitinformation und Vergleich mit
;	vorheriger Zeitinformation, DCF-Puffer lschen
;	Ausgang: r19=0 - alles ok, r19>0 - Fehler
;	----------------------------------------------
;
;	- Kontrolle der Prfbits fr Minuten, Stunden und Datum
;
mdcprc:	clr	r19			;Fehlerzhler lschen
	clr	r21			;wird fr Parittsber. bentigt
	lds	r22,dcfcn3		;DCF-Zhler 3 holen
	sts	dcfcn3,r21		;DCF-Zhler 3 lschen
	cpi	r22,59			;sind 59 Impulse eingegangen?
	breq	mdc010			;ja -> weiter
	inc	r19			;sonst Fehlerzhler erhhen
	rjmp	mdc200			;Auswertung vorzeitig beenden
;
mdc010:	clr	r22			;Zhler fr Parittsberechnung
	lds	r23,dcftab+1		;Byte 1 aus Tabelle holen
	ldi	r20,6			;6 Minuten-Bits auswerten
mdc020:	rol	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	dec	r20			;alle Bits ausgewertet?
	brne	mdc020			;nein -> Schleife
	lds	r23,dcftab+2		;Byte 2 aus Tabelle holen
	ror	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	ror	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	bst	r22,0			;war das Ergebnis geradzahlig?
	brtc	mdc030			;ja -> weiter
	inc	r19			;sonst Fehlerzhler erhhen
;
mdc030:	clr	r22			;Zhler fr Parittsberechnung
	ldi	r20,6			;6 Stunden-Bits auswerten
mdc040:	ror	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	dec	r20			;alle Bits ausgewertet?
	brne	mdc040			;nein -> Schleife
	lds	r23,dcftab+3		;Byte 3 aus Tabelle holen
	ror	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	bst	r22,0			;war das Ergebnis geradzahlig?
	brtc	mdc050			;ja -> weiter
	inc	r19			;sonst Fehlerzhler erhhen
;
mdc050:	clr	r22			;Zhler fr Parittsberechnung
	ldi	r20,7			;7 Datum-Bits auswerten
mdc060:	ror	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	dec	r20			;alle Bits ausgewertet?
	brne	mdc060			;nein -> Schleife
	lds	r23,dcftab+4		;Byte 4 aus Tabelle holen
	ldi	r20,8			;8 Datum-Bits auswerten
mdc070:	ror	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	dec	r20			;alle Bits ausgewertet?
	brne	mdc070			;nein -> Schleife
	lds	r23,dcftab+5		;Byte 5 aus Tabelle holen
	ldi	r20,8			;8 Datum-Bits auswerten
mdc080:	ror	r23			;relevantes Bit in Carry
	adc	r22,r21			;Eins-Bit addieren
	dec	r20			;alle Bits ausgewertet?
	brne	mdc080			;nein -> Schleife
	bst	r22,0			;war das Ergebnis geradzahlig?
	brtc	mdc090			;ja -> weiter
	inc	r19			;sonst Fehlerzhler erhhen
mdc090:	tst	r19			;Parittsfehler aufgetreten?
	breq	mdc100			;nein -> weiter, sonst
	rjmp	mdc200			;Auswertung vorzeitig beenden
;
;	- Ablegen der Zeitinformation in Puffer 1
;
mdc100:	ldi	zl,low(dcbuf1)		;Zeiger auf DCF77-Puffer 1
	ldi	zh,high(dcbuf1)
	lds	r23,dcftab		;Byte 0 aus Tabelle holen
	rol	r23			;Bit 6 auf Bit 0 schieben
	rol	r23
	rol	r23
	andi	r23,0x01		;relevantes Bit filtern
	st	z+,r23			;Zeitzone speichern
	lds	r23,dcftab+1		;Byte 1 aus Tabelle holen
	ror	r23			;Bits 2-5 auf Bits 0-3 schieben
	ror	r23
	andi	r23,0x0f		;relevante Bits filtern
	st	z+,r23			;Minuten Einer speichern
	lds	r23,dcftab+1		;Byte 1 aus Tabelle holen
	lds	r22,dcftab+2		;Byte 2 aus Tabelle holen
	rol	r23			;Bits 6-7 aus r23 und 0 aus r22
	rol	r22			;auf Bits 0-2 von r22 schieben
	rol	r23
	rol	r22
	andi	r22,0x07		;relevante Bits filtern
	st	z+,r22			;Minuten Zehner speichern
	lds	r23,dcftab+2		;Byte 2 aus Tabelle holen
	ror	r23			;Bits 2-5 auf Bits 0-3 schieben
	ror	r23
	andi	r23,0x0f		;relevante Bits filtern
	st	z+,r23			;Stunden Einer speichern
	lds	r23,dcftab+2		;Byte 2 aus Tabelle holen
	rol	r23			;Bits 6-7 auf Bits 0-1 schieben
	rol	r23
	rol	r23
	andi	r23,0x03		;relevante Bits filtern
	st	z+,r23			;Stunden Zehner speichern
	lds	r23,dcftab+3		;Byte 3 aus Tabelle holen
	ror	r23			;Bits 1-4 auf Bits 0-3 schieben
	andi	r23,0x0f		;relevante Bits filtern
	st	z+,r23			;Kalendertag Einer speichern
	lds	r23,dcftab+3		;Byte 3 aus Tabelle holen
	ror	r23			;Bits 5-6 auf Bits 4-5 schieben
	swap	r23			;Nibbles tauschen
	andi	r23,0x03		;relevante Bits filtern
	st	z+,r23			;Kalendertag Zehner speichern
	lds	r23,dcftab+3		;Byte 3 aus Tabelle holen
	rol	r23			;Bit 7 in Carry schieben
	lds	r23,dcftab+4		;Byte 4 aus Tabelle holen
	rol	r23			;Carry in Bit 0 schieben
	andi	r23,0x07		;relevante Bits filtern
	st	z+,r23			;Wochentag speichern
	lds	r23,dcftab+4		;Byte 4 aus Tabelle holen
	ror	r23			;Bits 2-5 in Bits 0-3 schieben
	ror	r23
	andi	r23,0x0f		;relevante Bits filtern
	st	z+,r23			;Monat Einer speichern
	lds	r23,dcftab+4		;Byte 4 aus Tabelle holen
	rol	r23			;Bit 6 in Bit 0 schieben
	rol	r23
	rol	r23
	andi	r23,0x01		;relevantes Bit filtern
	st	z+,r23			;Monat Zehner speichern
	lds	r23,dcftab+4		;Byte 4 aus Tabelle holen
	rol	r23			;Bit 7 in Carry schieben
	lds	r23,dcftab+5		;Byte 5 aus Tabelle holen
	rol	r23			;Carry in Bit 0 schieben
	andi	r23,0x0f		;relevante Bits filtern
	st	z+,r23			;Jahr Einer speichern
	lds	r23,dcftab+5		;Byte 5 aus Tabelle holen
	rol	r23			;Bits 3-6 in Bits 4-7 schieben
	swap	r23			;Nibbles tauschen
	andi	r23,0x0f		;relevante Bits filtern
	st	z+,r23			;Jahr Zehner speichern
;
;	- Vergleich des aktuellen Puffers mit den vorherigen Zeit-
;	  Informationen und Kopieren des Puffers 2 nach Puffer 3 sowie
;	  Puffer 1 nach Puffer 2
;
	ldi	yl,low(dcbuf1)		;Zeiger auf DCF77-Puffer 1
	ldi	yh,high(dcbuf1)
	ldi	zl,low(dcbuf2)		;Zeiger auf DCF77-Puffer 2
	ldi	zh,high(dcbuf2)
	ldi	xl,low(dcbuf3)		;Zeiger auf DCF77-Puffer 3
	ldi	xh,high(dcbuf3)
	clr	r18			;Nullbyte-Detektor
	ldi	r23,12			;12 Bytes vergleichen
mdc110:	ld	r22,y+			;Puffer 1 Inhalt holen
	or	r18,r22			;Nullbyte-Detektor bearbeiten
	ld	r21,z			;Puffer 2 Inhalt holen
	ld	r20,x			;Puffer 3 Inhalt holen
	st	x+,r21			;Puffer 2 nach 3 kopieren
	st	z+,r22			;Puffer 1 nach 2 kopieren
	cp	r21,r22			;Inhalt P1/P2 identisch?
	brne	mdc120			;nein -> Fehler
	cp	r20,r21			;Inhalt P2/P3 identisch?
	breq	mdc130			;ja -> weiter
mdc120:	inc	r19			;sonst Fehlerzhler erhhen
mdc130:	dec	r23			;alle Bytes bearbeitet?
	brne	mdc110			;nein -> Schleife
	tst	r18			;alles Nullbytes im Puffer?
	brne	mdc140			;nein -> weiter
	inc	r19			;sonst Fehlerzhler erhhen
;
;	- Puffer 2 und 3 um eine Minute erhhen
;
mdc140:	ldi	zl,low(dcbuf2)
	ldi	zh,high(dcbuf2)		;Zeiger auf DCF77-Puffer 2
	rcall	mdc300			;um eine Minute erhhen
	ldi	zl,low(dcbuf3)
	ldi	zh,high(dcbuf3)		;Zeiger auf DCF77-Puffer 3
	rcall	mdc300			;um eine Minute erhhen
;
;	- Ende, DCF-Tabelle lschen
;
mdc200:	ldi	zl,low(dcftab)		;Zeiger auf DCF77-Tabelle
	ldi	zh,high(dcftab)
	ldi	r23,6			;6 Bytes bearbeiten
	clr	r22			;Nullwert
mdc210:	st	z+,r22			;Tabellenplatz lschen
	dec	r23			;alle Pltze bearbeitet?
	brne	mdc210			;nein -> Schleife
	ret
;
;	- Unterprogramm zum Erhhen des DCF-Pufferinhaltes um eine
;	  Minute, es werden nur Minuten und Stunden bercksichtigt
;
mdc300:	ldd	r23,z+1			;Minuten Einer holen
	inc	r23			;erhhen
	std	z+1,r23			;und wieder speichern
	cpi	r23,10			;bertrag?
	brcs	mdc320			;nein -> weiter
	clr	r23			;sonst zurcksetzen
	std	z+1,r23			;und speichern
	ldd	r23,z+2			;Minuten Zehner holen
	inc	r23			;erhhen
	std	z+2,r23			;und wieder speichern
	cpi	r23,6			;bertrag?
	brcs	mdc320			;nein -> weiter
	clr	r23			;sonst zurcksetzen
	std	z+2,r23			;und speichern
	ldd	r22,z+4			;Stunden Zehner holen
	ldd	r23,z+3			;Stunden Einer holen
	inc	r23			;erhhen
	std	z+3,r23			;und wieder speichern
	cpi	r23,10			;bertrag?
	brcs	mdc310			;nein -> Test auf "24"
	clr	r23			;sonst zurcksetzen
	std	z+3,r23			;und speichern
	inc	r22			;Stunden Zehner erhhen
	std	z+4,r22			;und speichern
mdc310:	cpi	r22,2			;Stunden Zehner=2?
	brne	mdc320			;nein -> weiter
	cpi	r23,4			;Stunden Einer=4 (=24) ?
	brne	mdc320			;nein -> weiter
	clr	r23			;sonst Stunden zurcksetzen
	std	z+3,r23			;Stunden Einer speichern
	std	z+4,r23			;Stunden Zehner speichern
mdc320:	ret
;
;	------------------------------------------
;	Zeitinformationen in Uhrenbereich kopieren
;	und Uhrzeit synchronisieren
;	------------------------------------------
;
mtsync:	lds	r23,dcbuf1		;Zeitzone holen
	sts	tzone,r23		;und speichern
	lds	r23,dcbuf1+5		;Kalendertag Einer holen
	sts	dayl,r23		;und speichern
	lds	r23,dcbuf1+6		;Kalendertag Zehner holen
	sts	dayh,r23		;und speichern
	lds	r23,dcbuf1+7		;Wochentag holen
	sts	dayw,r23		;und speichern
	lds	r23,dcbuf1+8		;Monat Einer holen
	sts	monthl,r23		;und speichern
	lds	r23,dcbuf1+9		;Monat Zehner holen
	sts	monthh,r23		;und speichern
	lds	r23,dcbuf1+10		;Jahr Einer holen
	sts	yearl,r23		;und speichern
	lds	r23,dcbuf1+11		;Jahr Zehner holen
	sts	yearh,r23		;und speichern
	cli				;Int vorbergehend sperren
	lds	r23,dcbuf1+1		;Minuten Einer holen
	sts	minutl,r23		;und speichern
	lds	r23,dcbuf1+2		;Minuten Zehner holen
	sts	minuth,r23		;und speichern
	lds	r23,dcbuf1+3		;Stunden Einer holen
	sts	hourl,r23		;und speichern
	lds	r23,dcbuf1+4		;Stunden Zehner holen
	sts	hourh,r23		;und speichern
	clr	r23
	sts	second,r23		;Sekundenzhler lschen
	sts	pcoun2,r23		;Vorteiler 2 lschen
	lds	r23,dcflag		;DCF-Flags holen
	sbr	r23,0b00001100		;Synchron-Bits setzen
	sts	dcflag,r23		;und wieder speichern
	ldi	r23,dtimeo		;DCF-Timeout-Wert laden
	sts	dcftim,r23		;und neu setzen
	sei				;Interrupts wieder aktivieren
	ret
;
;	-----------------------------------
;	Anzeige entsprechend Modus aufrufen
;	Eingang: r23 - Anzeige-Modus (1-5)
;	-----------------------------------
;
callmo:	lds	r21,bdayfl		;Geburtstags-Flag L holen
	lds	r22,bdayfh		;Geburtstags-Flag H holen
	or	r22,r21			;Textausgabe aktiviert?
	breq	cal010			;nein -> normal weiter
	rjmp	mobday			;sonst zum Geburtstagstext
cal010:	tst	r23			;Modus 0 (keine Daten)?
	breq	monoda			;ja -> Sprung zu Modus 0
	cpi	r23,1			;Modus 1 (Kompakt)?
	breq	mokomp			;ja -> Sprung zu Modus 1
	cpi	r23,2			;Modus 2 (Sekunden)?
	brne	cal020			;nein -> weiter testen
	rjmp	moseco			;sonst Sprung zu Modus 2
cal020:	cpi	r23,3			;Modus 3 (DCF-Test)?
	brne	cal030			;nein -> weiter testen
	rjmp	modcft			;sonst Sprung zu Modus 3
cal030:	cpi	r23,4			;Modus 4 (Datum)?
	brne	cal040			;nein -> weiter testen
	rjmp	modate			;ja -> Sprung zu Modus 4
cal040:	cpi	r23,5			;Modus 5 (Wochentag)?
	brne	cal050			;nein -> Modus 6
	rjmp	modayw			;ja -> Sprung zu Modus 5
cal050:	rjmp	motemp			;sonst Sprung zu Modus 6
					;mit Lschen der Anzeige
;
;	-------------------------------------
;	Anzeige bei fehlenden Daten [Modus 0]
;	-------------------------------------
;
monoda:	ldi	zl,low(nodast*2)	;Zeiger auf Moment-Text
	ldi	zh,high(nodast*2)
	rcall	copytx			;Zeichen in Textpuffer kopieren
	ret
;
;	---------------------------------------------------------------
;	Kompaktanzeige [Modus 1]: Wochentag, Kalendertag und Temperatur
;	---------------------------------------------------------------
;
mokomp:	rcall	motemp			;Temperatur anzeigen
	lds	r23,dcflag		;DCF77-Flags holen
	bst	r23,2			;luft Uhr synchron mit DCF77?
	brts	mok010			;ja -> weiter
	ret				;sonst Ende
mok010:	lds	r23,dayl		;Kalendertag Einer holen
	ori	r23,0xb0		;in ASCII wandeln (Dezimalp.)
	sts	texbuf+6,r23		;und in Textpuffer speichern
	lds	r23,dayh		;Kalendertag Zehner holen
	ori	r23,0x30		;in ASCII wandeln
	cpi	r23,0x30		;Zehnerwert="0"?
	brne	mok020			;nein -> weiter
	ldi	r23,' '			;sonst durch Leerzei. ersetzen
mok020:	sts	texbuf+7,r23		;und in Textpuffer speichern
	lds	r23,dayw		;Wochentag holen
	dec	r23			;Offset korrigieren
	add	r23,r23			;Verdoppeln
	ldi	zl,low(2*do2tab)	;Zeiger auf kurze Wochentage
	ldi	zh,high(2*do2tab)
	add	zl,r23			;Tabellenplatz berechnen
	clr	r22
	adc	zh,r22			;eventuell bertrag addieren
	lpm				;erstes Zeichen holen
	sts	texbuf+9,r0		;und in Textpuffer schreiben
	ld	r0,z+			;Zeiger auf zweites Zeichen
	lpm				;zweites Zeichen holen
	sts	texbuf+8,r0		;und in Textpuffer schreiben
	ret
;
;	------------------------------
;	Anzeige der Sekunden [Modus 2]
;	------------------------------
;
moseco:	ldi	zl,low(secstr*2)	;Zeiger auf Text
	ldi	zh,high(secstr*2)
	rcall	copytx			;Zeichen in Textpuffer kopieren
	lds	r22,second		;Sekunden holen
	clr	r23			;H-Byte=0
	rcall	binasc			;ins ASCII-Format wandeln
	sts	texbuf,r0		;Ergebnis in Anzeige legen (L)
	sts	texbuf+1,r1		;Ergebnis in Anzeige legen (M)
	ret
;
;	---------------------------------------------
;	Statusanzeige des DCF77-Decoders [Modus 3]
;	Impulsabstand: Zhler1 (Einheiten von 16,7ms)
;	Impulsdauer:   Zhler2 (Einheiten von 16,7ms)
;	Impulsnummer:  Zhler3 (zhlt aufwrts)
;	---------------------------------------------
;
modcft:	ldi	zl,low(dcf77s*2)	;Zeiger auf Text
	ldi	zh,high(dcf77s*2)
	rcall	copytx			;Zeichen in Textpuffer kopieren
	lds	r23,dcflag		;DCF77-Flags holen
	bst	r23,0			;akt. Empfnger-Status holen
	brts	modc10			;wenn Status=0, dann
	ldi	r23,' '			;Antennenzeichen durch
	sts	texbuf+9,r23		;Leerzeichen ersetzen
modc10:	clr	r23			;H-Byte=0
	lds	r22,dcfcn1		;DCF77-Zhler 1 holen
	rcall	binasc			;in ASCII konvertieren
	mov	r23,r0			;LSB kopieren
	ori	r23,0x80		;Dezimalpunkt setzen
	sts	texbuf+4,r23		;und im Textpuffer ablegen
	sts	texbuf+5,r1
	sts	texbuf+6,r2
	clr	r23			;H-Byte=0
	lds	r22,dcfcn2		;DCF77-Zhler 2 holen
	rcall	binasc			;in ASCII konvertieren
	mov	r23,r0			;LSB kopieren
	ori	r23,0x80		;Dezimalpunkt setzen
	sts	texbuf+2,r23		;und im Textpuffer ablegen
	sts	texbuf+3,r1
	clr	r23			;H-Byte=0
	lds	r22,dcfcn3		;DCF77-Zhler 3 holen
	rcall	binasc			;in ASCII konvertieren
	mov	r23,r0			;LSB kopieren
	ori	r23,0x80		;Dezimalpunkt setzen
	sts	texbuf+0,r23		;und im Textpuffer ablegen
	sts	texbuf+1,r1
	ret
;
;	----------------------------------------------
;	Anzeige von Datum (Tag, Monat, Jahr) [Modus 4]
;	----------------------------------------------
;
modate:	lds	r23,yearl		;Jahr Einer holen
	ori	r23,0x30		;in ASCII wandeln
	sts	texbuf,r23		;und in Textpuffer schreiben
	lds	r23,yearh		;Jahr Zehner holen
	ori	r23,0x30		;in ASCII wandeln
	sts	texbuf+1,r23		;und in Textpuffer schreiben
	ldi	r23,year2		;Jahr Hunderter holen
	sts	texbuf+2,r23		;und in Textpuffer schreiben
	ldi	r23,year3		;Jahr Tausender holen
	sts	texbuf+3,r23		;und in Textpuffer schreiben
	lds	r23,monthl		;Monat Einer holen
	ori	r23,0x30		;in ASCII wandeln
	sts	texbuf+5,r23		;und in Textpuffer schreiben
	lds	r23,monthh		;Monat Zehner holen
	ori	r23,0x30		;in ASCII wandeln
	sts	texbuf+6,r23		;und in Textpuffer schreiben
	lds	r23,dayl		;Kalendertag Einer holen
	ori	r23,0x30		;in ASCII wandeln
	sts	texbuf+8,r23		;und in Textpuffer speichern
	lds	r23,dayh		;Kalendertag Zehner holen
	ori	r23,0x30		;in ASCII wandeln
	sts	texbuf+9,r23		;und in Textpuffer speichern
	ldi	r23,'-'			;Bindestrich als Trennzeichen
	sts	texbuf+4,r23		;ausgeben
	sts	texbuf+7,r23
	ret
;
;	---------------------------------
;	Anzeige des Wochentages [Modus 5]
;	---------------------------------
;
modayw:	lds	r23,dayw		;Wochentag holen
	clc
	dec	r23			;Offset korrigieren
	rol	r23			;Offset *10, zuerst *2
	mov	r22,r23			;und Wert sichern
	rol	r23			;dann nochmals *2 (= *4)
	rol	r23			;dann nochmals *2 (= *8)
	add	r23,r22			;und +2 (= *10)
	ldi	zl,low(dowtab*2)	;Zeiger auf Wochentag-Tabelle
	ldi	zh,high(dowtab*2)
	add	zl,r23			;Tabellenplatz berechnen
	clr	r22
	adc	zh,r22			;eventuell bertrag addieren
	rcall	copytx			;Wochentag im Textpuffer legen
	ret
;
;	---------------------------------------------------------
;	Anzeige der Temperatur [Modus 6], Temperaturberechnung
;	Temperatur wird aus Sensor DS1620 ausgelesen und nach dem
;	Datenblatt des DS1620 bzw. AppNote AN-068 aufbereitet,
;	Anzeigebereich von -55.0C bis 99.9C
;	---------------------------------------------------------
;
motemp:	lds	r22,muxtex		;Multiplexzhler holen
	cpi	r22,5			;Zhler=5 (Leerstelle zwischen
	brne	motemp			;Text und Temp.) nein -> warten
mot010:	lds	r22,muxtex		;Multiplexzhler holen
	cpi	r22,5			;Zhler=5?
	breq	mot010			;ja -> warten (Synchronisation)
;
	cli				;Interrupt sperren
	rcall	w3actv			;3Wire-Interface aktivieren
	ldi	r22,0xaa		;Kommando "Read Temperature"
	rcall	w3send			;Kommando senden
	rcall	w3rec9			;9 Datenbits empfangen
	rcall	w3deac			;3Wire-Interface deaktivieren
	sts	tempxa,r22		;Temperatur-Wert L speichern
	sts	tempxa+1,r23		;Temperatur-Wert H speichern
	rcall	w3actv			;3Wire-Interface aktivieren
	ldi	r22,0xa0		;Kommando "Read Counter"
	rcall	w3send			;Kommando senden
	rcall	w3rec9			;9 Datenbits empfangen
	rcall	w3deac			;3Wire-Interface deaktivieren
	sts	tempxb,r22		;Counter-Wert L speichern
	sts	tempxb+1,r23		;Counter-Wert H speichern
	rcall	w3actv			;3Wire-Interface aktivieren
	ldi	r22,0xa9		;Kommando "Read Slope"
	rcall	w3send			;Kommando senden
	rcall	w3rec9			;9 Datenbits empfangen
	rcall	w3deac			;3Wire-Interface deaktivieren
	sts	tempxc,r22		;Slope-Wert L speichern
	sts	tempxc+1,r23		;Slope-Wert H speichern
	rcall	w3actv			;3Wire-Interface aktivieren
	ldi	r22,0xee		;Kommando "Start Conversion T"
	rcall	w3send			;Kommando senden
	rcall	w3deac			;3Wire-Interface deaktivieren
	sei				;Interrupt wieder aktivieren
;
	lds	r16,tempxa		;Temperatur-Wert L holen
	lds	r17,tempxa+1		;Temperatur-Wert H holen
	tst	r17			;Temperatur-Wert negativ?
	breq	mot020			;nein -> weiter
	neg	r16			;sonst Temp-Wert ins Zweier-
	sts	tempxa,r16		;komplement wandeln, speichern
;
;	Berechnung der Temperatur nach Datenblatt DS1620 (AN-068)
;
mot020:	lds	r16,tempxc		;Slope-Wert holen
	lds	r17,tempxc+1
	lds	r18,tempxb		;Counter-Wert holen
	lds	r19,tempxb+1
	sub	r16,r18			;Subtraktion: Slope - Counter
	sbc	r17,r19
	ldi	r18,low(100)		;Multiplikation mit 100 zur
	ldi	r19,high(100)		;Erhhung der Genauigkeit
	rcall	mul16u
	mov	r16,r18			;Ergebnis nach r16,r17 als
	mov	r17,r19			;Divident
	lds	r18,tempxc		;Slope-Wert holen (Divisor)
	lds	r19,tempxc+1
	rcall	div16u			;Division
	mov	r8,r16			;Ergebnis in r8,r9 sichern
	mov	r9,r17
	lds	r18,tempxa		;Temperatur-Wert holen
	lsr	r18			;LSB abschneiden
	clr	r19			;H-Byte=0
	ldi	r16,low(100)		;Multiplikation mit 100 zur
	ldi	r17,high(100)		;Erhhung der Genauigkeit
	rcall	mul16u
	ldi	r20,low(25)		;Subtrahend 0,25*100
	ldi	r21,high(25)		;(fr hhere Genauigkeit)
	sub	r18,r20			;Subtraktion x = Temp - 0,25
	sbc	r19,r21
	add	r18,r8			;Addition y = x + Quotient
	adc	r19,r9
	mov	r16,r18			;Ergebnis nach r16,r17 als
	mov	r17,r19			;Divident
	ldi	r18,low(10)
	ldi	r19,high(10)		;Division durch 10, ergibt den
	rcall	div16u			;Temperaturwert in Zehntel Grad
	mov	r22,r16
	mov	r23,r17
	rcall	binasc			;Ergebnis in ASCII wandeln
	mov	r16,r0			;und kopieren
	mov	r17,r1
	mov	r18,r2
;
	ldi	zl,low(tempst*2)	;Zeiger auf Text
	ldi	zh,high(tempst*2)
	rcall	copytx			;Zeichen in Textpuffer kopieren
	sts	texbuf+2,r16		;Tempwert L in Anzeige legen
	sbr	r17,0x80		;Dezimalpunkt M setzen
	sts	texbuf+3,r17		;Tempwert M in Anzeige legen
	cpi	r18,'0'			;Tempwert H =0?
	brne	mot030			;nein -> berspringen
	ldi	r18,' '			;sonst durch Leerz. ersetzen
mot030:	sts	texbuf+4,r18		;Tempwert H in Anzeige legen
	lds	r17,tempxa+1		;Temperaturwert H holen
	tst	r17			;war Temperatur negativ?
	brne	mot040			;ja -> Minuszeichen ergnzen
	ret				;sonst Ende
;
mot040:	ldi	r17,'-'			;Minuszeichen laden
	cpi	r18,' '			;Temp-Wert <10 Grad?
	brne	mot050			;nein -> weiter
	sts	texbuf+4,r17		;sonst Minuszeichen anstatt
	ret				;Tempwert H setzen
mot050:	sts	texbuf+5,r17		;Minuszeichen vor H-Wert setzen
	ldi	zl,low(texbuf)		;und gesamte Anzeige um 1 Zei-
	ldi	zh,high(texbuf)		;chen nach rechts verschieben
	ldi	r16,5			;5 Verschiebungen
mot060:	ldd	r17,z+1			;linkes Nachbarzeichen holen
	st	z+,r17			;auf aktuelle Position speich.
	dec	r16			;alle Verschiebungen fertig?
	brne	mot060			;nein -> Schleife
	ldi	r16,' '			;letztes Zeichen lschen
	st	z,r16
	ret
;
;	---------------------------------------------------------
;	Geburtstags-Textanzeige, Lesen des Namens aus dem EEPROM,
;	Berechnen des Alters, Generieren des Anzeigetextes und
;	Erzeugen der Laufschrift
;	---------------------------------------------------------
;
mobday:	ldi	yl,low(bdaytx)		;Zeiger auf Textpuffer setzen
	ldi	yh,high(bdaytx)
	ldi	zl,low(bdstr1*2)	;Zeiger auf Geburtstagstext 1
	ldi	zh,high(bdstr1*2)
	lpm				;1. Zeichen holen (Textlnge)
	mov	r22,r0			;Zeichenzhler setzen
	ld	r1,z+
	ld	r1,z+			;Zeiger auf erstes Textzeichen
mob010:	lpm				;Textzeichen holen
	ld	r1,z+			;Zeiger erhhen
	st	y+,r0			;Textzeichen in Puffer legen
	dec	r22			;alle Zeichen gelesen?
	brne	mob010			;nein -> Schleife
	lds	r18,bdayfl		;EEPROM-Adresse L holen
	lds	r19,bdayfh		;EEPROM-Adresse H holen
mob020:	rcall	readee			;EEPROM lesen
	cpi	r20,0xff		;Endezeichen?
	breq	mob030			;ja -> weiter
	st	y+,r20			;sonst Zeichen in Puffer legen
	inc	r18			;EEPROM-Adresse L erhhen
	brne	mob020			;bertrag? nein -> nchstes Z.
	inc	r19			;EEPROM-Adresse H erhhen
	rjmp	mob020			;nchstes Zeichen holen
mob030:	ldi	zl,low(bdstr2*2)	;Zeiger auf Geburtstagstext 2
	ldi	zh,high(bdstr2*2)
	lpm				;1. Zeichen holen (Textlnge)
	mov	r22,r0			;Zeichenzhler setzen
	ld	r1,z+
	ld	r1,z+			;Zeiger auf erstes Textzeichen
mob040:	lpm				;Textzeichen holen
	ld	r1,z+			;Zeiger erhhen
	st	y+,r0			;Textzeichen in Puffer legen
	dec	r22			;alle Zeichen gelesen?
	brne	mob040			;nein -> Schleife
;
	lds	r20,bdayyl		;Geburtsjahr L holen
	lds	r19,bdayyh		;Geburtsjahr H holen
	mov	r21,r19			;Geburtsjahr H kopieren
	or	r21,r20			;war ein Geburtsjahr vorhanden?
	breq	mob110			;nein -> Berechnung berspr.
;
	clr	r18			;Zwischenspeicher (Flag) lsch.
	lds	r22,yearl		;aktuelles Jahr Einer holen
	lds	r23,yearh		;aktuelles Jahr Zehner holen
	rcall	bcdhex			;in Hex-Wert wandeln
	mov	r21,r19			;Geburtsjahr H holen
	ldi	r23,((year3-48)*10)+(year2-48)	;aktuelles Jahrhundert
	sub	r22,r20			;Zehner/Einer subtrahieren
	sbc	r23,r21			;Hunderter subtrahieren
	tst	r22			;waren Zehner/Einer negativ?
	brpl	mob050			;nein -> weiter
	subi	r22,156			;sonst Zehner/Einer korrigieren
mob050:	mov	r20,r23			;Hunderter holen
	rcall	hexbcd			;und in BCD wandeln
	tst	r21			;H-Byte=0?
	breq	mob060			;ja -> berspringen
	ori	r21,0x30		;sonst Ziffer in ASCII wandeln
	st	y+,r21			;und in Puffer legen
	mov	r18,r21			;Flag setzen
mob060:	tst	r20			;L-Byte=0?
	brne	mob070			;nein -> ausgeben
	tst	r18			;hherwertige Ziffer vorhanden?
	breq	mob080			;nein -> berspringen	
mob070:	ori	r20,0x30		;sonst Ziffer in ASCII wandeln
	st	y+,r20			;und in Puffer legen
	mov	r18,r20			;Flag setzen
mob080:	mov	r20,r22			;Zehner/Einer holen
	rcall	hexbcd			;und in BCD wandeln
	tst	r21			;H-Byte=0?
	brne	mob090			;nein -> ausgeben
	tst	r18			;hherwertige Ziffer vorhanden?
	breq	mob100			;nein -> berspringen
mob090:	ori	r21,0x30		;sonst Ziffer in ASCII wandeln
	st	y+,r21			;und in Puffer legen
mob100:	ori	r20,0xb0		;L-Byte in ASCII+Dezimalpunkt
	st	y+,r20			;und in Puffer legen
	ldi	r20,' '			;Leerzeichen laden
	st	y+,r20			;und in Puffer legen
mob110:	ldi	zl,low(bdstr3*2)	;Zeiger auf Geburtstagstext 3
	ldi	zh,high(bdstr3*2)
	lpm				;1. Zeichen holen (Textlnge)
	mov	r22,r0			;Zeichenzhler setzen
	ld	r1,z+
	ld	r1,z+			;Zeiger auf erstes Textzeichen
mob120:	lpm				;Textzeichen holen
	ld	r1,z+			;Zeiger erhhen
	st	y+,r0			;Textzeichen in Puffer legen
	dec	r22			;alle Zeichen gelesen?
	brne	mob120			;nein -> Schleife
	ser	r21			;Endezeichen
	st	y,r21			;Textzeichen in Puffer legen
;
	clr	r19			;Offset (L) setzen
	clr	r20			;Offset (H) setzen
mob130:	ldi	yl,low(bdaytx)		;Zeiger auf Geb-Puffer setzen
	ldi	yh,high(bdaytx)
	add	yl,r19			;aktuelle Geburtstags-Puffer-
	adc	yh,r20			;Position berechnen
	ldi	r22,10			;Zeichen kopieren
	ldi	xl,low(texbuf+10)	;Zeiger auf Textpuffer-Ende
	ldi	xh,high(texbuf+10)
mob140:	ld	r21,y+			;Zeichen holen und
	st	-x,r21			;in Textpuffer kopieren
	dec	r22			;alle Zeichen kopiert?
	brne	mob140			;nein -> Schleife
	ld	r21,y+			;nchstes Zeichen lesen
	rcall	outtxt			;Text ausgeben
	ldi	r18,7			;350ms warten
	rcall	waitnn			;Warteschleife
	tst	r17			;wurde Schleife abgebrochen?
	brne	mob150			;ja -> Ende
	cpi	r21,0xff		;Endezeichen?
	breq	mob150			;ja -> Ende
	inc	r19			;sonst Offset erhhen
	rjmp	mob130			;Schleife
mob150:	clr	r22
	sts	bdayfl,r22		;Geburtstags-Flag L lschen
	sts	bdayfh,r22		;Geburtstags-Flag H lschen
	ret
;
;	-----------------------------------
;	LED-Test; Test alle Anzeigeelemente
;	-----------------------------------
;
ledtst:	rcall	clrtxt			;Textanzeige lschen
	ldi	r23,4			;Zeitanzeige, 4 Ziffern
	ldi	r22,0x0f		;Anzeigestelle lschen
	ldi	xl,low(timbuf)		;Zeiger auf Zeitanzeige
	ldi	xh,high(timbuf)
led010:	st	x+,r22			;Ziffer lschen
	dec	r23			;alle Ziffern bearbeitet?
	brne	led010			;nein -> Schleife
	st	x,r23			;Dezimalpunkte lschen
;
	ldi	r23,17			;17 Ausgabeschleifen
	ldi	r21,-6			;Anfangswert fr Ziffer
	clr	r9			;Anfangswert fr Dezimalpunkte
led020:	mov	r20,r21			;Ziffernwert kopieren
	ldi	r22,4			;4 Ziffern ausgeben
	ldi	xl,low(timbuf+4)	;Zeiger auf Ende des
	ldi	xh,high(timbuf+4)	;Zeitanzeige-Puffers
	cpi	r20,-4			;Start fr Dezimalpunkt?
	clc				;Carry lschen
	brne	led030			;nein -> weiter
	sec				;sonst Carry setzen
led030:	rol	r9			;Carry als Dezimalpunkt 0
	sts	timept,r9		;Dezimalpunkte speichern
led040:	mov	r19,r20			;Ziffernwert nochmals kopieren
	cpi	r19,10			;Ziffernwert<10?
	brcs	led050			;ja -> weiter
	ldi	r19,0x0f		;sonst Ziffer ausblenden
led050:	st	-x,r19			;Ziffer in Puffer schreiben
	inc	r20			;nchsten Ziffernwert bearb.
	dec	r22			;alle 4 Ziffern bearbeitet?
	brne	led040			;nein -> Schleife
	ldi	r18,10			;500 ms warten
	rcall	waitnn
	tst	r17			;wurde Schleife abgebrochen?
	brne	ledend			;ja -> Ende
	inc	r21			;Anfangswert erhhen
	dec	r23			;alle Testschleifen erledigt?
	brne	led020
;
	ldi	r23,107			;107 Ausgabeschleifen
	ldi	r21,23			;Anfangswert fr Zeichen
led060:	mov	r20,r21			;Ziffernwert kopieren
	ldi	r22,10			;10 Zeichen ausgeben
	ldi	xl,low(texbuf+10)	;Zeiger auf Ende des Text-
	ldi	xh,high(texbuf+10)	;Puffers
led070:	mov	r19,r20			;Zeichenwert nochmals kopieren
	cpi	r19,0x80		;Zeichenwert>127?
	brcs	led080			;nein -> weiter
	ldi	r19,' '			;sonst Leerzeichen verwenden
led080:	cpi	r19,' '			;Zeichenwert<32?
	brcc	led090			;nein -> weiter
	ldi	r19,' '			;sonst Leerzeichen verwenden
led090:	st	-x,r19			;Zeichen in Puffer schreiben
	inc	r20			;nchsten Zeichenwert bearb.
	dec	r22			;alle 10 Zeichen bearbeitet?
	brne	led070			;nein -> Schleife
	push	r23
	push	r22			;bentigte Register sichern
	rcall	outtxt			;Text ausgeben
	pop	r22			;Register restaurieren
	pop	r23
	ldi	r18,10			;500 ms warten
	rcall	waitnn
	tst	r17			;wurde Schleife abgebrochen?
	brne	ledend			;ja -> Ende
	inc	r21			;Anfangswert erhhen
	dec	r23			;alle Testschleifen erledigt?
	brne	led060
;
ledend:	lds	r23,dcflag		;DCF77-Flags holen
	cbr	r23,0x20		;LED-Test-Flag lschen
	sts	dcflag,r23		;und Flags wieder speichern
	clr	r23
	sts	timept,r23		;Dezimalpunkte lschen
	rjmp	main			;zurck in die Hauptschleife
;
;	---------------------------------------------------
;	Unterprogramm fr beliebige Warteschleifen im
;	Raster von 50ms, verwendet Unterprogramm waitxx
;	benutzt Register r0,r16,r17,r18
;	Eingang: r18 - Zeit in 50-ms-Schritten
;	Ausgang: r17=0 - Warteschleife ok, r17<>0 - Abbruch
;	---------------------------------------------------
;
waitnn:	rcall	waitxx			;Warteschleife 50 ms
	tst	r17			;Warteschleife ok?
	brne	waitne			;nein -> Ende
	dec	r18			;Schrittzhler vermindern
	brne	waitnn			;Ende erreicht? nein -> weiter
waitne:	ret
;
;	---------------------------------------------------
;	Unterprogramm fr Warteschleife von etwa 50 ms
;	Whrend der Warteschleife werden stndig die
;	Tasten-Bits und das DCF77-Minuten-Bit abgefragt
;	benutzt Register r0,r16,r17
;	Ausgang: r17=0 - Warteschleife ok, r17<>0 - Abbruch
;	---------------------------------------------------
;
waitxx:	ldi	r16,72			;Wartezeit 50 ms
	clr	r0			;Zykluszhler lschen
wait20:	lds	r17,xflags		;Flags holen
	bst	r17,2			;Taste 1 gedrckt?
	brtc	wait30			;nein -> weiter
	bst	r17,4			;Taste 1 bereits bearbeitet?
	brtc	waiend			;nein -> Ende
wait30:	bst	r17,3			;Taste 2 gedrckt?
	brtc	wait40			;nein -> weiter
	bst	r17,5			;Taste 2 bereits bearbeitet?
	brtc	waiend			;nein -> Ende
wait40:	dec	r0			;sonst Zykluszhler vermindern
	brne	wait20			;Ende erreicht? nein -> Schl.
	dec	r16			;Wartezeit vermindern
	brne	wait20			;Wartezeit erreicht? nein -> S.
	clr	r17			;Ende ohne Unterbrech. (r17=0)
waiend:	ret
;
;	----------------------------------------------
;	Unterprogramm fr Warteschleife von etwa 50 ms
;	benutzt Register r16,r17
;	----------------------------------------------
;
waityy:	clr	r17			;Wartezeit 50 ms
	clr	r16			;Zykluszhler lschen
wait50:	dec	r16			;sonst Zykluszhler vermindern
	brne	wait50			;Ende erreicht? nein -> Schl.
	wdr				;Watchdog zurcksetzen
	dec	r17			;Wartezeit vermindern
	brne	wait50			;Wartezeit erreicht? nein -> S.
	ret
;
;	----------------------------------------------------------
;	Unterprogramm zur Multiplikation 16*16 Bit ohne Vorzeichen
;	(aus AppNote AVR200)
;	Register: r16,r17,r18,r19,r20,r21,r22
;		  r16 - Faktor 1 Low
;		  r17 - Faktor 1 High
;		  r18 - Faktor 2 Low  -> Produkt 0 (LSB)
;		  r19 - Faktor 2 High -> Produkt 1
;		  r20 -			 Produkt 2
;		  r21 -			 Produkt 3 (MSB)
;	----------------------------------------------------------
;
mul16u:	clr	r21		;die 2 hchstwertigen Bytes lschen
	clr	r20
	ldi	r22,16		;Schleifenzhler initialisieren
	lsr	r19
	ror	r18
m16u10:	brcc	m16u20		;wenn Bit 0 in Faktor 2 gesetzt, dann
	add	r20,r16		;Faktor 1 mit Ergebnisbyte 2 addieren
	adc	r21,r17		;Faktor 1 mit Ergebnisbyte 3 addieren
m16u20:	ror	r21		;Ergebnisbyte 3 nach rechts schieben
	ror	r20		;Ergebnisbyte 2 nach rechts schieben
	ror	r19		;Ergebnisbyte 1 nach rechts schieben
	ror	r18		;Ergebnisbyte 0 nach rechts schieben
	dec	r22		;Schleifenzhler dekrementieren
	brne	m16u10		;weiter wenn Zhler>0
	ret

;	----------------------------------------------------
;	Unterprogramm zur Division 16/16 Bit ohne Vorzeichen
;	(aus AppNote AVR200)
;	Register: r8,r9,r16,r17,r18,r19,r20
;		  r16 - Divident Low  -> Quotient Low
;		  r17 - Divident High -> Quotient High
;		  r18 - Divisor Low
;		  r19 - Divisor High
;		  r8  - Rest Low
;		  r9  - Rest High
;	----------------------------------------------------
;
div16u:	clr	r8		;Rest L lschen
	sub	r9,r9		;Rest H und Carry lschen
	ldi	r20,17		;Schleifenzhler initialisieren
d16u10:	rol	r16		;Dividend nach links schieben
	rol	r17
	dec	r20		;Schleifenzhler decrementieren
	brne	d16u20		;weiter wenn Zhler>0
	ret			;sonst Ende
d16u20:	rol	r8		;Dividend in Rest schieben
	rol	r9
	sub	r8,r18		;Rest = Rest - Divisor
	sbc	r9,r19
	brcc	d16u30		;weiter wenn Ergebnis negativ
	add	r8,r18		;sonst Rest wieder holen
	adc	r9,r19
	clc			;Carry lschen und ins
	rjmp	d16u10		;Ergebnis schieben
d16u30:	sec			;oder Carry setzen und ins
	rjmp	d16u10		;Ergebnis schieben
;
;	-----------------------------------------
;	Unterprogramm zum Lschen der Textanzeige
;	benutzt Register r22,r23,x
;	-----------------------------------------
;
clrtxt:	ldi	r22,30			;30 Bytes Pufferspeicher
	clr	r23			;lschen (Segmente und ASCII)
	ldi	xl,low(segbuf)		;Zeiger auf Segmentpuffer
	ldi	xh,high(segbuf)		;setzen
clr010:	st	x+,r23			;Pufferbyte lschen
	dec	r22			;alle Bytes bearbeitet?
	brne	clr010			;nein -> Schleife
	ret
;
;	-------------------------------------------
;	Unterprogramm zum Kopieren einer Zeichkette
;	aus dem Programmspeicher in den Textpuffer
;	benutzt Register r0,r22,y,z
;	Eingang: z - Zeiger auf Text im Programm
;	-------------------------------------------
;
copytx:	ldi	r22,10			;10 Zeichen ausgeben
	ldi	yl,low(texbuf+10)	;Zeiger auf Ende
	ldi	yh,high(texbuf+10)	;des Textpuffers
copy10:	lpm				;Zeichen aus Programm holen
	inc	zl			;Zeiger L erhhen
	brne	copy20			;bertrag? nein -> weiter
	inc	zh			;sonst H erhhen
copy20:	st	-y,r0
	dec	r22
	brne	copy10
	ret
;
;	--------------------------------------------
;	Unterprogramm zur Ausgabe einer Zeichenkette
;	benutzt Register r0,r1,r2,r22,r23,x,y
;	--------------------------------------------
;
outtxt:	ldi	r22,10			;10 Zeichen ausgeben
	ldi	xl,low(texbuf)		;Zeiger auf Textpuffer
	ldi	xh,high(texbuf)
	ldi	yl,low(segbuf)		;Zeiger auf Segmentpuffer
	ldi	yh,high(segbuf)
out010:	ld	r23,x+			;ASCII-Zeichen holen
	rcall	asconv			;in Segmente konvertieren
	std	y+10,r2			;Segmente (H) ablegen
	st	y+,r1			;Segmente (L) ablegen
	dec	r22			;alle Zeichen bearbeitet?
	brne	out010			;nein -> Schleife
	ret
;
;	-------------------------------------------------------
;	Unterprogramm zur Ausgabe einer Zeichenkette mit Effekt
;	benutzt Register r0,r1,r2,r16,r17,r21,r22,r23,x,y
;	-------------------------------------------------------
;
outeff:	ldi	r22,10			;10 Zeichen ausgeben
	ldi	xl,low(texbuf+10)	;Zeiger auf Textpuffer
	ldi	xh,high(texbuf+10)
	ldi	yl,low(segbuf+9)	;Zeiger auf Segmentpuffer
	ldi	yh,high(segbuf+9)
oute10:	clr	r21
	std	y+10,r21		;Segmente zunchst lschen (H)
	st	y,r21			;Segmente zunchst lschen (L)
	rcall	waitxx			;Warteschleife 50ms
	ld	r23,-x			;ASCII-Zeichen holen
	rcall	asconv			;in Segmente konvertieren
	std	y+10,r2			;Segmente (H) ablegen
	st	y,r1			;Segmente (L) ablegen
	dec	yl
	dec	r22			;alle Zeichen bearbeitet?
	brne	oute10			;nein -> Schleife
	ret
;
;	---------------------------------------------------
;	Unterprogramm zur Konvertierung ASCII -> 16-Segment
;	benutzt Register r0,r1,r2,r23
;	Eingang: r23 - ASCII-Zeichen
;	Ausgang: r1  - Segmente Low a-i
;		 r2  - Segmente High j-x
;	---------------------------------------------------
;
asconv:	bst	r23,7			;Bit 7 sichern (Dezimalpunkt)
	cbr	r23,0x80		;Bit 7 lschen
	cpi	r23,0x20		;Code < 20h?
	brcc	asc020			;nein -> weiter
asc010:	clr	r1			;sonst alle Segmente
	clr	r2			;lschen
	ret				;sonst
asc020:	subi	r23,0x20		;Offset korrigieren
	push	zl			;Zeiger-Register sichern
	push	zh
	ldi	zl,low(disptb)		;Zeiger auf Zeichentabelle L
	ldi	zh,high(disptb)		;Zeiger auf Zeichentabelle H
	add	zl,r23			;Offset addieren
	clr	r0
	adc	zh,r0			;bertrag addieren
	rol	zl			;Ergebnis *2
	rol	zh
	lpm				;16-Segment-Code (L) holen
	mov	r1,r0
	inc	zl			;Zeiger auf H-Byte
	lpm				;16-Segment-Code (H) holen
	mov	r2,r0
	bld	r2,7			;Dezimalpunkt ergnzen
	pop	zh			;Zeiger-Register restaurieren
	pop	zl
	ret
;
;	----------------------------------------------
;	Unterprogramm zur Konvertierung Binr (10 Bit)
;	in ASCII (3 Zeichen)
;	benutzt Register r0,r1,r2,r22,r23
;	Eingang: r22 - Binrzahl low
;		 r23 - Binrzahl High
;	Ausgang: r0  - ASCII-Zahl Low
;		 r1  - ASCII-Zahl Mid
;		 r2  - ASCII-Zahl High
;	----------------------------------------------
;
binasc:	clr	r0			;0-Wert fr 16-Bit Subtraktion
	clr	r2			;ASCII-High lschen
bin010:	mov	r1,r22			;Binrzahl zwischenspeichern L
	subi	r22,100			;100 subtrahieren
	sbc	r23,r0			;bertrag subtrahieren
	brcs	bin020			;war Zahl>99? nein -> weiter
	inc	r2			;ASCII-High erhhen
	rjmp	bin010			;Schleife
bin020:	mov	r22,r1			;letzten Binrwert L holen
	clr	r1			;ASCII-Mid lschen
bin030:	cpi	r22,10			;Wert>9?
	brcs	bin040			;nein -> Rest auswerten
	inc	r1			;sonst ASCII-Mid erhhen
	subi	r22,10			;Wert um 10 vermindern
	rjmp	bin030			;Schleife
bin040:	mov	r0,r22			;Rest in ASCII-Low legen
	ldi	r23,0x30		;Offset zur ASCII-Wandlung
	or	r0,r23			;Ergebnis in ASCII wandeln
	or	r1,r23
	or	r2,r23
	ret
;
;	---------------------------------------------
;	Unterprogramm zum Konvertieren von BCD in Hex
;	benutzte Register: r21,r22,r23
;	Eingang: r22 - BCD-Wert L (0-9)
;		 r23 - BCD-Wert H (0-9)
;	Ausgang: r22 - Hex-Wert (0-99)
;	---------------------------------------------
;
bcdhex:	ldi	r21,10			;Umrechnungswert=10
bcd010:	tst	r23			;BCD-H-Wert=0?
	breq	bcd020			;ja - weiter
	dec	r23
	add	r22,r21			;sonst Ergebnis um 10 erhhen
	rjmp	bcd010			;Schleife
bcd020:	ret
;
;	---------------------------------------------
;	Unterprogramm zum Konvertieren von Hex in BCD
;	benutzte Register: r20,r21
;	Eingang: r20 - Hexzahl (0-99)
;		 r20 - BCD-Zahl L (0-9)
;		 r21 - BCD-Zahl H (0-9)
;	---------------------------------------------
;
hexbcd:	clr	r21			;High-Zahl lschen
hexb10:	cpi	r20,10			;Hexwert>9?
	brcs	hexb20			;nein -> Low-Zahl bearbeiten
	inc	r21			;sonst High-Zahl erhhen
	subi	r20,10			;Hexwert-10
	rjmp	hexb10			;Schleife
hexb20:	ret				;Low-Zahl in r20
;
;	-----------------------------------------
;	Unterprogramm zum Lesen des EEPROM
;	benutzte Register: r18,r19,r20
;	Eingang: r18 - Adrebyte (L)
;		 r19 - Adrebyte (H)
;	Ausgang: r20 - Datenbyte
;	-----------------------------------------
;
readee:	sbic	eecr,eewe		;Schreibvorgang noch aktiv?
	rjmp	readee			;ja -> Schleife
	out	eearl,r18		;EEPROM-Adresse L setzen
	out	eearh,r19		;EEPROM-Adresse H setzen
	sbi	eecr,eere		;EEPROM-Lese-Bit setzen
	in	r20,eedr		;EEPROM-Byte auslesen
	ret
;
;	-----------------------------------------
;	Unterprogramm zum Schreiben in den EEPROM
;	benutzte Register: r18,r19,r20
;	Eingang: r18 - Adrebyte (L)
;		 r19 - Adrebyte (H)
;		 r20 - Datenbyte
;	-----------------------------------------
;
writee:	sbic	eecr,eewe		;Schreibvorgang noch aktiv?
	rjmp	writee			;ja -> Schleife
	out	eearl,r18		;EEPROM-Adresse L setzen
	out	eearh,r19		;EEPROM-Adresse H setzen
	out	eedr,r20		;EEPROM-Datenbyte setzen
	sbi	eecr,eemwe		;Masterwrite-Bit setzen
	sbi	eecr,eewe		;Write-Bit setzen
	ret
;
;	-------------------------------------------------
;	Unterprogramm zum Aktivieren des 3Wire-Interface
;	zur Kommunikation mit dem Temperatursensor DS1620
;	benutzte Register: r20
;	-------------------------------------------------
;
w3actv:	ldi	r20,0b11111110		;PortA 1-3 mit Pullup und
	out	porta,r20		;Textdisplay-Mux=15 ausgeben
	ldi	r20,20			;kurze Warteschleife, verhin-
w3a010:	dec	r20			;dert strendes Leuchten der
	brne	w3a010			;Anzeige beim 3Wire-Zugriff
	ldi	r20,0b10		;3Wire-Clk auf High setzen
	out	portc,r20		;ausgeben
	nop
	nop				;warten
	sbi	porta,0			;2Wire-Rst auf High setzen
	ret
;
;	--------------------------------------------------
;	Unterprogramm zum Deaktivieren des 3Wire-Interface
;	benutzte Register: r20
;	--------------------------------------------------
;
w3deac:	cbi	porta,0			;3Wire-Rst in Ruhezustand
	clr	r20			;Clk/DQ deaktivieren
	out	portc,r20		;ausgeben
	ret
;
;	---------------------------------------------
;	Unterprogramm zum Senden eines Kommandos ber
;	3Wire-Interface zum Temperatursensor DS1620
;	benutzte Register: r20,r21,r22
;	Eingang: r22 - zu sendendes Byte
;	---------------------------------------------
;
w3send:	ldi	r21,8			;8 Bits senden
w3se10:	clr	r20			;Clk auf Low setzen
	bst	r22,0			;LSB vom Datenbyte holen
	bld	r20,0			;und als Datenbit einsetzen
	out	portc,r20		;ausgeben
	ori	r20,0b10		;Clk auf High (Datenbernahme)
	ror	r22			;nchstes Bit vorbereiten
	dec	r21			;alle Bits gesendet?
	out	portc,r20		;ausgeben
	brne	w3se10			;Schleife
	ret
;
;	-------------------------------------------
;	Unterprogramm zum Empfangen von 8 Bits ber
;	3Wire-Interface vom Temperatursensor DS1620
;	benutzte Register: r20,r21,r22,r23
;	Ausgang: r22 - empfangenes Byte
;	-------------------------------------------
;
w3rec8:	ldi	r20,0xfe		;DQ auf Input umschalten
	out	ddrc,r20		;ausgeben
	ldi	r20,0b10		;Clk auf High, DQ hochohmig
	out	portc,r20		;ausgeben
	ldi	r21,8			;8 Datenbits einlesen
w3re10:	cbi	portc,1			;Clk auf Low (Datenbernahme)
	nop
	nop				;warten
	in	r23,pinc		;Datenbit einlesen
	sbi	portc,1			;Clk auf High
	ror	r23			;empfangenes Bit in Carry und
	ror	r22			;in Datenbyte einschieben
	dec	r21			;alle Bits eingelesen?
	brne	w3re10			;nein -> Schleife
	ldi	r20,0xff		;sonst DQ auf Output umschalten
	out	ddrc,r20		;ausgeben
	ret
;
;	-------------------------------------------
;	Unterprogramm zum Empfangen von 9 Bits ber
;	3Wire-Interface vom Temperatursensor DS1620
;	benutzte Register: r20,r21,r22,r23
;	Ausgang: r22 - empfangenes Byte (L)
;		 r23 - empfangenes Byte (H)
;	-------------------------------------------
;
w3rec9:	ldi	r20,0xfe		;DQ auf Input umschalten
	out	ddrc,r20		;ausgeben
	ldi	r20,0b10		;Clk auf High, DQ hochohmig
	out	portc,r20		;ausgeben
	ldi	r21,8			;8 Datenbits einlesen
w3re20:	cbi	portc,1			;Clk auf Low (Datenbernahme)
	nop
	nop
	in	r23,pinc		;Datenbit einlesen
	sbi	portc,1			;Clk auf High
	ror	r23			;empfangenes Bit in Carry und
	ror	r22			;in Datenbyte einschieben
	dec	r21			;alle Bits eingelesen?
	brne	w3re20			;nein -> Schleife
	cbi	portc,1			;Clk auf Low (Datenbernahme)
	nop
	nop
	in	r23,pinc		;Datenbit einlesen
	sbi	portc,1			;Clk auf High
	andi	r23,0x01		;MSB (Bit 9) in r23
	ldi	r20,0xff		;DQ auf Output umschalten
	out	ddrc,r20		;ausgeben
	ret
;
;	------------------------------------------------------------
;	Interrupt-Routine Timer1 Compare A
;	steuert die Multiplex-Anzeige (Textdisplay, Zifferndisplay),
;	und viele andere Funktionen,
;	benutzt Register r10,r11,r12,r13,r14,r24
;	------------------------------------------------------------
;
timint:	in	tflag,sreg		;Flags sichern
	push	yl			;Y-Register sichern
	push	yh
;
;	- Ausgabe der Textanzeige -
;
	clr	r10
	out	portc,r10		;zuerst alle Segmente des
	out	portd,r10		;Textdisplays abschalten
	ldi	r24,0b00001110		;Status von PortA (Pullups)
	mov	r12,r24			;und sichern
	lds	r11,muxtex		;Muxzhler fr Textdisplay
	bst	r11,0			;Bit 0 des Muxzhlers sichern
	mov	r24,r11			;Zhler zwischenspeichern
	swap	r11			;Nibbles tauschen
	or	r11,r12			;PortA-Status hinzufgen
	out	porta,r11		;Multiplexzhler ausgeben
	ldi	yl,low(segbuf)		;Zeiger auf Anzeigepuffer
	ldi	yh,high(segbuf)		;setzen
	add	yl,r24			;Textpufferadresse berechnen
	ld	r13,y			;Textpufferinhalt L holen
	ldd	r14,y+10		;Textpufferinhalt H holen
	inc	r24			;Muxzhler fr Textdisplay erh.
	sts	muxtex,r24		;und wieder speichern
	cpi	r24,10			;Endwert erreicht?
	brcs	tim010			;nein -> Weiter zum Zeitdisplay
	sts	muxtex,r10		;sonst Muxzhler rcksetzen
tim010:	ldi	r24,10			;kleine Warteschleife
tim020:	dec	r24
	brne	tim020
	lds	r24,xflags		;Flags holen
	cbr	r24,0x7f		;Bit 7 (Sleep) gesetzt?
	brne	tim030			;ja -> Segmentausgabe berspr.
	out	portc,r13		;erst jetzt Segmente L und H
	out	portd,r14		;ausgeben (kein Nachleuchten)
;
;	- Ausgabe der Zeitanzeige -
;
tim030:	brts	tim050			;Text-Muxz. gerade? -> weiter
	rjmp	tim110			;sonst berspringen
tim050:	lds	r11,muxtim		;Muxzhler fr Zeitdisplay hol.
	mov	r14,r11			;und nochmals zwischenspeichern
	mov	r24,r11			;und zwischenspeichern
	dec	r24			;Mux-Zhler auf vorherigen Wert
	andi	r24,0x03		;eventuellen berlauf lschen
	swap	r24			;Muxwert auf Bits 4,5 setzen
	sbr	r24,0x0f		;Ziffernwert 15 (Anzeige aus)
	lds	r10,xflags		;Flags holen
	bst	r10,6			;Gong-Bit holen
	bld	r24,7			;in Ausgabebyte einsetzen
	out	portb,r24		;Daten ausgeben
	mov	r24,r11			;Muxzhler wieder holen
	inc	r24			;Muxzhler erhhen
	andi	r24,0x03		;eventuellen berlauf lschen
	sts	muxtim,r24		;neuen Muxzhler speichern
	ldi	yl,low(timbuf)		;Zeiger auf Anzeigepuffer
	ldi	yh,high(timbuf)		;setzen
	add	yl,r11			;Zeitpufferadresse berechnen
	ld	r24,y			;Zeitpufferinhalt holen
	swap	r11			;Muxwert auf Bits 4,5 setzen
	or	r11,r24			;Ziffernwert auf Bits 0-3 erg.
	mov	r24,r11			;Byte zwischenspeichern
	sbr	r24,0x0f		;zunchst Ziffernwert 15 setzen
	bld	r24,7			;gesichertes Gong-Bit einsetzen
	out	portb,r24		;und ausgeben (Anzeige aussch.)
	ldi	r24,10			;kleine Warteschleife
tim060:	dec	r24
	brne	tim060
	lds	r13,timept		;Ziffern-Dezimalpunkte holen
tim070:	ror	r13			;Dezimalpunkt in C schieben
	tst	r14			;richt. Dezimalpunkt erreicht?
	breq	tim080			;ja -> weiter (Dezimal-P. in C)
	dec	r14			;sonst nchsten Punkt bearb.
	rjmp	tim070
tim080:	brcc	tim090			;Dezimalpunkt aktiv?
	ldi	r24,0x40		;Dezimalpunkt setzen
	or	r11,r24			;Dezimalpunkt ergnzen (Bit 6)
tim090:	bld	r11,7			;gesichertes Gong-Bit einsetzen
	out	portb,r11		;neuen Zeitwert ausgeben
;
	bst	r10,7			;Flags-Bit 7 (Sleep) gesetzt?
	brtc	tim110			;nein -> weiter
	ldi	r24,15			;sonst kurze Warteschleife
tim100:	dec	r24
	brne	tim100
	mov	r24,r11			;letztes Ausgabebyte holen
	sbr	r24,0x0f		;Ziffer ausblenden
	cbr	r24,0x40		;Dezimalpunkt ausblenden
	out	portb,r24		;ausgeben
;
;	- Vorteiler 1 bearbeiten
;
tim110:	wdr				;Watchdog zurcksetzen
	lds	r24,pcoun1		;Vorteiler 1 holen
	inc	r24			;Vorteiler 1 erhhen
	andi	r24,0x0f		;eventuellen bertrag lschen
	sts	pcoun1,r24		;Vorteiler 1 wieder speichern
	breq	tim140			;Vorteiler-Reset? ja -> weiter
	rjmp	timend			;sonst -> Ende
;
;	- Vorteiler 1 berlauf (alle 15,6ms)
;	- Blinken von Dezimalpunkt 2, Tastenabfrage, DCF77-Decoder,
;	- Steuerung des Gongs
;
tim140:	lds	r24,timept		;Ziffer-Dezimalpunkte holen
	lds	r11,dcflag		;DCF77-Flags holen
	bst	r11,5			;LED-Test-Flag gesetzt?
	brts	tim170			;ja -> DP2 nicht verndern
	bst	r11,3			;Uhr schon synchronisiert?
	brts	tim150			;ja -> Blinksteuerung
	bst	r11,0			;sonst DCF-Status holen und
	bld	r24,2			;in Dezimalpunkt 2 kopieren
	rjmp	tim160			;speichern
tim150:	lds	r11,pcoun2		;Vorteiler 2 holen
	com	r11			;alle Bits invertieren
	bst	r11,5			;hchstwertiges Bit sichern und
	bld	r24,2			;in Dezimalpunkt 2 bertragen
tim160:	sts	timept,r24		;Dezimalpunkte wieder speichern
;
tim170:	in	r24,pina		;Tasten und DCF77 einlesen
	bst	r24,1			;Bit 1 (DCF77-Status) sichern
	lds	r10,dcflag		;DCF77-Flags holen
	bld	r10,0			;aktuellen DCF77-Status setzen
	sts	dcflag,r10		;DCF77-Flags wieder speichern
	lds	r10,xflags		;Flags holen
	lsr	r24			;Tastenbits auf Position 0/1
	lsr	r24			;schieben
	com	r24			;Bits invertieren
	cbr	r24,0b11111100		;Tastenbits filtern
	mov	r13,r24			;Tastenbits sichern
	mov	r12,r13			;Tastenbits kopieren
	mov	r11,r10			;Flags kopieren
	ldi	r24,0x01		;Maske fr Taste 1 setzen
	and	r11,r24			;Taste 1 in den Flags filtern
	and	r12,r24			;Taste 1 in Tasten filtern
	cp	r11,r12			;Status Taste 1 gendert?
	breq	tim180			;nein -> weiter
	bst	r13,0			;sonst neuen Tastenstatus
	bld	r10,0			;fr Taste 1 setzen
	rjmp	tim190
tim180:	bst	r10,0			;Status fr Taste 1 wird
	bld	r10,2			;entprellt
	brts	tim190			;weiter wenn Taste 1 gedrckt
	bld	r10,4			;sonst Bearbeitungs-Flag lsch.
tim190:	mov	r12,r13			;Tastenbits kopieren
	mov	r11,r10			;Flags kopieren
	ldi	r24,0x02		;Maske fr Taste 2 setzen
	and	r11,r24			;Taste 2 in den Flags filtern
	and	r12,r24			;Taste 2 in Tasten filtern
	cp	r11,r12			;Status Taste 2 gendert?
	breq	tim200			;nein -> weiter
	bst	r13,1			;sonst neuen Tastenstatus
	bld	r10,1			;fr Taste 2 setzen
	rjmp	tim210
tim200:	bst	r10,1			;Status fr Taste 2 wird
	bld	r10,3			;entprellt
	brts	tim210			;weiter wenn Taste 2 gedrckt
	bld	r10,5			;sonst Bearbeitungs-Flag lsch.
tim210:	sts	xflags,r10		;Flags wieder speichern
;
	lds	r24,dcfcnt		;DCF77-Zhler holen
	inc	r24			;Zhler erhhen
	sts	dcfcnt,r24		;und wieder speichern
	lds	r10,dcflag		;DCF-Flags holen
	bst	r10,0			;akuellen DCF77-Status prfen
	brts	tim310			;ist DCF77 High? ja -> weiter
	bst	r10,1			;sonst vorh. DCF-Status prfen
	brtc	tim350			;DCF77 vorher H? nein -> weiter
	lds	r24,dcfcnt		;DCF77-Zhler holen
	sts	dcfcn1,r24		;Zhlerstand (Impulsabstand)
	cpi	r24,96			;Zhler<96 (1,5s) ?
	brcs	tim300			;nein -> weiter
	bld	r10,7			;sonst Rahmenende setzen
;
tim300:	cpi	r24,58			;Zhler<58 (905ms) ?
	brcs	tim350			;ja -> ignorieren
	clr	r24			;sonst
	sts	dcfcnt,r24		;DCF77-Zhler lschen
	rjmp	tim350			;Ende
tim310:	bst	r10,1			;sonst vorh. DCF-Status prfen
	brts	tim350			;war DCF77 vorher H? ja -> Ende
	lds	r24,dcfcnt		;DCF77-Zhler holen
	sts	dcfcn2,r24		;Zhlerstand (Impulslnge)
	cpi	r24,16			;DCF-Zhler<16 (250ms)?
	brcc	tim350			;nein -> ignorieren
	cpi	r24,3			;DCF-Zhler<3 (47ms)?
	brcs	tim350			;ja -> ignorieren
	lds	r11,dcfcn3		;DCF-Zhler 3 holen
	inc	r11			;Zhler erhhen
	sts	dcfcn3,r11		;und wieder speichern
	cpi	r24,9			;Zhler<9? Ergebnis in C
	ldi	r24,6			;6 Pufferbytes bearbeiten
	ldi	yl,low(dcftab+6)	;Zeiger auf Pufferende setzen
	ldi	yh,high(dcftab+6)
	rol	r11			;Carry in Register legen
	com	r11			;alle Bits invertieren
	ror	r11			;wieder in Carry schieben
tim320:	ld	r11,-y			;Pufferbyte holen
	ror	r11			;neues Bit einschieben als MSB
	st	y,r11			;LSB in Carry und speichern
	dec	r24			;alle Pufferbytes bearbeitet?
	brne	tim320			;nein -> Schleife
tim350:	bst	r10,0			;aktuellen DCF77-Status holen
	bld	r10,1			;und als neuen Status speichern
	sts	dcflag,r10		;DCF77-Flags speichern
;
	lds	r24,xflags		;Flags holen
	bst	r24,6			;Gong-Flag gesetzt?
	brtc	tim380			;nein -> weiter
	lds	r11,gngcnt		;sonst Gong-Zhler holen
	dec	r11			;Zhler -1 und wieder
	sts	gngcnt,r11		;speichern, Zhler abgelaufen?
	brne	tim380			;nein -> weiter
	cbr	r24,0x40		;sonst Gong-Flag lschen
	sts	xflags,r24		;Flags wieder speichern
;
;	- Aktuelle Uhrzeit ausgeben
;
tim380:	sbrc	r10,5			;LED-Test-Flag gesetzt?
	rjmp	tim410			;ja -> Zeitausgabe berspringen
	lds	r24,minutl		;Minuten Einer holen
	sts	timbuf,r24		;und in Zeitpuffer schreiben
	lds	r24,minuth		;Minuten Zehner holen
	sts	timbuf+1,r24		;und in Zeitpuffer schreiben
	lds	r24,hourl		;Stunden Einer holen
	sts	timbuf+2,r24		;und in Zeitpuffer schreiben
	lds	r24,hourh		;Stunden Zehner holen
	tst	r24			;Stunden-Zehner=0?
	brne	tim400			;nein -> weiter
	ldi	r24,0x0f		;sonst Ziffer ausblenden
tim400:	sts	timbuf+3,r24		;in Zeitpuffer schreiben
;
;	- Vorteiler 2 bearbeiten
;
tim410:	lds	r24,pcoun2		;Vorteiler 2 holen
	inc	r24			;Vorteiler 2 erhhen
	andi	r24,0x3f		;eventuellen bertrag lschen
	sts	pcoun2,r24		;Vorteiler 2 wieder speichern
	breq	tim420			;bertrag? ja -> weiter
	rjmp	timend			;sonst Ende
;
;	- Vorteiler 2 berlauf (alle 1,0s)
;	- Timeout-Zhler fr Men bearbeiten
;	- Zeitzhlung Sekunden
;
tim420:	lds	r24,mencn1		;Men-Timeout-Zhler holen
	inc	r24			;erhhen und
	sts	mencn1,r24		;wieder speichern
	lds	r24,second		;Sekundenzhler holen
	inc	r24			;erhhen und
	sts	second,r24		;wieder speichern
	cpi	r24,60			;Endwert erreicht?
	brne	tim430			;nein -> weiter
	clr	r24			;sonst zurcksetzen
	sts	second,r24		;und speichern
;
;	- Anzeige-Zyklus-Flag setzen (alle 4 Sekunden, beginnend ab
;	  Sekunde 2)
;
tim430:	inc	r24
	inc	r24			;Sekunde in 4s-Raster bringen
tim440:	subi	r24,4			;4 subtrahieren
	brcs	tim500			;Ergebnis negativ? ja -> Ende
	breq	tim450			;Ergebnis=0? ja -> Flag setzen
	rjmp	tim440			;Schleife
;
tim450:	lds	r24,dcflag		;DCF77-Flags holen
	sbr	r24,0x40		;Anzeige-Zyklus-Flag setzen
	sts	dcflag,r24		;und Flags wieder speichern
;
;	- Minuten-bertrag
;
tim500:	lds	r24,second		;Sekundenzhler holen
	tst	r24			;bertrag?
	breq	tim550			;ja -> weiter
	rjmp	timend			;sonst Ende
;
;	- DCF-Timeout-Zhler bearbeiten
;	- Zeitzhlung Minuten und Stunden
;
tim550:	lds	r24,dcflag		;DCF77-Flags holen
	bst	r24,5			;luft LED-Test?
	brts	tim600			;ja -> DCF-Timeout berspringen
	lds	r24,timept		;Dezimalpunkte (Zeit) holen
	lds	r10,dcftim		;DCF77-Timeout-Zhler holen
	tst	r10			;Zhlerstand 0 erreicht?
	brne	tim560			;nein -> weiter
	sbr	r24,0x01		;Dezimalpunkt Anzeige 0 setzen
	rjmp	tim570			;Daten wieder speichern
;
tim560:	dec	r10			;Zhler -1
	cbr	r24,0x01		;Dezimalpunkt Anzeige 0 lschen
tim570:	sts	dcftim,r10		;DCF77-Timeout-Zhler speichern
	sts	timept,r24		;Dezimalpunkte (Zeit) speichern
;
tim600:	lds	r24,minutl		;Minuten Einer holen
	inc	r24			;erhhen
	sts	minutl,r24		;und wieder speichern
	cpi	r24,10			;bertrag?
	brcs	tim610			;nein -> Ende
	clr	r24			;sonst zurcksetzen
	sts	minutl,r24		;und speichern
;	
	lds	r24,minuth		;Minuten Zehner holen
	inc	r24			;erhhen
	sts	minuth,r24		;und wieder speichern
	cpi	r24,6			;bertrag?
	brcs	tim610			;nein -> Ende
	clr	r24			;sonst zurcksetzen
	sts	minuth,r24		;und speichern
;
	lds	r24,hourl		;Stunden Einer holen
	inc	r24			;erhhen
	sts	hourl,r24		;und wieder speichern
	cpi	r24,10			;bertrag?
	brcs	tim620			;nein -> Test auf "24"
	clr	r24			;sonst zurcksetzen
	sts	hourl,r24		;und speichern
;	
	lds	r24,hourh		;Stunden Zehner holen
	inc	r24			;erhhen
	sts	hourh,r24		;und wieder speichern
tim610:	rjmp	timend			;Ende
;
tim620:	lds	r24,hourh		;Stunden Zehner holen
	cpi	r24,2			;Stunden Zehner =2?
	brne	tim610			;nein -> Ende
	lds	r24,hourl		;nochmals Stunden Einer holen
	cpi	r24,4			;Stunden Einer =4 (=24)?
	brne	tim610			;nein -> Ende
	clr	r24			;sonst Stunden zurcksetzen
	sts	hourl,r24		;Stunden Einer speichern
	sts	hourh,r24		;Stunden Zehner speichern
;
;	- Zeitzhlung Wochentag und Kalendertag
;
	lds	r24,dayw		;Wochentag holen
	inc	r24			;erhhen
	sts	dayw,r24		;und wieder speichern
	cpi	r24,8			;Endwert erreicht?
	brcs	tim700			;nein -> weiter
	ldi	r24,1			;sonst Wochentag zurcksetzen
	sts	dayw,r24		;und wieder speichern
;
tim700:	lds	r24,dayl		;Tag Einer holen
	inc	r24			;erhhen
	sts	dayl,r24		;und wieder speichern
	cpi	r24,10			;Endwert erreicht?
	brcs	tim710			;nein -> Monatsende testen
	clr	r24			;sonst Tag Einer lschen
	sts	dayl,r24		;und wieder speichern
	lds	r24,dayh		;Tag Zehner holen
	inc	r24			;erhhen
	sts	dayh,r24		;und wieder speichern
;
;	- Monatsende testen
;
tim710:	lds	yh,monthh		;Monat Zehner holen
	tst	yh			;Zehner=0?
	breq	tim720			;ja -> weiter
	ldi	yh,10			;sonst auf 10 setzen
tim720:	lds	r24,monthl		;Monat Einer holen
	add	yh,r24			;mit Zehner verknpfen
;
	lds	r14,dayh		;Tag Zehner holen (Zhler)
	ldi	r24,10			;Faktor 10 setzen
	clr	yl			;Ergebnisregister lschen
tim730:	tst	r14			;Zhler=0?
	breq	tim740			;ja -> Ende
	add	yl,r24			;sonst 10 addieren
	dec	r14			;Zhler vermindern
	rjmp	tim730			;Schleife
;
tim740:	lds	r24,dayl		;Tag Einer holen
	add	yl,r24			;mit Zehner verknpfen
;
	cpi	yh,1			;Monat Januar?
	brne	tim750			;nein -> weiter testen
	cpi	yl,32			;Tag>31?
	brcc	tim780			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim750:	cpi	yh,2			;Monat Februar?
	brne	tim800			;nein -> weiter testen
;
	lds	r14,yearh		;Jahr Zehner holen
	ldi	r24,10			;Faktor 10 setzen
	clr	r13			;Ergebnisregister lschen
tim760:	tst	r14			;Zhler=0?
	breq	tim770			;ja -> Ende
	add	r13,r24			;sonst 10 addieren
	dec	r14			;Zhler vermindern
	rjmp	tim760			;Schleife
;
tim770:	lds	r24,yearl		;Jahr Einer holen
	add	r24,r14			;mit Zehner verknpfen
	andi	r24,0x03		;Schaltjahr?
	breq	tim790			;ja -> 29 Tage
	cpi	yl,29			;sonst Tag>28?
;
tim780:	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
tim790:	cpi	yl,30			;Tag>29?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim800:	cpi	yh,3			;Monat Mrz?
	brne	tim810			;nein -> weiter testen
	cpi	yl,32			;Tag>31?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim810:	cpi	yh,4			;Monat April?
	brne	tim820			;nein -> weiter testen
	cpi	yl,31			;Tag>30?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim820:	cpi	yh,5			;Monat Mai?
	brne	tim830			;nein -> weiter testen
	cpi	yl,32			;Tag>31?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim830:	cpi	yh,6			;Monat Juni?
	brne	tim840			;nein -> weiter testen
	cpi	yl,31			;Tag>30?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim840:	cpi	yh,7			;Monat Juli?
	brne	tim850			;nein -> weiter testen
	cpi	yl,32			;Tag>31?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim850:	cpi	yh,8			;Monat August?
	brne	tim860			;nein -> weiter testen
	cpi	yl,32			;Tag>31?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim860:	cpi	yh,9			;Monat September?
	brne	tim870			;nein -> weiter testen
	cpi	yl,31			;Tag>30?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim870:	cpi	yh,10			;Monat Oktober?
	brne	tim880			;nein -> weiter testen
	cpi	yl,32			;Tag>31?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim880:	cpi	yh,11			;Monat November?
	brne	tim890			;nein -> Monat Dezember
	cpi	yl,31			;Tag>30?
	brcc	tim900			;ja -> Monatswechsel
	rjmp	timend			;sonst Ende
;
tim890:	cpi	yl,32			;Tag>31?
	brcs	timend			;nein -> Ende
;
tim900:	ldi	r24,1			;Tag Einer
	sts	dayl,r24		;lschen
	clr	r24			;Tag Zehner
	sts	dayh,r24		;lschen
;
;	- Zeitzhlung Monat und Jahr
;
	lds	yh,monthh		;Monat Zehner holen
	lds	yl,monthl		;Monat Einer holen
	inc	yl			;erhhen
	sts	monthl,yl		;und wieder speichern
	cpi	yl,10			;Endwert erreicht?
	brcs	tim910			;nein -> Jahrende testen
	clr	yl			;sonst Monat Einer lschen
	sts	monthl,yl		;und wieder speichern
	inc	yh			;erhhen
	sts	monthh,yh		;und wieder speichern
;
tim910:	cpi	yh,1			;Monat Zehner=1?
	brne	timend			;nein -> Ende
	cpi	yl,3			;Monat Einer=3?
	brne	timend			;nein -> Ende
	sts	monthl,yh		;sonst Monat Einer=1 setzen
	clr	yh
	sts	monthh,yh		;Monat Zehner lschen
;
	lds	r24,yearl		;Jahr Einer holen
	inc	r24			;erhhen
	sts	yearl,r24		;und wieder speichern
	cpi	r24,10			;Endwert erreicht?
	brcs	timend			;nein -> Ende
	clr	r24			;sonst Jahr Einer lschen
	sts	yearl,r24		;und wieder speichern
	lds	r24,yearh		;Jahr Zehner holen
	inc	r24			;erhhen
	sts	yearh,r24		;und wieder speichern
;
timend:	out	sreg,tflag		;Flags restaurieren
	pop	yh			;Y-Register restaurieren
	pop	yl
	reti
;
;	------------------
;	Verschiedene Texte
;	------------------
;
copstr:	.db	'V','1'|0x80,"28 *SFH*"
nodast:	.db	" MOMEN",'T'|0x80,0xa0,0xa0,' '
tempst:	.db	"TEMP    #C"
secstr:	.db	"SEKUNDE   "
dcf77s:	.db	"!         "
men1st:	.db	"AUTOMATIK?"
men2st:	.db	"KOMPAKT?  "
men3st:	.db	"SEKUNDEN? "
men4st:	.db	"DCF-TEST? "
men5st:	.db	"NACHTZEIT?"
men6st:	.db	"GONGZEIT? "
men7st:	.db	"GONGTEST? "
men8st:	.db	"LED-TEST? "
nachst:	.db	"NACHT  -  "
gongst:	.db	"GONG   -  "
okstrg:	.db	"   -OK-   "
bdstr1:	.db	18,0			;Lnge von Geburtstagstext 1
	.db	"            HALLO "	;Text 1
bdstr2:	.db	30,0			;Lnge von Geburtstagstext 2
	.db	", HERZLICHEN GLUECKWUNSCH ZUM " ;Text2
bdstr3:	.db	22,0			;Lnge von Geburtstagstext 3
	.db	"GEBURTSTA",'G'|0x80,"            " ;Text3
;
;	----------
;	Wochentage
;	----------
;
dowtab:	.db	"  MONTAG  "		;Wochentage in langer Form
	.db	" DIENSTAG "		;fr Wechsel-Anzeige
	.db	" MITTWOCH "
	.db	"DONNERSTAG"
	.db	" FREITAG  "
	.db	" SAMSTAG  "
	.db	" SONNTAG  "
;
do2tab:	.db	"Mo","Di","Mi","Do"	;Wochentage in kurzer Form
	.db	"Fr","Sa","So" 		;fr Kompakt-Anzeige
;
;	-----------------------------------------------------------
;	Display-Tabelle fr alphanumerisch Anzeige mit 16-Segmenten
;	ASCII von 20h bis 7Fh (96 Bytes)
;	-----------------------------------------------------------
;
disptb:	.dw	0b0000000000000000	;20h ' '
	.dw	0b0010001110000000	;21h '!' Antennensymbol
	.dw	0b0000000101000000	;22h '"'
	.dw	0b0000110001000111	;23h '#' Grad ()
	.dw	0b0010110101011011	;24h '$'
	.dw	0b0010001010010011	;25h '%' Weinglas
	.dw	0b0100011010111011	;26h '&'
	.dw	0b0000001000000000	;27h '''
	.dw	0b0100001000000000	;28h '('
	.dw	0b0001000010000000	;29h ')'
	.dw	0b0101111010000000	;2Ah '*'
	.dw	0b0010110100000000	;2Bh '+'
	.dw	0b0001000000000000	;2Ch ','
	.dw	0b0000110000000000	;2Dh '-'
	.dw	0b0001000000000000	;2Eh '.'
	.dw	0b0001001000000000	;2Fh '/'
;
	.dw	0b0000000001111111	;30h '0'
	.dw	0b0000001000001100	;31h '1'
	.dw	0b0000110000110111	;32h '2'
	.dw	0b0000110000011111	;33h '3'
	.dw	0b0000110001001100	;34h '4'
	.dw	0b0000110001011011	;35h '5'
	.dw	0b0000110001111011	;36h '6'
	.dw	0b0000000000001111	;37h '7'
	.dw	0b0000110001111111	;38h '8'
	.dw	0b0000110001011111	;39h '9'
	.dw	0b0100101000000000	;3Ah ':' Pfeil links
	.dw	0b0001010010000000	;3Bh ';' Pfeil rechts
	.dw	0b0100001000000000	;3Ch '<'
	.dw	0b0000110000010000	;3Dh '='
	.dw	0b0001000010000000	;3Eh '>'
	.dw	0b0010100000000111	;3Fh '?'
;
	.dw	0b0010010000111111	;40h '@'
	.dw	0b0000110001101111	;41h 'A'
	.dw	0b0010100100011111	;42h 'B'
	.dw	0b0000000001110011	;43h 'C'
	.dw	0b0010000100011111	;44h 'D'
	.dw	0b0000110001110011	;45h 'E'
	.dw	0b0000110001100011	;46h 'F'
	.dw	0b0000100001111011	;47h 'G'
	.dw	0b0000110001101100	;48h 'H'
	.dw	0b0010000100000000	;49h 'I'
	.dw	0b0000000000111100	;4Ah 'J'
	.dw	0b0100011001100000	;4Bh 'K'
	.dw	0b0000000001110000	;4Ch 'L'
	.dw	0b0000001011101100	;4Dh 'M'
	.dw	0b0100000011101100	;4Eh 'N'
	.dw	0b0000000001111111	;4Fh 'O'
;
	.dw	0b0000110001100111	;50h 'P'
	.dw	0b0100000001111111	;51h 'Q'
	.dw	0b0100110001100111	;52h 'R'
	.dw	0b0000110001011011	;53h 'S'
	.dw	0b0010000100000011	;54h 'T'
	.dw	0b0000000001111100	;55h 'U'
	.dw	0b0001001001100000	;56h 'V'
	.dw	0b0101000001101100	;57h 'W'
	.dw	0b0101001010000000	;58h 'X'
	.dw	0b0010001010000000	;59h 'Y'
	.dw	0b0001001000010011	;5Ah 'Z'
	.dw	0b0100001000000000	;5Bh '['
	.dw	0b0100000010000000	;5Ch '\'
	.dw	0b0001000010000000	;5Dh ']'
	.dw	0b0101000000000000	;5Eh '^'
	.dw	0b0000000000010000	;5Fh '_'
;
	.dw	0b0000000010000000	;60h '`'
	.dw	0b0010010000110000	;61h 'a'
	.dw	0b0000110001111000	;62h 'b'
	.dw	0b0000110000110000	;63h 'c'
	.dw	0b0000110000111100	;64h 'd'
	.dw	0b0000110001110011	;65h 'E'
	.dw	0b0010110100000010	;66h 'f'
	.dw	0b0000100001111011	;67h 'G'
	.dw	0b0000110001101000	;68h 'h'
	.dw	0b0000000000100000	;69h 'i'
	.dw	0b0000100000011000	;6Ah 'j'
	.dw	0b0100011001100000	;6Bh 'K'
	.dw	0b0000000001110000	;6Ch 'L'
	.dw	0b0010110000101000	;6Dh 'm'
	.dw	0b0000110000101000	;6Eh 'n'
	.dw	0b0000110000111000	;6Fh 'o'
;
	.dw	0b0000110001100111	;70h 'P'
	.dw	0b0100000001111111	;71h 'Q'
	.dw	0b0000110000100000	;72h 'r'
	.dw	0b0000110001011011	;73h 'S'
	.dw	0b0000010001110000	;74h 't'
	.dw	0b0000000000111000	;75h 'u'
	.dw	0b0001000000100000	;76h 'v'
	.dw	0b0101000000101000	;77h 'w'
	.dw	0b0101001010000000	;78h 'X'
	.dw	0b0010001010000000	;79h 'Y'
	.dw	0b0001010000010000	;7Ah 'z'
	.dw	0b0100001000000000	;7Bh '['
	.dw	0b0010000100000000	;7Ch '|'
	.dw	0b0001000010000000	;7Dh ']'
	.dw	0b0100000011001000	;7Eh '~'
	.dw	0b0111111110000000	;7Fh '*'
;
;	------------------------------------------------
;	EEPROM-Daten: Anzeige-Modus, Nachtzeit, Gongzeit
;	------------------------------------------------
;
.eseg
;
dummy:	.db	0xff	;erstes Byte wird nicht genutzt
edimod:	.db	1	;gespeicherter Anzeige-Modus:
			;0=Automatik
			;1=Kompakt
			;2=Sekunden
			;3=DCF77-Test
esleep:	.db	23,5	;Nachtzeiten: 23:00 Uhr ein, 05:00 Uhr aus
egong:	.db	8,22	;Gongzeiten:  08:00 Uhr ein, 22:00 Uhr aus
;
;	-------------------------------------------------------------
;	EEPROM-Daten: Geburtstage, 24 Eintrge mit folgendem Format:
;	11,12,19,67,"NAME",0xff		(entspricht 11.12.1967, Name)
;	Der Name darf bis zu 32 Zeichen lang sein, Endekennnung nicht
;	vergessen! Es sollten keine Kleinbuchstaben verwendet werden,
;	da nicht alle Kleinbuchstaben darstellbar sind.
;	-------------------------------------------------------------
;
ebtext:	.db	11,12,19,67,"NAME",0xff			;Eintrag 01
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 02
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 03
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 04
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 05
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 06
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 07
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 08
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 09
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 10
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 11
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 12
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 13
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 14
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 15
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 16
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 17
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 18
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 19
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 20
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 21
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 22
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 23
	.db	 0, 0, 0, 0," ",0xff			;Eintrag 24
;
