// Matrixuhr-Mini, Scott-Falk Hühn, "process.h"
// Verarbeitung der Sensoren, Alarme und Geburtstage

// Empfangene Wetterdaten dekodieren und als Einzelwerte speichern
void decode_weather() {
  uint16_t i;                                                         // Zähler- und Zwischenspeichervariable
  float numb;                                                         // Zwischenspeicher für Zahlenwerte
  unsigned long time;                                                 // Zwischenspeicher für Zeitwerte
  const char *iconstr;                                                // Zwischenspeicher für Icon-String
  char idstr[3];                                                      // Zwischenspeicher für ID-String (Wetterlage)
  int16_t offset;                                                     // Zwischenspeicher für Zeitdifferenz zur UTC
  uint8_t srmin, srhour, ssmin, sshour;                               // Zwischenspeicher für Minute und Stunde von Sonnenaufgang und Sonnenuntergang

  if (weatherjson[0] > 0) {                                           // wenn Zeichen im Puffer vorhanden
    for (i = 0; i < 13; i ++) weathervals[i][0] = 0;                  // zunächst alle Wetterelemente löschen
    weatv = "";                                                       // Wetterdatenstring für Web-Seite zunächst löschen
    for (i = 0; i < 12; i ++) {                                       // erste 12 Zeichen der Wetterdaten
      weatv += weatherjson[i];                                        // in Wetterdatenstring für Web-Seite übertragen
      if (weatv[i] == 0) break;                                       // wenn weniger als 12 Zeichen -> Schleife abbrechen
    }
    if (i > 11) weatv += "...";                                       // wenn mehr als 12 Zeichen vorhanden -> weitere Zeichen andeuten

    DeserializationError error = deserializeJson(json, weatherjson);  // JSON-Wetterdaten dekodieren
    if (!error) {                                                     // wenn kein Fehler aufgetreten
      if (json["tempc"].is<float>()) {                                // wenn Temperatur in °C vorhanden
        numb = json["tempc"];                                         // Temperatur holen
        sprintf(weathervals[0], "%.1f", numb);                        // Temperatur mit einer Nachkommastelle speichern
        if (numb > -0.5 && numb < 0) numb = 0;                        // wenn Wert zwischen -0,5 und 0 -> auf 0 setzen (vermeidet Rundungsfehler -0.0)
        sprintf(weathervals[1], "%.0f", numb);                        // Temperatur ohne Nachkommastelle speichern
      }
      if (json["humidity"].is<float>()) {                             // wenn Luftfeuchtigkeit in % vorhanden
        numb = json["humidity"];                                      // Luftfeuchtigkeit holen
        sprintf(weathervals[2], "%.0f", numb);                        // Luftfeuchtigkeit ohne Nachkommastelle speichern
      }
      if (json["pressure"].is<float>()) {                             // wenn Luftdruck in hPa vorhanden
        numb = json["pressure"];                                      // Luftdruck holen
        sprintf(weathervals[3], "%.0f", numb);                        // Luftdruck ohne Nachkommastelle speichern
      }
      if (json["windspeed"].is<float>()) {                            // wenn Windgeschwindigkeit in m/s vorhanden
        numb = json["windspeed"];                                     // Windgeschwindigkeit holen
        sprintf(weathervals[4], "%.1f", numb);                        // Windgeschwindigkeit in m/s mit einer Nachkommastelle speichern
        sprintf(weathervals[5], "%.0f", numb * 3.6);                  // Windgeschwindigkeit in km/h ohne Nachkommastelle speichern
      }
      if (json["rain"].is<float>()) {                                 // wenn Regenmenge in mm/h vorhanden
        numb = json["rain"];                                          // Regenmenge holen
        sprintf(weathervals[6], "%.1f", numb);                        // Regenmenge mit einer Nachkommastelle speichern
        sprintf(weathervals[7], "%.0f", numb);                        // Regenmenge ohne Nachkommastelle speichern
      }
      if (json["clouds"].is<float>()) {                               // wenn Wolkendichte in % vorhanden
        numb = json["clouds"];                                        // Wolkendichte holen
        sprintf(weathervals[8], "%.0f", numb);                        // Wolkendichte ohne Nachkommastelle speichern
      }
      weathervals[9][0] = '$';                                        // erstes Zeichen der Windrichtung ist immer $
      weathervals[9][1] = '0';                                        // Windrichtung auf unbestimmt vorbelegen
      weathervals[9][2] = 0;                                          // Endezeichen
      if (json["winddirection"].is<float>()) {                        // wenn Windrichtung vorhanden
        numb = json["winddirection"];                                 // Windrichtung in Grad holen
        if (numb > 157.5 && numb <= 202.5) weathervals[9][1] = '1';   // Windrichtung N (1) speichern
        if (numb > 202.5 && numb <= 247.5) weathervals[9][1] = '2';   // Windrichtung NO (2) speichern
        if (numb > 247.5 && numb <= 292.5) weathervals[9][1] = '3';   // Windrichtung O (3) speichern
        if (numb > 292.5 && numb <= 337.5) weathervals[9][1] = '4';   // Windrichtung SO (4) speichern
        if (numb > 337.5 || numb <= 22.5) weathervals[9][1] = '5';    // Windrichtung S (5) speichern
        if (numb > 22.5 && numb <= 67.5) weathervals[9][1] = '6';     // Windrichtung SW (6) speichern
        if (numb > 67.5 && numb <= 112.5) weathervals[9][1] = '7';    // Windrichtung W (7) speichern
        if (numb > 112.5 && numb <= 157.5) weathervals[9][1] = '8';   // Windrichtung NW (8) speichern
      }
      sunrise = 0;                                                    // Sonnenaufgang zunächst löschen
      sunset = 0;                                                     // Sonnenuntergang zunächst löschen

      if (json["sunrise"].is<unsigned long>() && json["sunset"].is<unsigned long>()) { // wenn Sonnenaufgang und Sonnenuntergang vorhanden
        timeinfo = gmtime(&now);                                      // aktuelle UTC holen
        offset = (minute + hour * 60) - (timeinfo->tm_min + timeinfo->tm_hour * 60); // Differenz zwischen Lokalzeit und UTC ermitteln
        time = json["sunrise"];                                       // Sonnenaufgangszeit (UTC-Unixzeit) holen
        time /= 60;                                                   // in Minuten umrechnen
        time += offset;                                               // Sonnenaufgangszeit in Lokalzeit umrechnen
        srmin = time % 60;                                            // Minute ermitteln
        time /= 60;                                                   // in Stunden umrechnen
        srhour = time % 24;                                           // Stunde ermitteln
        sunrise = srmin + srhour * 60;                                // Sonnenaufgangszeit in Minuten seit 0:00 speichern
        time = json["sunset"];                                        // Sonnenuntergangszeit (UTC-Unixzeit) holen
        time /= 60;                                                   // in Minuten umrechnen
        time += offset;                                               // Sonnenuntergangszeit in Lokalzeit umrechnen
        ssmin = time % 60;                                            // Minute ermitteln
        time /= 60;                                                   // in Stunden umrechnen
        sshour = time % 24;                                           // Stunde ermitteln
        sunset = ssmin + sshour * 60;                                 // Sonnenuntergangszeit in Minuten seit 0:00 speichern
        sprintf(weathervals[12], "%02d:%02d$T%02d:%02d", srhour, srmin, sshour, ssmin); // String für Sonnenwerte generieren
      }
      weathervals[10][0] = '$';                                       // erstes Zeichen des Wettersymbols ist immer $
      weathervals[10][1] = 'S';                                       // unbestimmtes Wettersymbol voreinstellen
      weathervals[10][2] = 0;                                         // Endezeichen

      if (json["icon"].is<JsonVariant>()) {                           // wenn Icon vorhanden
        iconstr = json["icon"];                                       // Icon holen
        for (i = 0; i < sizeof(weathericons) / 2; i ++) {             // Iconliste durchsuchen
          if (iconstr[0] == pgm_read_byte(&weathericons[i * 2])
          && iconstr[1] == pgm_read_byte(&weathericons[i * 2 + 1])) { // wenn beide Ziffern des Icons übereinstimmen
            weathervals[10][1] = i * 2 + 'A';                         // in Tages-Wettersymbol ($A, $C, $E ... $Q) umrechen
            break;
          }
        }
      }

      if (json["id"].is<int>()) {                                     // wenn Wetterlage vorhanden
        i = json["id"];                                               // Wetterlage holen
        if (i > 0) {                                                  // wenn Wetterlage eine Zahl enthält
          itoa(i, idstr, 10);                                         // in Zeichenkette umwandeln
          for (i = 0; i < sizeof(wcstringsd) / sizeof(PGM_P); i ++) { // Wetterlagenliste durchsuchen
            strncpy_P(strbuf, (PGM_P) pgm_read_ptr(&wcstringsd[i]), 3); // erste 3 Zeichen der gespeicherten Wetterlage kopieren
            if (idstr[0] == strbuf[0] && idstr[1] == strbuf[1] && idstr[2] == strbuf[2]) { // wenn alle 3 Zeichen übereinstimmen
              sprintf(weathervals[11], "%u", i);                      // Listenposition der Wetterlage speichern
              break;                                                  // Suchschleife abbrechen
            }
          }
        }
      }
    }
  }
}

// Empfangene Kraftstoffdaten dekodieren und als Einzelwerte speichern
void decode_fuel() {
  uint16_t i;                                                         // Zähler- und Zwischenspeichervariable
  float numb;                                                         // Zwischenspeicher für Zahlenwerte
  bool open;                                                          // Zwischenspeicher für Geöffnet-Status
  if (fueljson[0] > 0) {                                              // wenn Zeichen im Puffer vorhanden
    for (i = 0; i < 4; i ++) fuelvals[i][0] = 0;                      // zunächst alle Kraftstoffpreise löschen
    fuelv = "";                                                       // Kraftstoffdatenstring für Web-Seite zunächst löschen
    for (i = 0; i < 12; i ++) {                                       // erste 12 Zeichen der Kraftstoffdaten
      fuelv += fueljson[i];                                           // in Kraftstoffdatenstring für Web-Seite übertragen
      if (fuelv[i] == 0) break;                                       // wenn weniger als 12 Zeichen -> Schleife abbrechen
    }
    if (i > 11) fuelv += "...";                                       // wenn mehr als 12 Zeichen vorhanden -> weitere Zeichen andeuten

    DeserializationError error = deserializeJson(json, fueljson);     // JSON-Kraftstoffdaten dekodieren
    if (!error) {                                                     // wenn kein Fehler aufgetreten
      for (i = 0; i < 4; i ++) {                                      // 4 Preise bearbeiten
        open = json[i]["isOpen"];                                     // Geöffnet-Status holen
        if (open) {                                                   // wenn Tankstelle geöffnet
          numb = json[i]["price"];                                    // Kraftstoffpreis holen
          if (numb > 1 && numb < 10) {                                // wenn sinnvoller Preis
            sprintf(fuelvals[i], "%.2f", numb);                       // Kraftstoffpreis mit 2 Nachkommastellen speichern
          }
        }
      }
    }
  }
}

// Ein UTF-8 Zeichen (2 Byte) in ein internes Zeichen konvertieren
char utf8_conv(uint8_t c1, uint8_t c2) {                              // c1: erstes Zeichen, c2: zweites Zeichen
  uint8_t i;                                                          // Zählervariable
  uint8_t cc = ' ';                                                   // konvertiertes Zeichen auf Leerzeichen voreinstellen

  for (i = 0; i < sizeof(utf8tab); i += 3) {                          // UTF-8-Tabelle in Schritten von 3 Bytes abfragen
    if (cc == ' ') {                                                  // wenn noch kein Zeichen gefunden
      if (pgm_read_byte(&utf8tab[i]) == c1) {                         // wenn erstes Zeichen gefunden
        if (pgm_read_byte(&utf8tab[i + 1]) == c2) {                   // wenn zweites Zeichen gefunden
          cc = pgm_read_byte(&utf8tab[i + 2]);                        // internes Zeichen lesen
        }
      }
    }
  }
  return cc;                                                          // konvertiertes Zeichen zurückgeben
}

// Ein UTF-8 Zeichen (3 Byte) in ein internes Zeichen konvertieren
char utf8_conv3(uint8_t c1, uint8_t c2, uint8_t c3) {                 // c1: erstes Zeichen, c2: zweites Zeichen, c3: drittes Zeichen
  uint8_t i;                                                          // Zählervariable
  uint8_t cc = ' ';                                                   // konvertiertes Zeichen auf Leerzeichen voreinstellen

  for (i = 0; i < sizeof(utf8tab3); i += 4) {                         // UTF-8-Tabelle in Schritten von 4 Bytes abfragen
    if (cc == ' ') {                                                  // wenn noch kein Zeichen gefunden
      if (pgm_read_byte(&utf8tab3[i]) == c1) {                        // wenn erstes Zeichen gefunden
        if (pgm_read_byte(&utf8tab3[i + 1]) == c2) {                  // wenn zweites Zeichen gefunden
          if (pgm_read_byte(&utf8tab3[i + 2]) == c3) {                // wenn drittes Zeichen gefunden
            cc = pgm_read_byte(&utf8tab3[i + 3]);                     // internes Zeichen lesen
          }          
        }
      }
    }
  }
  return cc;                                                          // konvertiertes Zeichen zurückgeben
}

// Ausgabe eines Sensorwertes, des Datums, des Wochentages oder der Geburtstage in den Pixelpuffer
bool pbuff_sensor(uint8_t sensor) {                                   // sensor: Sensorkennung (A-D, M-Y, a-g)
  uint8_t i, j;                                                       // Zählervariablen
  char c, c1;                                                         // Zwischenspeicher für UTF8-Konvertierung
  uint8_t error = false;                                              // Fehler-Flag
  float senvalue;                                                     // Sensorwert
  char senval[10];                                                    // Zwischenspeicher für Sensorwert und Geburtstag-Alter

  switch (sensor) {                                                   // Sensorkennung auswerten und verzweigen
    case 'A' ... 'H':                                                 // Sensorkennung im Bereich A-H (freier Sensor)
      if (sensorvals[sensor - 'A'][0] > 0 && (millis() - sensortime[sensor - 'A']) < (mqtt_vali * 60000)) { // wenn Sensorwert vorhanden und Wert gültig
        if (sensordeci[sensor - 'A'] < 3) {                           // wenn 0, 1 oder 2 Nachkommastellen
          senvalue = atof(sensorvals[sensor - 'A']);                  // Sensorwert zunächst in numerischer Form zwischenspeichern
          if (sensordeci[sensor - 'A'] == 2) sprintf(senval, "%.2f", senvalue); // wenn 2 Nachkommastellen gewünscht -> Zeichenkette mit 2 Nachkommastellen speichern
          else {                                                      // wenn 1 oder 0 Nachkommastellen
            if (sensordeci[sensor - 'A'] == 1) sprintf(senval, "%.1f", senvalue); // wenn 1 Nachkommastelle gewünscht -> Zeichenkette mit 1 Nachkommastelle speichern
            else sprintf(senval, "%.0f", senvalue);                   // wenn ohne Nachkommastelle gewünscht -> als Zeichenkette ohne Nachkommastelle speichern
          }
          for (i = 0; i < 10; i ++) {                                 // Schleife
            if (senval[i] > 0) pbuff_char(senval[i]);                 // wenn gültiges Zeichen im Zwischenspeicher -> in Pixelpuffer ausgeben
            else break;                                               // sonst Schleife abbrechen
          }
        }
        else {                                                        // wenn Prüfung und Formatierung ausgeschaltet
          i = 0;                                                      // Zeichenzähler auf Anfang setzen
          while (i < SENCHARS) {                                      // Schleife
            if (sensorvals[sensor - 'A'][i] > 0) {                    // wenn gültiges Zeichen im Sensorwert
              c = sensorvals[sensor - 'A'][i ++];                     // Zeichen holen
              if (c < 128) {                                          // wenn ASCII-Zeichen
                if (c == '$') {                                       // wenn Symbol
                  if (i < SENCHARS && sensorvals[sensor - 'A'][i] > 0) { // wenn Ende noch nicht erreicht und noch ein weiteres Zeichen im Sensorwert
                    c1 = sensorvals[sensor - 'A'][i ++];              // Symbol-Kode holen
                    if (c1 >= '0' && c1 < '9') pbuff_symb(c1 - '0');  // wenn Wind-Symbol -> Symbol in Matrixpuffer ausgeben
                    if (c1 >= 'A' && c1 <= 'Z') pbuff_symb(c1 - 'A' + 9); // wenn Wetter- oder sonstiges Symbol -> Symbol in Matrixpuffer ausgeben
                  }
                }
                else pbuff_char(c);                                   // alle übrigen ASCII-Zeichen -> in Pixelpuffer ausgeben
              }
              else {                                                  // wenn UTF8-Zeichen
                if (i < SENCHARS && sensorvals[sensor - 'A'][i] > 0) { // wenn Ende noch nicht erreicht und noch ein weiteres Zeichen im Sensorwert
                  if (c == 0xc2 || c == 0xc3) {                       // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
                    pbuff_char(utf8_conv(c, sensorvals[sensor - 'A'][i ++])); // 2-Byte-UTF-8-Zeichens konvertieren und in Matrixpuffer ausgeben
                  }
                  if (c == 0xe2 && i + 1 < SENCHARS && sensorvals[sensor - 'A'][i + 1] > 0) { // wenn 3-Byte-Zeichen (beginnend mit E2), Ende noch nicht erreicht und noch 2 weitere Zeichen 
                    c1 = sensorvals[sensor - 'A'][i ++];              // zweites Zeichen vom Sensorwert holen und Position erhöhen
                    pbuff_char(utf8_conv3(c, c1, sensorvals[sensor - 'A'][i ++])); // 3-Byte-UTF-Zeichens konvertieren und in Matrixpuffer ausgeben
                  }
                }
              }
            }
            else break;                                               // sonst Schleife abbrechen
          }
        }
      }
      else {                                                          // wenn kein Sensorwert vorhanden oder Wert ungültig
        pbuff_char('?');                                              // Ersatzzeichen in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'M' ... 'U':                                                 // Sensorkennung im Bereich M-U (numerische Wetterdaten)
      if (weathervals[sensor - 'M'][0] > 0 && (millis() - weathertime) < (WEATHERV * 60000)) { // wenn Wetterdatenwert vorhanden und Wert gültig
        for (i = 0; i < 15; i ++) {                                   // Schleife
          if (weathervals[sensor - 'M'][i] > 0) pbuff_char(weathervals[sensor - 'M'][i]); // wenn gültiges Zeichen im Wetterdatenwert -> in Pixelpuffer ausgeben
          else break;                                                 // sonst Schleife abbrechen
        }
      }
      else {                                                          // wenn kein Sensorwert vorhanden oder Wert ungültig
        pbuff_char('?');                                              // Ersatzzeichen in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'V':                                                         // Sensorkennung V (Windrichtungspfeil)
      if (weathervals[sensor - 'M'][0] > 0 && (millis() - weathertime) < (WEATHERV * 60000)) { // wenn Windrichtung vorhanden und Wert gültig
        pbuff_symb(weathervals[sensor - 'M'][1] - '0');               // Windrichtungspfeil ausgeben
      }
      else {                                                          // wenn keine Windrichtung vorhanden oder Wert ungültig
        pbuff_symb(0);                                                // Ersatzsymbol in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'W':                                                         // Sensorkennung W (Wettersymbol)
      if (weathervals[sensor - 'M'][0] > 0 && (millis() - weathertime) < (WEATHERV * 60000)) { // wenn Wetterdatenwert vorhanden und Wert gültig
        if (nightsymbol) pbuff_symb(weathervals[sensor - 'M'][1] - 'A' + 10); // wenn Nachtsymbolzeit -> Nacht-Wettersymbol ausgeben
        else pbuff_symb(weathervals[sensor - 'M'][1] - 'A' + 9);      // sonst Tag-Wettersymbol ausgeben
      }
      else {                                                          // wenn kein Sensorwert vorhanden oder Wert ungültig
        pbuff_symb('S' - 'A' + 9);                                    // Fehlersymbol in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'X':                                                         // Sensorkennung X (Wetterlagentext)
      i = sizeof(wcstringsd) / sizeof(PGM_P);                         // Anzahl der Wetterlagentexte ermitteln
      if (weathervals[sensor - 'M'][0] > 0 && (millis() - weathertime) < (WEATHERV * 60000)) { // wenn Wetterlage vorhanden und Wert gültig
        j = atoi(weathervals[sensor - 'M']);                          // Wetterlagennummer holen
        if (j >= i) j = i - 1;                                        // wenn Wetterlagennummer nicht im zulässigen Bereich -> auf unbekannt setzen
        pbuff_wcstr(j);                                               // Wetterlagentext in Pixelpuffer ausgeben
      }
      else {                                                          // wenn keine Wetterlage vorhanden oder Wert ungültig
        pbuff_wcstr(i - 1);                                           // Fehlertext in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'Y':                                                         // Sensorkennung Y (Sonnenzeiten)
      if (weathervals[sensor - 'M'][0] > 0 && (millis() - weathertime) < (WEATHERV * 60000) && syncstat > 0) { // wenn Sonnenwerte vorhanden und gültig und Uhr synchronisiert
        for (i = 0; i < 15; i ++) {                                   // Schleife
          if (weathervals[sensor - 'M'][i] > 0) {                     // wenn gültiges Zeichen im Sonnenwert
            if (i < 5 || i > 6) pbuff_char(weathervals[sensor - 'M'][i]); // wenn Zeitangabe -> Zeichen in Pixelpuffer ausgeben
            if (i == 6) {                                             // wenn Symbol-Kode
              pixelbuff[pbuff_wpos ++] = 0;                           // Leerraum löschen und auf nächste Position setzen
              pbuff_symb(28);                                         // Sonnensymbol ausgeben
              pixelbuff[pbuff_wpos ++] = 0;                           // Leerraum löschen und auf nächste Position setzen
            }
          }
          else break;                                                 // sonst Schleife abbrechen
        }
      }
      else {                                                          // wenn kein Sensorwert vorhanden oder Wert ungültig
        pbuff_char('?');                                              // Ersatzzeichen in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'a' ... 'd':                                                 // Sensorkennung im Bereich a-d (Kraftstoffpreise)
      if (fuelvals[sensor - 'a'][0] > 0 && (millis() - fueltime) < (FUELVALI * 60000)) { // wenn Kraftstoffwert vorhanden und Wert gültig
        for (i = 0; i < 12; i ++) {                                   // Schleife
          if (fuelvals[sensor - 'a'][i] > 0) pbuff_char(fuelvals[sensor - 'a'][i]); // wenn gültiges Zeichen im Kraftstoffwert -> in Pixelpuffer ausgeben
          else break;                                                 // sonst Schleife abbrechen
        }
      }
      else {                                                          // wenn kein Sensorwert vorhanden oder Wert ungültig
        pbuff_char('?');                                              // Ersatzzeichen in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'e':                                                         // Sensorkennung e (Datum)
      if (syncstat > 0) {                                             // wenn Uhr synchronisiert
        i = 0;                                                        // Zeichenzähler auf Anfang setzen
        while (curdate[i] > 0) pbuff_char(curdate[i ++]);             // Datum bis zum Endezeichen (0) ausgeben
      }
      else {                                                          // wenn Uhr nicht synchronisiert
        pbuff_str(9);                                                 // Ersatztext in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'f':                                                         // Sensorkennung f (Wochentag)
      if (syncstat > 0) pbuff_str(wday + 1);                          // wenn Uhr synchronisiert -> Wochentag-String in Pixelpuffer ausgeben
      else {                                                          // wenn Uhr nicht synchronisiert
        pbuff_str(10);                                                // Ersatztext in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    case 'g':                                                         // Sensorkennung g (Geburtstage)
      bdaycurr = 0;                                                   // heute aktive Geburtstage löschen
      if (syncstat > 0) {                                             // wenn Uhr synchronisiert
        for (i = 0; i < MAXBDAYS; i ++) {                             // alle Einträge der Geburtstagsliste bearbeiten
          if (birthdays[i].length() > 0) {                            // wenn Eintrag gefunden
            if (birthdays[i].substring(4, 6).toInt() == month && birthdays[i].substring(6, 8).toInt() == day) { // wenn Monat und Tag übereinstimmen
              if (bdaycurr > 0) {                                     // wenn schon mindestens ein Geburtstag ausgegeben wurde
                pbuff_char(',');                                      // Komma in Pixelpuffer ausgeben
                pbuff_char(' ');                                      // Leerzeichen in Pixelpuffer ausgeben
              }
              j = 9;                                                  // Stringposition des Namens
              while(birthdays[i][j] > 0) {                            // Geburtstag bis zum Endezeichen (0) ausgeben
                c = birthdays[i][j ++];                               // Zeichen an der aktuellen Position holen und Position erhöhen
                if (c < 128) pbuff_char(c);                           // wenn ASCII-Zeichen -> in Pixelpuffer ausgeben
                else {                                                // wenn UTF8-Zeichen
                  if (j < birthdays[i].length()) {                    // wenn noch ein weiteres Zeichen im Geburtstag
                    if (c == 0xc2 || c == 0xc3) {                     // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
                      pbuff_char(utf8_conv(c, birthdays[i][j ++]));   // 2-Byte-UTF-8-Zeichens konvertieren und in Matrixpuffer ausgeben
                    }
                    if (c == 0xe2 && j < birthdays[i].length() - 1) { // wenn 3-Byte-Zeichen (nutzbare Zeichen beginnen mit E2) und noch 2 weitere Zeichen im Geburtstag
                      c1 = birthdays[i][j ++];                        // zweites Zeichen aus dem Geburtstag holen und Position erhöhen
                      pbuff_char(utf8_conv3(c, c1, birthdays[i][j ++])); // 3-Byte-UTF-Zeichens konvertieren und in Matrixpuffer ausgeben
                    }
                  }
                }
              }
              pbuff_char(' ');                                        // Leerzeichen in Pixelpuffer ausgeben
              itoa(year - birthdays[i].substring(0, 4).toInt(), senval, 10); // Alter ermitteln und in Zeichenkette umwandeln
              j = 0;                                                  // Zeichenposition für Alter
              while (senval[j] > 0) pbuff_char(senval[j ++]);         // Alter bis zum Endezeichen (0) ausgeben -> Zeichen vom Alter in Pixelpuffer ausgeben
              bdaycurr ++;                                            // heute aktive Geburtstage erhöhen
            }
          }
          else break;                                                 // wenn kein Eintrag gefunden -> Schleife beenden
        }
      }
      if (bdaycurr == 0) {                                            // wenn kein Geburtstag aktiv
        pbuff_str(11);                                                // Ersatztext in Pixelpuffer ausgeben
        error = true;                                                 // Sensorfehler setzen
      }
      break;

    default:
      break;
  }

  return error;                                                       // Fehlerstatus zurückgeben
}

// Datenausgabe steuern; Verarbeitung von Datum, Wochentag, Sensoren und Geburtstagen
void process_data() {
  uint8_t i;                                                          // Zählervariable
  uint8_t j = 0;                                                      // Position im Datenfeld
  char c, c1;                                                         // Zeichen aus dem Datenfeld
  bool error = false;                                                 // Fehler (wenn true)
  bool dynarea = false;                                               // dynamischer Bereich ist aktiv (wenn true)
  bool senmode = false;                                               // Sensormodus ist aktiv (wenn true)
  int16_t pbuff_temp = 0;                                             // Zwischenspeicher für Position im Pixelpuffer

  if (fwcount > 0) return;                                            // wenn Firmware-Update aktiv -> Abbruch
  if (sunrise > 0 && sunset > 0) {                                    // wenn Sonnenzeiten vorhanden
    curtime = minute + hour * 60;                                     // aktuelle Zeit in Minuten seit 0:00 Uhr ermitteln
    nightsymbol = false;                                              // Nachtmodus für Wettersymbol zunächst ausschalten
    if (curtime < sunrise || curtime > sunset) nightsymbol = true;    // wenn Nachtzeit -> Nachtmodus für Wettersymbol einschalten
  }
  for (i = 0; i < 8; i ++) {                                          // 8 Zeitstempel der Sensorwerte prüfenn
    if ((millis() - sensortime[i]) > (60 * 60000)) {                  // wenn Zeitstempel älter als eine Stunde
      sensorvals[i][0] = 0;                                           // Sensorwert löschen
    }
  }
  bdaycurr = 0;                                                       // Anzahl der heutigen Geburtstage löschen
  if (syncstat > 0) {                                                 // wenn Uhr synchronisiert
    for (i = 0; i < MAXBDAYS; i ++) {                                 // alle Einträge der Geburtstagsliste bearbeiten
      if (birthdays[i].length() > 0) {                                // wenn Eintrag gefunden
        if (birthdays[i].substring(4, 6).toInt() == month && birthdays[i].substring(6, 8).toInt() == day) { // wenn Monat und Tag übereinstimmen
          bdaycurr ++;                                                // heute aktive Geburtstage erhöhen
        }
      }
      else break;                                                     // wenn kein Eintrag gefunden -> Schleife beenden
    }
  }

  pbuff_wpos = 0;                                                     // Schreibzeiger an den Anfang des Pixelpuffers setzen
  while (j < datadisp.length()) {                                     // alle Zeichen des Datenfeldes bearbeiten
    c = datadisp[j];                                                  // Zeichen an aktueller Datenfeld-Position holen
    switch (c) {                                                      // gelesenes Zeichen auswerten und verzweigen
      case  '{':                                                      // wenn Beginn eines dynamischen Elements
        dynarea = true;                                               // dynamischen Bereich aktivieren
        error = false;                                                // Fehler löschen
        pbuff_temp = pbuff_wpos;                                      // aktuelle Schreibposition im Pixelpuffer zwischenspeichern
        if (pbuff_wpos > 0 && separator.length() > 0) {               // wenn schon Daten im Pixelpuffer und dynamisches Trenn-Element
          for (i = 0; i < separator.length(); i ++) {                 // Schleife
            switch (separator[i]) {                                   // dynamisches Trenn-Element auswerten
              case '0' ... '9':                                       // alle Zahlen
              case 'A' ... 'Z':                                       // alle Großbuchstaben
              case 'a' ... 'z':                                       // alle Kleinbuchstaben
                pbuff_char(' ');                                      // als Leerzeichen interpretieren und ausgeben
                break;
              default:                                                // alle anderen Zeichen
                if (separator[i] > 31 && separator[i] < 127) pbuff_char(separator[i]); // wenn gültiges ASCII-Zeichen -> ausgeben
                break;
            }
          }
        }
        break;
      case '}':                                                       // wenn Ende eines dynamischen Elements
        if (dynarea) {                                                // wenn ein dynamischer Bereich aktiv war
          dynarea = false;                                            // dynamischen Bereich deaktivieren
          if (error) pbuff_wpos = pbuff_temp;                         // wenn Fehler -> Bereich verwerfen und ursprüngliche Schreibposition im Pixelpuffer wiederherstellen
        }
        break;
      case '[':                                                       // wenn Beginn eines Sensorwertes
        senmode = true;                                               // Sensormodus aktivieren
        break;
      case ']':                                                       // wenn Ende eines Sensorwertes
        senmode = false;                                              // Sensormodus deaktivieren
        break;
      case '$':                                                       // wenn Symbol
        if (j < datadisp.length() - 1) {                              // wenn noch ein weiteres Zeichen im Datenfeld
          c1 = datadisp[++ j];                                        // Zeichen nach dem $ aus Datenfeld holen
          if (c1 >= '0' && c1 < '9') pbuff_symb(c1 - '0');            // wenn Wind-Symbol -> Symbol ausgeben
          if (c1 >= 'A' && c1 <= 'Z') pbuff_symb(c1 - 'A' + 9);       // wenn Wetter- oder sonstiges Symbol -> Symbol ausgeben
        }
        break;
      default:                                                        // bei allen anderen Zeichen
        if (senmode) {                                                // wenn Sensormodus aktiv
          if (pbuff_sensor(c)) error = true;                          // Zeichen als Sensorwert ausgeben, bei Fehler Flag setzen
        }
        else {                                                        // sonst normales Zeichen ausgeben
          if (c > 127 && j < datadisp.length() - 1) {                 // wenn UTF-8-Zeichen und noch ein weiteres Zeichen im Datenfeld
            if (c == 0xc2 || c == 0xc3) {                             // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
              c = utf8_conv(c, datadisp[++ j]);                       // 2 Bytes des UTF-8-Zeichens in internes Zeichen konvertieren
            }
            if (c == 0xe2 && j < datadisp.length() - 2) {             // wenn 3-Byte-Zeichen (nutzbare Zeichen beginnen mit E2) und noch 2 weitere Zeichen im Datenfeld
              c1 = datadisp[++ j];                                    // zweites Zeichen aus dem Datenfeld holen und Zeiger erhöhen
              c = utf8_conv3(c, c1, datadisp[++ j]);                  // 3 Bytes des UTF-Zeichens in internes Zeichen konvertieren
            }
          }
          if (c >= 32) pbuff_char(c);                                 // wenn zulässiger Zeichencode -> Zeichen in Pixelpuffer schreiben
        }
        break;
    }
    j ++;                                                             // nächste Datenfeld-Position
  }

  if (dispmode == 0 && !startup) {                                    // wenn keine Laufschrift aktiv und Startphase beendet
    pbuff_end = pbuff_wpos;                                           // Ende des Pixelpuffers festlegen
    if (pbuff_end > 0) {                                              // wenn Sensordaten im Pixelpuffer
      pbuff_rpos = -32;                                               // Leseposition auf 32 Pixelspalten vor den Pufferanfang setzen
      if (dispconf == 1 && dispmode == 0) pbuff_rpos = 0;             // wenn 2 Matrix-Module und keine Laufschrift auf Modul 2 -> Leseposition direkt auf den Pufferanfang setzen
      dispmode = 1;                                                   // Sensordaten anzeigen
      scrstop = false;                                                // Laufschrift aktiv
    }
  }
}

// Verarbeitung einer Textnachricht
void process_msg()                                                    // keine Parameter
{
  uint8_t  i;                                                         // Zeigervariable für Nachrichtenstring
  char c, c1;                                                         // Zeichen-Zwischenspeicher

  if (fwcount > 0) return;                                            // wenn Firmware-Update aktiv -> Abbruch
  mesgv = "";                                                         // Nachrichtenstring für Web-Seite zunächst löschen
  for (i = 0; i < 12; i ++) {                                         // erste 12 Zeichen der Textnachricht
    mesgv += message[i];                                              // in Nachrichtenstring für Web-Seite übertragen
    if (mesgv[i] == 0) break;                                         // wenn weniger als 12 Zeichen -> Schleife abbrechen
  }
  if (i > 11) mesgv += "...";                                         // wenn mehr als 12 Zeichen vorhanden -> weitere Zeichen andeuten

  i = 0;                                                              // Zeiger auf den Anfang der Textnachricht setzen
  pbuff_wpos = 0;                                                     // Schreibzeiger an den Anfang des Pixelpuffers setzen
  while (message[i] > 0) {                                            // solange noch Zeichen in der Textnachricht vorhanden sind
    c = message[i ++];                                                // Zeichen aus Textnachricht holen und Zeiger erhöhen
    if (c > 127 && message[i] > 0) {                                  // wenn UTF-8-Zeichen und noch ein weiteres Zeichen im Puffer
      if (c == 0xc2 || c == 0xc3) {                                   // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
        c = utf8_conv(c, message[i ++]);                              // 2 Bytes des UTF-8-Zeichens in internes Zeichen konvertieren
      }
      if (c == 0xe2) {                                                // wenn 3-Byte-Zeichen (nutzbare Zeichen beginnen mit E2)
        c1 = message[i ++];                                           // zweites Zeichen aus Textnachricht holen und Zeiger erhöhen
        if (message[i] > 0) {                                         // wenn noch ein weiteres Zeichen im Puffer
          c = utf8_conv3(c, c1, message[i ++]);                       // 3 Bytes des UTF-Zeichens in internes Zeichen konvertieren
        }
      }
    }
    if (c >= 32) pbuff_char(c);                                       // wenn zulässiger Zeichencode -> Zeichen in Pixelpuffer schreiben
  }

  pbuff_end = pbuff_wpos;                                             // Ende des Pixelpuffers festlegen
  if (pbuff_end > 0) {                                                // wenn eine Nachricht im Pixelpuffer
    pbuff_rpos = -32;                                                 // Leseposition auf 32 Pixelspalten vor den Pufferanfang setzen
    if (dispconf == 1 && dispmode == 0) pbuff_rpos = 0;               // wenn 2 Matrix-Module und keine Laufschrift auf Modul 2 -> Leseposition direkt auf den Pufferanfang setzen
    dispmode = 2;                                                     // Nachricht anzeigen
    scrstop = false;                                                  // Laufschrift aktiv
    scr_count = 0;                                                    // Ausgabe-Zähler löschen
  }
}
