// Matrixuhr-Mini, Scott-Falk Hühn, "http.h"
// Webserver-Daten und -Funktionen

// HTML-Header und CSS-Definitionen, wird von allen Seiten verwendet
const char header[] PROGMEM = R"rawliteral(<html lang="de">
<head>
 <title>Matrixuhr-Mini</title>
 <meta charset="utf-8" />
 <meta name="author" content="Scott Falk Hühn" />
 <meta name="date" content="%VERDATE%" />
 <style>
  body {font-size:14px; color:black; font-family:Helvetica,Arial,sans-serif; text-decoration:none}
  div.menu {position:absolute; top:2px; left:2px; width:150px; margin-bottom:5px; background-color:#f8f8f8; border-style:solid; border-color:gray; border-radius:6px; border-width:1px; padding-left:4px; padding-right:4px; padding-bottom:6px; overflow-x:auto; overflow-y:auto}
  div.main {position:absolute; top:0px; left:165px; right:5px; overflow-x:auto; overflow-y:auto}
  a {color:black; text-decoration:none; margin-left:14px}
  a:hover {border:1px solid #000; padding:0px 4px}
  h1 {font-size:16px; background-color:#e8e8e8; text-align:center}
  hr {color:lightgray}
  th {font-weight:normal; color:navy; padding:2px 4px}
  td {padding:2px 4px}
  fieldset {border-radius:6px; border-width:1px; border-color:darkgray; display:inline-block}
  .hd {font-size:15px; color:maroon; margin-bottom:5px}
  .cg {color:green}
  .co {color:orange}
  .cr {color:red}
  .le {text-align:left}
  .cc {text-align:center}
  .ri {text-align:right}
  .cx {border-radius:6px; border-style:solid; border-width:1px}
  .bo {font-weight:bold}
  .mx {width:100%%}
  .rg {color:white; background-color:#0a0; padding:2px; border-radius:6px}
  .rr {color:white; background-color:red; padding:2px; border-radius:6px}
  .bt {width:100px}
  .pr {padding-right:12px}
  .ml {margin-left:0px}
  .stat a.stat, .bday a.bday, .sens a.sens, .data a.data, .disp a.disp, .wifi a.wifi, .netw a.netw, .mqtt a.mqtt, .time a.time, .http a.http, .file a.file, .fwup a.fwup {background:#333; color:white; padding:0px 4px}
 </style>
</head>)rawliteral";

// Linkes Seitenmenü, wird von allen Seiten verwendet
const char leftmenu[] PROGMEM = R"rawliteral(<h1>Matrixuhr-Mini</h1>
 <div class="hd">Informationen</div>
 <a class="stat" href="/">Status</a>
 <hr>
 <div class="hd">Konfiguration</div>
 <a class="bday" href="/bday">Geburtstage</a><br>
 <a class="sens" href="/sens">Sensoren</a><br>
 <a class="data" href="/data">Datenausgabe</a><br>
 <a class="disp" href="/disp">Anzeige</a>
 <hr>
 <div class="hd">System-Einstellungen</div>
 <a class="wifi" href="/wifi">WLAN</a><br>
 <a class="netw" href="/netw">Netzwerk</a><br>
 <a class="mqtt" href="/mqtt">MQTT</a><br>
 <a class="time" href="/time">Zeit</a><br>
 <a class="http" href="/http">Sicherheit</a>
 <hr>
 <div class="hd">Wartung</div>
 <a class="file" href="/file">Datei-Manager</a><br>
 <a class="fwup" href="/fwup">Firmware-Update</a><br>
 <a class="boot" href="/boot">Neustart</a>)rawliteral";

// Statusanzeige grüner Haken
const char status_green[] PROGMEM = R"rawliteral(<span class="cg bo">&check;</span>)rawliteral";

// Statusanzeige oranger Haken
const char status_orange[] PROGMEM = R"rawliteral(<span class="co bo">&check;</span>)rawliteral";

// Statusanzeige rotes Kreuz
const char status_red[] PROGMEM = R"rawliteral(<span class="cr bo">&cross;</span>)rawliteral";

// Ergebnisanzeige grün ok
const char result_green[] PROGMEM = R"rawliteral(<span class="rg">&nbsp;OK&nbsp;</span>)rawliteral";

// Ergebnisanzeige rot Fehler
const char result_red[] PROGMEM = R"rawliteral(<span class="rr">&nbsp;Fehler&nbsp;</span>)rawliteral";

// Neustart-Hinweis
const char reboot_msg[] PROGMEM = R"rawliteral(<tr><td colspan="2" class="cr">Bitte die Uhr neu starten</td></tr>)rawliteral";

// Texte für Auswahl- und Checkboxen
const char selected[] PROGMEM = "selected";
const char checked[] PROGMEM = "checked";
const char disabled[] PROGMEM = "disabled";

// Seite Informationen, Status
const char stat_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="stat">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/" method="post">
  <fieldset>
   <legend>Status</legend>
   <table>
    <tr><th colspan="5">Übersicht</th></tr>
    <tr><td>Software-Version</td><td>%VERSION%</td><td></td><td>WLAN-SSID</td><td>%SSID%</td></tr>
    <tr><td>Software-Datum</td><td>%VERDATE%</td><td></td><td>WLAN-Signal</td><td>%RSSI% dB</td></tr>
    <tr><td>Systemlaufzeit</td><td>%UPTIME%</td><td></td><td>CPU-Frequenz</td><td>%CPUFREQ% MHz</td></tr>
    <tr><td>Dateisystem</td><td>%FILESYS%</td><td></td><td>Flash-Speicher</td><td>%FLSHSIZE% Byte</td></tr>
    <tr><td>Zeit-Status</td><td>%TIMESYNC%</td><td></td><td>RAM frei</td><td>%FREEHEAP% Byte</td></tr>
    <tr><td>MQTT-Status</td><td>%MQTT%</td><td></td><td></td><td></td></tr>
    <tr><td colspan="5"><hr></td></tr>
   </table>
   <table class="mx">
    <tr><td class="ri"><button type="submit">Aktualisieren</button></td></tr>
    <tr><td colspan="2"><hr></td></tr>
   </table>
   <table class="mx">
    <tr><th>Textnachricht</th></tr>
    <tr><td class="pr"><input class="mx" type="text" maxlength="100" name="message" value="%MESSAGE%"></td></tr>
    <tr><td><hr></td></tr>
    <tr><td><button type="submit" formaction="/mesg">Nachricht anzeigen</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Geburtstage
const char bday_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="bday">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/bday" method="post">
  <fieldset>
   <legend>Geburtstage</legend>
   <table>
    <tr class="cc"><td><input type="text" name="bday_deln" size="2" maxlength="3" value=""></td><td><button type="submit" formaction="/bdel" %DISAB%>Eintrag löschen</button></td><td class="le">%SAVE%</td><td class="ri"><button type="submit" formaction="/bdpg">Seite %BDAYPAGE%</button></td></tr>
    <tr><td colspan="4"><hr></td></tr>
    <tr class="cc"><th>Nummer</th><th>Geburtstag</th><th colspan="2" class="le">Name</th></tr>
    <tr class="cc"><td><button type="submit" %BDDISAB%> + </button></td><td><input type="date" name="bday_date"></td><td colspan="2"><input type="text" name="bday_name" size="25" maxlength="25"></td></tr>
%BDAYLIST%   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Sensoren
const char sens_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="sens">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/sens" method="post">
  <fieldset>
   <legend>Sensoren</legend>
   <table>
    <tr><th>Name</th><th>MQTT Topic für Sensoren</th><th>Dezimal</th><th>Wert</th></tr>
    <tr class="cc"><td>[A]</td><td><input type="text" size="40" maxlength="80" name="sena" value="%SENA%"></td><td><select name="seda"><option value="0" %SEDA0%>0</option><option value="1" %SEDA1%>1</option><option value="2" %SEDA2%>2</option><option value="3" %SEDA3%>aus</option></select></td><td>%SEVA%</td></tr>
    <tr class="cc"><td>[B]</td><td><input type="text" size="40" maxlength="80" name="senb" value="%SENB%"></td><td><select name="sedb"><option value="0" %SEDB0%>0</option><option value="1" %SEDB1%>1</option><option value="2" %SEDB2%>2</option><option value="3" %SEDB3%>aus</option></select></td><td>%SEVB%</td></tr>
    <tr class="cc"><td>[C]</td><td><input type="text" size="40" maxlength="80" name="senc" value="%SENC%"></td><td><select name="sedc"><option value="0" %SEDC0%>0</option><option value="1" %SEDC1%>1</option><option value="2" %SEDC2%>2</option><option value="3" %SEDC3%>aus</option></select></td><td>%SEVC%</td></tr>
    <tr class="cc"><td>[D]</td><td><input type="text" size="40" maxlength="80" name="send" value="%SEND%"></td><td><select name="sedd"><option value="0" %SEDD0%>0</option><option value="1" %SEDD1%>1</option><option value="2" %SEDD2%>2</option><option value="3" %SEDD3%>aus</option></select></td><td>%SEVD%</td></tr>
    <tr class="cc"><td>[E]</td><td><input type="text" size="40" maxlength="80" name="sene" value="%SENE%"></td><td><select name="sede"><option value="0" %SEDE0%>0</option><option value="1" %SEDE1%>1</option><option value="2" %SEDE2%>2</option><option value="3" %SEDE3%>aus</option></select></td><td>%SEVE%</td></tr>
    <tr class="cc"><td>[F]</td><td><input type="text" size="40" maxlength="80" name="senf" value="%SENF%"></td><td><select name="sedf"><option value="0" %SEDF0%>0</option><option value="1" %SEDF1%>1</option><option value="2" %SEDF2%>2</option><option value="3" %SEDF3%>aus</option></select></td><td>%SEVF%</td></tr>
    <tr class="cc"><td>[G]</td><td><input type="text" size="40" maxlength="80" name="seng" value="%SENG%"></td><td><select name="sedg"><option value="0" %SEDG0%>0</option><option value="1" %SEDG1%>1</option><option value="2" %SEDG2%>2</option><option value="3" %SEDG3%>aus</option></select></td><td>%SEVG%</td></tr>
    <tr class="cc"><td>[H]</td><td><input type="text" size="40" maxlength="80" name="senh" value="%SENH%"></td><td><select name="sedh"><option value="0" %SEDH0%>0</option><option value="1" %SEDH1%>1</option><option value="2" %SEDH2%>2</option><option value="3" %SEDH3%>aus</option></select></td><td>%SEVH%</td></tr>
    <tr><td colspan="4"><hr></td></tr>
    <tr><th>Name</th><th>MQTT Topic für spezielle Informationen</th><th colspan="2">Wert</th></tr>
    <tr class="cc"><td>Wetter</td><td><input type="text" size="40" maxlength="80" name="weat" value="%WEAT%"></td><td colspan="2">%WEATV%</td></tr>
    <tr class="cc"><td>Kraftstoff</td><td><input type="text" size="40" maxlength="80" name="fuel" value="%FUEL%"></td><td colspan="2">%FUELV%</td></tr>
    <tr class="cc"><td>Nachricht</td><td><input type="text" size="40" maxlength="80" name="mesg" value="%MESG%"></td><td colspan="2">%MESGV%</td></tr>
    <tr><td colspan="4"><hr></td></tr>
   </table>
   <table class="mx">
    <tr><td><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td><td class="ri"><button type="submit" formaction="/seac">Aktualisieren</button></td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Datenausgabe
const char data_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="data">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/data" method="post">
  <fieldset>
   <legend>Datenausgabe</legend>
   <table>
    <tr><td colspan="2"><input type="text" size="70" maxlength="%DSIZ%" name="data" value="%DATA%"></td></tr>
    <tr><th colspan="2" class="le">Hilfe:</th></tr>
    <tr><td>[A] ... [H] <a class="ml" href="/sens">Sensoren</a> A bis H</td><td>[M] Temperatur in °C (%TEM1%)</td></tr>
    <tr><td>[N] Temperatur in °C (%TEM2%)</td><td>[O] Luftfeuchtigkeit in %% (%HUMI%)</td></tr>
    <tr><td>[P] Luftdruck in hPa (%PRES%)</td><td>[Q] Wind in m/s (%WIN1%)</td></tr>
    <tr><td>[R] Wind in km/h (%WIN2%)</td><td>[S] Regenmenge in mm/h (%RAI1%)</td></tr>
    <tr><td>[T] Regenmenge in mm/h (%RAI2%)</td><td>[U] Wolkendichte in %% (%CLOU%)</td></tr>
    <tr><td>[V] Windrichtungssymbol (%WINS%)</td><td>[W] Wettersymbol (%WEAS%)</td></tr>
    <tr><td>[X] Wetterlage (Text%WTXT%)</td><td>[Y] Sonnenzeiten (%SUNT%)</td></tr>
    <tr><td>[a] Kraftstoffpreis 1 (%FUE1%)</td><td>[b] Kraftstoffpreis 2 (%FUE2%)</td></tr>
    <tr><td>[c] Kraftstoffpreis 3 (%FUE3%)</td><td>[d] Kraftstoffpreis 4 (%FUE4%)</td></tr>
    <tr><td>[e] Datum (%DATE%)</td><td>[f] Wochentag (%WDAY%)</td></tr>
    <tr><td>[g] Geburtstage</td><td>{ ... } dynamischer Bereich</td></tr>
    <tr><td colspan="2">$T Sonnensymbol, $U Solarsymbol, $V Batteriesymbol, $W Tankensymbol</td></tr>
    <tr><td colspan="2">$X Wolkensymbol, $Y Windsymbol, $Z Regensymbol</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td class="le"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td><td class="ri"><button type="submit" formaction="/daac">Aktualisieren</button></td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Konfiguration, Anzeige
const char disp_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="disp">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/disp" method="post">
  <fieldset>
   <legend>Anzeige</legend>
   <table>
    <tr><td><input type="checkbox" name="disp_conf" value="1" %DISPMODE%></td><td>2 Display-Module verwenden</td></tr>
    <tr><td><input type="checkbox" name="disp_secs" value="1" %DISPSECS%></td><td>Uhrzeit mit Sekunden</td></tr>
    <tr><td><select name="disp_intv"><option value="0" %DISPINT0%>kein</option><option value="1" %DISPINT1%>15 Sekunden</option><option value="2" %DISPINT2%>20 Sekunden</option><option value="3" %DISPINT3%>30 Sekunden</option><option value="4" %DISPINT4%>60 Sekunden</option><option value="5" %DISPINT5%>120 Sekunden</option></select></td><td>Datenausgabe-Intervall</td></tr>
    <tr><td><select name="disp_mesg"><option value="1" %DISPMSG1%>1 mal</option><option value="2" %DISPMSG2%>2 mal</option><option value="3" %DISPMSG3%>3 mal</option><option value="4" %DISPMSG4%>4 mal</option><option value="5" %DISPMSG5%>5 mal</option></select></td><td>Nachrichten anzeigen</td></tr>
    <tr><td><input type="text" size="8" maxlength="10" name="disp_sepa" value="%DISPSEPA%"></td><td>dynamisches Trenn-Element</td></tr>
    <tr><td><input type="range" min="0" max="11" name="disp_scr1" value="%DISPSCR1%"></td><td>Scroll-Geschwindigkeit Daten</td></tr>
    <tr><td><input type="range" min="0" max="11" name="disp_scr2" value="%DISPSCR2%"></td><td>Scroll-Geschwindigkeit Nachrichten</td></tr>
    <tr><td><input type="text" size="1" maxlength="2" name="nigh_stim" value="%NIGHSTIM%"> Uhr</td><td>Nacht Beginnzeit</td></tr>
    <tr><td><input type="text" size="1" maxlength="2" name="nigh_etim" value="%NIGHETIM%"> Uhr</td><td>Nacht Endezeit</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, WLAN
const char wifi_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="wifi">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/wifi" method="post">
  <fieldset>
   <legend>WLAN</legend>
   <table>
    <tr><td><input type="text" size="20" maxlength="50" name="wifi_user" value="%SSID%"></td><td>Netzwerk (SSID)</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="wifi_pass" value="%PASS%"></td><td>Passwort</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, Netzwerk
const char netw_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="netw">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/netw" method="post">
  <fieldset>
   <legend>Netzwerk</legend>
   <table>
    <tr><td><input type="checkbox" name="netw_enab" %NETWENAB% value="1"></td><td>statische IP-Adresse verwenden</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_addr" value="%NETWADDR%"></td><td>IP-Adresse</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_subn" value="%NETWSUBN%"></td><td>Subnetzmaske</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_gate" value="%NETWGATE%"></td><td>Gateway</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="netw_dns1" value="%NETWDNS1%"></td><td>DNS</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, MQTT
const char mqtt_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="mqtt">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/mqtt" method="post">
  <fieldset>
   <legend>MQTT</legend>
   <table>
    <tr><td><input type="checkbox" name="mqtt_enab" %MQTTENAB% value="1"></td><td>MQTT aktivieren</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_addr" value="%MQTTADDR%"></td><td>Adresse des Servers</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_port" value="%MQTTPORT%"></td><td>Port des Servers</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_user" value="%MQTTUSER%"></td><td>Username</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_pass" value="%MQTTPASS%"></td><td>Passwort</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_ltop" value="%MQTTLTOP%"></td><td>LWT Topic</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_utop" value="%MQTTUTOP%"></td><td>Uptime Topic</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_rtop" value="%MQTTRTOP%"></td><td>RSSI Topic</td></tr>
    <tr><td><input type="text" size="40" maxlength="80" name="mqtt_vali" value="%MQTTVALI%"></td><td>Werte-Gültigkeit (2-60 min)</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, Zeit
const char time_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="time">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/time" method="post">
  <fieldset>
   <legend>Zeit</legend>
   <table>
    <tr><td><input type="text" size="30" maxlength="50" name="time_ntp1" value="%TIMENTP1%"></td><td>NTP-Server 1</td></tr>
    <tr><td><input type="text" size="30" maxlength="50" name="time_ntp2" value="%TIMENTP2%"></td><td>NTP-Server 2</td></tr>
    <tr><td><input type="text" size="30" maxlength="50" name="time_zone" value="%TIMEZONE%"></td><td>Zeitzonen-Einstellung</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite System-Einstellungen, Sicherheit
const char http_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="http">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/http" method="post">
  <fieldset>
   <legend>Sicherheit</legend>
   <table>
    <tr><td><input type="checkbox" name="http_enab" %HTTPENAB% value="1"></td><td>Passwortschutz aktivieren</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="http_user" value="%HTTPUSER%"></td><td>Username für Web-Seite</td></tr>
    <tr><td><input type="text" size="20" maxlength="50" name="http_pass" value="%HTTPPASS%"></td><td>Passwort für Web-Seite</td></tr>
    <tr><td colspan="2"><hr></td></tr>
    <tr><td colspan="2"><button type="submit" %DISAB%>Einstellungen speichern</button> %SAVE%</td></tr>
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Wartung, Datei-Manager
const char file_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="file">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/file" method="post">
  <fieldset>
   <legend>Datei-Manager</legend>
   <table>
    <tr class="cc"><th>Nummer</th><th class="le">Dateiname</th><th>Bytes</th><th>Zeit</th></tr>
%FILELIST%    <tr><td colspan="4"><hr></td></tr>
    <tr class="cc"><td><input type="text" size="1" maxlength="3" name="file_numb" value=""></td><td><button type="submit" %DISAB%>Download</button></td><td><button type="submit" formaction="/fdel" %DISAB%>Löschen</button></td></tr>
   </table>
  </fieldset>
 </form>
 <form action="/fupl" method="post" enctype="multipart/form-data">
  <fieldset>
   <legend>Upload</legend>
   <table>
    <tr><td><input type="file" name="data"></td></tr>
    <tr><td><input type="submit" name="file_upld" value="Upload" %DISAB%></td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Seite Wartung, Firmware-Update
const char fwup_html[] PROGMEM = R"rawliteral(<!doctype html>
%HEADER%
<body class="fwup">
<div class="menu">%MENU%
</div>
<div class="main">
 <form action="/fwup" method="post" enctype="multipart/form-data">
  <fieldset>
   <legend>Firmware-Update</legend>
   <table>
    <tr><td><input type="file" name="data"></td></tr>
    <tr><td><input type="submit" name="fwup" value="Update">&nbsp; %SAVE%</td></tr>%REBOOT%
   </table>
  </fieldset>
 </form>
</div>
</body>
</html>)rawliteral";

// Platzhalter-Variablen im HTML-Text ersetzen
String processor(const String& var) {                                 // Variable lesen und durch einen String ersetzen
  uint i;                                                             // Zählervariable
  String s;                                                           // String-Zwischenspeicher

  if (var == "HEADER") return header;                                 // HTML-Header und CSS-Definitionen einsetzen
  if (var == "MENU") return leftmenu;                                 // Linkes Seitenmenü einsetzen
  if (var == "VERSION") return string00;                              // Software-Version einsetzen
  if (var == "VERDATE") return string01;                              // Software-Datum einsetzen
  if (var == "FLSHSIZE") return String(ESP.getFlashChipSize());       // Flash-Speichergröße einsetzen
  if (var == "FREEHEAP") return String(ESP.getFreeHeap());            // freien Speicher einsetzen
  if (var == "CPUFREQ") return String(ESP.getCpuFreqMHz());           // CPU-Frequenz einsetzen
  if (var == "RSSI") return String(rssi);                             // WLAN-Empfangssignal einsetzen
  if (var == "SSID") return percentmask(wifi_ssid);                   // WLAN-SSID einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "PASS") return percentmask(wifi_pass);                   // WLAN-Passwort einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "UPTIME") return uptimex;                                // dynamische Systemlaufzeit einsetzen
  if (var == "DISAB") return filestat? "": disabled;                  // wenn Dateisystem nicht vorhanden -> Speichern-Button deaktivieren
  if (var == "FILESYS") return filestat? status_green: status_red;    // Dateisystemstatus einsetzen
  if (var == "MQTT") return mqttstat? status_green: status_red;       // MQTT-Verbindungsstatus einsetzen
  if (var == "REBOOT") return reboot? reboot_msg: "";                 // wenn Reboot und Neustart erforderlich -> Neustart-Meldung einsetzen
  if (var == "TIMESYNC") {                                            // wenn Status der Zeitsynchronisierung
    if (syncstat == 0) return status_red;                             // wenn nicht synchronisiert -> Status rot
    if (syncstat == 1) return status_orange;                          // wenn Synchronisierung überfällig -> Status orange
    if (syncstat == 2) return status_green;                           // wenn synchronisiert -> Status grün
  }
  if (var == "SAVE") {                                                // wenn Status der letzten Speicheraktion
    if (save == 0) return "";                                         // wenn keine Anzeige -> leerer String
    if (save == 1) return result_green;                               // wenn Status ok -> Ergebnis ok
    if (save == 2) return result_red;                                 // wenn Status Fehler -> Ergebnis Fehler
  }
  if (var == "FILELIST") return filelist;                             // Dateiliste einsetzen
  if (var == "MESSAGE") return percentmask(message);                  // Nachricht einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DISPMODE") return dispconf? checked: "";                // wenn 2 Displaymodule verwendet werden -> Checkbox aktivieren
  if (var == "DISPSECS") return dispsecs? checked: "";                // wenn Sekundenanzeige eingeschaltet -> Checkbox aktivieren
  if (var == "DISPINT0" && dispintv == 0) return selected;            // wenn Intervall-Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "DISPINT1" && dispintv == 1) return selected;            // wenn Intervall-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "DISPINT2" && dispintv == 2) return selected;            // wenn Intervall-Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "DISPINT3" && dispintv == 3) return selected;            // wenn Intervall-Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "DISPINT4" && dispintv == 4) return selected;            // wenn Intervall-Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "DISPINT5" && dispintv == 5) return selected;            // wenn Intervall-Option 5 und Einstellung 5 aktiv -> Option aktivieren
  if (var == "DISPMSG1" && msg_count == 1) return selected;           // wenn Nachrichten-anzeigen-Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "DISPMSG2" && msg_count == 2) return selected;           // wenn Nachrichten-anzeigen-Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "DISPMSG3" && msg_count == 3) return selected;           // wenn Nachrichten-anzeigen-Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "DISPMSG4" && msg_count == 4) return selected;           // wenn Nachrichten-anzeigen-Option 4 und Einstellung 4 aktiv -> Option aktivieren
  if (var == "DISPMSG5" && msg_count == 5) return selected;           // wenn Nachrichten-anzeigen-Option 5 und Einstellung 5 aktiv -> Option aktivieren
  if (var == "DISPSEPA") return percentmask(separator);               // dynamisches Trenn-Element einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DISPSCR1") return String(scrolltm1);                    // Scroll-Geschwindigkeit Daten einsetzen
  if (var == "DISPSCR2") return String(scrolltm2);                    // Scroll-Geschwindigkeit Nachrichten einsetzen
  if (var == "NIGHSTIM") return String(night_stim);                   // Nacht-Beginnzeit einsetzen
  if (var == "NIGHETIM") return String(night_etim);                   // Nacht-Endezeit einsetzen
  if (var == "NETWENAB") return netw_enab? checked: "";               // wenn statische IP-Adresse aktiviert -> Checkbox aktivieren
  if (var == "NETWADDR") return percentmask(netw_addr);               // IP-Adresse einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "NETWSUBN") return percentmask(netw_subn);               // Subnetzmaske einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "NETWGATE") return percentmask(netw_gate);               // Gateway einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "NETWDNS1") return percentmask(netw_dns1);               // DNS einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTENAB") return mqtt_enab? checked: "";               // wenn MQTT aktiviert -> Checkbox aktivieren
  if (var == "MQTTADDR") return percentmask(mqtt_addr);               // MQTT-Adresse einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTPORT") return percentmask(mqtt_port);               // MQTT-Port einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTUSER") return percentmask(mqtt_user);               // MQTT-Username einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTPASS") return percentmask(mqtt_pass);               // MQTT-Passwort einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTLTOP") return percentmask(mqtt_ltop);               // MQTT LWT-Topic einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTUTOP") return percentmask(mqtt_utop);               // MQTT Uptime-Topic einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTRTOP") return percentmask(mqtt_rtop);               // MQTT RSSI-Topic einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MQTTVALI") return String(mqtt_vali);                    // MQTT Werte-Gültigkeit einsetzen
  if (var == "TIMENTP1") return percentmask(time_ntp1);               // NTP-Server 1 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "TIMENTP2") return percentmask(time_ntp2);               // NTP-Server 2 einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "TIMEZONE") return percentmask(time_zone);               // Zeitzonen-Einstellungen einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "HTTPENAB") return http_enab? checked: "";               // wenn HTTP-Authentifizierung aktiviert -> Checkbox aktivieren
  if (var == "HTTPUSER") return percentmask(http_user);               // HTTP-Username einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "HTTPPASS") return percentmask(http_pass);               // HTTP-Passwort einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "BDAYPAGE") return String(bdaypage + 1);                 // aktuelle Seite der Geburtstagsliste einsetzen
  if (var == "BDAYLIST") return bdaylist;                             // Geburtstagsliste einsetzen
  if (var == "BDDISAB") {
    if (!filestat || bdaycount >= MAXBDAYS) return disabled; else return ""; // wenn Dateisystem nicht vorhanden oder Geburtstagsliste voll -> Plus-Button deaktivieren
  }
  if (var == "SENA") return percentmask(sensorlist[0]);               // MQTT-Topic von Sensor A einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENB") return percentmask(sensorlist[1]);               // MQTT-Topic von Sensor B einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENC") return percentmask(sensorlist[2]);               // MQTT-Topic von Sensor C einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEND") return percentmask(sensorlist[3]);               // MQTT-Topic von Sensor D einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENE") return percentmask(sensorlist[4]);               // MQTT-Topic von Sensor E einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENF") return percentmask(sensorlist[5]);               // MQTT-Topic von Sensor F einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENG") return percentmask(sensorlist[6]);               // MQTT-Topic von Sensor G einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SENH") return percentmask(sensorlist[7]);               // MQTT-Topic von Sensor H einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "WEAT") return percentmask(sensorlist[8]);               // MQTT-Topic von Wettersensor einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "FUEL") return percentmask(sensorlist[9]);               // MQTT-Topic von Kraftstoffsensor einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MESG") return percentmask(sensorlist[10]);              // MQTT-Topic von Textnachricht einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEDA0" && sensordeci[0] == 0) return selected;          // wenn Nachkommastelle von Sensor A Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDA1" && sensordeci[0] == 1) return selected;          // wenn Nachkommastelle von Sensor A Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDA2" && sensordeci[0] == 2) return selected;          // wenn Nachkommastelle von Sensor A Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDA3" && sensordeci[0] == 3) return selected;          // wenn Nachkommastelle von Sensor A Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDB0" && sensordeci[1] == 0) return selected;          // wenn Nachkommastelle von Sensor B Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDB1" && sensordeci[1] == 1) return selected;          // wenn Nachkommastelle von Sensor B Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDB2" && sensordeci[1] == 2) return selected;          // wenn Nachkommastelle von Sensor B Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDB3" && sensordeci[1] == 3) return selected;          // wenn Nachkommastelle von Sensor B Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDC0" && sensordeci[2] == 0) return selected;          // wenn Nachkommastelle von Sensor C Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDC1" && sensordeci[2] == 1) return selected;          // wenn Nachkommastelle von Sensor C Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDC2" && sensordeci[2] == 2) return selected;          // wenn Nachkommastelle von Sensor C Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDC3" && sensordeci[2] == 3) return selected;          // wenn Nachkommastelle von Sensor C Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDD0" && sensordeci[3] == 0) return selected;          // wenn Nachkommastelle von Sensor D Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDD1" && sensordeci[3] == 1) return selected;          // wenn Nachkommastelle von Sensor D Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDD2" && sensordeci[3] == 2) return selected;          // wenn Nachkommastelle von Sensor D Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDD3" && sensordeci[3] == 3) return selected;          // wenn Nachkommastelle von Sensor D Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDE0" && sensordeci[4] == 0) return selected;          // wenn Nachkommastelle von Sensor E Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDE1" && sensordeci[4] == 1) return selected;          // wenn Nachkommastelle von Sensor E Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDE2" && sensordeci[4] == 2) return selected;          // wenn Nachkommastelle von Sensor E Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDE3" && sensordeci[4] == 3) return selected;          // wenn Nachkommastelle von Sensor E Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDF0" && sensordeci[5] == 0) return selected;          // wenn Nachkommastelle von Sensor F Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDF1" && sensordeci[5] == 1) return selected;          // wenn Nachkommastelle von Sensor F Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDF2" && sensordeci[5] == 2) return selected;          // wenn Nachkommastelle von Sensor F Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDF3" && sensordeci[5] == 3) return selected;          // wenn Nachkommastelle von Sensor F Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDG0" && sensordeci[6] == 0) return selected;          // wenn Nachkommastelle von Sensor G Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDG1" && sensordeci[6] == 1) return selected;          // wenn Nachkommastelle von Sensor G Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDG2" && sensordeci[6] == 2) return selected;          // wenn Nachkommastelle von Sensor G Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDG3" && sensordeci[6] == 3) return selected;          // wenn Nachkommastelle von Sensor G Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEDH0" && sensordeci[7] == 0) return selected;          // wenn Nachkommastelle von Sensor H Option 0 und Einstellung 0 aktiv -> Option aktivieren
  if (var == "SEDH1" && sensordeci[7] == 1) return selected;          // wenn Nachkommastelle von Sensor H Option 1 und Einstellung 1 aktiv -> Option aktivieren
  if (var == "SEDH2" && sensordeci[7] == 2) return selected;          // wenn Nachkommastelle von Sensor H Option 2 und Einstellung 2 aktiv -> Option aktivieren
  if (var == "SEDH3" && sensordeci[7] == 3) return selected;          // wenn Nachkommastelle von Sensor H Option 3 und Einstellung 3 aktiv -> Option aktivieren
  if (var == "SEVA") return percentmask(sensorvals[0]);               // Wert von Sensor A einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVB") return percentmask(sensorvals[1]);               // Wert von Sensor B einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVC") return percentmask(sensorvals[2]);               // Wert von Sensor C einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVD") return percentmask(sensorvals[3]);               // Wert von Sensor D einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVE") return percentmask(sensorvals[4]);               // Wert von Sensor E einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVF") return percentmask(sensorvals[5]);               // Wert von Sensor F einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVG") return percentmask(sensorvals[6]);               // Wert von Sensor G einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "SEVH") return percentmask(sensorvals[7]);               // Wert von Sensor H einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "WEATV") return percentmask(weatv);                      // Anfang der Wetterdaten einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "FUELV") return percentmask(fuelv);                      // Anfang der Kraftstoffdaten einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "MESGV") return percentmask(mesgv);                      // Anfang der Textnachricht einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DATA") return percentmask(datadisp);                    // Datenausgabe Datenfeld einsetzen (mit Prozentzeichen-Maskierung)
  if (var == "DSIZ") return String(DATASIZE);                         // Datenfeldlänge einsetzen
  if (var == "TEM1") return weathervals[0][0]? weathervals[0]: "X.X"; // Wetterdaten, Temperatur mit Nachkommastelle einsetzen
  if (var == "TEM2") return weathervals[1][0]? weathervals[1]: "X";   // Wetterdaten, Temperatur ohne Nachkommastelle einsetzen
  if (var == "HUMI") return weathervals[2][0]? weathervals[2]: "X";   // Wetterdaten, Luftfeuchtigkeit einsetzen
  if (var == "PRES") return weathervals[3][0]? weathervals[3]: "X";   // Wetterdaten, Luftdruck einsetzen
  if (var == "WIN1") return weathervals[4][0]? weathervals[4]: "X.X"; // Wetterdaten, Windgeschwindigkeit in m/s einsetzen
  if (var == "WIN2") return weathervals[5][0]? weathervals[5]: "X";   // Wetterdaten, Windgeschwindigkeit in km/h einsetzen
  if (var == "RAI1") return weathervals[6][0]? weathervals[6]: "X.X"; // Wetterdaten, Regenmenge mit Nachkommastelle einsetzen
  if (var == "RAI2") return weathervals[7][0]? weathervals[7]: "X";   // Wetterdaten, Regenmenge ohne Nachkommastelle einsetzen
  if (var == "CLOU") return weathervals[8][0]? weathervals[8]: "X";   // Wetterdaten, Wolkendichte einsetzen
  if (var == "WINS") return weathervals[9][0]? weathervals[9]: "";    // Wetterdaten, Windsymbol einsetzen
  if (var == "WEAS" && weathervals[10][0]) {                          // Wetterdaten, Wettersymbol
    s = weathervals[10];                                              // Wettersymbol als String zwischenspeichern
    i = weathervals[10][1];                                           // Wettersymbolname als ASCII-Wert holen
    if (nightsymbol) i ++;                                            // wenn Nachtmodus -> auf Nachtsymbol ändern
    return s.substring(0, 1) + char(i);                               // vollständiges Wettersymbol einsetzen
  }
  if (var == "WTXT" && weathervals[11][0]) return " " + String(weathervals[11]); // Wetterlagentext-Nummer einsetzen
  if (var == "SUNT" && weathervals[12][0]) {                          // wenn Wetterdaten, Sonnenwerte vorhanden
    s = weathervals[12];                                              // Sonnenwerte zwischenspeichern
    return s.substring(0, 5) + "&#9728;" + s.substring(7);            // mit HTML-Symbol neu zusammensetzen und zurückgeben
  }
  if (var == "FUE1") return fuelvals[0][0]? fuelvals[0]: "X.XX";      // Kraftstoffpreis 1 einsetzen
  if (var == "FUE2") return fuelvals[1][0]? fuelvals[1]: "X.XX";      // Kraftstoffpreis 2 einsetzen
  if (var == "FUE3") return fuelvals[2][0]? fuelvals[2]: "X.XX";      // Kraftstoffpreis 3 einsetzen
  if (var == "FUE4") return fuelvals[3][0]? fuelvals[3]: "X.XX";      // Kraftstoffpreis 4 einsetzen
  if (var == "DATE") return (syncstat > 0)? curdate: stringsd[9];     // Datum einsetzen
  if (var == "WDAY") return (syncstat > 0)? stringsd[wday + 1]: stringsd[10]; // Wochentag einsetzen
  return percentmask(String());                                       // ersetzten String zurückgeben (mit Prozentzeichen-Maskierung)
}

// Liste für Datei-Manager erstellen
void filedir() {
  filecount = 0;                                                      // Dateizähler löschen
  filelist = "";                                                      // Dateiliste löschen
  if (filestat) {                                                     // wenn Dateisystem vorhanden
    Dir dir = LittleFS.openDir("/");                                  // Hauptverzeichnis öffnen
    while (dir.next()) {                                              // solange weitere Dateine vorhanden sind
      File file = dir.openFile("r");                                  // Datei zum Lesen öffnen
      filenames[filecount] = String(dir.fileName());                  // Dateiname speichern
      filesizes[filecount] = String(dir.fileSize());                  // Dateigröße speichern
      time_t fdate = file.getLastWrite();                             // Dateizeit speichen (letzter Schreibzugriff)
      file.close();                                                   // Datei schließen
      struct tm *tmstruct = localtime(&fdate);                        // strukturierte Dateizeit erstellen
      sprintf(filedate, "%02d.%02d.%d %02d:%02d:%02d", tmstruct->tm_mday, (tmstruct->tm_mon) + 1, (tmstruct->tm_year) + 1900, tmstruct->tm_hour, tmstruct->tm_min, tmstruct->tm_sec);
      filelist += F("    <tr class=\"cc\"><td>");                     // Dateiliste erstellen, neue Tabellenzeile
      filelist += filecount + 1;                                      // Dateiliste erstellen, Dateinummer
      filelist += F("</td><td class=\"le\">");                        // Dateiliste erstellen, neue Tabellenspalte
      filelist += filenames[filecount];                               // Dateiliste erstellen, Dateiname
      filelist += F("</td><td>");                                     // Dateiliste erstellen, neue Tabellenspalte
      filelist += filesizes[filecount];                               // Dateiliste erstellen, Dateigröße
      filelist += F("</td><td>");                                     // Dateiliste erstellen, neue Tabellenspalte
      filelist += filedate;                                           // Dateiliste erstellen, Dateizeit
      filelist += F("</td></tr>\n");                                  // Dateiliste erstellen, Ende Tabellenzeile
      filecount ++;                                                   // Dateizähler erhöhen
    }
  }
  if (!filestat || filecount == 0) {                                  // wenn kein Dateisystem oder keine Datei vorhanden
    filelist = F("    <tr class=\"cc\"><td></td><td>&lt;leer&gt;</td><td></td></tr>\n"); // leere Tabellenzeile erzeugen
  }
}

// Liste mit Geburtstagen erstellen
void bdaylister() {
  uint8_t i;                                                          // Zählervariable
  uint8_t start = MAXBPAGE * bdaypage;                                // Listenanfang berechnen
  uint8_t end = start + MAXBPAGE;                                     // Listenende berechnen
  bdaylist = "";                                                      // Geburtstagsliste löschen
  
  for (i = start; i < end; i ++) {                                    // Listenbereich bearbeiten
    if (i >= MAXBDAYS) break;                                         // wenn Ende der Liste erreicht -> Ende
    if (birthdays[i] == "") break;                                    // wenn leerer Eintrag -> Ende
    else {                                                            // wenn Eintrag mit Daten
      bdaylist += F("    <tr class=\"cc\"><td>");                     // Geburtstagsliste erstellen, neue Tabellenzeile
      bdaylist += i + 1;                                              // Geburtstagsliste erstellen, Eintragnummer
      bdaylist += F("</td><td>");                                     // Geburtstagsliste erstellen, neue Tabellenspalte
      bdaylist += birthdays[i].substring(6, 8) + "." + birthdays[i].substring(4, 6) + "." + birthdays[i].substring(0, 4); // Geburtstagsliste erstellen, lesbares Datum
      bdaylist += F("</td><td colspan=\"2\" class=\"le\">");          // Geburtstagsliste erstellen, neue Tabellenspalte
      bdaylist += percentmask(birthdays[i].substring(9));             // Geburtstagsliste erstellen, Name (mit Prozentzeichen-Maskierung)
      bdaylist += F("</td></tr>\n");                                  // Geburtstagsliste erstellen, Ende Tabellenzeile
    }
  }
  if (bdaycount == 0) {                                               // wenn keine Geburtstage vorhanden
    bdaylist = F("    <tr class=\"cc\"><td colspan=\"4\">&lt;leer&gt;</td></tr>\n"); // leere Tabellenzeile erzeugen
  }
}
