// Matrixuhr-ESP32, Scott-Falk Hühn, "tables.h"
// verschiedene Tabellen und Texte

// RGB-Farbwerttabelle (16 Farben, jeweils 3 Bytes mit dem R-, G- und B-Wert)
const uint8_t rgbcolors[] PROGMEM = {
  255, 0, 0,        // rot
  230, 115, 0,      // orange
  204, 204, 0,      // gelb
  115, 230, 0,      // gelb-grün
  0, 255, 0,        // grün
  0, 230, 115,      // grün-cyan
  0, 204, 204,      // cyan
  0, 115, 230,      // cyan-blau
  0, 0, 255,        // blau
  115, 0, 230,      // blau-magenta
  204, 0, 204,      // magenta
  230, 0, 115,      // magenta-rot
  204, 102, 102,    // rot 2
  102, 204, 102,    // grün 2
  102, 102, 204,    // blau 2
  165, 165, 165,    // weiß
};

// Helligkeits-Tabelle (Basis-Helligkeitswert)
const uint8_t brightntab[] PROGMEM = {
    6,   6,   6,   6,   6,   6,   6,   6,  12,  12,
   12,  22,  22,  28,  38,  50,  55,  65,  75,  85,
  100, 115, 130, 145, 160, 180
};

// Helligkeits-Tabelle (Divisoren für die Farbwert-Berechnung)
const float brightdtab[] PROGMEM = {
  2.40, 2.00, 1.80, 1.60, 1.40, 1.25, 1.10, 1.00, 1.25, 1.12,
  1.00, 1.08, 1.00, 1.00, 1.00, 1.00, 1.00, 1.00, 1.00, 1.00,
  1.00, 1.00, 1.00, 1.00, 1.00, 1.00
};

// Strings allgemein
const char string00[] PROGMEM = VERSION_TEXT;   // Versionsnummer
const char string20[] PROGMEM = VERSION_NUMB;   // Versionsdatum für Webseite

// Strings deutsch
const char string01[] PROGMEM = "Sonntag";
const char string02[] PROGMEM = "Montag";
const char string03[] PROGMEM = "Dienstag";
const char string04[] PROGMEM = "Mittwoch";
const char string05[] PROGMEM = "Donnerstag";
const char string06[] PROGMEM = "Freitag";
const char string07[] PROGMEM = "Samstag";
const char string08[] PROGMEM = "MatrixuhrESP";
const char string09[] PROGMEM = "kein Datum";
const char string10[] PROGMEM = "kein Tag";
const char string11[] PROGMEM = "keine Daten";
const char string12[] PROGMEM = "kein Geburtstag";

const PROGMEM char * const PROGMEM stringsd[] = {
  string00, string01, string02, string03, string04, string05, string06, string07, string08, string09, string10, string11, string12, string20
};

// UTF-8 Tabelle für 2-Byte-Zeichen: ÄÖÜäöüéß°
const uint8_t utf8tab[] PROGMEM = {
  0xc3, 0x84, 128,        // Code C3 84 -> Ä
  0xc3, 0x96, 129,        // Code C3 96 -> Ö
  0xc3, 0x9c, 130,        // Code C3 9C -> Ü
  0xc3, 0xa4, 131,        // Code C3 A4 -> ä
  0xc3, 0xb6, 132,        // Code C3 B6 -> ö
  0xc3, 0xbc, 133,        // Code C3 BC -> ü
  0xc3, 0xa9, 139,        // Code C3 A9 -> é
  0xc3, 0x9f, 134,        // Code C3 9F -> ß
  0xc2, 0xb0, 138         // Code C2 B0 -> Gradzeichen
};

// UTF-8 Tabelle für 3-Byte-Zeichen: €
const uint8_t utf8tab3[] PROGMEM = {
  0xe2, 0x82, 0xac, 140   // Code E2 82 AC -> €
};

// Kommandos zum Abspielen der Sounds 1-6 für Soundmodul DY-SV8F
const char soundcmds[] PROGMEM = {
  170, 7, 2, 0, 1, 180,   // Sound 1 abspielen
  170, 7, 2, 0, 2, 181,   // Sound 2 abspielen
  170, 7, 2, 0, 3, 182,   // Sound 3 abspielen
  170, 7, 2, 0, 4, 183,   // Sound 4 abspielen
  170, 7, 2, 0, 5, 184,   // Sound 5 abspielen
  170, 7, 2, 0, 6, 185,   // Sound 6 abspielen
};

// favicon.png, 16x16 Pixel
const uint8_t favicon[] = {
  0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x08, 0x06, 0x00, 0x00, 0x00, 0x1F, 0xF3, 0xFF, 0x61,
  0x00, 0x00, 0x00, 0x2B, 0x74, 0x45, 0x58, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x54, 0x69, 0x6D, 0x65, 0x00, 0x53, 0x61, 0x20, 0x32, 0x32, 0x20, 0x41, 0x70, 0x72, 0x20, 0x32,
  0x30, 0x32, 0x33, 0x20, 0x32, 0x32, 0x3A, 0x31, 0x37, 0x3A, 0x33, 0x30, 0x20, 0x2B, 0x30, 0x31, 0x30, 0x30, 0x7C, 0xCF, 0x4E, 0x65, 0x00, 0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE7, 0x04,
  0x16, 0x14, 0x13, 0x1B, 0xB7, 0xC2, 0xAC, 0xCB, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0F, 0x61, 0x00, 0x00, 0x0F, 0x61, 0x01, 0xA8, 0x3F, 0xA7, 0x69, 0x00, 0x00, 0x00, 0x04,
  0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1, 0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00, 0x00, 0x00, 0x5C, 0x49, 0x44, 0x41, 0x54, 0x78, 0xDA, 0x63, 0x64, 0x38, 0x70, 0xE0, 0x3F, 0x03, 0x32, 0x70, 0x70, 0x60,
  0x04, 0xD3, 0xC4, 0x8A, 0x63, 0x0A, 0x90, 0x20, 0x0E, 0x64, 0x33, 0x31, 0x50, 0x08, 0x18, 0x51, 0x4C, 0x84, 0x39, 0x93, 0x2A, 0x5E, 0xC0, 0xE3, 0x6C, 0x64, 0x29, 0x8A, 0xBD, 0xC0, 0x82, 0x61, 0x2A,
  0x4E, 0xA7, 0x0E, 0x56, 0x00, 0x8C, 0x05, 0x06, 0xDC, 0x4E, 0x75, 0x60, 0x80, 0x7A, 0x87, 0x81, 0x0C, 0xEF, 0x10, 0xA3, 0x09, 0xA8, 0x86, 0x4A, 0xB1, 0x40, 0xC8, 0x46, 0x8A, 0xBD, 0x80, 0xC7, 0x00,
  0x2A, 0x78, 0x81, 0x58, 0xE7, 0xE1, 0x50, 0x07, 0x00, 0x16, 0x50, 0x39, 0xC5, 0x29, 0xC8, 0x75, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82
};

// Wetter-Iconliste
const char weathericons[] = {
  '0', '1',               // 01d/01n - Klarer Himmel
  '0', '2',               // 02d/02n - Ein paar Wolken
  '0', '3',               // 03d/03n - Mäßig bewölkt
  '0', '4',               // 04d/04n - Überwiegend bewölkt
  '0', '9',               // 09d/09n - Regenschauer
  '1', '0',               // 10d/10n - Regen
  '1', '1',               // 11d/11n - Gewitter
  '1', '3',               // 13d/13n - Schnee
  '5', '0'                // 50d/50n - Nebel
};

// Wetterlage-Texte deutsch, Umlaute müssen folgendermaßen geschrieben werden:
// Ä = \200, Ö = \201, Ü = \202, ä = \203, ö = \204, ü = \205, ß = \206
const char wcstrd00[] PROGMEM = "200 Gewitter mit leichtem Regen";
const char wcstrd01[] PROGMEM = "201 Gewitter mit Regen";
const char wcstrd02[] PROGMEM = "202 Gewitter mit starkem Regen";
const char wcstrd03[] PROGMEM = "210 Leichtes Gewitter";
const char wcstrd04[] PROGMEM = "211 Gewitter";
const char wcstrd05[] PROGMEM = "212 Schweres Gewitter";
const char wcstrd06[] PROGMEM = "221 Einige Gewitter";
const char wcstrd07[] PROGMEM = "230 Gewitter mit leichtem Nieselregen";
const char wcstrd08[] PROGMEM = "231 Gewitter mit Nieselregen";
const char wcstrd09[] PROGMEM = "232 Gewitter mit starkem Nieselregen";
const char wcstrd10[] PROGMEM = "300 Leichtes Nieseln";
const char wcstrd11[] PROGMEM = "301 Nieseln";
const char wcstrd12[] PROGMEM = "302 Starkes Nieseln";
const char wcstrd13[] PROGMEM = "310 Leichter Nieselregen";
const char wcstrd14[] PROGMEM = "311 Nieselregen";
const char wcstrd15[] PROGMEM = "312 Starker Nieselregen";
const char wcstrd16[] PROGMEM = "313 Regen und Niesel";
const char wcstrd17[] PROGMEM = "314 Starker Regen und Niesel";
const char wcstrd18[] PROGMEM = "321 Spr\205hregen";
const char wcstrd19[] PROGMEM = "500 Leichter Regen";
const char wcstrd20[] PROGMEM = "501 M\203\206iger Regen";
const char wcstrd21[] PROGMEM = "502 Starker Regen";
const char wcstrd22[] PROGMEM = "503 Sehr starker Regen";
const char wcstrd23[] PROGMEM = "504 Extremer Regen";
const char wcstrd24[] PROGMEM = "511 Gefrierender Regen";
const char wcstrd25[] PROGMEM = "520 Leichter Regen- schauer";
const char wcstrd26[] PROGMEM = "521 Regen- schauer";
const char wcstrd27[] PROGMEM = "522 Starker Regen- schauer";
const char wcstrd28[] PROGMEM = "531 Einige Regen- schauer";
const char wcstrd29[] PROGMEM = "600 Leichter Schneefall";
const char wcstrd30[] PROGMEM = "601 Schneefall";
const char wcstrd31[] PROGMEM = "602 Starker Schneefall";
const char wcstrd32[] PROGMEM = "611 Schneeregen";
const char wcstrd33[] PROGMEM = "612 Schneeregen Schauer";
const char wcstrd34[] PROGMEM = "613 Starker Schneeregen";
const char wcstrd35[] PROGMEM = "615 Leichter Regen und Schneefall";
const char wcstrd36[] PROGMEM = "616 Regen und Schneefall";
const char wcstrd37[] PROGMEM = "620 Leichter Schnee- schauer";
const char wcstrd38[] PROGMEM = "621 Schnee- schauer";
const char wcstrd39[] PROGMEM = "622 Starker Schnee- schauer";
const char wcstrd40[] PROGMEM = "701 Dunst";
const char wcstrd41[] PROGMEM = "711 Rauch";
const char wcstrd42[] PROGMEM = "721 Tr\205b";
const char wcstrd43[] PROGMEM = "731 Sand und Staubwirbel";
const char wcstrd44[] PROGMEM = "741 Nebel";
const char wcstrd45[] PROGMEM = "751 Sand";
const char wcstrd46[] PROGMEM = "761 Staub";
const char wcstrd47[] PROGMEM = "762 Vulkanasche";
const char wcstrd48[] PROGMEM = "771 B\204en";
const char wcstrd49[] PROGMEM = "781 Orkan";
const char wcstrd50[] PROGMEM = "800 Klarer Himmel";
const char wcstrd51[] PROGMEM = "801 Ein paar Wolken";
const char wcstrd52[] PROGMEM = "802 M\203\206ig bew\204lkt";
const char wcstrd53[] PROGMEM = "803 \202berwiegend bew\204lkt";
const char wcstrd54[] PROGMEM = "804 Bedeckt";
const char wcstrd55[] PROGMEM = "999 Unbekannt";

// Wetterlagenliste
const PROGMEM char * const PROGMEM wcstringsd[] = {
  wcstrd00, wcstrd01, wcstrd02, wcstrd03, wcstrd04, wcstrd05, wcstrd06, wcstrd07, wcstrd08, wcstrd09, wcstrd10, wcstrd11, wcstrd12, wcstrd13, wcstrd14, wcstrd15, wcstrd16, wcstrd17, wcstrd18, wcstrd19,
  wcstrd20, wcstrd21, wcstrd22, wcstrd23, wcstrd24, wcstrd25, wcstrd26, wcstrd27, wcstrd28, wcstrd29, wcstrd30, wcstrd31, wcstrd32, wcstrd33, wcstrd34, wcstrd35, wcstrd36, wcstrd37, wcstrd38, wcstrd39,
  wcstrd40, wcstrd41, wcstrd42, wcstrd43, wcstrd44, wcstrd45, wcstrd46, wcstrd47, wcstrd48, wcstrd49, wcstrd50, wcstrd51, wcstrd52, wcstrd53, wcstrd54, wcstrd55
};
