// Matrixuhr-ESP32, Scott-Falk Hühn, "functions.h"
// verschiedene Funktionen

// Helligkeitssensor und Min/Max-Einstellungen lesen und Helligkeit einstellen
void set_bright() {
  uint8_t i;                                                          // Zählervariable
  int x = 0;                                                          // Zwischenspeicher für Mittelwertberechnung

  for (i = 0; i < 64; i ++) x += bright[i];                           // alle Werte aus dem Helligkeits-Puffer addieren
  x = pow(x, BRIGHTEXPO) * BRIGHTCORR;                                // Helligkeits-Summenwert mit Exponential-Korrektur!
  brightfact = (256 * 64) / (BRIGHTLEVEL - brightmin - (14 - brightmax)); // Helligkeitsstufen-Faktor und Berücksichtigung von Min- und Max-Wert ermitteln
  brightlevel = x / brightfact + brightmin;                           // Helligkeitstufe ermitteln
  brightdiv = pgm_read_float(&brightdtab[brightlevel]);               // Helligkeits-Divisor aus Tabelle holen
  if (syncstat > 0) {                                                 // wenn Uhr synchronisiert
    nighttime = false;                                                // Nacht-Zeit-Flag zunächst löschen
    if (night_stim < night_etim) {                                    // wenn Beginnzeit < Endzeit
      if (hour >= night_stim && hour < night_etim) nighttime = true;  // wenn aktuelle Zeit innerhalb der Beginn- und Endzeit -> Nacht-Zeit-Flag setzen
    }
    if (night_stim > night_etim) {                                    // wenn Beginnzeit > Endzeit
      if (hour >= night_stim || hour < night_etim) nighttime = true;  // wenn aktuelle Zeit nach Beginnzeit oder vor Endzeit -> Nacht-Zeit-Flag setzen
    }
  }
  else nighttime = false;                                             // wenn Uhr nicht synchronisiert -> Nacht-Zeit-Flag löschen
  if (nighttime && nacttout == 255) {                                 // wenn Nacht-Zeit und Nachtaktivierungs-Zähler inaktiv
    display->setBrightness(0);                                        // Display-Helligkeit auf 0 setzen
    brightdiv = 500;                                                  // Helligkeits-Divisor so setzen, dass Farbwerte immer 0 sind
  }
  else {                                                              // wenn Nacht-Zeit und Nachtaktivierungs-Zähler aktiv
    display->setBrightness(pgm_read_byte(&brightntab[brightlevel]));  // Helligkeitswert aus Tabelle holen und Display-Grundhelligkeit einstellen
  }
}

// Timer-Funktionen, werden alle 40ms von loop() aufgerufen
void timer40ms() {
  int8_t i;                                                           // Zählervariable
  bool touchtemp = false;                                             // Zwischenspeicher für aktuellen Status des Berührungssensors

  if (touchRead(TOUCH_PIN) < TOUCHLEVEL) touchtemp = true;            // wenn Berührungssensor aktiv -> Status zwischenspeichern
  if (touchtemp == touchold) {                                        // wenn aktueller = vorheriger Status
    if (touchtemp) {                                                  // wenn Berührungssensor aktiv
      touchstat = true;                                               // aktuellen Status auf "aktiv" setzen
      if (touchidle == TOUCHIDLE) touchidle = 0;                      // wenn Zählerendwert für Pause zwischen 2 Berührungen erreicht -> Zähler löschen
      if (touchlong < TOUCHTOUT) touchlong ++;                        // wenn Endwert für lange Berührung noch nicht erreicht -> Zähler erhöhen
    }
    else {                                                            // wenn Berührungssensor inaktiv
      touchstat = false;                                              // aktuellen Status auf "inaktiv" setzen
      touchsquit = false;                                             // Quittierungs-Status für kurze Berührung löschen
      touchlquit = false;                                             // Quittierungs-Status für lange Berührung löschen
      touchlong = 0;                                                  // Zähler für lange Berührung löschen
      if (touchidle < TOUCHIDLE) touchidle ++;                        // wenn Endwert für Pause zwischen den Berührungen noch nicht erreicht -> Zähler erhöhen
    }
  }
  touchold = touchtemp;                                               // Status für nächste Abfrage des Berührungssensors speichern

  if (boottout < 255) {                                               // wenn Reboot-Timeout-Zähler aktiv
    if (boottout > 0) boottout --;                                    // wenn Reboot-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }
  if (soundtout < 255) {                                              // wenn Sound-Timeout-Zähler aktiv
    if (soundtout > 0) soundtout --;                                  // wenn Sound-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }

  if (quitcount < 32) quitcount ++;                                   // wenn Quittierungszähler aktiv -> erhöhen
  bright[brightpos ++] = analogRead(ADC_PIN) / 16;                    // neuen Helligkeitswert auf 8-Bit-Wert umrechnen und in Puffer schreiben, Position erhöhen
  if (brightpos >= 64) brightpos = 0;                                 // wenn letzte Position überschritten -> zurücksetzen
}

// Timer-Funktionen, werden jede Sekunde von loop() aufgerufen
void timer1sec() {                                                    // Timeout-Zähler 1s verwalten
  uint8_t temp;                                                       // Zwischenspeicher
  int8_t i;                                                           // Zählervariable

  if (brightchg == 1) set_bright();                                   // wenn Helligkeits-Änderung im Sekundentakt -> Helligkeit einstellen
  process_call();                                                     // Anrufe bearbeiten
  if (disptout < 255) {                                               // wenn Anzeige-Timeout-Zähler aktiv
    if (disptout > 0) disptout --;                                    // wenn Anzeige-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }
  if (wifitout < 255) {                                               // wenn WLAN-Timeout-Zähler aktiv
    if (wifitout > 0) wifitout --;                                    // wenn WLAN-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }
  if (mqtttout < 255) {                                               // wenn MQTT-Timeout-Zähler aktiv
    if (mqtttout > 0) mqtttout --;                                    // wenn MQTT-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }
  if (nacttout < 255) {                                               // wenn Nachtaktivierungs-Zähler aktiv
    if (nacttout > 0) nacttout --;                                    // wenn Nachtaktivierungs-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
  }

  if ((second % chgtime) == (chgtime - 2)) {                          // wenn Wechselzeit erreicht (bei 2 und Sekunde 0, 2, 4, ...; bei 3 und Sekunde 1, 4, 7, ...; bei 4 und Sekunde 2, 6, 10, ...)
    if (brightchg == 2) set_bright();                                 // wenn Helligkeits-Änderung zur Wechselzeit -> Helligkeit einstellen
    process();                                                        // Verarbeitung von Sensoren, speziellen Alarmen und Geburtstagen
    daymcount ++;                                                     // Zähler für Taganzeige erhöhen
    if (daymcount > 1) daymcount = 0;                                 // wenn Endwert überschritten -> zurücksetzen
    datacount ++;                                                     // Datenfeldzähler erhöhen
    if (datacount > 33) datacount = 0;                                // wenn Datenfeldzähler außerhalb des zulässigen Bereiches
    if ((datacount == 0) && !showdate) datacount ++;                  // wenn Zähler auf Datum und dieses nicht angezeigt werden soll -> Zähler auf Wochentag
    if ((datacount == 1) && !showday) datacount ++;                   // wenn Zähler auf Wochentag und dieser nicht angezeigt werden soll -> Zähler auf Datenfeld
    temp = datacount;                                                 // aktuellen Zählerstand zwischenspeichern
    if (datacount > 1) {                                              // wenn Zähler > 1 (Sensorwert oder Geburtstag)
      for (i = 0; i < 2; i ++) {                                      // nachfolgende Datenfeldsuche zweimal durchführen
        while (datacount < 33) {                                      // wiederholen solange Zähler im zulässigen Bereich
          if (datarray[datacount - 2][0] > 0) break;                  // wenn belegtes Datenfeld gefunden -> Abbruch
          datacount ++;                                               // Datenfeldzähler erhöhen
        }
        if (datacount > 32) datacount = 0;                            // wenn alle Datenfelder ausgegeben -> Zähler zurücksetzen
        if (i == 0) {                                                 // wenn erster Such-Durchlauf
          if (!showdate && !showday && (datacount == 0) && (temp > 2)) { // wenn Datum und Wochentag nicht angezeigt werden sollen, Datenfeldzähler zurückgesetzt und vorher ein Datenfeld angezeigt wurde
            datacount = 2;                                            // Zähler für erneute Suche auf erstes Datenfeld setzen
          }
          if (showdate || showday) i ++;                              // wenn Datum oder Wochentag angezeigt werden sollen -> zweiten Such-Durchlauf überspringen
        }
      }
    }
    if ((datacount == 0) && (temp > 0)) {                             // wenn Zähler jetzt auf Datum und vorher ein anderes Feld angezeigt wurde
      if (!showdate) {                                                // wenn Datum nicht angezeigt werden soll
        datacount ++;                                                 // Zähler auf Wochentag
        if (!showday) datacount = 33;                                 // wenn Wochentag nicht angezeigt werden soll -> "keine Daten" anzeigen
      }
    }
    for (i = 0; i < 8; i ++) {                                        // 8 Alarmfeld-Timeout-Zähler bearbeiten
      if (alarmtout[i] < 255) {                                       // wenn Zähler aktiv
        if (alarmtout[i] > 0) alarmtout[i] --;                        // wenn Zähler noch nicht abgelaufen -> Zähler vermindern
        if (alarmtout[i] == 0) {                                      // wenn Zähler abgelaufen
          alarmtout[i] = 255;                                         // Zähler stoppen
          if (alarmhold[i] == 0) alarmarray[i][0] = 0;                // wenn kein Halte-Flag gesetzt -> Alarm löschen
        }
      }
    }
    alarmcount ++;                                                    // Alarmfeldzähler erhöhen
    i = alarmcount;                                                   // Zähler zwischenspeichern
    while (alarmcount < 8) {                                          // wiederholen solange Zähler im zulässigen Bereich
      if (alarmarray[alarmcount][0] > 0) break;                       // wenn belegtes Alarmfeld gefunden -> Abbruch
      alarmcount ++;                                                  // sonst Alarmfeldzähler erhöhen
    }
    if (alarmcount > 7) {                                             // wenn alle Alarmfelder ausgegeben
      alarmcount = 0;                                                 // Zähler zurücksetzen und
      while (alarmcount < i) {                                        // weiter bis zum letzten Zählerstand suchen
        if (alarmarray[alarmcount][0] > 0) break;                     // wenn belegtes Alarmfeld gefunden -> Abbruch
        alarmcount ++;                                                // sonst Alarmfeldzähler erhöhen
      }
    }
    alarm_flag = false;                                               // Alarm-Flag zunächst ausschalten
    for (i = 0; i < 8; i ++) {                                        // Alarmfelder durchsuchen
      if (alarmarray[i][0] > 0) alarm_flag = true;                    // wenn Alarm-Eintrag gefunden -> Alarm-Flag setzen
    }
  }

  seccount ++;                                                        // Sekundenzähler erhöhen
  if (seccount > 59) {                                                // wenn Endwert (59) überschritten
    seccount = 0;                                                     // Sekundenzähler zurücksetzen, alle weiteren Teile dieser Funktion werden im Minutentakt abgearbeitet

    if (synctout < 255) {                                             // wenn Synchronisierungs-Timeout-Zähler aktiv
      if (synctout > 0) synctout --;                                  // wenn Synchronisierungs-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
    }

    mincount ++;                                                      // Minutenzähler erhöhen
    if (mincount > 59) {                                              // wenn Endwert (59) überschritten
      mincount = 0;                                                   // Minutenzähler zurücksetzen, alle weiteren Teile dieser Funktion werden im Stundentakt abgearbeitet
      if (mutetout < 255) {                                           // wenn Stummschaltungs-Timeout-Zähler aktiv
        if (mutetout > 0) mutetout --;                                // wenn Stummschaltungs-Timeout-Zähler noch nicht abgelaufen -> Timeout-Zähler vermindern
      }
    }
  }
}

// Farbe für auszugebende Pixel setzen
uint16_t matrix_color(uint8_t c) {                                    // c: Farbnummer 0-15
  return display->color565(pgm_read_byte(&rgbcolors[c * 3]) / brightdiv, pgm_read_byte(&rgbcolors[c * 3 + 1]) / brightdiv, pgm_read_byte(&rgbcolors[c * 3 + 2]) / brightdiv);
}                                                                     // Farbbytes R, G und B aus Tabelle holen und für 565-Farbwert entspechend Helligkeitswert berechnen

// Uhrzeit-Farbe einstellen
uint16_t color_clock() {
  if (colorclk == 0) return matrix_color(colorclkr);                  // wenn Zufallsfarbe ausgewählt -> einstellen
  else return matrix_color(colorclk - 1);                             // sonst gespeicherte Farbe einstellen
}

// Datum-Farbe einstellen
uint16_t color_date() {
  if (colordat == 0) return matrix_color(colordatr);                  // wenn Zufallsfarbe ausgewählt -> einstellen
  else return matrix_color(colordat - 1);                             // sonst gespeicherte Farbe einstellen
}

// Alarm-Farbe einstellen
uint16_t color_alarm() {
  if (coloralm == 0) return matrix_color(coloralmr);                  // wenn Zufallsfarbe ausgewählt -> einstellen
  else return matrix_color(coloralm - 1);                             // sonst gespeicherte Farbe einstellen
}

// Neue Zufallsfarben erzeugen
void color_random() {
  uint8_t c1, c2, c3, c4;                                             // Zwischenspeicher für bisherige Farben und zu meidende Farbe

  if (colorclk == 0) c1 = colorclkr;                                  // wenn Zeit-Farbe auf Zufall gesetzt -> Zufallsfarbe speichern
  else c1 = colorclk - 1;                                             // sonst festen Farbwert speichern
  if (colordat == 0) c2 = colordatr;                                  // wenn Datum-Farbe auf Zufall gesetzt -> Zufallsfarbe speichern
  else c2 = colordat - 1;                                             // sonst festen Farbwert speichern
  if (coloralm == 0) c3 = coloralmr;                                  // wenn Alarm-Farbe auf Zufall gesetzt -> Zufallsfarbe speichern
  else c3 = coloralm - 1;                                             // sonst festen Farbwert speichern
  if (coloravo) c4 = coloravo - 1;                                    // wenn zu meidende Farbe gesetzt -> Farbe speichern
  else c4 = 16;                                                       // sonst ungülte Farbe setzen

  if (colorclk == 0) {                                                // wenn Zeit-Farbe auf Zufall gesetzt ist
    do {                                                              // Schleife
      colorclkr = rand() / (RAND_MAX / 16);                           // neue Zufallsfarbe für Uhrzeit ermitteln
    } while ((colorclkr == c1) || (colorclkr == c2) ||
      (colorclkr == c3) || (colorclkr == c4));                        // solange wiederholen, bis alle Farben unterschiedlich sind
    c1 = colorclkr;                                                   // neue Zufallsfarbe speichern
  }
  if (colordat == 0) {                                                // wenn Datum-Farbe auf Zufall gesetzt ist
    do {                                                              // Schleife
      colordatr = rand() / (RAND_MAX / 16);                           // neue Zufallsfarbe für Datum ermitteln
    } while ((colordatr == c1) || (colordatr == c2) ||
      (colordatr == c3) || (colordatr == c4));                        // solange wiederholen, bis alle Farben unterschiedlich sind
    c2 = colordatr;                                                   // neue Zufallsfarbe speichern
  }
  if (coloralm == 0) {                                                // wenn Alarm-Farbe auf Zufall gesetzt ist
    do {                                                              // Schleife
      coloralmr = rand() / (RAND_MAX / 16);                           // neue Zufallsfarbe für Alarm ermitteln
    } while ((coloralmr == c1) || (coloralmr == c2) ||
      (coloralmr == c3) || (coloralmr == c4));                        // solange wiederholen, bis alle Farben unterschiedlich sind
  }
}

// Eine Großziffer 10x18 (Stunden & Minuten) in die LED-Matrix schreiben
void matrix_digit1(uint8_t d, uint16_t col) {                         // d: auszugebende Ziffer (0-9), col: Farbwert 16 Bit
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle

  offset = d * 36;                                                    // Tabellen-Offset berechnen
  for (y = 0; y < 18; y ++) {                                         // 18 Zeilen mit je 2 Bytes ausgeben
    b = pgm_read_byte(&digit_1_array[offset ++]);                     // Zeilenbyte 1 holen
    for (x = 2; x > 0; x --) {                                        // Zeilenbyte 1 bitweise ausgeben
      if (b & 1) display->drawPixel(posx + x - 1, posy + y, col);     // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b >>= 1;                                                        // nächste Bit-Position an LSB
    }
    b = pgm_read_byte(&digit_1_array[offset ++]);                     // Zeilenbyte 2 holen
    for (x = 8; x > 0; x --) {                                        // Zeilenbyte 2 bitweise ausgeben
      if (b & 1) display->drawPixel(posx + x + 1, posy + y, col);     // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b >>= 1;                                                        // nächste Bit-Position an LSB
    }
  }
  posx += 12;                                                         // X-Position für nächstes Zeichen
}

// Eine Großziffer 10x8 (Stunden & Minuten) in die LED-Matrix schreiben
void matrix_digit2(uint8_t d, uint16_t col) {                         // d: auszugebende Ziffer (0-9), col: Farbwert 16 Bit
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle

  offset = d * 16;                                                    // Tabellen-Offset berechnen
  for (y = 0; y < 8; y ++) {                                          // 8 Zeilen mit je 2 Bytes ausgeben
    b = pgm_read_byte(&digit_2_array[offset ++]);                     // Zeilenbyte 1 holen
    for (x = 2; x > 0; x --) {                                        // Zeilenbyte 1 bitweise ausgeben
      if (b & 1) display->drawPixel(posx + x - 1, posy + y, col);     // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b >>= 1;                                                        // nächste Bit-Position an LSB
    }
    b = pgm_read_byte(&digit_2_array[offset ++]);                     // Zeilenbyte 2 holen
    for (x = 8; x > 0; x --) {                                        // Zeilenbyte 2 bitweise ausgeben
      if (b & 1) display->drawPixel(posx + x + 1, posy + y, col);     // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b >>= 1;                                                        // nächste Bit-Position an LSB
    }
  }
  posx += 12;                                                         // X-Position für nächstes Zeichen
}

// Eine Kleinziffer 5x8 (Sekunden & Tag) in die LED-Matrix schreiben
void matrix_digit3(uint8_t d, uint16_t col) {                         // d: auszugebende Ziffer (0-9), col: Farbwert 16 Bit
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle

  offset = d * 8;                                                     // Tabellen-Offset berechnen
  for (y = 0; y < 8; y ++) {                                          // 8 Zeilenbytes ausgeben
    b = pgm_read_byte(&digit_3_array[offset ++]);                     // Zeilenbyte holen
    for (x = 5; x > 0; x --) {                                        // Zeilenbyte bitweise ausgeben
      if (b & 1) display->drawPixel(posx + x - 1, posy + y, col);     // wenn Pixel gesetzt werden muss -> LSB als Pixel ausgeben
      b >>= 1;                                                        // nächste Bit-Position an LSB
    }
  }
  posx += 6;                                                          // X-Position für nächstes Zeichen
}

// Die Pixelbreite eines Zeichens ermitteln
uint8_t chrw(uint8_t c) {                                             // c: Zeichen
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t charw = 0;                                                  // Pixelbreite des Zeichens zunächst auf 0 setzen

  if (c == 0) c = 127;                                                // wenn Nullzeichen -> durch Endezeichen ersetzen
  if (c >= 32) {                                                      // wenn zulässiger Zeichencode
    offset = (c - 32) * 12;                                           // Tabellen-Offset berechnen
    charw = pgm_read_byte(&charset_normal_array[offset]);             // Zeichenbreite holen
    if (charw > 8) charw = 8;                                         // Zeichenbreite auf 8 begrenzen
  }
  return charw;                                                       // Pixelbreite zurückgeben
}

// Die Pixelbreite eines reduzierten Zeichens ermitteln
uint8_t chrwr(uint8_t c) {                                            // c: Zeichen
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t charw = 0;                                                  // Pixelbreite des Zeichens zunächst auf 0 setzen

  if (c == 0) c = 127;                                                // wenn Nullzeichen -> durch Endezeichen ersetzen
  if (c >= 32) {                                                      // wenn zulässiger Zeichencode
    offset = (c - 32) * 10;                                           // Tabellen-Offset berechnen
    charw = pgm_read_byte(&charset_reduced_array[offset]);            // Zeichenbreite holen
    if (charw > 8) charw = 8;                                         // Zeichenbreite auf 8 begrenzen
  }
  return charw;                                                       // Pixelbreite zurückgeben
}

// Die Pixelbreite eines Strings im Flash-Speicher ermitteln
uint8_t strw(uint8_t strnr) {                                         // strnr: String-Nummer im Flash-Speicher
  uint8_t i = 0;                                                      // Zeichenzähler
  uint8_t pw = 0;                                                     // Speicher für Pixelbreite

  strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&stringsd[strnr]));           // String in den RAM-Puffer kopieren
  while (strbuf[i] > 0) {                                             // Schleife bis zum Endezeichen (0)
    pw += chrw(strbuf[i ++]) + 1;                                     // Pixelbreite eines Zeichens und einen Zwischenraum addieren
  }
  if (pw > 0) pw --;                                                  // wenn Pixelbreite > 0 -> korrigieren
  return pw;                                                          // Pixelbreite zurückgeben
}

// Die Pixelbreite eines reduzierten Strings im Flash-Speicher ermitteln (2 Zeichen für Wochentag)
uint8_t strwr2(uint8_t strnr) {                                       // strnr: String-Nummer im Flash-Speicher
  uint8_t i = 0;                                                      // Zeichenzähler
  uint8_t pw = 0;                                                     // Speicher für Pixelbreite

  strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&stringsd[strnr]));           // String in den RAM-Puffer kopieren
  while ((strbuf[i] > 0) && (i < 2)) {                                // Schleife bis zum Endezeichen (0) oder bis zum zweiten Zeichen
    pw += chrwr(strbuf[i ++]) + 1;                                    // Pixelbreite eines reduzierten Zeichens und einen Zwischenraum addieren
  }
  if (pw > 0) pw --;                                                  // wenn Pixelbreite > 0 -> korrigieren
  return pw;                                                          // Pixelbreite zurückgeben
}

// Die Pixelbreite eines speziellen Symbols ermitteln
uint8_t symbolsw(uint8_t num) {                                       // num: Nummer des Symbols (0-6)
  int8_t i;                                                           // Zählervariable
  uint8_t b;                                                          // Symbolbreite
  PGM_P p;                                                            // Zeiger auf Symbol-Speicheradresse

  p = (PGM_P) &symbols;                                               // Symbol-Startadresse setzen
  for (i = 0; i < num; i ++) {                                        // Schleife zur Ermittlung der Startadresse des gewünschten Symbols
    b = pgm_read_byte(p ++);                                          // Symbolbreite holen
    p += b * 11;                                                      // Symbol-Startadresse auf nächstes Symbol setzen
  }
  return pgm_read_byte(p) + 1;                                        // Pixelbreite zurückgeben
}

// Die Pixelbreite eines Datenfeld-Elements ermitteln
uint8_t datafieldw(uint8_t pos) {                                     // pos: Feldposition
  uint8_t i = 0;                                                      // Zeichenzähler
  uint8_t pw = 0;                                                     // Speicher für Pixelbreite
  char c;                                                             // Zwischenspeicher für Windpfeil- oder Icon-Kennung

  while (i < 12) {                                                    // Schleife für 12 Zeichen
    if (datarray[pos][i] > 0) {                                       // wenn kein Nullzeichen
      if ((datarray[pos][i] == '$') && (i < 11)) {                    // wenn ein Windpfeil oder Icon ausgegeben werden soll und noch nicht das letzte Zeichen erreicht ist
        i ++;                                                         // Zähler auf nächstes Zeichen
        c = datarray[pos][i];                                         // Windpfeil- oder Icon-Kennung holen
        if (c > 0) {                                                  // wenn kein Nullzeichen
          i ++;                                                       // Zähler auf nächstes Zeichen
          if ((c >= 'A') && (c <= 'S')) pw += 25;                     // wenn Icon-Kennung Zwischen A und S -> Icon-Breite und Zwischenraum addieren
          if ((c >= '0') && (c <= '8')) pw += chrw(c - '0' + 144) + 1; // wenn Windpfeil-Kennung zwischen 0 und 8 -> Windpfeil-Breite und Zwischenraum addieren
          if ((c >= 'T') && (c <= 'Z')) pw += symbolsw(c - 'T');      // wenn spezielles Symbol -> Symbol-Breite addieren
        }
      }
      else pw += chrw(datarray[pos][i ++]) + 1;                       // wenn kein Windpfeil oder Icon ausgegeben werden soll -> Pixelbreite eines Zeichens und einen Zwischenraum addieren
    }
    else break;                                                       // wenn Nullzeichen -> Abbruch
  }
  if (pw > 0) pw --;                                                  // wenn Pixelbreite > 0 -> letzten Zwischenraum entfernen
  return pw;                                                          // Pixelbreite zurückgeben
}

// Die Pixelbreite eines Alarmfeld-Elements ermitteln
uint8_t alarmfieldw(uint8_t pos) {                                    // pos: Feldposition
  uint8_t i = 0;                                                      // Zeichenzähler
  uint8_t pw = 0;                                                     // Speicher für Pixelbreite

  while (i < 12) {                                                    // Schleife für 12 Zeichen
    if (alarmarray[pos][i] > 0) pw += chrw(alarmarray[pos][i ++]) + 1; // wenn kein Nullzeichen -> Pixelbreite eines Zeichens und einen Zwischenraum addieren
    else break;                                                       // wenn Nullzeichen -> Abbruch
  }
  if (pw > 0) pw --;                                                  // wenn Pixelbreite > 0 -> korrigieren
  return pw;                                                          // Pixelbreite zurückgeben
}

// Ein ASCII-Zeichen in die LED-Matrix schreiben
void matrix_chr(char c, uint16_t col1, uint16_t col2) {               // c: auszugebendes Zeichen (ASCII), col1: Hauptfarbe 16 Bit, col2: Unterstreichungsfarbe 16 Bit
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t cwidth;                                                     // Pixelbreite des Zeichens
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle

  if (c == 0) c = 127;                                                // wenn Nullzeichen -> durch Endezeichen ersetzen
  if (c >= 32) {                                                      // Ausgabe nur bei zulässigem Zeichencode
    offset = (c - 32) * 12;                                           // Tabellen-Offset berechnen
    cwidth = pgm_read_byte(&charset_normal_array[offset]);            // Zeichenbreite holen
    if (cwidth > 8) cwidth = 8;                                       // Zeichenbreite auf 8 begrenzen
    if (col1 != col2) {                                               // wenn Unterstreichungsfarbe abweichend von Hauptfarbe
      display->drawPixel(posx - 1, posy + 10, col2);                  // ein Pixel links neben dem Zeichen setzen (Unterstreichung)
      display->drawPixel(posx + cwidth, posy + 10, col2);             // ein Pixel rechts neben dem Zeichen setzen (Unterstreichung)
    }
    for (y = 0; y < 11; y ++) {                                       // 11 Zeilenbytes ausgeben
      b = pgm_read_byte(&charset_normal_array[offset + y + 1]);       // Zeilenbyte holen
      for (x = cwidth; x > 0; x --) {                                 // Zeilenbyte bitweise ausgeben
        if ((y < 10) && (b & 1))                                      // wenn Pixelzeile 0-9 und Bit gesetzt
          display->drawPixel(posx + x - 1, posy + y, col1);           // Pixel normal setzen
        if (y == 10) {                                                // wenn Pixelzeile 10
          if (b & 1) display->drawPixel(posx + x - 1, posy + y, col1); // wenn Bit gesetzt -> Pixel normal setzen
          else {                                                      // kein Bit gesetzt
            if (col1 != col2) {                                       // wenn Unterstreichungsfarbe abweichend von Hauptfarbe
              display->drawPixel(posx + x - 1, posy + y, col2);       // Unterstreichungs-Pixel setzen
            }
          }
        }
        b >>= 1;                                                      // nächstes Bit an Ausgabe-Position
      }
    }
    posx += cwidth + 1;                                               // X-Position für nächstes Zeichen
  }
}

// Ein reduziertes ASCII-Zeichen in die LED-Matrix schreiben
void matrix_chrr(char c, uint16_t col) {                              // c: auszugebendes Zeichen (ASCII), col: Farbwert 16 Bit
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t cwidth;                                                     // Pixelbreite des Zeichens
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle

  if (c == 0) c = 127;                                                // wenn Nullzeichen -> durch Endezeichen ersetzen
  if (c >= 32) {                                                      // Ausgabe nur bei zulässigem Zeichencode
    offset = (c - 32) * 10;                                           // Tabellen-Offset berechnen
    cwidth = pgm_read_byte(&charset_reduced_array[offset]);           // Zeichenbreite holen
    if (cwidth > 8) cwidth = 8;                                       // Zeichenbreite auf 8 begrenzen
    for (y = 0; y < 9; y ++) {                                        // 9 Zeilenbytes ausgeben
      b = pgm_read_byte(&charset_reduced_array[offset + y + 1]);      // Zeilenbyte holen
      for (x = cwidth; x > 0; x --) {                                 // Zeilenbyte bitweise ausgeben
        if (b & 1) display->drawPixel(posx + x - 1, posy + y, col);   // wenn Bit gesetzt -> Pixel setzen
        b >>= 1;                                                      // nächstes Bit an Ausgabe-Position
      }
    }
    posx += cwidth + 1;                                               // X-Position für nächstes Zeichen
  }
}

// Ein Wetter-Icon als Grafik in die LED-Matrix schreiben
void matrix_icon(uint8_t n) {                                         // n: auszugebende Icon-Nummer
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t c;                                                          // Zwischenspeicher für Farbwert
  PGM_P p;                                                            // Zeiger auf Icon-Speicheradresse

  p = (PGM_P) &iconarray + n * 264;                                   // Icon-Adresse berechnen
  for (y = 0; y < 11; y ++) {                                         // 11 Zeilen ausgeben
    for (x = 0; x < 24; x ++) {                                       // 24 Bytes (24 Pixel) ausgeben
      c = pgm_read_byte(p ++);                                        // Farbwert holen
      if (c > 0) {                                                    // wenn Farbwert > 0
        display->drawPixel(posx + x, posy + y, matrix_color(c - 1));  // Pixel ausgeben
      }
    }
  }
  posx += 25;                                                         // X-Position für nächstes Zeichen
}

// Ein spezielles Symbol in die LED-Matrix schreiben
void matrix_symbols(uint8_t num) {                                    // num: Nummer des Symbols (0-6)
  int8_t i;                                                           // Zählervariable
  uint8_t x;                                                          // Zähler für die Zeichenausgabe, X-Position
  uint8_t y;                                                          // Zähler für die Zeichenausgabe, Y-Position
  uint8_t b;                                                          // Symbolbreite
  uint8_t c;                                                          // Zwischenspeicher für Farbwert
  PGM_P p;                                                            // Zeiger auf Symbol-Speicheradresse

  p = (PGM_P) &symbols;                                               // Symbol-Startadresse setzen
  for (i = 0; i < num; i ++) {                                        // Schleife zur Ermittlung der Startadresse des gewünschten Symbols
    b = pgm_read_byte(p ++);                                          // Symbolbreite holen
    p += b * 11;                                                      // Symbol-Startadresse auf nächstes Symbol setzen
  }
  b = pgm_read_byte(p ++);                                            // Symbolbreite holen

  for (y = 0; y < 11; y ++) {                                         // 11 Zeilen ausgeben
    for (x = 0; x < b; x ++) {                                        // Anzahl Bytes (Pixel) entsprechend Symbolbreite ausgeben
      c = pgm_read_byte(p ++);                                        // Farbwert holen
      if (c > 0) {                                                    // wenn Farbwert > 0
        display->drawPixel(posx + x, posy + y, matrix_color(c - 1));  // Pixel ausgeben
      }
    }
  }
  posx += b + 1;                                                      // X-Position für nächstes Zeichen
}

// Einen String aus dem Flash-Speicher in die LED-Matrix schreiben
void matrix_str(uint8_t strnr, uint16_t col1, uint16_t col2) {        // strnr: String-Nummer im Flash-Speicher, col1: Hauptfarbe 16 Bit, col2: Unterstreichungsfarbe 16 Bit
  uint8_t i = 0;                                                      // Zeichenzähler auf erstes Zeichen setzen

  strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&stringsd[strnr]));           // String in den RAM-Puffer kopieren
  while (strbuf[i] > 0) {                                             // Schleife bis zum Endezeichen (0)
    matrix_chr(strbuf[i ++], col1, col2);                             // ein Zeichen ausgeben
  }
}

// Einen reduzierten String aus dem Flash-Speicher in die LED-Matrix schreiben (2 Zeichen für Wochentag)
void matrix_strr2(uint8_t strnr, uint16_t col) {                      // strnr: String-Nummer im Flash-Speicher, col: Farbwert 16 Bit
  uint8_t i = 0;                                                      // Zeichenzähler auf erstes Zeichen setzen

  strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&stringsd[strnr]));           // String in den RAM-Puffer kopieren
  while ((strbuf[i] > 0) && (i < 2)) {                                // Schleife bis zum Endezeichen (0) oder bis zum zweiten Zeichen
    matrix_chrr(strbuf[i ++], col);                                   // ein reduziertes Zeichen ausgeben
  }
}

// Ein Datenfeld-Element ausgeben
void matrix_datafield(uint8_t pos, uint16_t col1, uint16_t col2) {    // pos: Feldposition, col1: Hauptfarbe 16 Bit, col2: Unterstreichungsfarbe 16 Bit
  uint8_t i = 0;                                                      // Zeichenzähler auf erstes Zeichen setzen
  char c;                                                             // Zwischenspeicher für Windpfeil- oder Icon-Kennung

  while (i < 12) {                                                    // Schleife für 12 Zeichen
    if (datarray[pos][i] > 0) {                                       // wenn kein Nullzeichen
      if ((datarray[pos][i] == '$') && (i < 11)) {                    // wenn ein Windpfeil oder Icon ausgegeben werden soll und noch nicht das letzte Zeichen erreicht ist
        i ++;                                                         // Zähler auf nächstes Zeichen
        c = datarray[pos][i];                                         // Windpfeil- oder Icon-Kennung holen
        if (c > 0) {                                                  // wenn kein Nullzeichen
          i ++;                                                       // Zähler auf nächstes Zeichen
          if ((c >= 'A') && (c <= 'S')) matrix_icon(c - 'A');         // wenn Icon-Kennung Zwischen A und S -> Icon ausgeben
          if ((c >= '0') && (c <= '8')) matrix_chr(c - '0' + 144, col1, col2); // wenn Windpfeil-Kennung zwischen 0 und 8 -> Windpfeil ausgeben
          if ((c >= 'T') && (c <= 'Z')) matrix_symbols(c - 'T');      // wenn spezielles Symbol -> Symbol ausgeben
        }
      }
      else matrix_chr(datarray[pos][i ++], col1, col2);               // wenn kein Icon ausgegeben werden soll -> Zeichen normal ausgeben
    }
    else break;                                                       // wenn Nullzeichen -> Abbruch
  }
}

// Ein Alarmfeld-Element ausgeben
void matrix_alarmfield(uint8_t pos, uint16_t col1, uint16_t col2) {   // pos: Feldposition, col1: Hauptfarbe 16 Bit, col2: Unterstreichungsfarbe 16 Bit
  uint8_t i = 0;                                                      // Zeichenzähler auf erstes Zeichen setzen

  while (i < 12) {                                                    // Schleife für 12 Zeichen
    if (alarmarray[pos][i] > 0) matrix_chr(alarmarray[pos][i ++], col1, col2); // wenn kein Nullzeichen -> Zeichen ausgeben
    else break;                                                       // wenn Nullzeichen -> Abbruch
  }
}

// Alarme quittieren (durch Sensortaste oder Web-Seite)
void ack_alarms() {                                                   // keine Parameter
  uint8_t i;                                                          // Zählervariable
  bool f;                                                             // Status-Zwischenspeicher
  if (dispmode < 3) {                                                 // wenn normale, Alarm- oder Nachrichten-Anzeige aktiv
    quitcount = 0;                                                    // Quittierungszähler starten für Animation
    if (msg_flag) {                                                   // wenn Nachrichten-Flag gesetzt
      msg_flag = false;                                               // Nachrichten-Flag löschen
      msgpbend = 0;                                                   // Position vom Nachrichtenende löschen
    }
    else {                                                            // wenn Nachrichten-Flag nicht gesetzt
      for (i = 0; i < 8; i ++) {                                      // 8 Alarm-Einträge durchsuchen
        if (alarmstat[i] == 0) alarmarray[i][0] = 0;                  // wenn Alarmstatus aus -> Alarmeintrag löschen
      }
      f = false;                                                      // Flag zunächst löschen
      for (i = 0; i < 8; i ++) {                                      // 8 Alarm-Einträge durchsuchen
        if (alarmarray[i][0] > 0) f = true;                           // wenn Alarm-Eintrag gefunden -> Flag setzen
      }
      alarm_flag = f;                                                 // ermittelten Alarmstatus in Alarm-Flag übertragen
      if (alarm_flag) {                                               // wenn noch aktive Alarme anstehen
        alarmcount ++;                                                // Alarmfeldzähler erhöhen
        i = alarmcount;                                               // Zähler zwischenspeichern
        while (alarmcount < 8) {                                      // wiederholen solange Zähler im zulässigen Bereich
          if (alarmarray[alarmcount][0] > 0) break;                   // wenn belegtes Alarmfeld gefunden -> Abbruch
          alarmcount ++;                                              // Alarmfeldzähler erhöhen
        }
        if (alarmcount > 7) {                                         // wenn alle Alarmfelder ausgegeben
          alarmcount = 0;                                             // Zähler zurücksetzen und
          while (alarmcount < i) {                                    // weiter bis zum letzten Zählerstand suchen
            if (alarmarray[alarmcount][0] > 0) break;                 // wenn belegtes Alarmfeld gefunden -> Abbruch
            alarmcount ++;                                            // Alarmfeldzähler erhöhen
          }
        }
      }
    }
  }
}

// Prozentzeichen für die Web-Ausgabe maskieren, vermeidet Probleme mit dem Platzhalterzeichen % des Web-Servers
String percentmask(String sin) {                                      // sin: zu bearbeitender String
  uint8_t i;                                                          // Zählervariable
  String sout;                                                        // bearbeiteter String
  for (i = 0; i < sin.length(); i ++) {                               // alle Zeichen des Strings bearbeiten
    if (sin[i] == '%') sout += "&#37;";                               // wenn Prozentzeichen gefunden -> durch HTML-Code ersetzen
    else sout += sin[i];                                              // sonst Zeichen unverändert übernehmen
  }
  return sout;                                                        // bearbeiteten String zurückgeben
}

// Strings für die Laufzeit-Anzeige erstellen
void uptime_strings() {
  sprintf(uptime, "%.2f", (float) uptime_m / 24 / 60);                // Systemlaufzeit für MQTT-Ausgabe erstellen
  if (uptime_m < 60) {                                                // dynamische Systemlaufzeit für Web-Seite, wenn Zeit < 1 Stunde
    if (uptime_m == 1) sprintf(uptimex, "%u Minute", uptime_m);       // wenn Zeit = eine Minute -> Minute ausgeben
    else sprintf(uptimex, "%u Minuten", uptime_m);                    // sonst Minuten ausgeben
  }
  else {                                                              // wenn Zeit >= 1 Stunde
    if (uptime_m < 24 * 60) sprintf(uptimex, "%.1f Stunden", (float) uptime_m / 60); // wenn Zeit < 1 Tag -> Stunden ausgeben
    else sprintf(uptimex, "%.2f Tage", (float) uptime_m / 24 / 60);   // sonst Tage ausgeben
  }
}

// Schreiben einer Konfigurationsdatei in das Dateisystem
bool write_cfgfile(String filename, uint8_t lines) {                  // filename: Dateiname, lines: Anzahl der zu schreibenden Zeilen
  uint8_t linecnt;                                                    // Zeilenzähler

  if (filestat) {                                                     // wenn Dateisystem ok
    File cfgfile = LittleFS.open(filename, "w");                      // Datei zum Schreiben öffnen
    for (linecnt = 0; linecnt < lines; linecnt ++) {                  // Schleife zum Schreiben der Zeilen
      cfgfile.println(filedata[linecnt]);                             // eine Zeile schreiben
    }
    cfgfile.close();                                                  // Datei schließen
    return true;                                                      // Schreiben war erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Schreiben war nicht erfolgreich
}

// Lesen einer Konfigurationsdatei aus dem Dateisystem
bool read_cfgfile(String filename, uint8_t lines) {                   // filename: Dateiname, lines: Anzahl der zu lesenden Zeilen
  String readstr = "";                                                // String-Zwischenspeicher
  char readchar;                                                      // Zeichen-Zwischenspeicher
  uint8_t linecnt;                                                    // Zeilenzähler
  uint8_t i;                                                          // Schleifenzähler

  for (i = 0; i < FILEDATA; i ++) filedata[i] = "";                   // Dateipuffer löschen
  if (filestat) {                                                     // wenn Dateisystem ok
    if (lines > FILEDATA) lines = FILEDATA;                           // Zeilenanzahl auf verfügbare Pufferzeilen begrenzen
    File cfgfile = LittleFS.open(filename, "r");                      // Datei zum Lesen öffnen
    if (cfgfile) {                                                    // wenn Datei vorhanden
      while (cfgfile.available() && (linecnt < lines)) {              // Schleife bis alle Daten gelesen sind
        readchar = cfgfile.read();                                    // einzelnes Zeichen aus Datei lesen
        if (readchar >= 32) readstr += readchar;                      // wenn kein Steuerzeichen -> an String-Zwischenspeicher anhängen
        if (readchar == '\n') {                                       // wenn Zeilenende (LF/10)
          filedata[linecnt] = readstr;                                // Zeile in Dateipuffer speichern
          readstr = "";                                               // String-Zwischenspeicher wieder löschen
          linecnt ++;                                                 // nächste Zeile
        }
      }
      cfgfile.close();                                                // Datei schließen
      return true;                                                    // Lesen war erfolgreich
    }
    else return false;                                                // Datei nicht vorhanden -> Lesen war nicht erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Lesen war nicht erfolgreich
}

// Schreiben der Geburtstagliste in das Dateisystem
bool write_bdayfile() {
  uint8_t linecnt;                                                    // Zeilenzähler

  if (filestat) {                                                     // wenn Dateisystem ok
    File bdayfile = LittleFS.open(bday_filename, "w");                // Geburtstagsdatei zum Schreiben öffnen
    for (linecnt = 0; linecnt < MAXBDAYS; linecnt ++) {               // Schleife zum Schreiben der Zeilen
      if (birthdays[linecnt] == "") break;                            // wenn leerer String -> Ende
      bdayfile.println(birthdays[linecnt]);                           // eine Zeile schreiben
    }
    bdayfile.close();                                                 // Geburtstagsdatei schließen
    return true;                                                      // Schreiben war erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Schreiben war nicht erfolgreich
}

// Lesen der Geburtstagsliste aus dem Dateisystem
bool read_bdayfile() {
  String readstr = "";                                                // String-Zwischenspeicher
  char readchar;                                                      // Zeichen-Zwischenspeicher
  uint8_t linecnt;                                                    // Zeilenzähler
  uint8_t i;                                                          // Schleifenzähler

  for (i = 0; i < MAXBDAYS; i ++) birthdays[i] = "";                  // Geburtstagsliste löschen
  if (filestat) {                                                     // wenn Dateisystem ok
    File bdayfile = LittleFS.open(bday_filename, "r");                // Geburtstagsdatei zum Lesen öffnen
    if (bdayfile) {                                                   // wenn Datei vorhanden
      while (bdayfile.available() && (linecnt < MAXBDAYS)) {          // Schleife bis alle Daten gelesen sind
        readchar = bdayfile.read();                                   // einzelnes Zeichen aus Datei lesen
        if (readchar >= 32) readstr += readchar;                      // wenn kein Steuerzeichen -> an String-Zwischenspeicher anhängen
        if (readchar == '\n') {                                       // wenn Zeilenende (LF/10)
          birthdays[linecnt] = readstr;                               // Zeile in Geburtstagsliste speichern
          readstr = "";                                               // String-Zwischenspeicher wieder löschen
          linecnt ++;                                                 // nächste Zeile
        }
      }
      bdayfile.close();                                               // Geburtstagsdatei schließen
      return true;                                                    // Lesen war erfolgreich
    }
    else return false;                                                // Datei nicht vorhanden -> Lesen war nicht erfolgreich
  }
  else return false;                                                  // Dateisystemfehler -> Lesen war nicht erfolgreich
}

// Geburtstags-Datenfeld sortieren
void bdaysort() {
  int8_t i, j;                                                        // Zählervariablen
  String bdaytemp;                                                    // Zwischenspeicher für Geburtstagseintrag

  for (i = 0; i < MAXBDAYS; i ++) {                                   // Datenfeld neu organisieren: "jjjjmmtt Name" -> "mmttjjjj Name"
    if (birthdays[i] != "") {                                         // wenn Eintrag Daten enthält
      bdaytemp = birthdays[i].substring(4, 8) + birthdays[i].substring(0, 4) + birthdays[i].substring(8); // String umbauen und zwischenspeichern
      birthdays[i] = bdaytemp;                                        // geänderten Eintrag speichern
    }
    else birthdays[i] = "Z";                                          // wenn Eintrag keine Daten enthält -> Dummy-String setzen
  }
  for (j = MAXBDAYS - 1; j >= 0; j --) {                              // Bubblesort-Algorithmus, außere Schleife vom letzten Element bis 0
    for (i = 0; i < j; i ++) {                                        // innere Schleife von 0 bis zum Wert der äußeren Schleife
      if (birthdays[i] > birthdays[i + 1]) {                          // wenn größeres Element vor kleinerem Element -> tauschen
        bdaytemp = birthdays[i];                                      // größeres Element zwischenspeichern
        birthdays[i] = birthdays[i + 1];                              // kleineres Element eine Position nach unten
        birthdays[i + 1] = bdaytemp;                                  // zwischengespeichertes größeres Element nach hinten
      }
    }
  }
  for (i = 0; i < MAXBDAYS; i ++) {                                   // ursprüngliche Datenfeld-Ordnung wieder herstellen: "mmttjjjj Name" -> "jjjjmmtt Name"
    if (birthdays[i] != "Z") {                                        // wenn Eintrag keinen Dummy-String enthält
      bdaytemp = birthdays[i].substring(4, 8) + birthdays[i].substring(0, 4) + birthdays[i].substring(8); // String umbauen und zwischenspeichern
      birthdays[i] = bdaytemp;                                        // geänderten Eintrag speichern
    }
    else birthdays[i] = "";                                           // wenn Dummy-Eintrag -> String löschen
  }
  for (bdaycount = 0; bdaycount < MAXBDAYS; bdaycount ++) {           // Anzahl der Einträge ermitteln
    if (birthdays[bdaycount] == "") break;                            // wenn leerer String -> Ende
  }
}

// Web-Server, übergebene Datei ist nicht vorhanden
void notFound(AsyncWebServerRequest *request) {
  if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
  request->send(404, "text/plain", "Seite nicht gefunden");           // Fehlertext ausgeben
}

// Übergebenen String in Kleinbuchstaben umwandeln
String lowercase(String s) {                                          // s: zu bearbeitender String
  uint8_t i;                                                          // Zählervariable

  for (i = 0; i < s.length(); i ++) s[i] = toLowerCase(s[i]);         // String zeichenweise in Kleinbuchstaben wandeln
  return s;                                                           // bearbeiteten String zurückgeben
}

// Kommando zum Abspielen an Soundmodul senden
void play_sound(uint8_t n) {                                          // n: Soundnummer (0-5)
  uint8_t i;                                                          // Zählervariable
  PGM_P p;                                                            // Zeiger auf Tabelle der Sound-Kommandos

  if (n < 6) {                                                        // wenn gültige Soundnummer
    p = (PGM_P) &soundcmds + n * 6;                                   // Adresse auf Sound-Kommando setzen
    for (i = 0; i < 6; i ++) {                                        // 6 Byte ausgeben
      Serial2.print(char(pgm_read_byte(p ++)));                       // Zeichen an Soundmodul senden
    }
  }
}

// Kommando zur Einstellung der Lautstärke an Soundmodul senden
void send_volume(uint8_t v) {                                         // v: Lautstärke (0-30)
  if (v < 31) {                                                       // wenn gültige Lautstärke
    Serial2.print(char(170));                                         // Start Code an Soundmodul senden
    Serial2.print(char(19));                                          // Lautstärke-Kommando senden
    Serial2.print(char(1));                                           // Anzahl der Datenbytes senden
    Serial2.print(char(v));                                           // Lautstärkewert senden
    Serial2.print(char(190 + v));                                     // Prüfsumme senden
  }
}

// Callback-Function bei Zeit-Synchronisierung über ntp
void timesync(struct timeval *time) {
  Serial.println("Uhr wurde synchronisiert");
  if (syncstat == 0) {                                                // wenn erste Synchronisierung nach Systemstart
    setenv("TZ", time_zone_p, 1);                                     // Zeitzonen-Information einstellen
    tzset();
  }
  syncstat = 2;                                                       // Status auf synchronisiert setzen
  synctout = time_ival * 3;                                           // Timeout-Zähler auf 3 NTP-Intervalle setzen
}

// MQTT-CallBack-Funktion für den Nachrichtenempfang
void onMqttMessage(const espMqttClientTypes::MessageProperties& properties, const char* topic, const uint8_t* payload, size_t len, size_t index, size_t total) {
  uint8_t i;                                                          // Zählervariable
  uint j, maxchars;                                                   // Zählervariable und maximale Zeichenanzahl
  bool found = false;                                                 // Merker wird gesetzt, wenn Topic gefunden (weitere Suchen werden dann nicht durchgeführt)

  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > JSONBUFF - 1) maxchars = JSONBUFF - 1;             // maximale Zeichenanzahl begrenzen
    if (sensorlist_p[12]) {                                           // wenn MQTT-Topic vorhanden
      if (sensorlist[12] == topic) {                                  // wenn Topic übereinstimmt
        for (j = 0; j < maxchars; j ++) {                             // alle Zeichen im Payload
          weatherjson[j] = payload[j];                                // in Wetterdaten kopieren
        }
        weatherjson[j] = 0;                                           // String-Ende setzen
        weathertime = millis();                                       // Zeitstempel speichern
        weatherflag = true;                                           // neue Wetterdaten zum Verarbeiten empfangen
        found = true;                                                 // Topic wurde gefunden
      }
    }
  }
  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > JSONBUFF - 1) maxchars = JSONBUFF - 1;             // maximale Zeichenanzahl begrenzen
    if (sensorlist_p[13]) {                                           // wenn MQTT-Topic vorhanden
      if (sensorlist[13] == topic) {                                  // wenn Topic übereinstimmt
        for (j = 0; j < maxchars; j ++) {                             // alle Zeichen im Payload
          fueljson[j] = payload[j];                                   // in Kraftstoffdaten kopieren
        }
        fueljson[j] = 0;                                              // String-Ende setzen
        fueltime = millis();                                          // Zeitstempel speichern
        fuelflag = true;                                              // neue Kraftstoffdaten zum Verarbeiten empfangen
        found = true;                                                 // Topic wurde gefunden
      }
    }
  }
  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > 99) maxchars = 99;                                 // maximale Zeichenanzahl begrenzen
    if (sensorlist_p[14]) {                                           // wenn MQTT-Topic vorhanden
      if (sensorlist[14] == topic) {                                  // wenn Topic übereinstimmt
        message = "";                                                 // Textnachricht löschen
        for (j = 0; j < maxchars; j ++) {                             // alle Zeichen im Payload
          message += char(payload[j]);                                // an Textnachricht anfügen
        }
        messageflag = true;                                           // Textnachricht-Flag setzen
        found = true;                                                 // Topic wurde gefunden
      }
    }
  }
  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > SENCHARS - 1) maxchars = SENCHARS - 1;             // maximale Zeichenanzahl begrenzen
    for (i = 0; i < 12; i ++) {                                       // 12 MQTT-Topics der Sensorliste prüfen
      if (sensorlist_p[i]) {                                          // wenn MQTT-Topic vorhanden
        if (sensorlist[i] == topic) {                                 // wenn Topic mit Nachricht übereinstimmt
          for (j = 0; j < maxchars; j ++) {                           // alle Zeichen im Payload
            sensorvals[i][j] = payload[j];                            // in Sensorwertefeld kopieren
          }
          sensorvals[i][j] = 0;                                       // String-Ende setzen
          sensortime[i] = millis();                                   // Zeitstempel speichern
          found = true;                                               // Topic wurde gefunden
          break;                                                      // Schleife abbrechen
        }
      }
    }
  }
  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > ALMCHARS - 1) maxchars = ALMCHARS - 1;             // maximale Zeichenanzahl begrenzen
    for (i = 0; i < 4; i ++) {                                        // 4 MQTT-Topics der Alarmliste prüfen
      if (alarmlist_p[i]) {                                           // wenn MQTT-Topic vorhanden
        if (alarmlist[i] == topic) {                                  // wenn Topic mit Nachricht übereinstimmt
          for (j = 0; j < maxchars; j ++) {                           // alle Zeichen im Payload
            alarmvals[i][j] = payload[j];                             // in Alarmwertefeld kopieren
          }
          alarmvals[i][j] = 0;                                        // String-Ende setzen
          alarmflags[i] = true;                                       // Alarm-Flag setzen
          found = true;                                               // Topic wurde gefunden
          break;                                                      // Schleife abbrechen
        }
      }
    }
  }
  if (!found) {                                                       // wenn Topic noch nicht gefunden
    maxchars = len;                                                   // Nachrichtenlänge kopieren
    if (maxchars > CALLCHRS - 1) maxchars = CALLCHRS - 1;             // maximale Zeichenanzahl begrenzen
    for (i = 0; i < 4; i ++) {                                        // 4 MQTT-Topics der Anrufliste prüfen
      if (call_list_p[i]) {                                           // wenn MQTT-Topic vorhanden
        if (call_list[i] == topic) {                                  // wenn Topic mit Nachricht übereinstimmt
          for (j = 0; j < maxchars; j ++) {                           // alle Zeichen im Payload
            callvals[i][j] = payload[j];                              // in Anrufdatenfeld kopieren
          }
          callvals[i][j] = 0;                                         // String-Ende setzen
          found = true;                                               // Topic wurde gefunden
          break;                                                      // Schleife abbrechen
        }
      }
    }
  }
}

// Initialisierungs-Sequenz für FM6126A-Treiber (https://github.com/mrfaptastic/ESP32-HUB75-MatrixPanel-DMA/issues/23)
void init_fm6126a() {
  int MaxLed = 64;                                                    // maximale LED-Anzahl
  int C12[16] = {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};     // Daten für Chip-Register 12
  int C13[16] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0};     // Daten für Chip-Register 13

  pinMode(R1_PIN, OUTPUT);                                            // alle Panel-Pins initialisieren
  pinMode(G1_PIN, OUTPUT);
  pinMode(B1_PIN, OUTPUT);
  pinMode(R2_PIN, OUTPUT);
  pinMode(G2_PIN, OUTPUT);
  pinMode(B2_PIN, OUTPUT);
  pinMode(A_PIN, OUTPUT);
  pinMode(B_PIN, OUTPUT);
  pinMode(C_PIN, OUTPUT);
  pinMode(D_PIN, OUTPUT);
  pinMode(CLK_PIN, OUTPUT);
  pinMode(LAT_PIN, OUTPUT);
  pinMode(OE_PIN, OUTPUT);

  digitalWrite(OE_PIN, HIGH);                                         // Display-Reset
  digitalWrite(LAT_PIN, LOW);
  digitalWrite(CLK_PIN, LOW);

  for (int l = 0; l < MaxLed; l ++) {                                 // Daten in Register 12 senden
    int y = l % 16;                                                   // Bitposition ermitteln
    digitalWrite(R1_PIN, LOW);                                        // alle Farbausgänge auf Low setzen
    digitalWrite(G1_PIN, LOW);
    digitalWrite(B1_PIN, LOW);
    digitalWrite(R2_PIN, LOW);
    digitalWrite(G2_PIN, LOW);
    digitalWrite(B2_PIN, LOW);
    if (C12[y] == 1) {                                                // wenn Datenbit High
      digitalWrite(R1_PIN, HIGH);                                     // alle Farbausgänge auf High setzen
      digitalWrite(G1_PIN, HIGH);
      digitalWrite(B1_PIN, HIGH);
      digitalWrite(R2_PIN, HIGH);
      digitalWrite(G2_PIN, HIGH);
      digitalWrite(B2_PIN, HIGH);
    }
    if (l > MaxLed - 12) digitalWrite(LAT_PIN, HIGH);                 // wenn Schiebregister-Position für Register 12 erreicht -> LAT auf High setzen
    else digitalWrite(LAT_PIN, LOW);                                  // sonst LAT auf Low setzen
    digitalWrite(CLK_PIN, HIGH);                                      // CLK auf High setzen (Taktimpuls)
    digitalWrite(CLK_PIN, LOW);                                       // CLK auf Low setzen
  }
  digitalWrite(LAT_PIN, LOW);                                         // nach Register-Ausgabe LAT wieder auf Low setzen
  digitalWrite(CLK_PIN, LOW);                                         // CLK wieder auf Low setzen

  for (int l = 0; l < MaxLed; l ++) {                                 // Daten in Register 13 senden
    int y = l % 16;                                                   // Bitposition ermitteln
    digitalWrite(R1_PIN, LOW);                                        // alle Farbausgänge auf Low setzen
    digitalWrite(G1_PIN, LOW);
    digitalWrite(B1_PIN, LOW);
    digitalWrite(R2_PIN, LOW);
    digitalWrite(G2_PIN, LOW);
    digitalWrite(B2_PIN, LOW);
    if (C13[y] == 1) {                                                // wenn Datenbit High
      digitalWrite(R1_PIN, HIGH);                                     // alle Farbausgänge auf High setzen
      digitalWrite(G1_PIN, HIGH);
      digitalWrite(B1_PIN, HIGH);
      digitalWrite(R2_PIN, HIGH);
      digitalWrite(G2_PIN, HIGH);
      digitalWrite(B2_PIN, HIGH);
    }
    if (l > MaxLed - 13) digitalWrite(LAT_PIN, HIGH);                 // wenn Schiebregister-Position für Register 13 erreicht -> LAT auf High setzen
    else digitalWrite(LAT_PIN, LOW);                                  // sonst LAT auf Low setzen
    digitalWrite(CLK_PIN, HIGH);                                      // CLK auf High setzen (Taktimpuls)
    digitalWrite(CLK_PIN, LOW);                                       // CLK auf Low setzen
  }
  digitalWrite(LAT_PIN, LOW);                                         // nach Register-Ausgabe LAT wieder auf Low setzen
  digitalWrite(CLK_PIN, LOW);                                         // CLK wieder auf Low setzen
}
