// Matrixuhr-ESP32, Scott-Falk Hühn, "charset.h"
// Zeichensatz-Definitionen

// Großziffern für Stunden und Minuten (18x10 Pixel, je 2x18 Bytes = 36 Bytes)
const uint8_t digit_1_array[] PROGMEM =
{
  0, 0xfc, 1, 0xfe, 3, 0x87, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,                      // Großziffer '0'
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0x87, 1, 0xfe, 0, 0xfc,
  0, 4, 0, 0x0c, 0, 0x1c, 0, 0x3c, 0, 0x7c, 0, 0xec, 0, 0xcc, 0, 0x0c, 0, 0x0c,       // Großziffer '1'
  0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c,
  0, 0xfc, 1, 0xfe, 3, 0x87, 3, 3, 0, 3, 0, 3, 0, 3, 0, 7, 0, 6,                      // Großziffer '2'
  0, 0x0e, 0, 0x1c, 0, 0x38, 0, 0x70, 0, 0xe0, 1, 0xc0, 3, 0x80, 3, 0xff, 3, 0xff,
  0, 0xfc, 1, 0xfe, 3, 0x87, 3, 3, 0, 3, 0, 3, 0, 3, 0, 7, 0, 0x3e,                   // Großziffer '3'
  0, 0x3e, 0, 7, 0, 3, 0, 3, 0, 3, 3, 3, 3, 0x87, 1, 0xfe, 0, 0xfc,
  0, 0x0c, 0, 0x0c, 0, 0x1c, 0, 0x1c, 0, 0x3c, 0, 0x3c, 0, 0x6c, 0, 0x6c, 0, 0xcc,    // Großziffer '4'
  0, 0xcc, 1, 0x8c, 1, 0x8c, 3, 0xff, 3, 0xff, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c,
  0, 0xfe, 1, 0xfe, 1, 0x80, 1, 0x80, 1, 0x80, 3, 0, 3, 0, 3, 0xfc, 3, 0xfe,          // Großziffer '5'
  3, 0x87, 0, 3, 0, 3, 0, 3, 0, 3, 3, 3, 3, 0x87, 1, 0xfe, 0, 0xfc,
  0, 0x18, 0, 0x38, 0, 0x70, 0, 0xe0, 0, 0xc0, 1, 0xc0, 1, 0x80, 3, 0xfc, 3, 0xfe,    // Großziffer '6'
  3, 0x87, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0x87, 1, 0xfe, 0, 0xfc,
  3, 0xff, 3, 0xff, 0, 3, 0, 7, 0, 6, 0, 0x0c, 0, 0x0c, 0, 0x18, 0, 0x18,             // Großziffer '7'
  0, 0x30, 0, 0x30, 0, 0x30, 0, 0x60, 0, 0x60, 0, 0x60, 0, 0x60, 0, 0x60, 0, 0x60,
  0, 0xfc, 1, 0xfe, 3, 0x87, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0x87, 1, 0xfe,                // Großziffer '8'
  1, 0xfe, 3, 0x87, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0x87, 1, 0xfe, 0, 0xfc,
  0, 0xfc, 1, 0xfe, 3, 0x87, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0x87,                   // Großziffer '9'
  1, 0xff, 0, 0xff, 0, 6, 0, 0x0e, 0, 0x0c, 0, 0x1c, 0, 0x38, 0, 0x70, 0, 0x60
};

// Großziffern für Stunden und Minuten (8x10 Pixel, je 2x8 Bytes = 16 Bytes)
const uint8_t digit_2_array[] PROGMEM =
{
  1, 0xfe, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 0xfe,                               // Großziffer '0'
  0, 0x0c, 0, 0x3c, 0, 0xcc, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c, 0, 0x0c,             // Großziffer '1'
  1, 0xfe, 3, 3, 0, 3, 0, 0x0c, 0, 0x30, 0, 0xc0, 3, 0, 3, 0xff,                      // Großziffer '2'
  1, 0xfe, 3, 3, 0, 3, 0, 0x3e, 0, 3, 0, 3, 3, 3, 1, 0xfe,                            // Großziffer '3'
  0, 0x1c, 0, 0x3c, 0, 0x6c, 0, 0xcc, 1, 0x8c, 3, 0xff, 0, 0x0c, 0, 0x0c,             // Großziffer '4'
  3, 0xfe, 3, 0, 3, 0, 3, 0xfe, 0, 3, 0, 3, 3, 3, 1, 0xfe,                            // Großziffer '5'
  0, 0xf8, 1, 0x80, 3, 0, 3, 0xfe, 3, 3, 3, 3, 3, 3, 1, 0xfe,                         // Großziffer '6'
  3, 0xff, 0, 3, 0, 6, 0, 0x0c, 0, 0x18, 0, 0x30, 0, 0x30, 0, 0x30,                   // Großziffer '7'
  1, 0xfe, 3, 3, 3, 3, 1, 0xfe, 3, 3, 3, 3, 3, 3, 1, 0xfe,                            // Großziffer '8'
  1, 0xfe, 3, 3, 3, 3, 3, 3, 1, 0xff, 0, 3, 0, 6, 0, 0x7c                             // Großziffer '9'
};

// Kleinziffern für Sekunden (8x5 Pixel, je 8 Bytes)
const uint8_t digit_3_array[] PROGMEM =
{
  14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 14,                   // Kleinziffer '0'
  2, 6, 10, 2, 2, 2, 2, 2,                                      // Kleinziffer '1'
  14, 0x11, 1, 2, 4, 8, 16, 0x1f,                               // Kleinziffer '2'
  14, 0x11, 1, 6, 1, 1, 0x11, 14,                               // Kleinziffer '3'
  2, 6, 10, 10, 0x12, 0x1f, 2, 2,                               // Kleinziffer '4'
  0x1f, 16, 16, 0x1e, 1, 1, 0x11, 14,                           // Kleinziffer '5'
  4, 8, 16, 0x1e, 0x11, 0x11, 0x11, 14,                         // Kleinziffer '6'
  0x1f, 1, 1, 2, 2, 4, 4, 4,                                    // Kleinziffer '7'
  14, 0x11, 0x11, 14, 0x11, 0x11, 0x11, 14,                     // Kleinziffer '8'
  14, 0x11, 0x11, 0x11, 15, 1, 2, 4,                            // Kleinziffer '9'
};

// ASCII-Zeichensatz in normaler Größe proportional, jedes Zeichen wird mit 12 Bytes definiert, Byte 0 enthält die
// Zeichenbreite (0-8), die restlichen Bytes enthalten zeilenweise die Bitmap des Zeichens, Beispiel Dollarzeichen
//
// Byte  0 = 5                                                  (Zeichen ist 5 Pixel breit)
// Byte  1 = 0          . . . . . . . .                         (Zeile für Umlaute)
// Byte  2 = 4          . . . . . # . .
// Byte  3 = 0x0e       . . . . # # # .
// Byte  4 = 0x14       . . . # . # . .
// Byte  5 = 0x0e       . . . . # # # .
// Byte  6 = 5          . . . . . # . #
// Byte  7 = 0x15       . . . # . # . #
// Byte  8 = 0x0e       . . . . # # # .
// Byte  9 = 4          . . . . . # . .
// Byte 10 = 0          . . . . . . . .                         (Zeile für Unterlängen)
// Byte 11 = 0          . . . . . . . .                         (Zeile für Unterlängen)

const uint8_t charset_normal_array[] PROGMEM =
{
  // ASCII 0x20 - 0x7f (normaler Zeichensatz)
  3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x20 032 ' '
  1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0,                           // Code 0x21 033 '!'
  5, 0, 0x1b, 0x1b, 9, 0x12, 0, 0, 0, 0, 0, 0,                  // Code 0x22 034 '"'
  5, 0, 0, 0x0a, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x0a, 0, 0,      // Code 0x23 035 '#'
  5, 0, 4, 0x0e, 0x14, 0x0e, 5, 0x15, 0x0e, 4, 0, 0,            // Code 0x24 036 '$'
  5, 0, 0x18, 0x19, 2, 4, 4, 8, 0x13, 3, 0, 0,                  // Code 0x25 037 '%'
  5, 0, 0x0c, 0x12, 0x12, 0x14, 8, 0x15, 0x12, 0x0d, 0, 0,      // Code 0x26 038 '&'
  2, 0, 3, 3, 1, 2, 0, 0, 0, 0, 0, 0,                           // Code 0x27 039 '''
  3, 0, 1, 2, 4, 4, 4, 4, 2, 1, 0, 0,                           // Code 0x28 040 '('
  3, 0, 4, 2, 1, 1, 1, 1, 2, 4, 0, 0,                           // Code 0x29 041 ')'
  5, 0, 0, 0, 0x0a, 4, 0x1f, 4, 0x0a, 0, 0, 0,                  // Code 0x2a 042 '*'
  3, 0, 0, 0, 0, 2, 7, 2, 0, 0, 0, 0,                           // Code 0x2b 043 '+'
  2, 0, 0, 0, 0, 0, 0, 0, 3, 3, 1, 2,                           // Code 0x2c 044 ','
  3, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0,                           // Code 0x2d 045 '-'
  1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,                           // Code 0x2e 046 '.'
  4, 0, 1, 1, 2, 2, 4, 4, 8, 8, 0, 0,                           // Code 0x2f 047 '/'

  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0, 0,   // Code 0x30 048 '0'
  5, 0, 2, 6, 0x0a, 2, 2, 2, 2, 2, 0, 0,                        // Code 0x31 049 '1'
  5, 0, 0x0e, 0x11, 1, 2, 4, 8, 0x10, 0x1f, 0, 0,               // Code 0x32 050 '2'
  5, 0, 0x0e, 0x11, 1, 6, 1, 1, 0x11, 0x0e, 0, 0,               // Code 0x33 051 '3'
  5, 0, 2, 6, 0x0a, 0x0a, 0x12, 0x1f, 2, 2, 0, 0,               // Code 0x34 052 '4'
  5, 0, 0x1f, 0x10, 0x10, 0x1e, 1, 1, 0x11, 0x0e, 0, 0,         // Code 0x35 053 '5'
  5, 0, 4, 8, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x0e, 0, 0,         // Code 0x36 054 '6'
  5, 0, 0x1f, 1, 1, 2, 2, 4, 4, 4, 0, 0,                        // Code 0x37 055 '7'
  5, 0, 0x0e, 0x11, 0x11, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0, 0,   // Code 0x38 056 '8'
  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x0f, 1, 2, 4, 0, 0,            // Code 0x39 057 '9'
  2, 0, 0, 0, 0, 3, 3, 0, 3, 3, 0, 0,                           // Code 0x3a 058 ':'
  2, 0, 0, 0, 0, 3, 3, 0, 3, 3, 1, 2,                           // Code 0x3b 059 ';'
  4, 0, 0, 1, 2, 4, 8, 4, 2, 1, 0, 0,                           // Code 0x3c 060 '<'
  5, 0, 0, 0, 0, 0x1f, 0, 0x1f, 0, 0, 0, 0,                     // Code 0x3d 061 '='
  4, 0, 0, 8, 4, 2, 1, 2, 4, 8, 0, 0,                           // Code 0x3e 062 '>'
  5, 0, 0x0e, 0x11, 1, 2, 4, 4, 0, 4, 0, 0,                     // Code 0x3f 063 '?'

  7, 0, 0x1e, 0x21, 0x4d, 0x55, 0x55, 0x4e, 0x20, 0x1e, 0, 0,   // Code 0x40 064 '@'
  5, 0, 0x04, 0x0a, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0, 0,   // Code 0x41 065 'A'
  5, 0, 0x1e, 0x11, 0x11, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0, 0,   // Code 0x42 066 'B'
  5, 0, 0x0e, 0x11, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0e, 0, 0,   // Code 0x43 067 'C'
  5, 0, 0x1c, 0x12, 0x11, 0x11, 0x11, 0x11, 0x12, 0x1c, 0, 0,   // Code 0x44 068 'D'
  5, 0, 0x1f, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x10, 0x1f, 0, 0,   // Code 0x45 069 'E'
  5, 0, 0x1f, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x10, 0x10, 0, 0,   // Code 0x46 070 'F'
  5, 0, 0x0e, 0x11, 0x10, 0x10, 0x13, 0x11, 0x11, 0x0e, 0, 0,   // Code 0x47 071 'G'
  5, 0, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x11, 0, 0,   // Code 0x48 072 'H'
  1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,                           // Code 0x49 073 'I'
  4, 0, 1, 1, 1, 1, 1, 1, 9, 6, 0, 0,                           // Code 0x4a 074 'J'
  5, 0, 0x11, 0x12, 0x14, 0x18, 0x18, 0x14, 0x12, 0x11, 0, 0,   // Code 0x4b 075 'K'
  5, 0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0, 0,   // Code 0x4c 076 'L'
  5, 0, 0x11, 0x1b, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0, 0,   // Code 0x4d 077 'M'
  5, 0, 0x11, 0x19, 0x19, 0x15, 0x15, 0x13, 0x13, 0x11, 0, 0,   // Code 0x4e 078 'N'
  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0, 0,   // Code 0x4f 079 'O'

  5, 0, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10, 0, 0,   // Code 0x50 080 'P'
  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x15, 0x12, 0x0d, 0, 0,   // Code 0x51 081 'Q'
  5, 0, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x14, 0x12, 0x11, 0, 0,   // Code 0x52 082 'R'
  5, 0, 0x0e, 0x11, 0x10, 0x0e, 1, 1, 0x11, 0x0e, 0, 0,         // Code 0x53 083 'S'
  5, 0, 0x1f, 4, 4, 4, 4, 4, 4, 4, 0, 0,                        // Code 0x54 084 'T'
  5, 0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0, 0,   // Code 0x55 085 'U'
  5, 0, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x0a, 4, 4, 0, 0,         // Code 0x56 086 'V'
  5, 0, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x0a, 0, 0,   // Code 0x57 087 'W'
  5, 0, 0x11, 0x11, 0x0a, 4, 0x0a, 0x11, 0x11, 0x11, 0, 0,      // Code 0x58 088 'X'
  5, 0, 0x11, 0x11, 0x11, 0x0a, 4, 4, 4, 4, 0, 0,               // Code 0x59 089 'Y'
  5, 0, 0x1f, 1, 2, 4, 4, 8, 0x10, 0x1f, 0, 0,                  // Code 0x5a 090 'Z'
  3, 0, 7, 4, 4, 4, 4, 4, 4, 7, 0, 0,                           // Code 0x5b 091 '['
  4, 0, 8, 8, 4, 4, 2, 2, 1, 1, 0, 0,                           // Code 0x5c 092 '\'
  3, 0, 7, 1, 1, 1, 1, 1, 1, 7, 0, 0,                           // Code 0x5d 093 ']'
  5, 0, 4, 0x0a, 0x11, 0, 0, 0, 0, 0, 0, 0,                     // Code 0x5e 094 '^'
  5, 0, 0, 0, 0, 0, 0, 0, 0, 0x1f, 0, 0,                        // Code 0x5f 095 '_'

  3, 0, 4, 2, 1, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x60 096 '`'
  5, 0, 0, 0, 0, 0x0e, 1, 0x0f, 0x11, 0x0f, 0, 0,               // Code 0x61 097 'a'
  5, 0, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0, 0,   // Code 0x62 098 'b'
  4, 0, 0, 0, 0, 7, 8, 8, 8, 7, 0, 0,                           // Code 0x63 099 'c'
  5, 0, 1, 1, 1, 0x0f, 0x11, 0x11, 0x11, 0x0f, 0, 0,            // Code 0x64 100 'd'
  5, 0, 0, 0, 0, 0x0e, 0x11, 0x1f, 0x10, 0x0e, 0, 0,            // Code 0x65 101 'e'
  3, 0, 1, 2, 2, 7, 2, 2, 2, 2, 0, 0,                           // Code 0x66 102 'f'
  5, 0, 0, 0, 0, 0x0f, 0x11, 0x11, 0x11, 0x0f, 1, 0x0e,         // Code 0x67 103 'g'
  5, 0, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x11, 0, 0,   // Code 0x68 104 'h'
  1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0,                           // Code 0x69 105 'i'
  2, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 2,                           // Code 0x6a 106 'j'
  4, 0, 8, 8, 8, 9, 0x0a, 0x0c, 0x0a, 9, 0, 0,                  // Code 0x6b 107 'k'
  2, 0, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0,                           // Code 0x6c 108 'l'
  5, 0, 0, 0, 0, 0x1a, 0x15, 0x15, 0x15, 0x15, 0, 0,            // Code 0x6d 109 'm'
  5, 0, 0, 0, 0, 0x16, 0x19, 0x11, 0x11, 0x11, 0, 0,            // Code 0x6e 110 'n'
  5, 0, 0, 0, 0, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0, 0,            // Code 0x6f 111 'o'

  5, 0, 0, 0, 0, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10,      // Code 0x70 112 'p'
  5, 0, 0, 0, 0, 0x0f, 0x11, 0x11, 0x11, 0x0f, 1, 1,            // Code 0x71 113 'q'
  4, 0, 0, 0, 0, 0x0a, 0x0d, 8, 8, 8, 0, 0,                     // Code 0x72 114 'r'
  5, 0, 0, 0, 0, 0x0e, 0x10, 0x0e, 1, 0x1e, 0, 0,               // Code 0x73 115 's'
  3, 0, 0, 2, 2, 7, 2, 2, 2, 1, 0, 0,                           // Code 0x74 116 't'
  5, 0, 0, 0, 0, 0x11, 0x11, 0x11, 0x11, 0x0e, 0, 0,            // Code 0x75 117 'u'
  5, 0, 0, 0, 0, 0x11, 0x11, 0x11, 0x0a, 4, 0, 0,               // Code 0x76 118 'v'
  5, 0, 0, 0, 0, 0x11, 0x11, 0x15, 0x15, 0x0a, 0, 0,            // Code 0x77 119 'w'
  5, 0, 0, 0, 0, 0x11, 0x0a, 4, 0x0a, 0x11, 0, 0,               // Code 0x78 120 'x'
  5, 0, 0, 0, 0, 0x11, 0x11, 0x11, 0x11, 0x0f, 1, 0x0e,         // Code 0x79 121 'y'
  5, 0, 0, 0, 0, 0x1f, 2, 4, 8, 0x1f, 0, 0,                     // Code 0x7a 122 'z'
  3, 0, 1, 2, 2, 4, 2, 2, 2, 1, 0, 0,                           // Code 0x7b 123 '{'
  1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0,                           // Code 0x7c 124 '|'
  3, 0, 4, 2, 2, 1, 2, 2, 2, 4, 0, 0,                           // Code 0x7d 125 '}'
  5, 0, 8, 0x15, 2, 0, 0, 0, 0, 0, 0, 0,                        // Code 0x7e 126 '~'
  3, 0, 0, 0, 0, 0, 0, 7, 7, 7, 0, 0,                           // Code 0x7f 127 Endezeichen

  // ASCII 0x80 - 0x8f (Umlaute und Sonderzeichen)
  5, 0x11, 4, 0x0a, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0, 0,   // Code 0x80 128 'Ä'
  5, 0x0a, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0, 0,   // Code 0x81 129 'Ö'
  5, 0x0a, 0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0, 0,   // Code 0x82 130 'Ü'
  5, 0, 0, 0x0a, 0, 0x0e, 1, 0x0f, 0x11, 0x0f, 0, 0,            // Code 0x83 131 'ä'
  5, 0, 0, 0x0a, 0, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0, 0,         // Code 0x84 132 'ö'
  5, 0, 0, 0x0a, 0, 0x11, 0x11, 0x11, 0x11, 0x0e, 0, 0,         // Code 0x85 133 'ü'
  5, 0, 0x0e, 0x11, 0x11, 0x16, 0x11, 0x11, 0x11, 0x16, 0, 0,   // Code 0x86 134 'ß'
  5, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0x0e, 0x1f,                     // Code 0x87 135 Pfeil nach oben, für Farbauswahl-Menü
  5, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0, 0, 0, 0,      // Code 0x88 136 Pixelblock hohl  \ gleiche
  5, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0, 0, 0, 0,      // Code 0x89 137 Pixelblock voll  / Zeichenbreite
  2, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8a 138 Grad-Zeichen
  5, 0, 0, 2, 4, 0x0e, 0x11, 0x1f, 0x10, 0x0e, 0, 0,            // Code 0x8b 139 'é'
  5, 0, 7, 8, 0x1e, 8, 0x1e, 8, 8, 7, 0, 0,                     // Code 0x8c 140 '€'
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8d 141 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8e 142 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8f 143 (nicht genutzt)

  // ASCII 0x90 - 0x98 (Windpfeile)
  7, 0, 0, 0, 0, 8, 0x1c, 8, 0, 0, 0, 0,                        // Code 0x90 144 Windpfeil aus
  7, 0, 0, 8, 0x1c, 0x2a, 8, 8, 8, 8, 0, 0,                     // Code 0x91 145 Windpfeil Richtung N
  7, 0, 0, 0x0f, 3, 5, 9, 0x10, 0x20, 0x40, 0, 0,               // Code 0x92 146 Windpfeil Richtung NO
  7, 0, 0, 0, 4, 2, 0x7f, 2, 4, 0, 0, 0,                        // Code 0x93 147 Windpfeil Richtung O
  7, 0, 0, 0x40, 0x20, 0x10, 9, 5, 3, 0x0f, 0, 0,               // Code 0x94 148 Windpfeil Richtung SO
  7, 0, 0, 8, 8, 8, 8, 0x2a, 0x1c, 8, 0, 0,                     // Code 0x95 149 Windpfeil Richtung S
  7, 0, 0, 1, 2, 4, 0x48, 0x50, 0x60, 0x78, 0, 0,               // Code 0x96 150 Windpfeil Richtung SW
  7, 0, 0, 0, 0x10, 0x20, 0x7f, 0x20, 0x10, 0, 0, 0,            // Code 0x97 151 Windpfeil Richtung W
  7, 0, 0, 0x78, 0x60, 0x50, 0x48, 4, 2, 1, 0, 0                // Code 0x98 152 Windpfeil Richtung NW
};

// ASCII-Zeichensatz in reduzierter Größe proportional, jedes Zeichen wird mit 10 Bytes definiert, Byte 0 enthält die
// Zeichenbreite (0-8), die restlichen Bytes enthalten zeilenweise die Bitmap des Zeichens, Beispiel Dollarzeichen
//
// Byte  0 = 5                                                  (Zeichen ist 5 Pixel breit)
// Byte  1 = 0          . . . . . . . .                         (Zeile für Umlaute)
// Byte  2 = 4          . . . . . # . .
// Byte  3 = 0x0e       . . . . # # # .
// Byte  4 = 0x14       . . . # . # . .
// Byte  5 = 0x0e       . . . . # # # .
// Byte  6 = 5          . . . . . # . #
// Byte  7 = 0x15       . . . # . # . #
// Byte  8 = 0x0e       . . . . # # # .
// Byte  9 = 4          . . . . . # . .

const uint8_t charset_reduced_array[] PROGMEM =
{
  // ASCII 0x20 - 0x7f (normaler Zeichensatz)
  3, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                 // Code 0x20 032 ' '
  1, 0, 1, 1, 1, 1, 1, 1, 0, 1,                                 // Code 0x21 033 '!'
  5, 0, 0x1b, 0x1b, 9, 0x12, 0, 0, 0, 0,                        // Code 0x22 034 '"'
  5, 0, 0, 0x0a, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x0a,            // Code 0x23 035 '#'
  5, 0, 4, 0x0e, 0x14, 0x0e, 5, 0x15, 0x0e, 4,                  // Code 0x24 036 '$'
  5, 0, 0x18, 0x19, 2, 4, 4, 8, 0x13, 3,                        // Code 0x25 037 '%'
  5, 0, 0x0c, 0x12, 0x12, 0x14, 8, 0x15, 0x12, 0x0d,            // Code 0x26 038 '&'
  2, 0, 3, 3, 1, 2, 0, 0, 0, 0,                                 // Code 0x27 039 '''
  3, 0, 1, 2, 4, 4, 4, 4, 2, 1,                                 // Code 0x28 040 '('
  3, 0, 4, 2, 1, 1, 1, 1, 2, 4,                                 // Code 0x29 041 ')'
  5, 0, 0, 0, 0x0a, 4, 0x1f, 4, 0x0a, 0,                        // Code 0x2a 042 '*'
  3, 0, 0, 0, 0, 2, 7, 2, 0, 0,                                 // Code 0x2b 043 '+'
  2, 0, 0, 0, 0, 0, 0, 0, 3, 3,                                 // Code 0x2c 044 ','
  3, 0, 0, 0, 0, 0, 7, 0, 0, 0,                                 // Code 0x2d 045 '-'
  1, 0, 0, 0, 0, 0, 0, 0, 0, 1,                                 // Code 0x2e 046 '.'
  4, 0, 1, 1, 2, 2, 4, 4, 8, 8,                                 // Code 0x2f 047 '/'

  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e,         // Code 0x30 048 '0'
  5, 0, 2, 6, 0x0a, 2, 2, 2, 2, 2,                              // Code 0x31 049 '1'
  5, 0, 0x0e, 0x11, 1, 2, 4, 8, 0x10, 0x1f,                     // Code 0x32 050 '2'
  5, 0, 0x0e, 0x11, 1, 6, 1, 1, 0x11, 0x0e,                     // Code 0x33 051 '3'
  5, 0, 2, 6, 0x0a, 0x0a, 0x12, 0x1f, 2, 2,                     // Code 0x34 052 '4'
  5, 0, 0x1f, 0x10, 0x10, 0x1e, 1, 1, 0x11, 0x0e,               // Code 0x35 053 '5'
  5, 0, 4, 8, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x0e,               // Code 0x36 054 '6'
  5, 0, 0x1f, 1, 1, 2, 2, 4, 4, 4,                              // Code 0x37 055 '7'
  5, 0, 0x0e, 0x11, 0x11, 0x0e, 0x11, 0x11, 0x11, 0x0e,         // Code 0x38 056 '8'
  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x0f, 1, 2, 4,                  // Code 0x39 057 '9'
  2, 0, 0, 0, 0, 3, 3, 0, 3, 3,                                 // Code 0x3a 058 ':'
  2, 0, 0, 0, 0, 3, 3, 0, 3, 3,                                 // Code 0x3b 059 ';'
  4, 0, 0, 1, 2, 4, 8, 4, 2, 1,                                 // Code 0x3c 060 '<'
  5, 0, 0, 0, 0, 0x1f, 0, 0x1f, 0, 0,                           // Code 0x3d 061 '='
  4, 0, 0, 8, 4, 2, 1, 2, 4, 8,                                 // Code 0x3e 062 '>'
  5, 0, 0x0e, 0x11, 1, 2, 4, 4, 0, 4,                           // Code 0x3f 063 '?'

  5, 0, 6, 9, 0x13, 0x15, 0x15, 0x13, 8, 7,                     // Code 0x40 064 '@'
  5, 0, 0x04, 0x0a, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11,         // Code 0x41 065 'A'
  5, 0, 0x1e, 0x11, 0x11, 0x1e, 0x11, 0x11, 0x11, 0x1e,         // Code 0x42 066 'B'
  5, 0, 0x0e, 0x11, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0e,         // Code 0x43 067 'C'
  5, 0, 0x1c, 0x12, 0x11, 0x11, 0x11, 0x11, 0x12, 0x1c,         // Code 0x44 068 'D'
  5, 0, 0x1f, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x10, 0x1f,         // Code 0x45 069 'E'
  5, 0, 0x1f, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x10, 0x10,         // Code 0x46 070 'F'
  5, 0, 0x0e, 0x11, 0x10, 0x10, 0x13, 0x11, 0x11, 0x0e,         // Code 0x47 071 'G'
  5, 0, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x11,         // Code 0x48 072 'H'
  1, 0, 1, 1, 1, 1, 1, 1, 1, 1,                                 // Code 0x49 073 'I'
  4, 0, 1, 1, 1, 1, 1, 1, 9, 6,                                 // Code 0x4a 074 'J'
  5, 0, 0x11, 0x12, 0x14, 0x18, 0x18, 0x14, 0x12, 0x11,         // Code 0x4b 075 'K'
  5, 0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f,         // Code 0x4c 076 'L'
  5, 0, 0x11, 0x1b, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11,         // Code 0x4d 077 'M'
  5, 0, 0x11, 0x19, 0x19, 0x15, 0x15, 0x13, 0x13, 0x11,         // Code 0x4e 078 'N'
  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e,         // Code 0x4f 079 'O'

  5, 0, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10,         // Code 0x50 080 'P'
  5, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x15, 0x12, 0x0d,         // Code 0x51 081 'Q'
  5, 0, 0x1e, 0x11, 0x11, 0x11, 0x1e, 0x14, 0x12, 0x11,         // Code 0x52 082 'R'
  5, 0, 0x0e, 0x11, 0x10, 0x0e, 1, 1, 0x11, 0x0e,               // Code 0x53 083 'S'
  5, 0, 0x1f, 4, 4, 4, 4, 4, 4, 4,                              // Code 0x54 084 'T'
  5, 0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e,         // Code 0x55 085 'U'
  5, 0, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x0a, 4, 4,               // Code 0x56 086 'V'
  5, 0, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x0a,         // Code 0x57 087 'W'
  5, 0, 0x11, 0x11, 0x0a, 4, 0x0a, 0x11, 0x11, 0x11,            // Code 0x58 088 'X'
  5, 0, 0x11, 0x11, 0x11, 0x0a, 4, 4, 4, 4,                     // Code 0x59 089 'Y'
  5, 0, 0x1f, 1, 2, 4, 4, 8, 0x10, 0x1f,                        // Code 0x5a 090 'Z'
  3, 0, 7, 4, 4, 4, 4, 4, 4, 7,                                 // Code 0x5b 091 '['
  4, 0, 8, 8, 4, 4, 2, 2, 1, 1,                                 // Code 0x5c 092 '\'
  3, 0, 7, 1, 1, 1, 1, 1, 1, 7,                                 // Code 0x5d 093 ']'
  5, 0, 4, 0x0a, 0x11, 0, 0, 0, 0, 0,                           // Code 0x5e 094 '^'
  5, 0, 0, 0, 0, 0, 0, 0, 0, 0x1f,                              // Code 0x5f 095 '_'

  3, 0, 4, 2, 1, 0, 0, 0, 0, 0,                                 // Code 0x60 096 '`'
  5, 0, 0, 0, 0, 0x0e, 1, 0x0f, 0x11, 0x0f,                     // Code 0x61 097 'a'
  5, 0, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x1e,         // Code 0x62 098 'b'
  4, 0, 0, 0, 0, 7, 8, 8, 8, 7,                                 // Code 0x63 099 'c'
  5, 0, 1, 1, 1, 0x0f, 0x11, 0x11, 0x11, 0x0f,                  // Code 0x64 100 'd'
  5, 0, 0, 0, 0, 0x0e, 0x11, 0x1f, 0x10, 0x0e,                  // Code 0x65 101 'e'
  3, 0, 1, 2, 2, 7, 2, 2, 2, 2,                                 // Code 0x66 102 'f'
  5, 0, 0, 0, 0x0f, 0x11, 0x11, 0x0f, 1, 0x0e,                  // Code 0x67 103 'g'
  5, 0, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11, 0x11,         // Code 0x68 104 'h'
  1, 0, 0, 1, 0, 1, 1, 1, 1, 1,                                 // Code 0x69 105 'i'
  2, 0, 0, 1, 0, 1, 1, 1, 1, 2,                                 // Code 0x6a 106 'j'
  4, 0, 8, 8, 8, 9, 0x0a, 0x0c, 0x0a, 9,                        // Code 0x6b 107 'k'
  2, 0, 2, 2, 2, 2, 2, 2, 2, 1,                                 // Code 0x6c 108 'l'
  5, 0, 0, 0, 0, 0x1a, 0x15, 0x15, 0x15, 0x15,                  // Code 0x6d 109 'm'
  5, 0, 0, 0, 0, 0x16, 0x19, 0x11, 0x11, 0x11,                  // Code 0x6e 110 'n'
  5, 0, 0, 0, 0, 0x0e, 0x11, 0x11, 0x11, 0x0e,                  // Code 0x6f 111 'o'


  5, 0, 0, 0, 0x1e, 0x11, 0x11, 0x1e, 0x10, 0x10,               // Code 0x70 112 'p'
  5, 0, 0, 0, 0x0f, 0x11, 0x11, 0x0f, 1, 1,                     // Code 0x71 113 'q'
  4, 0, 0, 0, 0, 0x0a, 0x0d, 8, 8, 8,                           // Code 0x72 114 'r'
  5, 0, 0, 0, 0, 0x0e, 0x10, 0x0e, 1, 0x1e,                     // Code 0x73 115 's'
  3, 0, 0, 2, 2, 7, 2, 2, 2, 1,                                 // Code 0x74 116 't'
  5, 0, 0, 0, 0, 0x11, 0x11, 0x11, 0x11, 0x0e,                  // Code 0x75 117 'u'
  5, 0, 0, 0, 0, 0x11, 0x11, 0x11, 0x0a, 4,                     // Code 0x76 118 'v'
  5, 0, 0, 0, 0, 0x11, 0x11, 0x15, 0x15, 0x0a,                  // Code 0x77 119 'w'
  5, 0, 0, 0, 0, 0x11, 0x0a, 4, 0x0a, 0x11,                     // Code 0x78 120 'x'
  5, 0, 0, 0, 0x11, 0x11, 0x11, 0x0f, 1, 0x0e,                  // Code 0x79 121 'y'
  5, 0, 0, 0, 0, 0x1f, 2, 4, 8, 0x1f,                           // Code 0x7a 122 'z'
  3, 0, 1, 2, 2, 4, 2, 2, 2, 1,                                 // Code 0x7b 123 '{'
  1, 0, 1, 1, 1, 0, 1, 1, 1, 1,                                 // Code 0x7c 124 '|'
  3, 0, 4, 2, 2, 1, 2, 2, 2, 4,                                 // Code 0x7d 125 '}'
  5, 0, 8, 0x15, 2, 0, 0, 0, 0, 0,                              // Code 0x7e 126 '~'
  3, 0, 0, 0, 0, 0, 0, 7, 7, 7,                                 // Code 0x7f 127 Endezeichen

  // ASCII 0x80 - 0x8f (Umlaute und Sonderzeichen)
  5, 0x11, 4, 0x0a, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11,         // Code 0x80 128 'Ä'
  5, 0x0a, 0, 0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e,         // Code 0x81 129 'Ö'
  5, 0x0a, 0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e,         // Code 0x82 130 'Ü'
  5, 0, 0, 0x0a, 0, 0x0e, 1, 0x0f, 0x11, 0x0f,                  // Code 0x83 131 'ä'
  5, 0, 0, 0x0a, 0, 0x0e, 0x11, 0x11, 0x11, 0x0e,               // Code 0x84 132 'ö'
  5, 0, 0, 0x0a, 0, 0x11, 0x11, 0x11, 0x11, 0x0e,               // Code 0x85 133 'ü'
  5, 0, 0x0e, 0x11, 0x11, 0x16, 0x11, 0x11, 0x11, 0x16,         // Code 0x86 134 'ß'
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8c 135 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8d 136 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x89 137 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8a 138 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8b 139 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8c 140 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8d 141 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                           // Code 0x8e 142 (nicht genutzt)
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0                            // Code 0x8f 143 (nicht genutzt)
};

// 20 Wettersymbol-Icons (24x11 Pixel, jeweils 264 Bytes)
const uint8_t iconarray[] PROGMEM =
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon A (01d), Zeile 1
  0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 16, 0, 0, 0, 0, 0,                      // Icon A (01d), Zeile 2
  16, 16, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,                     // Icon A (01d), Zeile 3
  0, 16, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                      // Icon A (01d), Zeile 4
  0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon A (01d), Zeile 5
  0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 16, 16, 0,                     // Icon A (01d), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 16, 16,                     // Icon A (01d), Zeile 7
  0, 0, 16, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                      // Icon A (01d), Zeile 8
  0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon A (01d), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon A (01d), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon A (01d), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon B (01n), Zeile 1
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0,                      // Icon B (01n), Zeile 2
  0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                   // Icon B (01n), Zeile 3
  0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0,                 // Icon B (01n), Zeile 4
  0, 0, 11, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0,               // Icon B (01n), Zeile 5
  0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 11,               // Icon B (01n), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 11, 11, 0 ,0 , 0, 0, 0, 0, 0, 0, 0,               // Icon B (01n), Zeile 7
  0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0,                 // Icon B (01n), Zeile 8
  11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                   // Icon B (01n), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon B (01n), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon B (01n), Zeile 11
  
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,                       // Icon C (02d), Zeile 1
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,                       // Icon C (02d), Zeile 2
  0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0, 3, 0, 0,                    // Icon C (02d), Zeile 3
  16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0,                  // Icon C (02d), Zeile 4
  0, 16, 16, 16, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0,                  // Icon C (02d), Zeile 5
  0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,                   // Icon C (02d), Zeile 6
  0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0,                 // Icon C (02d), Zeile 7
  0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0,                 // Icon C (02d), Zeile 8
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0, 3, 0, 0,                   // Icon C (02d), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,                       // Icon C (02d), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,                       // Icon C (02d), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon D (02n), Zeile 1
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0,                      // Icon D (02n), Zeile 2
  0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 0, 0,                 // Icon D (02n), Zeile 3
  16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 0,             // Icon D (02n), Zeile 4
  0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 11, 11,           // Icon D (02n), Zeile 5
  0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 11, 11, 11, 11, 11, 11, 11,            // Icon D (02n), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 11, 11, 11, 11, 11, 11, 11,          // Icon D (02n), Zeile 7
  0, 0, 11, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 11, 11, 11, 11, 11, 0,           // Icon D (02n), Zeile 8
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 0, 0,                // Icon D (02n), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon D (02n), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon D (02n), Zeile 11
  
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,                       // Icon E (03d), Zeile 1
  0, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0,                 // Icon E (03d), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 3, 0, 0,             // Icon E (03d), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 0, 3, 3, 3, 3, 0, 0, 0,          // Icon E (03d), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 3, 3, 3, 0, 0,            // Icon E (03d), Zeile 5
  0, 0, 16, 16, 0, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 3, 3, 3, 3,          // Icon E (03d), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 3, 3, 0, 0,            // Icon E (03d), Zeile 7
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 3, 0, 0, 0,          // Icon E (03d), Zeile 8
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 3, 0, 0,          // Icon E (03d), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 3, 0,            // Icon E (03d), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0,                // Icon E (03d), Zeile 11
  
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon F (03n), Zeile 1
  0, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                 // Icon F (03n), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 0, 0,          // Icon F (03n), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 0, 0, 11, 11, 11, 11, 11, 0,     // Icon F (03n), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 16, 16, 16, 16, 16, 0, 0, 0, 11, 11, 11, 11,       // Icon F (03n), Zeile 5
  0, 0, 16, 16, 0, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 11, 11, 11,      // Icon F (03n), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 11, 11, 11,        // Icon F (03n), Zeile 7
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 11, 11, 0,       // Icon F (03n), Zeile 8
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 11, 0, 0,        // Icon F (03n), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0,           // Icon F (03n), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0,               // Icon F (03n), Zeile 11
  
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0,                 // Icon G (04d), Zeile 1
  0, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,      // Icon G (04d), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,   // Icon G (04d), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16,     // Icon G (04d), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16,       // Icon G (04d), Zeile 5
  0, 0, 16, 16, 0, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 16, 16, 16, 16, 16, 0,      // Icon G (04d), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0,           // Icon G (04d), Zeile 7
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0,           // Icon G (04d), Zeile 8
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0,          // Icon G (04d), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0,           // Icon G (04d), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0,               // Icon G (04d), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0,                 // Icon H (04n), Zeile 1
  0, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,      // Icon H (04n), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,   // Icon H (04n), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16,     // Icon H (04n), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16,       // Icon H (04n), Zeile 5
  0, 0, 16, 16, 0, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 16, 16, 16, 16, 16, 0,      // Icon H (04n), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0,           // Icon H (04n), Zeile 7
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0,           // Icon H (04n), Zeile 8
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0,          // Icon H (04n), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0,           // Icon H (04n), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0,               // Icon H (04n), Zeile 11

  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0,               // Icon I (09d), Zeile 1
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0,     // Icon I (09d), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,   // Icon I (09d), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, // Icon I (09d), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16,   // Icon I (09d), Zeile 5
  0, 0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0,        // Icon I (09d), Zeile 6
  0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 16, 16, 0, 0,                    // Icon I (09d), Zeile 7
  0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0,                       // Icon I (09d), Zeile 8
  0, 0, 0, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0,                       // Icon I (09d), Zeile 9
  0, 0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0,                       // Icon I (09d), Zeile 10
  0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon I (09d), Zeile 11

  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0,               // Icon J (09n), Zeile 1
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0,     // Icon J (09n), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,   // Icon J (09n), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, // Icon J (09n), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16,   // Icon J (09n), Zeile 5
  0, 0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0,        // Icon J (09n), Zeile 6
  0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 16, 16, 0, 0,                    // Icon J (09n), Zeile 7
  0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0,                       // Icon J (09n), Zeile 8
  0, 0, 0, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0,                       // Icon J (09n), Zeile 9
  0, 0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0,                       // Icon J (09n), Zeile 10
  0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon J (09n), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,                       // Icon K (10d), Zeile 1
  0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0,                  // Icon K (10d), Zeile 2
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 3, 0, 0,             // Icon K (10d), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 0, 0, 3, 3, 3, 3, 0, 0, 0,          // Icon K (10d), Zeile 4
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 3, 3, 3, 0, 0,         // Icon K (10d), Zeile 5
  0, 16, 16, 16, 16, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 3, 3, 3, 3,           // Icon K (10d), Zeile 6
  0, 0, 0, 0, 16, 0, 7, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 3, 3, 0, 0,              // Icon K (10d), Zeile 7
  0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 3, 0, 0, 0,               // Icon K (10d), Zeile 8
  0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 3, 0, 0,                // Icon K (10d), Zeile 9
  0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 3, 0,                    // Icon K (10d), Zeile 10
  0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon K (10d), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon L (10n), Zeile 1
  0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                  // Icon L (10n), Zeile 2
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 11, 11, 11, 0, 0,          // Icon L (10n), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 0, 11, 11, 11, 11, 11, 0,    // Icon L (10n), Zeile 4
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0, 11, 11, 11, 11,    // Icon L (10n), Zeile 5
  0, 16, 16, 16, 16, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 11, 11, 11,       // Icon L (10n), Zeile 6
  0, 0, 0, 0, 16, 0, 7, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 11, 11, 11,          // Icon L (10n), Zeile 7
  0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 11, 11, 0,            // Icon L (10n), Zeile 8
  0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 11, 0, 0,              // Icon L (10n), Zeile 9
  0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 0, 0, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0,                   // Icon L (10n), Zeile 10
  0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0,                      // Icon L (10n), Zeile 11

  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0,               // Icon M (11d), Zeile 1
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0,     // Icon M (11d), Zeile 2
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,    // Icon M (11d), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16,     // Icon M (11d), Zeile 4
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 1, 0, 16, 16, 16, 16, 16,   // Icon M (11d), Zeile 5
  16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0, 0, 1, 0, 0, 16, 16, 16, 16, 16,       // Icon M (11d), Zeile 6
  0, 16, 16, 0, 0, 0, 16, 0, 7, 0, 0, 0, 0, 16, 0, 1, 0, 0, 0, 16, 16, 16, 16, 0,               // Icon M (11d), Zeile 7
  0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 1, 1, 1, 0, 16, 16, 16, 0, 0,                    // Icon M (11d), Zeile 8
  0, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,                       // Icon M (11d), Zeile 9
  0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,                       // Icon M (11d), Zeile 10
  0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon M (11d), Zeile 11

  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0,               // Icon N (11n), Zeile 1
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0,     // Icon N (11n), Zeile 2
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,    // Icon N (11n), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16,     // Icon N (11n), Zeile 4
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 1, 0, 16, 16, 16, 16, 16,   // Icon N (11n), Zeile 5
  16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0, 0, 1, 0, 0, 16, 16, 16, 16, 16,       // Icon N (11n), Zeile 6
  0, 16, 16, 0, 0, 0, 16, 0, 7, 0, 0, 0, 0, 16, 0, 1, 0, 0, 0, 16, 16, 16, 16, 0,               // Icon N (11n), Zeile 7
  0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 1, 1, 1, 0, 16, 16, 16, 0, 0,                    // Icon N (11n), Zeile 8
  0, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,                       // Icon N (11n), Zeile 9
  0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 7, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,                       // Icon N (11n), Zeile 10
  0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon N (11n), Zeile 11

  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0,               // Icon O (13d), Zeile 1
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0,     // Icon O (13d), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,   // Icon O (13d), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, // Icon O (13d), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16,   // Icon O (13d), Zeile 5
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0,     // Icon O (13d), Zeile 6
  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0,                 // Icon O (13d), Zeile 7
  0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0,                       // Icon O (13d), Zeile 8
  0, 0, 0, 7, 0, 7, 0, 0, 0, 7, 0, 0, 0, 7, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0,                       // Icon O (13d), Zeile 9
  0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 7, 0, 0, 0, 7, 0, 0, 0, 7, 0, 7, 0, 0, 0,                       // Icon O (13d), Zeile 10
  0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon O (13d), Zeile 11

  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0,               // Icon P (13n), Zeile 1
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0,     // Icon P (13n), Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,   // Icon P (13n), Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, // Icon P (13n), Zeile 4
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16,   // Icon P (13n), Zeile 5
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 16, 16, 16, 0,     // Icon P (13n), Zeile 6
  0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0,                 // Icon P (13n), Zeile 7
  0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0,                       // Icon P (13n), Zeile 8
  0, 0, 0, 7, 0, 7, 0, 0, 0, 7, 0, 0, 0, 7, 0, 7, 0, 0, 0, 7, 0, 0, 0, 0,                       // Icon P (13n), Zeile 9
  0, 0, 0, 0, 7, 0, 0, 0, 7, 0, 7, 0, 0, 0, 7, 0, 0, 0, 7, 0, 7, 0, 0, 0,                       // Icon P (13n), Zeile 10
  0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon P (13n), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon Q (50d), Zeile 1
  16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16,           // Icon Q (50d), Zeile 2
  0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0,           // Icon Q (50d), Zeile 3
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon Q (50d), Zeile 4
  16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16,           // Icon Q (50d), Zeile 5
  0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0,           // Icon Q (50d), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon Q (50d), Zeile 7
  16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16,           // Icon Q (50d), Zeile 8
  0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0,           // Icon Q (50d), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon Q (50d), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon Q (50d), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon R (50n), Zeile 1
  16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16,           // Icon R (50n), Zeile 2
  0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0,           // Icon R (50n), Zeile 3
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon R (50n), Zeile 4
  16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16,           // Icon R (50n), Zeile 5
  0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0,           // Icon R (50n), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon R (50n), Zeile 7
  16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16,           // Icon R (50n), Zeile 8
  0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 0, 0,           // Icon R (50n), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon R (50n), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon R (50n), Zeile 11

  0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                     // Icon S (xxx), Zeile 1
  0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0,                    // Icon S (xxx), Zeile 2
  16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                     // Icon S (xxx), Zeile 3
  0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                      // Icon S (xxx), Zeile 4
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon S (xxx), Zeile 5
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0,                    // Icon S (xxx), Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16,                    // Icon S (xxx), Zeile 7
  0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                      // Icon S (xxx), Zeile 8
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 0, 0,                     // Icon S (xxx), Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon S (xxx), Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                       // Icon S (xxx), Zeile 11
};

// Spezielle Symbole für Sonne, Solar, Batterie, Tanken, Wolken, Wind und Regen (Breite variabel, steht im Byte 0, Höhe 11 Pixel)
const uint8_t symbols[] PROGMEM =
{
  10,                                                                 // Sonnen-Symbol, Breite 10 Pixel
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 1
  0, 0, 0, 3, 0, 0, 3, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 2
  0, 0, 0, 3, 0, 3, 0, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 3
  0, 3, 0, 0, 3, 3, 0, 3, 3, 0,                                       // Sonnen-Symbol, Zeile 4
  0, 0, 3, 3, 3, 3, 3, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 5
  0, 0, 0, 3, 3, 3, 3, 3, 0, 0,                                       // Sonnen-Symbol, Zeile 6
  0, 3, 3, 0, 3, 3, 0, 0, 3, 0,                                       // Sonnen-Symbol, Zeile 7
  0, 0, 0, 0, 3, 0, 3, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 8
  0, 0, 0, 3, 0, 0, 3, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                       // Sonnen-Symbol, Zeile 11

  13,                                                                 // Solar-Symbol, Breite 13 Pixel
  0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0,                              // Solar-Symbol, Zeile 1
  0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0,                              // Solar-Symbol, Zeile 2
  0, 0, 0, 3, 0, 3, 3, 3, 0, 3, 0, 0, 0,                              // Solar-Symbol, Zeile 3
  0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0,                              // Solar-Symbol, Zeile 4
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                              // Solar-Symbol, Zeile 5
  0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0,                     // Solar-Symbol, Zeile 6
  0, 16, 0, 0, 0, 0, 16, 0, 0, 0, 0, 16, 0,                           // Solar-Symbol, Zeile 7
  0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,                   // Solar-Symbol, Zeile 8
  16, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 16,                           // Solar-Symbol, Zeile 9
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,                 // Solar-Symbol, Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                              // Solar-Symbol, Zeile 11

  5,                                                                  // Batterie-Symbol, Breite 5 Pixel
  0, 16, 16, 16, 0,                                                   // Batterie-Symbol, Zeile 1
  16, 16, 16, 16, 16,                                                 // Batterie-Symbol, Zeile 2
  16, 0, 0, 0, 16,                                                    // Batterie-Symbol, Zeile 3
  16, 0, 0, 0, 16,                                                    // Batterie-Symbol, Zeile 4
  16, 16, 0, 0, 16,                                                   // Batterie-Symbol, Zeile 5
  16, 16, 16, 0, 16,                                                  // Batterie-Symbol, Zeile 6
  16, 16, 16, 16, 16,                                                 // Batterie-Symbol, Zeile 7
  16, 16, 16, 16, 16,                                                 // Batterie-Symbol, Zeile 8
  16, 16, 16, 16, 16,                                                 // Batterie-Symbol, Zeile 9
  16, 16, 16, 16, 16,                                                 // Batterie-Symbol, Zeile 10
  0, 0, 0, 0, 0,                                                      // Batterie-Symbol, Zeile 11

  10,                                                                 // Tankstellen-Symbol, Breite 10 Pixel
  0, 16, 16, 16, 16, 16, 16, 0, 0, 0,                                 // Tankstellen-Symbol, Zeile 1
  0, 16, 0, 0, 0, 0, 16, 0, 16, 0,                                    // Tankstellen-Symbol, Zeile 2
  0, 16, 0, 0, 0, 0, 16, 0, 16, 16,                                   // Tankstellen-Symbol, Zeile 3
  0, 16, 0, 0, 0, 0, 16, 0, 16, 16,                                   // Tankstellen-Symbol, Zeile 4
  0, 16, 16, 16, 16, 16, 16, 0, 0, 16,                                // Tankstellen-Symbol, Zeile 5
  0, 16, 16, 16, 16, 16, 16, 0, 0, 16,                                // Tankstellen-Symbol, Zeile 6
  0, 16, 16, 16, 16, 16, 16, 16, 0, 16,                               // Tankstellen-Symbol, Zeile 7
  0, 16, 16, 16, 16, 16, 16, 0, 16, 0,                                // Tankstellen-Symbol, Zeile 8
  0, 16, 16, 16, 16, 16, 16, 0, 0, 0,                                 // Tankstellen-Symbol, Zeile 9
  16, 16, 16, 16, 16, 16, 16, 16, 0, 0,                               // Tankstellen-Symbol, Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                       // Tankstellen-Symbol, Zeile 11

  16,                                                                 // Wolken-Symbol, Breite 16 Pixel
  0, 16, 16, 16, 0, 0, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0,               // Wolken-Symbol, Zeile 1
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0,           // Wolken-Symbol, Zeile 2
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0,          // Wolken-Symbol, Zeile 3
  0, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 16, 16, 0, 0,            // Wolken-Symbol, Zeile 4
  0, 0, 16, 16, 0, 16, 16, 0, 0, 16, 16, 16, 16, 16, 16, 0,           // Wolken-Symbol, Zeile 5
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16,             // Wolken-Symbol, Zeile 6
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,           // Wolken-Symbol, Zeile 7
  0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,            // Wolken-Symbol, Zeile 8
  0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 0, 0,              // Wolken-Symbol, Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 16, 16, 0, 0, 0,                 // Wolken-Symbol, Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                     // Wolken-Symbol, Zeile 11

  16,                                                                 // Wind-Symbol, Breite 16 Pixel
  0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 0, 0,                   // Wind-Symbol, Zeile 1
  0, 0, 0, 0, 0, 0, 16, 0, 0, 16, 0, 0, 0, 0, 0, 0,                   // Wind-Symbol, Zeile 2
  0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 16, 16, 0,                  // Wind-Symbol, Zeile 3
  16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 16, 0, 0, 16,          // Wind-Symbol, Zeile 4
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16,                    // Wind-Symbol, Zeile 5
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0,      // Wind-Symbol, Zeile 6
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                     // Wind-Symbol, Zeile 7
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0,         // Wind-Symbol, Zeile 8
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0,                    // Wind-Symbol, Zeile 9
  0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 16, 0, 0, 0,                   // Wind-Symbol, Zeile 10
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0,                   // Wind-Symbol, Zeile 11

  16,                                                                 // Regen-Symbol, Breite 16 Pixel
  0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0,                     // Regen-Symbol, Zeile 1
  0, 0, 0, 7, 7, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0,                     // Regen-Symbol, Zeile 2
  0, 0, 7, 7, 7, 0, 0, 0, 7, 7, 7, 0, 0, 0, 0, 7,                     // Regen-Symbol, Zeile 3
  0, 7, 7, 7, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 7, 7,                     // Regen-Symbol, Zeile 4
  7, 7, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7,                     // Regen-Symbol, Zeile 5
  7, 7, 7, 7, 7, 0, 0, 0, 7, 0, 0, 0, 7, 7, 7, 7,                     // Regen-Symbol, Zeile 6
  0, 7, 7, 7, 0, 0, 0, 7, 7, 0, 0, 7, 7, 7, 0, 7,                     // Regen-Symbol, Zeile 7
  0, 0, 0, 0, 0, 0, 7, 7, 7, 0, 0, 7, 7, 7, 7, 7,                     // Regen-Symbol, Zeile 8
  0, 0, 0, 0, 0, 7, 7, 0, 7, 0, 0, 0, 7, 7, 7, 0,                     // Regen-Symbol, Zeile 9
  0, 0, 0, 0, 0, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0,                     // Regen-Symbol, Zeile 10
  0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0                      // Regen-Symbol, Zeile 11
};
