// Matrixuhr-ESP32, Scott-Falk Hühn, "process.h"
// Verarbeitung der Sensoren, Alarme und Geburtstage

// Empfangene Wetterdaten dekodieren und als Einzelwerte speichern
void decode_weather() {
  uint16_t i;                                                         // Zähler- und Zwischenspeichervariable
  float numb;                                                         // Zwischenspeicher für Zahlenwerte
  unsigned long time;                                                 // Zwischenspeicher für Zeitwerte
  const char *iconstr;                                                // Zwischenspeicher für Icon-String
  char idstr[3];                                                      // Zwischenspeicher für ID-String (Wetterlage)
  int16_t offset;                                                     // Zwischenspeicher für Zeitdifferenz zur UTC
  uint8_t srmin, srhour, ssmin, sshour;                               // Zwischenspeicher für Minute und Stunde von Sonnenaufgang und Sonnenuntergang

  if (weatherjson[0] > 0) {                                           // wenn Zeichen im Puffer vorhanden
    for (i = 0; i < 13; i ++) weathervals[i][0] = 0;                  // zunächst alle Wetterelemente löschen
    weatv = "";                                                       // Wetterdatenstring für Web-Seite zunächst löschen
    for (i = 0; i < 12; i ++) {                                       // erste 12 Zeichen der Wetterdaten
      weatv += weatherjson[i];                                        // in Wetterdatenstring für Web-Seite übertragen
      if (weatv[i] == 0) break;                                       // wenn weniger als 12 Zeichen -> Schleife abbrechen
    }
    if (i > 11) weatv += "...";                                       // wenn mehr als 12 Zeichen vorhanden -> weitere Zeichen andeuten
    DeserializationError error = deserializeJson(json, weatherjson);  // JSON-Wetterdaten dekodieren
    if (!error) {                                                     // wenn kein Fehler aufgetreten
      if (json["tempc"].is<float>()) {                                // wenn Temperatur in °C vorhanden
        numb = json["tempc"];                                         // Temperatur holen
        sprintf(weathervals[0], "%.1f", numb);                        // Temperatur mit einer Nachkommastelle speichern
        if (numb > -0.5 && numb < 0) numb = 0;                        // wenn Wert zwischen -0,5 und 0 -> auf 0 setzen (vermeidet Rundungsfehler -0.0)
        sprintf(weathervals[1], "%.0f", numb);                        // Temperatur ohne Nachkommastelle speichern
      }
      if (json["humidity"].is<float>()) {                             // wenn Luftfeuchtigkeit in % vorhanden
        numb = json["humidity"];                                      // Luftfeuchtigkeit holen
        sprintf(weathervals[2], "%.0f", numb);                        // Luftfeuchtigkeit ohne Nachkommastelle speichern
      }
      if (json["pressure"].is<float>()) {                             // wenn Luftdruck in hPa vorhanden
        numb = json["pressure"];                                      // Luftdruck holen
        sprintf(weathervals[3], "%.0f", numb);                        // Luftdruck ohne Nachkommastelle speichern
      }
      if (json["windspeed"].is<float>()) {                            // wenn Windgeschwindigkeit in m/s vorhanden
        numb = json["windspeed"];                                     // Windgeschwindigkeit holen
        sprintf(weathervals[4], "%.1f", numb);                        // Windgeschwindigkeit in m/s mit einer Nachkommastelle speichern
        sprintf(weathervals[5], "%.0f", numb * 3.6);                  // Windgeschwindigkeit in km/h ohne Nachkommastelle speichern
      }
      if (json["rain"].is<float>()) {                                 // wenn Regenmenge in mm/h vorhanden
        numb = json["rain"];                                          // Regenmenge holen
        sprintf(weathervals[6], "%.1f", numb);                        // Regenmenge mit einer Nachkommastelle speichern
        sprintf(weathervals[7], "%.0f", numb);                        // Regenmenge ohne Nachkommastelle speichern
      }
      if (json["clouds"].is<float>()) {                               // wenn Wolkendichte in % vorhanden
        numb = json["clouds"];                                        // Wolkendichte holen
        sprintf(weathervals[8], "%.0f", numb);                        // Wolkendichte ohne Nachkommastelle speichern
      }
      weathervals[9][0] = '$';                                        // erstes Zeichen der Windrichtung ist immer $
      weathervals[9][1] = '0';                                        // Windrichtung auf unbestimmt vorbelegen
      weathervals[9][2] = 0;                                          // Endezeichen
      if (json["winddirection"].is<float>()) {                        // wenn Windrichtung vorhanden
        numb = json["winddirection"];                                 // Windrichtung in Grad holen
        if (numb > 157.5 && numb <= 202.5) weathervals[9][1] = '1';   // Windrichtung N (1) speichern
        if (numb > 202.5 && numb <= 247.5) weathervals[9][1] = '2';   // Windrichtung NO (2) speichern
        if (numb > 247.5 && numb <= 292.5) weathervals[9][1] = '3';   // Windrichtung O (3) speichern
        if (numb > 292.5 && numb <= 337.5) weathervals[9][1] = '4';   // Windrichtung SO (4) speichern
        if (numb > 337.5 || numb <= 22.5) weathervals[9][1] = '5';    // Windrichtung S (5) speichern
        if (numb > 22.5 && numb <= 67.5) weathervals[9][1] = '6';     // Windrichtung SW (6) speichern
        if (numb > 67.5 && numb <= 112.5) weathervals[9][1] = '7';    // Windrichtung W (7) speichern
        if (numb > 112.5 && numb <= 157.5) weathervals[9][1] = '8';   // Windrichtung NW (8) speichern
      }
      sunrise = 0;                                                    // Sonnenaufgang zunächst löschen
      sunset = 0;                                                     // Sonnenuntergang zunächst löschen
      if (json["sunrise"].is<unsigned long>() && json["sunset"].is<unsigned long>()) { // wenn Sonnenaufgang und Sonnenuntergang vorhanden
        offset = (minute + hour * 60) - (utcinfo->tm_min + utcinfo->tm_hour * 60); // Differenz zwischen Lokalzeit und UTC ermitteln
        time = json["sunrise"];                                       // Sonnenaufgangszeit (UTC-Unixzeit) holen
        time /= 60;                                                   // in Minuten umrechnen
        time += offset;                                               // Sonnenaufgangszeit in Lokalzeit umrechnen
        srmin = time % 60;                                            // Minute ermitteln
        time /= 60;                                                   // in Stunden umrechnen
        srhour = time % 24;                                           // Stunde ermitteln
        sunrise = srmin + srhour * 60;                                // Sonnenaufgangszeit in Minuten seit 0:00 speichern
        time = json["sunset"];                                        // Sonnenuntergangszeit (UTC-Unixzeit) holen
        time /= 60;                                                   // in Minuten umrechnen
        time += offset;                                               // Sonnenuntergangszeit in Lokalzeit umrechnen
        ssmin = time % 60;                                            // Minute ermitteln
        time /= 60;                                                   // in Stunden umrechnen
        sshour = time % 24;                                           // Stunde ermitteln
        sunset = ssmin + sshour * 60;                                 // Sonnenuntergangszeit in Minuten seit 0:00 speichern
        sprintf(weathervals[12], "%02d:%02d$T%02d:%02d", srhour, srmin, sshour, ssmin); // String für Sonnenwerte generieren
      }
      weathervals[10][0] = '$';                                       // erstes Zeichen des Wettersymbols ist immer $
      weathervals[10][1] = 'S';                                       // unbestimmtes Wettersymbol voreinstellen
      weathervals[10][2] = 0;                                         // Endezeichen
      if (json["icon"].is<JsonVariant>()) {                           // wenn Icon vorhanden
        iconstr = json["icon"];                                       // Icon holen
        for (i = 0; i < sizeof(weathericons) / 2; i ++) {             // Iconliste durchsuchen
          if (iconstr[0] == pgm_read_byte(&weathericons[i * 2])
          && iconstr[1] == pgm_read_byte(&weathericons[i * 2 + 1])) { // wenn beide Ziffern des Icons übereinstimmen
            weathervals[10][1] = i * 2 + 'A';                         // in Tages-Wettersymbol ($A, $C, $E ... $Q) umrechen
            break;
          }
        }
      }
      if (json["id"].is<int>()) {                                     // wenn Wetterlage vorhanden
        i = json["id"];                                               // Wetterlage holen
        if (i > 0) {                                                  // wenn Wetterlage eine Zahl enthält
          itoa(i, idstr, 10);                                         // in Zeichenkette umwandeln
          for (i = 0; i < sizeof(wcstringsd) / sizeof(PGM_P); i ++) { // Wetterlagenliste durchsuchen
            strncpy_P(strbuf, (PGM_P) pgm_read_ptr(&wcstringsd[i]), 3); // erste 3 Zeichen der gespeicherten Wetterlage kopieren
            if (idstr[0] == strbuf[0] && idstr[1] == strbuf[1] && idstr[2] == strbuf[2]) { // wenn alle 3 Zeichen übereinstimmen
              sprintf(weathervals[11], "%u", i);                      // Listenposition der Wetterlage speichern
              break;                                                  // Suchschleife abbrechen
            }
          }
        }
      }
    }
  }
}

// Empfangene Kraftstoffdaten dekodieren und als Einzelwerte speichern
void decode_fuel() {
  uint16_t i;                                                         // Zähler- und Zwischenspeichervariable
  float numb;                                                         // Zwischenspeicher für Zahlenwerte
  bool open;                                                          // Zwischenspeicher für Geöffnet-Status
  if (fueljson[0] > 0) {                                              // wenn Zeichen im Puffer vorhanden
    for (i = 0; i < 4; i ++) fuelvals[i][0] = 0;                      // zunächst alle Kraftstoffpreise löschen
    fuelv = "";                                                       // Kraftstoffdatenstring für Web-Seite zunächst löschen
    for (i = 0; i < 12; i ++) {                                       // erste 12 Zeichen der Kraftstoffdaten
      fuelv += fueljson[i];                                           // in Kraftstoffdatenstring für Web-Seite übertragen
      if (fuelv[i] == 0) break;                                       // wenn weniger als 12 Zeichen -> Schleife abbrechen
    }
    if (i > 11) fuelv += "...";                                       // wenn mehr als 12 Zeichen vorhanden -> weitere Zeichen andeuten
    DeserializationError error = deserializeJson(json, fueljson);     // JSON-Kraftstoffdaten dekodieren
    if (!error) {                                                     // wenn kein Fehler aufgetreten
      for (i = 0; i < 4; i ++) {                                      // 4 Preise bearbeiten
        open = json[i]["isOpen"];                                     // Geöffnet-Status holen
        if (open) {                                                   // wenn Tankstelle geöffnet
          numb = json[i]["price"];                                    // Kraftstoffpreis holen
          if (numb > 1 && numb < 10) {                                // wenn sinnvoller Preis
            sprintf(fuelvals[i], "%.2f", numb);                       // Kraftstoffpreis mit 2 Nachkommastellen speichern
          }
        }
      }
    }
  }
}

// Ein UTF-8 Zeichen (2 Byte) in ein internes Zeichen konvertieren
char utf8_conv(uint8_t c1, uint8_t c2) {                              // c1: erstes Zeichen, c2: zweites Zeichen
  uint8_t i;                                                          // Zählervariable
  uint8_t cc = ' ';                                                   // konvertiertes Zeichen auf Leerzeichen voreinstellen

  for (i = 0; i < sizeof(utf8tab); i += 3) {                          // UTF-8-Tabelle in Schritten von 3 Bytes abfragen
    if (cc == ' ') {                                                  // wenn noch kein Zeichen gefunden
      if (pgm_read_byte(&utf8tab[i]) == c1) {                         // wenn erstes Zeichen gefunden
        if (pgm_read_byte(&utf8tab[i + 1]) == c2) {                   // wenn zweites Zeichen gefunden
          cc = pgm_read_byte(&utf8tab[i + 2]);                        // internes Zeichen lesen
        }
      }
    }
  }
  return cc;                                                          // konvertiertes Zeichen zurückgeben
}

// Ein UTF-8 Zeichen (3 Byte) in ein internes Zeichen konvertieren
char utf8_conv3(uint8_t c1, uint8_t c2, uint8_t c3) {                 // c1: erstes Zeichen, c2: zweites Zeichen, c3: drittes Zeichen
  uint8_t i;                                                          // Zählervariable
  uint8_t cc = ' ';                                                   // konvertiertes Zeichen auf Leerzeichen voreinstellen

  for (i = 0; i < sizeof(utf8tab3); i += 4) {                         // UTF-8-Tabelle in Schritten von 4 Bytes abfragen
    if (cc == ' ') {                                                  // wenn noch kein Zeichen gefunden
      if (pgm_read_byte(&utf8tab3[i]) == c1) {                        // wenn erstes Zeichen gefunden
        if (pgm_read_byte(&utf8tab3[i + 1]) == c2) {                  // wenn zweites Zeichen gefunden
          if (pgm_read_byte(&utf8tab3[i + 2]) == c3) {                // wenn drittes Zeichen gefunden
            cc = pgm_read_byte(&utf8tab3[i + 3]);                     // internes Zeichen lesen
          }          
        }
      }
    }
  }
  return cc;                                                          // konvertiertes Zeichen zurückgeben
}

// Einen Alarm senden (aktivieren oder deaktivieren)
void send_alarm(uint8_t alm, bool val) {                              // alm: Alarmnummer (0-7), val: Alarmwert (false, true)
  if (val) alarmvals[alm][0] = '1';                                   // wenn Alarm aktiv -> Alarmwert 1 setzen
  else alarmvals[alm][0] = '0';                                       // wenn Alarm inaktiv -> Alarmwert 0 setzen
  alarmvals[alm][1] = 0;                                              // String-Ende setzen
  alarmflags[alm] = true;                                             // Alarm-Flag setzen
}

// Verarbeitung von Sensoren, Geburtstagen und speziellen Alarmen
void process() {
  uint8_t i, j, k, l;                                                 // Zähler- und Zwischenspeichervariablen
  uint8_t count = 0;                                                  // Datenfeldzähler auf Anfangswert setzen
  uint8_t splitpos[6];                                                // Positionen der Trennstellen im Wetterlagentext
  char senname;                                                       // Zwischenspeicher für Sensorname
  float senvalue;                                                     // Zwischenspeicher für Sensorwert (Zahlenwert)
  char cmpname;                                                       // Zwischenspeicher für Vergleichssensorname
  float cmpvalue;                                                     // Zwischenspeicher für Vergleichsensorwert (Zahlenwert)
  char senval[10];                                                    // Zwischenspeicher für Sensorwert (formatiert mit oder ohne Zehntel entsprechend Einstellung)
  bool senmode;                                                       // Sensormodus (true: nächstes Zeichen wird als Sensorname interpretiert)
  bool senerror;                                                      // Sensorfehler (true: kein Sensorwert vorhanden oder Daten sind veraltet)
  bool bdayflag;                                                      // Geburtstags-Flag, wird zur Auslösung des Geburtstags-Alarms benötigt
  char almhourc[3];                                                   // Zwischenspeicher für Stunde der Alarmzeit
  char almminutec[3];                                                 // Zwischenspeicher für Minute der Alarmzeit
  uint8_t almhour;                                                    // Zwischenspeicher für Stunde der Alarmzeit
  uint8_t almminute;                                                  // Zwischenspeicher für Minute der Alarmzeit
  uint8_t almwday;                                                    // Zwischenspeicher für Wochentag (umgerechnet auf 1 = Montag bis 7 = Sonntag)

  if (sunrise > 0 && sunset > 0) {                                    // wenn Sonnenzeiten vorhanden
    curtime = minute + hour * 60;                                     // aktuelle Zeit in Minuten seit 0:00 Uhr ermitteln
    nightsymbol = false;                                              // Nachtmodus für Wettersymbol zunächst ausschalten
    if (curtime < sunrise || curtime > sunset) nightsymbol = true;    // wenn Nachtzeit -> Nachtmodus für Wettersymbol einschalten
  }
  for (i = 0; i < 12; i ++) {                                         // 12 Zeitstempel der Sensorwerte prüfenn
    if ((millis() - sensortime[i]) > (60 * 60000)) {                  // wenn Zeitstempel älter als eine Stunde
      sensorvals[i][0] = 0;                                           // Sensorwert löschen
    }
  }

  for (i = 0; i < 10; i ++) {                                         // alle Felder der Datenanzeige bearbeiten
    if (datadisp[i].length() > 0) {                                   // wenn Datenanzeigefeld Daten enthält
      if (datadisp[i] == "[X]") {                                     // wenn Wetterlage [X]
        if (weathervals[11][0] > 0) {                                 // wenn Wetterlage vorhanden
          if ((millis() - weathertime) < (WEATHERT * 60000)) {        // wenn Wetterdaten gültig
            l = sizeof(wcstringsd) / sizeof(PGM_P);                   // Anzahl der Wetterlagentexte ermitteln
            k = atoi(weathervals[11]);                                // Wetterlagennummer holen
            if (k > l) k = l;                                         // wenn Wetterlagennummer nicht im zulässigen Bereich -> auf unbekannt setzen
            strcpy_P(strbuf, (PGM_P) pgm_read_ptr(&wcstringsd[k]));   // aktuellen Wetterlagentext in den String-Puffer kopieren
            for (k = 0; k < 6; k ++) splitpos[k] = 0;                 // Trennpositionen löschen
            j = 3;                                                    // Anfangsposition des Wetterlagentextes im String-Puffer
            k = 0;                                                    // Trennstellenzähler
            while (strbuf[j] > 0 && k < 6 && j < 50) {                // solange Textende noch nicht erreicht, Platz im Trennstellenspeicher vorhanden und Pufferende noch nicht erreicht
              if (strbuf[j] == ' ') splitpos[k ++] = j;               // wenn Leerzeichen im String-Puffer gefunden -> Trennstellenposition speichern
              j ++;                                                   // Position erhöhen
            }
            if (k < 6) splitpos[k] = j;                               // wenn Platz im Trennstellenspeicher -> Position des Textendes speichern
          }
          k = 0;                                                      // Wortzähler
          l = 0;                                                      // Zeichenposition im Datenfeld auf Anfang setzen
          do {                                                        // Schleife
            if (l + (splitpos[k + 1] - splitpos[k]) > 12) {           // wenn das nächste Wort nicht mehr ins Datenfeld passt
              if (l < 12) datarray[count][l] = 0;                     // wenn noch Zeichen im Datenfeld frei -> Endezeichen setzen
              count ++;                                               // nächstes Datenfeld auswählen
              l = 0;                                                  // Zeichenposition im Datenfeld wieder auf Anfang setzen
            }
            else if (l > 0) datarray[count][l ++] = ' ';              // wenn das nächste Wort noch ins Datenfeld passt -> wenn nicht Anfangsposition -> Leerzeichen einfügen
            for (j = splitpos[k] + 1; j < splitpos[k + 1]; j ++) {    // alle Zeichen des Wortes bearbeiten
              datarray[count][l ++] = strbuf[j];                      // Zeichen in Datenfeld kopieren
            }
            k ++;                                                     // nächstes Wort bearbeiten
          } while (splitpos[k] > 0 && splitpos[k + 1] > 0);           // Schleife solange noch ein weiteres Wort vorhanden
          if (l < 12) datarray[count][l] = 0;                         // wenn noch Zeichen im letzten Datenfeld frei -> Endezeichen setzen
          count ++;                                                   // nächstes Datenfeld auswählen
        }
      }
      else {                                                          // wenn keine Wetterlage (alle anderen Sensorinformationen)
        j = 0;                                                        // Zeichenzähler für den Eintrag in der Datenanzeige
        k = 0;                                                        // Zeichenzähler für das Datenfeld
        senmode = false;                                              // Sensormodus ausschalten
        senerror = false;                                             // Sensorfehler löschen
        do {                                                          // Schleife
          if (senmode) {                                              // wenn Sensornamenmodus
            if (datadisp[i][j] == ']') {                              // wenn Zeichen "]"
              senmode = false;                                        // Sensornamenmodus ausschalten
              switch (senname) {                                      // Auswahl entsprechend Sensorname
                case 'A' ... 'L':                                     // falls Sensorname im Bereich A-L
                  if (sensorvals[senname - 'A'][0] > 0 && (millis() - sensortime[senname - 'A']) < (mqtt_vali * 60000)) { // wenn Sensorwert vorhanden und Wert gültig
                    if (sensordeci[senname - 'A'] < 3) {              // wenn 0, 1 oder 2 Nachkommastellen
                      senvalue = atof(sensorvals[senname - 'A']);     // Sensorwert zunächst in numerischer Form zwischenspeichern
                      if (sensordeci[senname - 'A'] == 2) sprintf(senval, "%.2f", senvalue); // wenn 2 Nachkommastellen gewünscht -> Zeichenkette mit 2 Nachkommastellen speichern
                      else {
                        if (sensordeci[senname - 'A'] == 1) sprintf(senval, "%.1f", senvalue); // wenn 1 Nachkommastelle gewünscht -> Zeichenkette mit 1 Nachkommastelle speichern
                        else sprintf(senval, "%.0f", senvalue);       // wenn ohne Nachkommastelle gewünscht -> als Zeichenkette ohne Nachkommastelle speichern
                      }
                      l = 0;                                          // Zeichenzähler für Sensorwert
                      do {                                            // Schleife
                        if (k < 12) datarray[count][k ++] = senval[l ++]; // wenn noch Platz -> ein Zeichen vom konvertierten Sensorwert ins Datenfeld kopieren
                        else l ++;                                    // wenn kein Platz -> nur Zähler erhöhen
                      } while (senval[l] > 0);                        // solange noch weitere Zeichen vorhanden sind
                    }
                    else {                                            // wenn Prüfung und Formatierung ausgeschaltet
                      l = 0;                                          // Zeichenzähler für Sensorwert
                      do {                                            // Schleife
                        if (k < 12) datarray[count][k ++] = sensorvals[senname - 'A'][l ++]; // wenn noch Platz -> ein Zeichen vom originalen Sensorwert ins Datenfeld kopieren
                        else l ++;                                    // wenn kein Platz -> nur Zähler erhöhen
                      } while (sensorvals[senname - 'A'][l] > 0 && l < 12);  // solange noch weitere Zeichen vorhanden sind
                    }
                  }
                  else senerror = true;                               // wenn kein Sensorwert vorhanden oder Wert ungültig -> Sensorfehler setzen
                  break;
                case 'M' ... 'W':                                     // falls Sensorname im Bereich M-W (Wetterdaten, Symbole)
                  if (weathervals[senname - 'M'][0] > 0 && (millis() - weathertime) < (60 * 60000)) { // wenn Wetterdatenwert vorhanden und Wert gültig
                    l = 0;                                            // Zeichenzähler für Wetterdatenwert
                    do {                                              // Schleife
                      if (k < 12) {                                   // wenn noch Platz im Datenfeld
                        if (senname == 'W' && l == 1 && nightsymbol) { // wenn Wettersymbol, zweites Zeichen und Nachtmodus
                          datarray[count][k ++] = weathervals[senname - 'M'][l ++] + 1; // ein Zeichen vom Wetterdatenwert holen, erhöhen und ins Datenfeld kopieren (Wettersymbol Nacht)
                        }
                        else datarray[count][k ++] = weathervals[senname - 'M'][l ++]; // sonst Zeichen vom Wetterdatenwert direkt ins Datenfeld kopieren
                      }
                      else l ++;                                      // wenn kein Platz -> nur Zähler erhöhen
                    } while (weathervals[senname - 'M'][l] > 0);      // solange noch weitere Zeichen vorhanden sind
                  }
                  else senerror = true;                               // wenn kein Wetterdatenwert vorhanden oder Wert ungültig -> Sensorfehler setzen
                  break;
                case 'Y':                                             // falls Sensorname Y (Sonnenwerte)
                  if (weathervals[12][0] > 0 && (millis() - weathertime) < (60 * 60000) && syncstat) { // wenn Sonnenwerte vorhanden und gültig und Uhr synchronisiert
                    l = 0;                                            // Zeichenzähler für Sonnenwerte
                    do {                                              // Schleife
                      if (k < 12) datarray[count][k ++] = weathervals[12][l ++];  // wenn noch Platz -> ein Zeichen der Sonnenwerte ins Datenfeld kopieren
                      else l ++;                                      // wenn kein Platz -> nur Zähler erhöhen
                    } while (weathervals[12][l] > 0);                 // solange noch weitere Zeichen vorhanden sind
                  }
                  else senerror = true;                               // wenn keine Sonnenwerte vorhanden oder Wert ungültig -> Sensorfehler setzen
                  break;
                case 'a' ... 'd':                                     // falls Sensorname im Bereich a-d (Kraftstoffpreise)
                  if (fuelvals[senname - 'a'][0] > 0 && (millis() - fueltime) < (60 * 60000)) { // wenn Kraftstoffwert vorhanden und Wert gültig
                    l = 0;                                            // Zeichenzähler für Kraftstoffwert
                    do {                                              // Schleife
                      if (k < 12) datarray[count][k ++] = fuelvals[senname - 'a'][l ++]; // wenn noch Platz -> ein Zeichen vom Kraftstoffwert ins Datenfeld kopieren
                      else l ++;                                      // wenn kein Platz -> nur Zähler erhöhen
                    } while (fuelvals[senname - 'a'][l] > 0);         // solange noch weitere Zeichen vorhanden sind
                  }
                  else senerror = true;                               // wenn kein Kraftstoffwert vorhanden oder Wert ungültig -> Sensorfehler setzen
                  break;
                default:                                              // falls ungültiger Sensorname
                  senerror = true;                                    // Sensorfehler setzen
                  break;
              }
            }
            else senname = datadisp[i][j];                            // wenn Sensornamenmodus und kein "]" Zeichen -> Sensorname lesen
          }
          else {                                                      // wenn Normalmodus
            if (datadisp[i][j] == '[') {                              // wenn Zeichen "["
              senmode = true;                                         // Sensornamenmodus einschalten
              senname = '@';                                          // Sensorname zunächst auf ungültigen Wert setzen
            }
            else {                                                    // wenn nicht Zeichen "["
              if (k < 12) {                                           // wenn noch Platz im Datenfeld
                if (datadisp[i][j] < 128) {                           // wenn ASCII-Zeichen
                  datarray[count][k] = datadisp[i][j];                // ungefiltert ins Datenfeld kopieren
                }
                else {                                                // wenn UTF-8-Zeichen
                  if (datadisp[i][j] == 0xc2 || datadisp[i][j] == 0xc3) { // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
                    datarray[count][k] = utf8_conv(datadisp[i][j ++], datadisp[i][j]); // 2 Bytes des UTF-8-Zeichens in internes Zeichen konvertieren
                  }
                  if (datadisp[i][j] == 0xe2) {                       // wenn 3-Byte-Zeichen (nutzbare Zeichen beginnen mit E2)
                    datarray[count][k] = utf8_conv3(datadisp[i][j ++], datadisp[i][j ++], datadisp[i][j]); // 3 Bytes des UTF-Zeichens in internes Zeichen konvertieren
                  }
                }
                k ++;                                                 // auf nächste Zeichenposition im Datenfeld setzen
              }
            }
          }
          j ++;                                                       // auf nächste Zeichenposition in der Datenanzeige setzen
        } while (j < datadisp[i].length());                           // Schleife bis alle Zeichen bearbeitet sind
        if (senerror) datarray[count][0] = 0;                         // wenn Sensorfehler aufgetreten -> Datenfeld wieder löschen
        else {                                                        // wenn kein Sensorfehler aufgetreten
          if (k < 12) datarray[count][k] = 0;                         // wenn noch Zeichen im Datenfeld frei -> Endezeichen setzen
          count ++;                                                   // nächstes Datenfeld auswählen
        }
      }
    }
  }                                                                   // Geburtstage prüfen und ausgeben
  bdayflag = false;                                                   // Geburtstags-Flag löschen
  if (syncstat) {                                                     // wenn Uhr synchronisiert
    for (i = 0; i < MAXBDAYS; i ++) {                                 // alle Einträge der Geburtstagsliste bearbeiten
      if (birthdays[i].length() > 0) {                                // wenn Eintrag gefunden
        if (birthdays[i].substring(4, 6).toInt() == month && birthdays[i].substring(6, 8).toInt() == day) { // wenn Monat und Tag übereinstimmen
          if (count < 31) {                                           // wenn noch Datenfelder frei sind
            j = 9;                                                    // Zeichenposition auf Name des Geburtstagseintrages setzen
            k = 0;                                                    // Zeichenposition für Datenfeld auf Anfang setzen
            while (k < 12 && birthdays[i][j] > 0) {                   // solange noch Zeichen ins Datenfeld passen und der Name weitere Zeichen enthält
              if (birthdays[i][j] < 128) {                            // wenn ASCII-Zeichen
                datarray[count][k ++] = birthdays[i][j ++];           // ungefiltert ins Datenfeld kopieren
              }
              else {                                                  // wenn UTF-8-Zeichen
                if (birthdays[i][j] == 0xc2 || birthdays[i][j] == 0xc3) { // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
                  datarray[count][k ++] = utf8_conv(birthdays[i][j ++], birthdays[i][j ++]); // 2 Bytes des UTF-8-Zeichens in internes Zeichen konvertieren
                }
                if (birthdays[i][j] == 0xe2) {                        // wenn 3-Byte-Zeichen (nutzbare Zeichen beginnen mit E2)
                  datarray[count][k ++] = utf8_conv3(birthdays[i][j ++], birthdays[i][j ++], birthdays[i][j ++]); // 3 Bytes des UTF-Zeichens in internes Zeichen konvertieren
                }
              }
            }
            if (k < 12) datarray[count][k ++] = ' ';                  // wenn noch Platz im Datenfeld -> Leerzeichen anfügen
            itoa(year - birthdays[i].substring(0, 4).toInt(), senval, 10); // Alter ermitteln und in Zeichenkette umwandeln
            j = 0;                                                    // Zeichenposition für Alter
            while (k < 12 && senval[j] > 0) {                         // solange noch Zeichen ins Datenfeld passen und das Alter weitere Zeichen enthält
              datarray[count][k ++] = senval[j ++];                   // Zeichen vom Alter ins Datenfeld kopieren
            }
            if (k < 12) datarray[count][k] = 0;                       // wenn noch Zeichen im Datenfeld frei -> Endezeichen setzen
            count ++;                                                 // nächstes Datenfeld auswählen
            bdayflag = true;                                          // Geburtstags-Flag setzen (für Geburtstagsalarm)
          }
        }
      }
      else break;                                                     // wenn kein Eintrag gefunden -> Schleife beenden
    }
  }
  while (count < 31) datarray[count ++][0] = 0;                       // restliche Datenfelder löschen

                                                                      // spezielle Alarme auswerten und ausgeben
  for (i = 4; i < 8; i ++) {                                          // 4 spezielle Alarme bearbeiten
    for (j = 0; j < sizeof(strbuf); j ++) strbuf[j] = 0;              // Stringpuffer löschen
    alarmlist[i].toCharArray(strbuf, 20);                             // Alarmbedingung in Stringpuffer kopieren (maximal 20 Zeichen)
    for (j = 0; j < 20; j ++) if (strbuf[j] == 0) break;              // Ende des Stringpuffers ermitteln
    if (j >= 5) {                                                     // wenn Stringpuffer mindestens 5 Zeichen enthält (Bedingung vorhanden)
      senname = '@';                                                  // Sensorname zunächst auf ungültigen Wert setzen
      senvalue = -100;                                                // Sensorwert zunächst auf ungültigen Wert setzen
      j = 0;                                                          // Position des Vergleichsoperators löschen
      if (strbuf[0] == '[' && strbuf[2] == ']') {                     // wenn Zeile mit "[" beginnt und sich "]" an zweiter Position befindet
        senname = strbuf[1];                                          // Sensorname ermitteln
        j = 3;                                                        // Position im Stringpuffer auf Vergleichsoperator setzen
        switch (senname) {                                            // Auswahl entsprechend Sensorname
          case 'A' ... 'L':                                           // falls Sensorname im Bereich A-L
            if (sensorvals[senname - 'A'][0] > 0 && sensordeci[senname - 'A'] < 3 && (millis() - sensortime[senname - 'A']) < (mqtt_vali * 60000)) { // wenn Sensorwert vorhanden und Wert gültig
              senvalue = atof(sensorvals[senname - 'A']);             // Sensorwert in numerischer Form zwischenspeichern
            }
            break;
          case 'M' ... 'U':                                           // falls Sensorname im Bereich M-U (Wetterdaten)
            if (weathervals[senname - 'M'][0] > 0 && (millis() - weathertime) < (60 * 60000)) { // wenn Wetterdatenwert vorhanden und Wert gültig
              senvalue = atof(weathervals[senname - 'M']);            // Sensorwert in numerischer Form zwischenspeichern
            }
            break;
          case 'a' ... 'd':                                           // falls Sensorname im Bereich a-d (Kraftstoffpreise)
            if (fuelvals[senname - 'a'][0] > 0 && (millis() - fueltime) < (60 * 60000)) { // wenn Kraftstoffwert vorhanden und Wert gültig
              senvalue = atof(fuelvals[senname - 'a']);               // Wert in numerischer Form zwischenspeichern
            }
            break;
        }
        if (senvalue != -100) {                                       // wenn Sensorwert vorhanden
          cmpname = '@';                                              // Vergleichsensorname zunächst auf ungültigen Wert setzen
          cmpvalue = -100;                                            // Vergleichsensorwert zunächst auf ungültigen Wert setzen
          if (strbuf[j + 1] == '[' && strbuf[j + 3] == ']') {         // wenn Vergleichswert ebenfalls ein Sensorname
            cmpname = strbuf[j + 2];                                  // Vergleichssensorname ermitteln
            switch (cmpname) {                                        // Auswahl entsprechend Vergleichssensorname
              case 'A' ... 'L':                                       // falls Vergleichssensorname im Bereich A-L
                if (sensorvals[cmpname - 'A'][0] > 0 && sensordeci[cmpname - 'A'] < 3 && (millis() - sensortime[cmpname - 'A']) < (mqtt_vali * 60000)) { // wenn Sensorwert vorhanden und Wert gültig
                  cmpvalue = atof(sensorvals[cmpname - 'A']);         // Vergleichssensorwert in numerischer Form zwischenspeichern
                }
                break;
              case 'M' ... 'U':                                       // falls Vergleichssensorname im Bereich M-U (Wetterdaten)
                if (weathervals[cmpname - 'M'][0] > 0 && (millis() - weathertime) < (60 * 60000)) { // wenn Wetterdatenwert vorhanden und Wert gültig
                  cmpvalue = atof(weathervals[cmpname - 'M']);        // Sensorwert in numerischer Form zwischenspeichern
                }
                break;
              case 'a' ... 'd':                                       // falls Vergleichssensorname im Bereich a-d (Kraftstoffpreise)
                if (fuelvals[cmpname - 'a'][0] > 0 && (millis() - fueltime) < (60 * 60000)) { // wenn Kraftstoffwert vorhanden und Wert gültig
                  cmpvalue = atof(fuelvals[cmpname - 'a']);           // Vergleichswert in numerischer Form zwischenspeichern
                }
                break;
            }
          }
          else {                                                      // wenn Vergleichswert direkt angegeben
            k = j + 1;                                                // Position im Stringpuffer auf Vergleichswert setzen
            l = 0;                                                    // Position im Zwischenspeicher für den Sensorwert auf Anfang setzen
            while (strbuf[k] > 0 && l < 9) senval[l ++] = strbuf[k ++]; // solange noch Zeichen im Stringpuffer und Platz im Zwischenspeicher -> Zeichen vom Vergleichswert kopieren
            senval[l] = 0;                                            // Stringende im Zwischenspeicher setzen
            cmpvalue = atof(senval);                                  // Vergleichssensorwert in numerischer Form zwischenspeichern
          }
          if (cmpvalue != -100) {                                     // wenn Vergleichswert vorhanden
            if (strbuf[j] == '<') {                                   // wenn Vergleichsoperator "<"
              if (senvalue < cmpvalue) send_alarm(i, true);           // wenn Sensorwert < Vergleichswert (Bedingung erfüllt) -> Alarm aktivieren
              else send_alarm(i, false);                              // wenn Bedingung nicht erfüllt -> Alarm deaktivieren
            }
            if (strbuf[j] == '>') {                                   // wenn Vergleichsoperator ">"
              if (senvalue > cmpvalue) send_alarm(i, true);           // wenn Sensorwert > Vergleichswert (Bedingung erfüllt) -> Alarm aktivieren
              else send_alarm(i, false);                              // wenn Bedingung nicht erfüllt -> Alarm deaktivieren
            }
          }
        }
      }
      if ((strbuf[0] == '*' || strbuf[0] == '+' || (strbuf[0] >= '1' && strbuf[0] <= '7')) && strbuf[1] == ':' && strbuf[4] == ':') { // wenn Timer-Alarm definiert
        almhourc[0] = strbuf[2];                                      // Alarmstunden Zehner kopieren
        almhourc[1] = strbuf[3];                                      // Alarmstunden Einer kopieren
        almhourc[2] = 0;                                              // Endezeichen
        almminutec[0] = strbuf[5];                                    // Alarmminuten Zehner kopieren
        almminutec[1] = strbuf[6];                                    // Alarmminuten Einer kopieren
        almminutec[2] = 0;                                            // Endezeichen
        almhour = atoi(almhourc);                                     // Alarmstunden in Zahl konvertieren
        almminute = atoi(almminutec);                                 // Alarmminuten in Zahl konvertieren
        if (almhour >= 0 && almhour < 24 && almminute >= 0 && almminute < 60) { // wenn gültige Alarmzeit
          if (almhour == hour && almminute == minute) {               // wenn Alarmzeit erreicht
            almwday = wday - 1;                                       // Wochentag umrechnen
            if (almwday == 0) almwday = 7;                            // wenn Wochentag = 0 (Sonntag) -> auf 7 ändern
            alarmtflag[0] = false;                                    // Merker für Alarmauslösung löschen
            if (strbuf[0] == '+' && bdayflag) alarmtflag[0] = true;   // wenn Geburtstagsalarm und Geburtstags-Flag -> Merker setzen
            if (strbuf[0] == char(almwday + 48)) alarmtflag[0] = true; // wenn Wochentagsalarm und passender Wochentag -> Merker setzen
            if (strbuf[0] == '*') alarmtflag[0] = true;               // wenn täglicher Alarm -> Merker setzen
            if (alarmtflag[0] && !alarmtflag[i]) {                    // wenn Merker gesetzt und Timer-Flag des Alarms noch nicht gesetzt
              alarmtflag[i] = true;                                   // Timer-Flag setzen (neue Auslösung verhindern)
              send_alarm(i, true);                                    // Alarm aktivieren
            }
            else send_alarm(i, false);                                // wenn Timer-Flag bereits gesetzt -> Alarm deaktivieren
          }
          else {                                                      // wenn Alarmzeit nicht passt
            alarmtflag[i] = false;                                    // Timer-Flag löschen
            send_alarm(i, false);                                     // Alarm deaktivieren
          }
        }
      }
    }
  }
}

// Alarme 1-8 bearbeiten (Alarme vom Sensormodul und spezielle Alarme)
void process_alarm(uint8_t alarm) {                                   // alarm: Alarmnummer (0-7)
  uint8_t i, j;                                                       // Zählervariablen

  if (alarm < 8) {                                                    // wenn Alarmnummer im zulässigen Bereich
    if (alarmvals[alarm][0] != '0') {                                 // wenn Alarm aktiv
      for (i = 0; i < sizeof(strbuf); i ++) strbuf[i] = 0;            // Stringpuffer löschen
      alarmtext[alarm].toCharArray(strbuf, 20);                       // Alarmtext in Stringpuffer kopieren (maximal 20 Zeichen)
      i = 0;                                                          // Zeichenzähler für Stringpuffer auf Anfang setzen
      j = 0;                                                          // Zeichenzähler für Alarmfeld auf Anfang setzen
      while (j < 12 && strbuf[i] > 0) {                               // solange noch Zeichen ins Alarmfeld passen und der Stringpuffer weitere Zeichen enthält
        if (strbuf[i] < 128) {                                        // wenn ASCII-Zeichen
          alarmarray[alarm][j ++] = strbuf[i ++];                     // ungefiltert ins Alarmfeld kopieren
        }
        else {                                                        // wenn UTF-8-Zeichen
          if (strbuf[i] == 0xc2 || strbuf[i] == 0xc3) {               // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
            alarmarray[alarm][j ++] = utf8_conv(strbuf[i ++], strbuf[i ++]); // 2 Bytes des UTF-8-Zeichens in internes Zeichen konvertieren
          }
          if (strbuf[i] == 0xe2) {                                    // wenn 3-Byte-Zeichen (nutzbare Zeichen beginnen mit E2)
            alarmarray[alarm][j ++] = utf8_conv3(strbuf[i ++], strbuf[i ++], strbuf[i ++]); // 3 Bytes des UTF-Zeichens in internes Zeichen konvertieren
          }
        }
      }
      if (j < 12) alarmarray[alarm][j] = 0;                           // wenn noch Platz im Alarmfeld -> Endezeichen setzen
      if (!alarmstat[alarm]) {                                        // wenn bisheriger Status inaktiv
        alarmstat[alarm] = true;                                      // Status auf aktiv setzen
        alarmcount = alarm;                                           // Alarm-Zähler auf neuen Alarm setzen
        if (!alarm_flag) alarm_flag = true;                           // wenn Alarm-Flag noch nicht gesetzt -> Alarm-Flag setzen
        if (syncstat > 0 && sound_enab && soundtime && !mute) {       // wenn Uhr synchronisiert, Sound aktiviert, Soundzeit und keine Stummschaltung
          if (alarmsound[alarm] > 0) {                                // wenn einer der 6 Alarm-Sounds ausgewählt ist
            soundflags[alarmsound[alarm] - 1] = true;                 // Sound-Flag setzen, akustischen Alarm auslösen
          }
        }
      }
      alarmtout[alarm] = ALRMTOUT / chgtime;                          // Timeout-Zähler des Alarms neu setzen
    }
    else {                                                            // wenn Alarm inaktiv
      if (alarmstat[alarm]) {                                         // wenn bisheriger Status aktiv
        alarmstat[alarm] = false;                                     // Status auf inaktiv setzen
        alarmtout[alarm] = ALRMTOUT / chgtime;                        // Timeout-Zähler des Alarms ein letztes mal neu setzen
      }
    }
  }
}

// Verarbeitung von Anrufen
void process_call() {
  uint8_t i, j;                                                       // Zähler- und Zwischenspeichervariablen
  char calltemp[CALLCHRS];                                            // Zwischenspeicher für Anrufinformation

  if (call_alarm > 0) {                                               // wenn Anruffunktion aktiviert und Alarmnummer gesetzt
    j = 0;                                                            // Zähler für Anruf-Parameter
    for (i = 0; i < 4; i ++) {                                        // Anrufdatenfeld durchsuchen
      if (callvals[i][0] > 0) j ++;                                   // wenn Anruf-Parameter vorhanden -> Zähler erhöhen
    }
    if (j == 4) {                                                     // wenn alle 4 Anruf-Parameter vorhanden
      if (strcmp(callvals[0], "ring") == 0) {                         // wenn Anruf-Ereignis
        if (call_numb.length() == 0 || call_numb == String(callvals[3])) { // wenn keine Nummer definiert oder eigene Nummer ok
          if (strcmp(callvals[1], "unknown") == 0) {                  // wenn Anrufer unbekannt (nicht im Telefonbuch)
            for (i = 0; i < 10; i ++) {                               // Anrufernummer auf 10 Ziffern kürzen
              if (callvals[2][i] == 0) break;                         // wenn weniger als 10 Ziffern -> Schleife abbrechen
            }
            if (i > 9) {                                              // wenn mindestens 10 Ziffern vorhanden
              if (callvals[2][10] > 0) {                              // wenn kein String-Ende (mehr als 10 Zeichen)
                callvals[2][10] = '.';                                // Punkt ergänzen
                callvals[2][11] = 0;                                  // neues String-Ende setzen
              }
            }
            strcpy(calltemp, callvals[2]);                            // Anrufernummer verwenden
          }
          else strcpy(calltemp, callvals[1]);                         // wenn Anrufer bekannt -> Anrufername verwenden
          if (strcmp(calltemp, "unknown") == 0) strcpy(calltemp, "Ohne Nummer"); // wenn Anrufer ohne Nummer -> anzeigen
          alarmtext[call_alarm - 1] = calltemp;                       // Alarmtext erstellen
          send_alarm(call_alarm - 1, true);                           // Alarm aktivieren (logische Alarmnummer verwenden)
        }
      }
      for (i = 0; i < 4; i ++) callvals[i][0] = 0;                    // Anruf-Parameter löschen
    }
    else send_alarm(call_alarm - 1, false);                           // wenn nicht alle 4 Anruf-Parameter vorhanden -> Alarm deaktivieren (logische Alarmnummer verwenden)
  }
}

// Verarbeitung einer Textnachricht
void process_msg(bool sound)                                          // sound: false = Ausgabe ohne Sound, true = Ausgabe mit Sound
{
  uint8_t  i = 0;                                                     // Zeigervariable für Nachrichtenstring
  uint16_t j = 0;                                                     // Zeigervariable für Pixelpuffer
  char     c, c1;                                                     // Zeichen-Zwischenspeicher
  uint16_t offset;                                                    // Offset in der Zeichensatz-Tabelle
  uint8_t  cwidth;                                                    // Pixelbreite des Zeichens
  uint8_t  x;                                                         // Zähler für die Zeichenausgabe, X-Position
  uint8_t  y;                                                         // Zähler für die Zeichenausgabe, Y-Position
  uint8_t  b;                                                         // Zwischenspeicher für Bytes aus der Zeichensatz-Tabelle
  uint8_t  s;                                                         // Byte mit in Spalten angeordneten Bits

  mesgv = "";                                                         // Nachrichtenstring für Web-Seite zunächst löschen
  for (i = 0; i < 12; i ++) {                                         // erste 12 Zeichen der Textnachricht
    mesgv += message[i];                                              // in Nachrichtenstring für Web-Seite übertragen
    if (mesgv[i] == 0) break;                                         // wenn weniger als 12 Zeichen -> Schleife abbrechen
  }
  if (i > 11) mesgv += "...";                                         // wenn mehr als 12 Zeichen vorhanden -> weitere Zeichen andeuten
  i = 0;                                                              // Zeiger wieder auf den Textanfang setzen
  while (i < message.length()) {                                      // solange noch Zeichen in der Textnachricht vorhanden sind
    c = message[i ++];                                                // Zeichen aus Textnachricht holen und Zeiger erhöhen
    if (c > 127 && message[i] > 0) {                                  // wenn UTF-8-Zeichen und noch ein weiteres Zeichen im Puffer
      if (c == 0xc2 || c == 0xc3) {                                   // wenn 2-Byte-Zeichen (nutzbare Zeichen beginnen mit C2 oder C3)
        c = utf8_conv(c, message[i ++]);                              // 2 Bytes des UTF-8-Zeichens in internes Zeichen konvertieren
      }
      if (c == 0xe2) {                                                // wenn 3-Byte-Zeichen (nutzbare Zeichen beginnen mit E2)
        c1 = message[i ++];                                           // zweites Zeichen aus Textnachricht holen und Zeiger erhöhen
        if (message[i] > 0) {                                         // wenn noch ein weiteres Zeichen im Puffer
          c = utf8_conv3(c, c1, message[i ++]);                       // 3 Bytes des UTF-Zeichens in internes Zeichen konvertieren
        }
      }
    }
    if (c >= 32) {                                                    // wenn zulässiger Zeichencode
      offset = (c - 32) * 12;                                         // Tabellen-Offset berechnen
      cwidth = pgm_read_byte(&charset_normal_array[offset]);          // Zeichenbreite holen
      if (cwidth > 8) cwidth = 8;                                     // Zeichenbreite auf 8 begrenzen
      for (x = cwidth; x > 0; x--) {                                  // X-Pixelposition von Zeichenbreite bis 1 bearbeiten
        s = 0;                                                        // Spaltenbyte 1 löschen
        for (y = 0; y < 3; y ++) {                                    // 3 Zeilenbytes bearbeiten (Zeile 0-2)
          s <<= 1;                                                    // Spaltenbits nach links verschieben
          b = pgm_read_byte(&charset_normal_array[offset + y + 1]);   // Zeilenbyte holen
          s |= (b >> (x - 1)) & 1;                                    // benötigtes Bit an Position 0 schieben, filtern und zum Spaltenbyte hinzufügen
        }
        if (j < sizeof(msgpbuf)) msgpbuf[j ++] = s;                   // wenn noch Platz im Pixelpuffer -> Spaltenbyte 1 in Puffer schreiben
        s = 0;                                                        // Spaltenbyte 2 löschen
        for (y = 3; y < 11; y ++) {                                   // 8 Zeilenbytes bearbeiten (Zeile 3-10)
          s <<= 1;                                                    // Spaltenbits nach links verschieben
          b = pgm_read_byte(&charset_normal_array[offset + y + 1]);   // Zeilenbyte holen
          s |= (b >> (x - 1)) & 1;                                    // benötigtes Bit an Position 0 schieben, filtern und zum Spaltenbyte hinzufügen
        }
        if (j < sizeof(msgpbuf)) msgpbuf[j ++] = s;                   // wenn noch Platz im Pixelpuffer -> Spaltenbyte 2 in Puffer schreiben
      }
    }
    if (j < sizeof(msgpbuf)) msgpbuf[j ++] = 0;                       // wenn noch Platz im Pixelpuffer -> leeres Spaltenbyte 1 in Puffer schreiben (Zwischenraum)
    if (j < sizeof(msgpbuf)) msgpbuf[j ++] = 0;                       // wenn noch Platz im Pixelpuffer -> leeres Spaltenbyte 2 in Puffer schreiben (Zwischenraum)
  }
  msgpbend = j;                                                       // Nachrichtenende festlegen
  msgpbpos = -128;                                                    // Ausgabeposition auf 64 Pixelspalten vor den Anfang setzen
  if (msgpbend > 0) {                                                 // wenn eine Nachricht im Puffer
    if (!msg_flag) msg_flag = true;                                   // wenn Nachrichten-Flag noch nicht gesetzt -> Nachrichten-Flag setzen
    if (sound && sound_enab && syncstat > 0 && soundtime && !mute) {  // wenn Sound aktiviert, Uhr synchronisiert, Sound-Zeit-Flag gesetzt und keine Stummschaltung
      soundflags[4] = true;                                           // Alarm für Textnachricht auslösen
    }
  }
}
