// Matrixuhr-ESP32, Scott-Falk Hühn, "main.cpp" ("matrixuhr-esp32.ino")
// Hauptprogramm

// Versionsnummern und Texte
#define VERSION_NUMB "2024-11-03"                 // Versionsnummer für Web-Seite
#define VERSION_TEXT "V1.300 * SFH"               // Versionstext für Web-Seite und Matrixuhr-Startseite

// Matrix-Modul-Parameter
#define PANEL_RES_X 64                            // Breite eines Moduls in Pixel
#define PANEL_RES_Y 32                            // Höhe eines Moduls in Pixel
#define PANEL_CHAIN 1                             // Anzahl der verketteten Module

// Pin-Belegung ESP32
#define R1_PIN 25                                 // Matrix-Anschluss R1
#define G1_PIN 26                                 // Matrix-Anschluss G1
#define B1_PIN 27                                 // Matrix-Anschluss B1
#define R2_PIN 14                                 // Matrix-Anschluss R2
#define G2_PIN 12                                 // Matrix-Anschluss G2
#define B2_PIN 13                                 // Matrix-Anschluss B2
#define A_PIN 23                                  // Matrix-Anschluss A
#define B_PIN 19                                  // Matrix-Anschluss B
#define C_PIN 5                                   // Matrix-Anschluss C
#define D_PIN 17                                  // Matrix-Anschluss D
#define E_PIN -1                                  // Matrix-Anschluss E (nicht genutzt)
#define LAT_PIN 4                                 // Matrix-Anschluss LAT
#define OE_PIN 15                                 // Matrix-Anschluss OE
#define CLK_PIN 16                                // Matrix-Anschluss CLK
#define ADC_PIN 34                                // Anschluss Helligkeitssensor
#define TOUCH_PIN 2                               // Anschluss Berührungssensor
#define RXD2_PIN 35                               // UART2 RXD (nicht genutzt)
#define TXD2_PIN 18                               // UART2 TXD zum Soundmodul

// Zeitvorgaben für Timeout-Zähler
#define SYSSTART 10                               // Anzeigezeit für Versionsinformationen beim Systemstart in Sekunden (maximal 254)
#define ALRMTOUT 120                              // Speicherzeit von Alarmdaten in Sekunden (maximal 254)
#define MUTETOUT 12                               // Zeit in Stunden bis zur automatischen Abschaltung der Mute-Funktion (maximal 254)
#define WIFITOUT 5                                // Zeit in Sekunden für neuen Verbindungsversuch nach einer WLAN-Unterbrechung
#define MQTTTOUT 5                                // Zeit in Sekunden für neuen Verbindungsversuch nach einer MQTT-Unterbrechung
#define NACTTOUT 30                               // Zeit in Sekunden für die vorübergehende Aktivierung des Displays zur Nachtzeit (maximal 254)
#define BOOTTOUT 25                               // Wartezeit in Zyklen von 40ms bis zum Reboot des ESP32
#define TOUCHTOUT 25                              // Wartezeit in Zyklen von 40ms bis zur Erkennung einer langen Berührung
#define TOUCHIDLE 13                              // Pausenzeit in Zyklen von 40ms zur Erkennung einer doppelten Berührung
#define SOUNDTOUT 75                              // Wartezeit in Zyklen von 40ms nach Auslösung eines akustischen Alarms

// Verschiedene Voreinstellungen
#define FILEDATA 16                               // maximale Anzahl der Zeilen im Dateipuffer
#define MAXFILES 20                               // maximale Anzahl der Dateien im Dateisystem
#define BRIGHTLEVEL sizeof(brightntab)            // Anzahl der Helligkeitstufen ermitteln
#define BRIGHTEXPO 0.75                           // Exponential-Korrekturwert für die Helligkeitsregelung
#define BRIGHTCORR 16320 / pow(16320, BRIGHTEXPO) // Korrekturfaktor für Helligkeitsregelung (16320 = 64 Speicherplätze * 255)
#define MAXBDAYS 100                              // maximale Anzahl der Einträge in der Geburtstagsliste
#define SENCHARS 13                               // maximale Anzahl der Zeichen der über MQTT empfangenen Sensorwerte
#define ALMCHARS 2                                // maximale Anzahl der Zeichen der über MQTT empfangenen Alarmwerte
#define CALLCHRS 20                               // maximale Anzahl der Zeichen der über MQTT empfangenen Anrufdaten
#define JSONBUFF 1536                             // maximale Anzahl der Zeichen der über MQTT empfangenen JSON-Daten (Wetter- Kraftstoffdaten)
#define WEATHERT 60                               // Gültigkeit der Wetterdaten in Minuten
#define TOUCHLEVEL 30                             // Schwellwert für die Erkennung einer Berührung

// Bibliotheken einbinden
#include <ESP32-HUB75-MatrixPanel-I2S-DMA.h>      // Matrix-Bibliothek
#include <LittleFS.h>                             // Dateisystem LittleFS
#include <WiFi.h>                                 // WLAN-Bibliothek
#include <sntp.h>                                 // zusätzliche NTP-Funktionen
#include <Update.h>                               // OTA-Update-Funktionen
#include <ESPAsyncWebServer.h>                    // Web-Server
#include <espMqttClient.h>                        // MQTT-Client
#include <ArduinoJson.h>                          // JSON-Bibliothek

// Definition der Dateinamen
#define bday_filename "/birthdays.txt"            // Dateiname für Geburtstagsliste
#define sens_filename "/sensors.txt"              // Dateiname für Sensor-Konfiguration
#define data_filename "/datadisp.txt"             // Dateiname für Datenanzeige-Konfiguration
#define alms_filename "/alarms.txt"               // Dateiname für Alarm-Konfiguration
#define cols_filename "/colors.txt"               // Dateiname für Farb-Konfiguration
#define disn_filename "/dispsound.txt"            // Dateiname für Anzeige- und Sound-Konfiguration
#define call_filename "/calls.txt"                // Dateiname für Anruf-Konfiguration
#define wifi_filename "/wifi.txt"                 // Dateiname für WLAN-Daten (SSID und Passwort)
#define matr_filename "/matrix.txt"               // Dateiname für Matrix-Einstellungen
#define netw_filename "/network.txt"              // Dateiname für Netzwerk-Einstellungen
#define time_filename "/time.txt"                 // Dateiname für Zeit-Einstellungen
#define mqtt_filename "/mqtt.txt"                 // Dateiname für MQTT-Einstellungen
#define http_filename "/http.txt"                 // Dateiname für HTTP-Authentifizierung

MatrixPanel_I2S_DMA *display = nullptr;           // Matrix-Dispay einrichten
WiFiClient espClient;                             // WLAN-Client einrichten
AsyncWebServer server(80);                        // Web-Server auf Port 80 einrichten
espMqttClient mqttClient;                         // MQTT-Client einrichten

// Folgende Variablen werden beim Systemstart aus dem Dateisystem gelesen

String wifi_ssid;                                 // WLAN-SSID (wird aus WLAN-Datei gelesen)
String wifi_pass;                                 // WLAN-Paswort (wird aus WLAN-Datei gelesen)
const char *wifi_ssid_p;                          // WLAN-SSID (wird aus WLAN-Datei gelesen)
const char *wifi_pass_p;                          // WLAN-Passwort (wird aus WLAN-Datei gelesen)
uint8_t matr_clks;                                // Matrix-Taktfrequenz (wird aus Matrix-Datei gelesen)
uint8_t matr_driv;                                // Matrix-Treiber-Chip (wird aus Matrix-Datei gelesen)
uint8_t matr_latb;                                // Matrix-Latch-Blanking (wird aus Matrix-Datei gelesen)
uint8_t matr_refr;                                // Matrix-Bildwiederholfrequenz (wird aus Matrix-Datei gelesen)
bool http_enab;                                   // HTTP-Authentifizierung aktiv (wird aus HTTP-Datei gelesen)
String http_user;                                 // HTTP-User-String (wird aus HTTP-Datei gelesen)
String http_pass;                                 // HTTP-Passwort-String (wird aus HTTP-Datei gelesen)
const char *http_user_p;                          // HTTP-Benutzer (wird aus HTTP-Datei gelesen)
const char *http_pass_p;                          // HTTP-Passwort (wird aus HTTP-Datei gelesen)
bool netw_enab;                                   // statische IP-Adresse aktivieren (wird aus Netzwerk-Datei gelesen)
String netw_addr;                                 // IP-Adresse (wird aus Netzwerk-Datei gelesen)
String netw_subn;                                 // Subnetz (wird aus Netzwerk-Datei gelesen)
String netw_gate;                                 // Gateway (wird aus Netzwerk-Datei gelesen)
String netw_dns1;                                 // DNS-Server (wird aus Netzwerk-Datei gelesen)
IPAddress IPaddr;                                 // IP-Adresse (wird aus Netzwerk-Datei gelesen)
IPAddress IPgate;                                 // Gateway (wird aus Netzwerk-Datei gelesen)
IPAddress IPsubn;                                 // Subnetzmaske (wird aus Netzwerk-Datei gelesen)
IPAddress IPdns1;                                 // DNS (wird aus Netzwerk-Datei gelesen)
String time_ntp1;                                 // NTP-Server 1 (wird aus Zeit-Datei gelesen)
String time_ntp2;                                 // NTP-Server 2 (wird aus Zeit-Datei gelesen)
String time_zone;                                 // Zeitzonen-Einstellungen (wird aus Zeit-Datei gelesen)
uint8_t time_ival;                                // Synchronisierungs-Intervall (wird aus Zeit-Datei gelesen)
const char *time_ntp1_p;                          // NTP-Server 1 (wird aus Zeit-Datei gelesen)
const char *time_ntp2_p;                          // NTP-Server 2 (wird aus Zeit-Datei gelesen)
const char *time_zone_p;                          // Zeitzonen-Einstellungen (wird aus Zeit-Datei gelesen)
bool mqtt_enab;                                   // MQTT aktivieren (wird aus MQTT-Datei gelesen)
String mqtt_addr;                                 // MQTT-Server-Adresse (wird aus MQTT-Datei gelesen)
String mqtt_port;                                 // MQTT-Server-Port (wird aus MQTT-Datei gelesen)
String mqtt_user;                                 // MQTT-Username (wird aus MQTT-Datei gelesen)
String mqtt_pass;                                 // MQTT-Passwort (wird aus MQTT-Datei gelesen)
String mqtt_ltop;                                 // MQTT LWT-Topic (wird aus MQTT-Datei gelesen)
String mqtt_utop;                                 // MQTT Uptime-Topic (wird aus MQTT-Datei gelesen)
String mqtt_rtop;                                 // MQTT RSSI-Topic (wird aus MQTT-Datei gelesen)
uint8_t mqtt_vali;                                // MQTT Werte-Gültigkeit (wird aus MQTT-Datei gelesen)
const char *mqtt_addr_p;                          // MQTT-Adresse (wird aus MQTT-Datei gelesen)
uint16_t mqtt_port_i;                             // MQTT-Server-Port (wird aus MQTT-Datei gelesen)
const char *mqtt_user_p;                          // MQTT-Username (wird aus MQTT-Datei gelesen)
const char *mqtt_pass_p;                          // MQTT-Passwort (wird aus MQTT-Datei gelesen)
const char *mqtt_ltop_p;                          // MQTT LWT-Topic (wird aus MQTT-Datei gelesen)
const char *mqtt_utop_p;                          // MQTT Uptime-Topic (wird aus MQTT-Datei gelesen)
const char *mqtt_rtop_p;                          // MQTT RSSI-Topic (wird aus MQTT-Datei gelesen)
uint8_t colorclk;                                 // Farbe für Uhrzeit (0-16), 0 = Zufall, 1-16 Farbe aus Tabelle (wird aus Farben-Datei gelesen)
uint8_t colordat;                                 // Farbe für Datum, Wochentag und Sensordaten (0-16), 0 = Zufall, 1-16 Farbe aus Tabelle (wird aus Farben-Datei gelesen)
uint8_t coloralm;                                 // Farbe für Alarmmeldungen (0-16), 0 = Zufall,  1-16 Farbe aus Tabelle (wird aus Farben-Datei gelesen)
uint8_t coloravo;                                 // Farbe meiden (0-16), 0 = aus, 1-16 Farbe aus Tabelle (wird aus Farben-Datei gelesen)
uint8_t chgtime;                                  // Wechselzeit der Anzeige in Sekunden (2-4) (wird aus Anzeige-Sound-Datei gelesen)
bool showdate;                                    // Datum anzeigen (true = ein) (wird aus Anzeige-Sound-Datei gelesen)
bool showday;                                     // Wochentag anzeigen (true = ein) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t smallmode;                                // Kleinanzeige-Modus (0-2), 0 = Kalendertag, 1 = Wochentag, 2 = Wechsel (wird aus Anzeige-Sound-Datei gelesen)
uint8_t brightchg;                                // Helligkeitsänderung (0-2), 0 = direkt, 1 = eine Sekunde, 2 = Wechsel-Intervall
uint8_t brightmin;                                // Minimale Helligkeit der LED-Matrix (0-10) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t brightmax;                                // Maximale Helligkeit der LED-Matrix (0-15) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t scrolltime;                               // Scroll-Geschwindigkeit der Textnachricht (0-10) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t night_stim;                               // Beginnzeit der Nacht (0-23) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t night_etim;                               // Endezeit der Nacht (0-23) (wird aus Anzeige-Sound-Datei gelesen)
String birthdays[MAXBDAYS];                       // Datenfeld mit Geburtstagsdaten (wird aus Geburtstags-Datei gelesen)
String sensorlist[15];                            // Datenfeld mit den MQTT-Topics der 12 Sensoren und 3 speziellen Informationen (wird aus Sensor-Datei gelesen)
const char *sensorlist_p[15];                     // Datenfeld mit den MQTT-Topics der 12 Sensoren und 3 speziellen Informationen (wird aus Sensor-Datei gelesen)
uint8_t sensordeci[12];                           // Datenfeld mit den Nachkommastellen der 12 Sensoren (0-3) (wird aus Sensor-Datei gelesen)
String datadisp[10];                              // Datenfeld für die Datenanzeige-Konfiguration (wird aus Datenanzeige-Datei gelesen)
String alarmlist[8];                              // Datenfeld mit den MQTT-Topics der 4 Alarme vom Messsystem bzw. Bedingungen der Alarme 5-8 (wird aus Alarmkonfigurations-Datei gelesen)
const char *alarmlist_p[4];                       // Datenfeld mit den MQTT-Topics der 4 Alarme vom Messsystem (wird aus Alarmkonfigurations-Datei gelesen)
uint8_t alarmsound[8];                            // Datenfeld für die Soundnummer der 8 Alarme (0-6) (wird aus Alarmkonfigurations-Datei gelesen)
bool alarmhold[8];                                // Datenfeld für den Haltemodus der 8 Alarme (true = halten, Quittierung erforderlich) (wird aus Alarmkonfigurations-Datei gelesen)
String alarmtext[8];                              // Datenfeld für den Alarmtext der 8 Alarme (wird aus Alarmkonfigurations-Datei gelesen)
bool sound_enab;                                  // Alarmsound, akustisches Alarmsignal eingeschaltet (true) (wird aus Anzeige-Sound-Datei gelesen)
bool sound_gong;                                  // Stundengong, akustisches Stundensignal eingeschaltet (true) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t sound_stim;                               // Beginnzeit der Soundausgabe (0-23) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t sound_etim;                               // Endzeit der Soundausgabe (0-23) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t sound_volu;                               // Lautstärke der Soundausgabe (0-30) (wird aus Anzeige-Sound-Datei gelesen)
uint8_t call_alarm;                               // Anrufanzeige, verwendete Alarmnummer (1-8, 0 = aus) (wird aus Anrufkonfigurations-Datei gelesen)
String call_numb;                                 // Anrufanzeige, eigene Nummer (wird aus Anrufkonfigurations-Datei gelesen)
String call_list[4];                              // Anrufanzeige, MQTT-Topics der 4 Anruf-Parameter (Ereignis, Anrufername, Anrufernummer, angerufene Nummer) (wird aus Anruf-Datei gelesen)
const char *call_list_p[4];                       // Anrufanzeige, MQTT-Topics der 4 Anruf-Parameter (Ereignis, Anrufername, Anrufernummer, angerufene Nummer) (wird aus Anruf-Datei gelesen)

// Weitere Variablen
JsonDocument json;                                // JSON-Puffer für die Dekodierung der Wetter- und Kraftstoffdaten
uint8_t bright[64];                               // Helligkeits-Puffer, enthält die letzten 64 im Abstand von 40ms gelesenen ADC-Werte vom Helligkeitssensor
uint8_t brightpos;                                // aktuelle Schreibposition des Helligkeits-Puffers
uint8_t brightlevel;                              // ermittelte Helligkeitsstufe für Zugriff auf Helligkeitstabelle 1
float brightdiv;                                  // Divisor für Helligkeitswert der LED-Matrix, wird für die Berechnung der Farbwerte benötigt (aus Helligkeitstabelle 2)
float brightfact;                                 // ermittelter Bereichsfaktor für die Berechnung der Helligkeitsstufe
int16_t posx;                                     // X-Position für die Zeichenausgabe (0-63)
int16_t posy;                                     // Y-Position für die Zeichenausgabe (0-31)
uint8_t colorclkr;                                // Zufallsfarbe für Uhrzeit (0-15)
uint8_t colordatr;                                // Zufallsfarbe für Datum, Wochentag und Sensordaten (0-15)
uint8_t coloralmr;                                // Zufallsfarbe für Alarmmeldungen (0-15)
uint8_t wifistat;                                 // aktueller WLAN-Status (0: normaler Verbindungsaufbau, 1: offline, 2: online)
bool mqttstat;                                    // aktueller MQTT-Status (true: online)
bool touchold;                                    // Berührungssensor, Zustand bei der letzten Abfrage
bool touchstat;                                   // Berührungssensor, aktueller stabiler Zustand
bool touchsquit;                                  // Berührungssensor, Quittierungs-Status für kurze Berührung
bool touchlquit;                                  // Berührungssensor, Quittierungs-Status für lange Berührung
uint8_t touchlong;                                // Berührungssensor, Zähler für lange Berührung (0-TOUCHTOUT)
uint8_t touchidle;                                // Berührungssensor, Zähler für Pause zwischen zwei Berührungen (0-TOUCHIDLE)
uint8_t dispmode;                                 // Anzeige-Modus (0-3)
                                                  // 0 = Normaler Modus (Zeit in großen Ziffern; Untere Zeile: Datum, Wochentag und Sensordaten im Wechsel)
                                                  // 1 = Alarm-Modus (Zeit verkleinert; Mittlere Zeile: Datum, Wochentag und Sensordaten im Wechsel; Untere Zeile: Alarmmeldungen im Wechsel)
                                                  // 2 = Nachrichten-Modus (Zeit verkleinert; Mittlere Zeile: Datum, Wochentag und Sensordaten im Wechsel; Untere Zeile: Nachricht als Laufschrift
                                                  // 3 = Systemstart-Modus (Zeit verkleinert; Mittlere und untere Zeile: Versions-Informationen)
uint8_t disptest;                                 // Anzeige-Testmodus (0-5)
                                                  // 0 = Normaler Modus
                                                  // 1 = Alle Pixel Rot
                                                  // 2 = Alle Pixel Grün
                                                  // 3 = Alle Pixel Blau
                                                  // 4 = Alle Pixel Weiß
                                                  // 5 = Farbmuster
bool alarm_flag;                                  // Alarm-Flag, mindestens ein Alarm ist aktiv
bool msg_flag;                                    // Nachrichten-Flag, eine Textnachricht wurde empfangen
uint8_t lasthour;                                 // Letzte Stunde, wird für die Erkennung des Stundenwechsels verwendet (automatischer Farbwechsel)
int8_t datacount;                                 // Zähler für die auszugebenden Datenfelder, zählt alle 2-4 Sekunden von 0 aufwärts:
                                                  // 0    = Ausgabe des Datums (wird übersprungen, wenn "Datum anzeigen" ausgeschaltet ist)
                                                  // 1    = Ausgabe des Wochentages (wird übersprungen, wenn "Wochentag anzeigen" ausgeschaltet ist)
                                                  // 2-32 = Ausgabe eines Sensorwertes oder Geburtstages (leere Felder werden übersprungen), mit Sensorfilter: Bereich 2-9
                                                  // 33   = Ausgabe von "keine Daten" (nur wenn Datum und Wochentag ausgeschaltet sind und keine Sensordaten vorhanden sind)
uint8_t alarmcount;                               // Zähler für die auszugebenden Alarmfelder, zählt alle 2-4 Sekunden von 0 aufwärts
uint8_t daymcount;                                // Zähler für die Taganzeige, wechselt alle 2-4 Sekunden zwischen 0 und 1
uint8_t syncstat;                                 // Status der Zeit-Synchronsierung (0-2)
                                                  // 0 = Uhr ist nicht synchronisiert (Status nach Systemstart) -> Doppelpunkt in Uhrzeit erscheint in der Alarmfarbe
                                                  // 1 = Uhr wurde mindestens 3 NTP-Intervalle nicht synchronisiert (Sync-Ausfall) -> Doppelpunkt in Uhrzeit erscheint in der Datumfarbe
                                                  // 2 = Uhr wurde innerhalb 3 NTP-Intervalle synchronisiert (Normalzustand) -> Doppelpunkt erscheint in der Zeitfarbe
uint8_t synctout;                                 // Synchronisierungs-Timeout-Zähler, nach Ablauf der Zeit wird der Synchronisierungsstatus auf Sync-Ausfall (syncstat = 1) gesetzt; wird vom Haupt-
                                                  // gesetzt und im Minutentakt auf 0 gezählt, das Hauptprogramm setzt nach Bearbeitung den Wert auf 255 (Stopp)
uint8_t disptout;                                 // Anzeige-Timeout-Zähler, nach Ablauf der Zeit wird zum normalen Anzeige-Modus zurückgekehrt; wird vom Hauptprogramm gesetzt und im Sekundentakt auf
                                                  // 0 gezählt, das Hauptprogramm setzt nach Bearbeitung den Wert auf 255 (Stopp)
uint8_t mutetout;                                 // Stummschaltungs-Timeout-Zähler, nach Ablauf der Zeit wird die Stummschaltung wieder aufgehoben; wird vom Hauptprogramm gesetzt und im Stundentakt
                                                  // auf 0 gezählt, das Hauptprogramm setzt nach Bearbeitung den Wert auf 255 (Stopp)
uint8_t wifitout;                                 // WLAN-Timeout-Zähler für Neuverbindung nach Unterbrechung, nach Ablauf der Zeit wird ein Verbindungsversuch gestartet; wird vom Hauptprogramm
                                                  // gesetzt und im Sekundentakt auf 0 gezählt, das Hauptprogramm setzt nach Bearbeitung den Wert auf 255 (Stopp)
uint8_t mqtttout;                                 // MQTT-Timeout-Zähler für Neuverbindung nach Unterbrechung, nach Ablauf der Zeit wird ein Verbindungsversuch gestartet; wird vom Hauptprogramm
                                                  // gesetzt und im Sekundentakt auf 0 gezählt, das Hauptprogramm setzt nach Bearbeitung den Wert auf 255 (Stopp)
uint8_t boottout;                                 // Reboot-Timeout-Zähler, nach Ablauf wird der ESP32 neu gestartet; wird vom Hauptprogramm gesetzt und im 40ms-Takt auf 0 gezählt, das Hauptprogramm
                                                  // setzt nach Bearbeitung den Wert auf 255 (Stopp)
uint8_t nacttout;                                 // Nachtaktivierungs-Timeout-Zähler, während der Nacht wird das Display durch Sensorberührung aktiviert und nach Ablauf der Zeit wieder deaktiviert;
                                                  // wird vom Hauptprogramm gesetzt und im Sekundentakt auf 0 gezählt, das Hauptprogramm setzt nach Bearbeitung den Wert auf 255 (Stopp)
char strbuf[50];                                  // Stringpuffer für die Matrix-Textausgabe und die Generierung von Einträgen für das Daten- und Alarmfeld
char datarray[31][12];                            // Datenfeld mit 31 Plätzen und jeweils 12 Zeichen für Sensor- und Geburtstagsdaten
char alarmarray[8][12];                           // Alarmfeld mit 8 Plätzen und jeweils 12 Zeichen für Alarme, die Plätze 0-3 werden immer von den Alarmen 1-4 des Sensormoduls verwendet
uint8_t alarmtout[8];                             // Alarmfeld-Timeout-Zähler mit 8 Plätzen, wird bei aktivem Alarm auf [alrmtout / chtime] gesetzt und im Wechselzeit-Takt rückwärts gezählt, bei 0
                                                  // wird der zugehörige Datensatz gelöscht bzw. markiert und der Zähler auf 255 gesetzt (Stopp)
bool alarmstat[8];                                // Alarmfeld-Status mit 8 Plätzen (true = Alarm aktiv)
bool alarmtflag[8];                               // Alarm-Timer-Flag-Feld mit 8 Plätzen (true = Timer-Alarm aktiv, nur 0, 4, 5, 6, 7 wird genutzt)
bool soundflags[6];                               // Sound-Flags für die Ausgabe der 6 akustischen Alarmsignale, true = Signal steht an
bool soundtime;                                   // Sound-Zeit-Flag, wird im Zeitraum zwischen Beginn- und Endzeit gesetzt und bei der Erzeugung der akustischen Alarme ausgewertet
uint8_t soundtout;                                // Sound-Timeout-Zähler, blockiert die Soundausgabe; wird vom Hauptprogramm gesetzt und im 40ms-Takt auf 0 gezählt, das Hauptprogramm setzt nach
                                                  // Bearbeitung den Wert auf 255 (Stopp)
bool mute;                                        // manuelle Stummschaltung, true = keine akustischen Alarme ausgeben
uint8_t quitcount;                                // Quittierungs-Zähler zur Anzeige der Animation beim Quittieren (0-32)
uint16_t color;                                   // Zwischenspeicher für RGB565-Farbwert
uint16_t coloru;                                  // Zwischenspeicher für RGB565-Farbwert (Unterstreichung)
unsigned long ms40millis;                         // Zwischenspeicher für Millisekundenwert (für 40ms-Timeout-Zähler-Funktionen)
unsigned long scrollmillis;                       // Zwischenspeicher für Millisekundenwert (für das Scrollen der Textnachricht)
unsigned long ms40count;                          // Zähler für 40ms-Intervalle (0-24) zur Erzeugung eines 1-Sekunden-Taktes für weitere Timeout-Zähler
uint8_t seccount;                                 // Sekundenzähler für Timeout-Funktionen (0-59)
uint8_t mincount;                                 // Minutenzähler für Timeout-Funktionen (0-59)
uint8_t houcount;                                 // Stundenzähler für Timeout-Funktionen (0-23)
unsigned long lastmillis;                         // Zwischenspeicher für Millisekundenwert (für blinkenden Doppelpunkt)
unsigned long luptmillis;                         // Zwischenspeicher für Millisekundenwert (für die Ermittlung der Laufzeit)
uint8_t lastsec;                                  // letzter gespeicherter Sekundenwert (für blinkenden Doppelpunkt und Timeout-Zähler-Funktionen)
bool filestat;                                    // Dateisystem vorhanden (wenn true)
bool ntp_ok;                                      // NTP-Dienst wurde gestartet (wenn true)
bool mqtt_ok;                                     // MQTT-Dienst wurde gestartet (wenn true)
bool mqtt_actv;                                   // MQTT Aktive-Status, wird beim Systemstart von mqtt_enab übernommen
struct tm timeinfo;                               // Variable für Zeitinformationen (aktuelle Zeit)
uint16_t year;                                    // Jahr
uint8_t month;                                    // Monat
uint8_t day;                                      // Tag
uint8_t wday;                                     // Wochentag
uint8_t hour;                                     // Stunde
uint8_t minute;                                   // Minute
uint8_t second;                                   // Sekunde
time_t utc;                                       // Variable für Zeit (UTC)
struct tm *utcinfo;                               // Variable für Zeitinformationen (UTC)
long uptime_m;                                    // Systemlaufzeit in Minuten
String serialstr;                                 // Puffer-String für empfangene serielle Daten
char serialchar;                                  // Zwischenspeicher für empfangenes serielles Zeichen
String newssid;                                   // neuer WLAN-SSID-String (wird seriell empfangen)
String newpass;                                   // neuer WLAN-Passwort-String (wird seriell empfangen)
char uptime[8];                                   // formatierter String mit der Systemlaufzeit in Tagen mit 2 Nachkommastellen (für MQTT-Ausgabe)
char uptimex[15];                                 // formatierter String mit dynamischer Systemlaufzeit in Minuten, Stunden oder Tagen (für Web-Seite)
int8_t rssi;                                      // RSSI-Wert in dB
uint8_t save;                                     // Status der letzten Speicheraktion für die Anzeige auf der Web-Seite (0 = keine Anzeige, 1 = OK, 2 = Fehler)
bool result;                                      // Ergebnis der letzten Dateioperation
bool reboot;                                      // Flag für Hinweis auf Neustart
String filedata[FILEDATA];                        // Dateipuffer zum Lesen und Schreiben von Dateien
const char *ipval;                                // Zeiger auf aktuellen IP-Wert, wird zur Konvertierung aus Stringwert benötigt
IPAddress ipadd;                                  // Zwischenspeicher zur Plausibilitätsprüfung einer IP-Adresse
bool err_flag;                                    // Fehler-Flag, wird beid er Konvertierung aus Stringwert benötigt
String filenames[MAXFILES];                       // Dateinamen-Liste für Datei-Manager
String filesizes[MAXFILES];                       // Dateigrößen-Liste für Datei-Manager
String filelist;                                  // Dateiliste für die Web-Seite
uint8_t filecount;                                // Zähler für Datei-Manager
uint8_t filenumb;                                 // eingegebene Dateinummer im Datei-Manager
String filetemp;                                  // Zwischenspeicher für Datei-Manager
String bdaylist;                                  // Geburtstagsliste für die Web-Seite
uint8_t bdaycount;                                // Zähler für Geburtstagsliste
uint8_t bdaynumb;                                 // eingegebene Eintragsnummer in der Geburtstagsliste
String bdaydate;                                  // eingegebenes Datum in der Geburtstagsliste
String bdayname;                                  // eingegebener Name in der Geburtstagsliste
String bdayadd;                                   // Zwischenspeicher für Klick auf "Hinzufügen"
String bdaydels;                                  // Zwischenspeicher für Klick auf "Löschen"
bool callfunction;                                // Anruffunktion aktivieren (wenn true)
char sensorvals[12][SENCHARS];                    // über MQTT empfangene Sensorwerte (jeweils maximal SENCHARS Zeichen)
char alarmvals[8][ALMCHARS];                      // über MQTT empfangene Alarmwerte (jeweils maximal ALMCHARS Zeichen)
bool alarmflags[8];                               // Alarm-Flags, werden beim Empfang eines Alarms gesetzt und vom Hauptprogramm bearbeitet
char callvals[4][CALLCHRS];                       // über MQTT empfangene Anrufdaten (jeweils maximal CALLCHRS Zeichen)
char weatherjson[JSONBUFF];                       // über MQTT empfangene Wetterdaten (maximal WEATCHRS Zeichen)
char fueljson[JSONBUFF];                          // über MQTT empfangene Kraftstoffdaten (maximal FUELCHRS Zeichen)
String weatv;                                     // erste 12 Zeichen der empfangenen Wetterdaten (für Web-Seite)
String fuelv;                                     // erste 12 Zeichen der empfangenen Kraftstoffdaten (für Web-Seite)
String mesgv;                                     // erste 12 Zeichen der empfangenen Textnachricht (für Web-Seite)
unsigned long sensortime[12];                     // Zeitstempel (Millis) der über MQTT empfangenen Sensorwerte
unsigned long weathertime;                        // Zeitstempel (Millis) der über MQTT empfangenen Wetterdaten
unsigned long fueltime;                           // Zeitstempel (Millis) der über MQTT empfangenen Kraftstoffdaten
bool weatherflag;                                 // zeigt an, wenn neue Wetterdaten empfangen wurden (wenn true)
bool fuelflag;                                    // zeigt an, wenn neue Kraftstoffdaten empfangen wurden (wenn true)
char weathervals[13][15];                         // Datenfeld für die einzelnen Wetterinformationen:
                                                  //  0 - Temperatur in °C mit einer Nachkommastelle
                                                  //  1 - Temperatur in °C ohne Nachkommastelle
                                                  //  2 - Luftfeuchtigkeit in % ohne Nachkommastelle
                                                  //  3 - Luftdruck in hPa ohne Nachkommastelle
                                                  //  4 - Windgeschwindigkeit in m/s mit einer Nachkommastelle
                                                  //  5 - Windgeschwindigkeit in km/h ohne Nachkommastelle
                                                  //  6 - Regenmenge in mm/h mit einer Nachkommastelle
                                                  //  7 - Regenmenge in mm/h ohne Nachkommastelle
                                                  //  8 - Wolkendichte in % ohne Nachkommastelle
                                                  //  9 - Symbol für Windrichtungspfeil ($0 - $8)
                                                  // 10 - Wettersymbol ($A - $S)
                                                  // 11 - Wetterlage, Tabelleneintrag (0-54)
                                                  // 12 - Zeiten für Sonnenaufgang und Sonnenuntergang
char fuelvals[4][12];                             // Datenfeld für die einzelnen Kraftstoffpreise
uint16_t sunrise;                                 // Sonnenaufgangszeit (Minuten seit 0:00 Uhr)
uint16_t sunset;                                  // Sonnenuntergangszeit (Minuten seit 0:00 Uhr)
uint16_t curtime;                                 // aktuelle Zeit (Minuten seit 0:00 Uhr)
bool nightsymbol;                                 // Nachtmodus für Wettersymbol
bool nighttime;                                   // Nachtzeit für Display
uint8_t msgpbuf[1000];                            // Pixelpuffer für die Textnachricht, der Platz reicht für 500 Pixelspalten, die jeweils 2 Bytes benötigen
int16_t msgpbend;                                 // zeigt auf das Ende der Nachricht im Pixelpuffer
int16_t msgpbpos;                                 // zeigt auf die aktuelle Pixelspalte im Pixelpuffer, wird für die Laufschrift-Ausgabe benötigt
String message;                                   // Speicher für die Textnachricht
bool messageflag;                                 // zeigt an, wenn eine neue Textnachricht empfangen wurde (wenn true)
const char *mqtt_lmsg_p;                          // MQTT LWT-Message (wird fest auf "offline" gesetzt)
const char *mqtt_smsg_p;                          // MQTT LWT-Start-Message (wird fest auf "online" gesetzt)
uint32_t sketch;                                  // Sketch-Größe, wird beim Systemstart gelesen und für Fortschrittsanzeige beim Firmware-Update benötigt
uint32_t fwcount;                                 // Bytezähler beim Firmware-Update
bool fwupok;                                      // Firmware-Update war erfolgreich (wenn true)
uint16_t cnt_wifi;                                // Zähler für Reconnects der WLAN-Verbindung (wird derzeit nicht ausgewertet)
uint16_t cnt_ntp;                                 // Zähler für Reconnects der NTP-Verbindung (wird derzeit nicht ausgewertet)
uint16_t cnt_mqtt;                                // Zähler für Reconnects der MQTT-Verbindung (wird derzeit nicht ausgewertet)

#include "charset.h"                              // Zeichensätze einbinden
#include "tables.h"                               // Verschiedene Tabellen und Texte einbinden
#include "process.h"                              // Ablaufsteuerung der Datenausgabe
#include "functions.h"                            // Verschiedene Funktionen einbinden
#include "http.h"                                 // Webserver-Daten und Funktionen einbinden

void setup() { // ====================================================== Initialisierung ======================================================================
  Serial.begin(115200);                                               // USB-Kommunikation aktivieren
  Serial.println(F("Systemstart"));
  Serial2.begin(9600, SERIAL_8N1, RXD2_PIN, TXD2_PIN);                // Schnittstelle zum Soundmodul aktivieren
  pinMode(RXD2_PIN, PULLUP);                                          // Pull-up am ungenutzten RXD-Pin aktivieren

  if (!LittleFS.begin(false)) {                                       // wenn Dateisystem noch nicht vorhanden
    Serial.println(F("Dateisystem wird angelegt"));
    if (LittleFS.begin(true)) {                                       // Dateisystem anlegen
      filestat = true;                                                // Dateisystem ist ok
      Serial.println(F("Dateisystem wurde angelegt"));
    }
    else {                                                            // Dateisystem ist nicht ok
      Serial.println(F("Fehler beim Anlegen des Dateisystems"));
    }
  }
  else {                                                              // wenn Dateisystem vorhanden
    filestat = true;                                                  // Dateisystem ist ok
    Serial.println(F("Dateisystem ok"));
  }

  // ------------------------------------------------------------------- Einstellungen und Konfiguration aus Dateisystem lesen --------------------------------

  Serial.print(F("Matrix-Einstellungen lesen ..."));
  result = read_cfgfile(matr_filename, 4);                            // Matrix-Einstellungen aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    matr_clks = filedata[0].toInt();                                  // Matrix-Taktfrequenz holen
    matr_driv = filedata[1].toInt();                                  // Matrix-Treiber-Chip holen
    matr_latb = filedata[2].toInt();                                  // Matrix-Latch-Blanking holen
    matr_refr = filedata[3].toInt();                                  // Matrix-Bildwiederholfrequenz holen
    if (matr_clks > 3) matr_clks = 0;                                 // wenn Bereich überschritten -> Default-Wert setzen
    if (matr_driv > 1) matr_driv = 0;                                 // wenn Bereich überschritten -> Default-Wert setzen
    if (matr_latb < 1 || matr_latb > 4) matr_latb = 1;                // wenn Bereich überschritten -> Default-Wert setzen
    if (matr_refr < 50) matr_refr = 50;                               // wenn Bereich unterschritten -> Default-Wert setzen
    if (matr_refr > 200) matr_refr = 200;                             // wenn Bereich überschritten -> Maximal-Wert setzen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    matr_clks = 0;                                                    // Voreinstellungen setzen
    matr_driv = 1;
    matr_latb = 1;
    matr_refr = 50;
    Serial.println(F(" Fehler"));
  }

  Serial.print(F("WLAN-Einstellungen lesen ..."));
  result = read_cfgfile(wifi_filename, 2);                            // WLAN-Zugangsdaten aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    wifi_ssid = filedata[0];                                          // SSID holen
    wifi_pass = filedata[1];                                          // Passwort holen
    if (wifi_ssid.length() == 0) wifi_ssid = "wifi_ssid";             // wenn keine SSID -> Dummy-Wert setzen
    if (wifi_pass.length() == 0) wifi_pass = "wifi_pass";             // wenn kein Passwort -> Dummy-Wert setzen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Lesen nicht erfolgreich
    wifi_ssid = "wifi_ssid";                                          // SSID-Dummy-Wert setzen
    wifi_pass = "wifi_pass";                                          // Passwort-Dummy-Wert setzen
    Serial.println(F(" Fehler"));
  }
  wifi_ssid_p = wifi_ssid.c_str();                                    // Zeiger auf SSID setzen
  wifi_pass_p = wifi_pass.c_str();                                    // Zeiger auf Paswort setzen

  Serial.print(F("Netzwerk-Einstellungen lesen ..."));
  result = read_cfgfile(netw_filename, 5);                            // Netzwerk-Einstellungen aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    netw_enab = filedata[0].toInt();                                  // statische IP-Adresse Aktivierung holen
    netw_addr = filedata[1];                                          // IP-Adresse holen
    netw_subn = filedata[2];                                          // Subnetzmaske holen
    netw_gate = filedata[3];                                          // Gateway holen
    netw_dns1 = filedata[4];                                          // DSN holen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    netw_enab = false;                                                // Voreinstellungen setzen
    netw_addr = "192.168.1.229";
    netw_subn = "255.255.255.0";
    netw_gate = "192.168.1.1";
    netw_dns1 = "192.168.1.1";
    Serial.println(F(" Fehler"));
  }
  err_flag = false;                                                   // Fehler-Flag löschen
  ipval = netw_addr.c_str();                                          // Zeiger setzen
  if (!IPaddr.fromString(ipval)) err_flag = true;                     // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
  ipval = netw_subn.c_str();                                          // Zeiger setzen
  if (!IPsubn.fromString(ipval)) err_flag = true;                     // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
  ipval = netw_gate.c_str();                                          // Zeiger setzen
  if (!IPgate.fromString(ipval)) err_flag = true;                     // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
  ipval = netw_dns1.c_str();                                          // Zeiger setzen
  if (!IPdns1.fromString(ipval)) err_flag = true;                     // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
  if (err_flag) netw_enab = false;                                    // wenn Konvertierung fehlgeschlagen ist -> statische IP-Adresse deaktivieren

  Serial.print(F("MQTT-Einstellungen lesen ..."));
  result = read_cfgfile(mqtt_filename, 9);                            // MQTT-Einstellungen aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    mqtt_enab = filedata[0].toInt();                                  // MQTT Aktivierung holen
    mqtt_addr = filedata[1];                                          // MQTT Server-Adresse holen
    mqtt_port = filedata[2];                                          // MQTT Server-Port holen
    mqtt_user = filedata[3];                                          // MQTT Username holen
    mqtt_pass = filedata[4];                                          // MQTT Passwort holen
    mqtt_ltop = filedata[5];                                          // MQTT LWT-Topic holen
    mqtt_utop = filedata[6];                                          // MQTT Uptime-Topic holen
    mqtt_rtop = filedata[7];                                          // MQTT RSSI-Topic holen
    mqtt_vali = filedata[8].toInt();                                  // MQTT Werte-Gültigkeit holen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    mqtt_enab = false;                                                // Voreinstellungen setzen
    mqtt_addr = "192.168.1.222";
    mqtt_port = "1883";
    mqtt_user = "";
    mqtt_pass = "";
    mqtt_ltop = "Haus/Technik/MatrixuhrESP-1/LWT";
    mqtt_utop = "Haus/Technik/MatrixuhrESP-1/uptime";
    mqtt_rtop = "Haus/Technik/MatrixuhrESP-1/rssi";
    mqtt_vali = 10;
    Serial.println(F(" Fehler"));
  }
  if (mqtt_addr.length() == 0 || mqtt_port.length() == 0) mqtt_enab = false; // wenn keine MQTT-Server-Adresse oder kein MQTT-Server-Port -> MQTT deaktivieren
  if (mqtt_enab) {                                                    // wenn MQTT aktiviert
    mqtt_addr_p = mqtt_addr.c_str();                                  // Zeiger auf MQTT-Server-Adresse setzen
    mqtt_port_i = mqtt_port.toInt();                                  // MQTT-Port in Zahl umwandeln
    if (mqtt_user.length() > 0) mqtt_user_p = mqtt_user.c_str();      // wenn MQTT-Username vorhanden -> Zeiger setzen
    else mqtt_user_p = nullptr;                                       // sonst Nullzeiger setzen
    if (mqtt_pass.length() > 0) mqtt_pass_p = mqtt_pass.c_str();      // wenn MQTT-Passwort vorhanden -> Zeiger setzen
    else mqtt_pass_p = nullptr;                                       // sonst Nullzeiger setzen
    if (mqtt_ltop.length() > 0) mqtt_ltop_p = mqtt_ltop.c_str();      // wenn MQTT LWT-Topic vorhanden -> Zeiger setzen
    else mqtt_ltop_p = nullptr;                                       // sonst Nullzeiger setzen
    if (mqtt_utop.length() > 0) mqtt_utop_p = mqtt_utop.c_str();      // wenn MQTT Uptime-Topic vorhanden -> Zeiger setzen
    else mqtt_utop_p = nullptr;                                       // sonst Nullzeiger setzen
    if (mqtt_rtop.length() > 0) mqtt_rtop_p = mqtt_rtop.c_str();      // wenn MQTT RSSI-Topic vorhanden -> Zeiger setzen
    else mqtt_rtop_p = nullptr;                                       // sonst Nullzeiger setzen
    if (mqtt_vali < 2 || mqtt_vali > 60) mqtt_vali = 10;              // wenn Werte-Gültigkeit außerhalb des Bereiches -> Voreinstellung setzen
  }
  mqtt_actv = mqtt_enab;                                              // MQTT-Aktivierung wird auf aktuellen Status übertragen

  Serial.print(F("Zeit-Einstellungen lesen ..."));
  result = read_cfgfile(time_filename, 4);                            // Zeit-Einstellungen aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    time_ntp1 = filedata[0];                                          // NTP-Server 1 holen
    time_ntp2 = filedata[1];                                          // NTP-Server 2 holen
    time_zone = filedata[2];                                          // Zeitzonen-Einstellung holen
    time_ival = filedata[3].toInt();                                  // Synchronisierungs-Intervall holen
    if (time_ntp1.length() == 0) time_ntp1 = "de.pool.ntp.org";       // wenn kein NTP-Server 1 -> Voreinstellung setzen
    if (time_zone.length() == 0) time_zone = "CET-1CEST,M3.5.0,M10.5.0/3"; // wenn keine Zeitzonen-Einstellung -> Voreinstellung setzen
    if (time_ival < 5 || time_ival > 60) time_ival = 30;              // wenn kein Synchronisierungs-Intervall -> Voreinstellung setzen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Lesen nicht erfolgreich
    time_ntp1 = "de.pool.ntp.org";                                    // Voreinstellungen setzen
    time_ntp2 = "ptbtime1.ptb.de";
    time_zone = "CET-1CEST,M3.5.0,M10.5.0/3";
    time_ival = 30;
    Serial.println(F(" Fehler"));
  }
  time_ntp1_p = time_ntp1.c_str();                                    // Zeiger auf NTP-Server 1 setzen
  if (time_ntp2.length() > 0) time_ntp2_p = time_ntp2.c_str();        // wenn NTP2-Server definiert -> Zeiger auf NTP-Server 2 setzen
  else time_ntp2_p = nullptr;                                         // sonst Nullzeiger setzen
  time_zone_p = time_zone.c_str();                                    // Zeiger auf Zeitzonen-Einstellung setzen

  Serial.print(F("HTTP-Authentifizierung lesen ..."));
  result = read_cfgfile(http_filename, 3);                            // HTTP-Authentifizierung aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    http_enab = filedata[0].toInt();                                  // HTTP-Aktivierung holen
    http_user = filedata[1];                                          // HTTP-Username holen
    http_pass = filedata[2];                                          // HTTP-Passwort holen
    if (http_user.length() == 0) http_user = "admin";                 // wenn kein HTTP-Username -> Dummy-Wert setzen
    if (http_pass.length() == 0) http_pass = "admin";                 // wenn kein HTTP-Passwort -> Dummy-Wert setzen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    http_enab = false;                                                // Voreinstellungen setzen
    http_user = "admin";
    http_pass = "admin";
    Serial.println(F(" Fehler"));
  }
  http_user_p = http_user.c_str();                                    // Zeiger auf HTTP-Username setzen
  http_pass_p = http_pass.c_str();                                    // Zeiger auf HTTP-Passwort setzen

  Serial.print(F("Geburtstage lesen ..."));
  result = read_bdayfile();                                           // Geburtstagsdatei lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    for (bdaycount = 0; bdaycount < MAXBDAYS; bdaycount ++) {         // Anzahl der Einträge ermitteln
      if (birthdays[bdaycount] == "") break;                          // wenn leerer String -> Ende
    }
    Serial.print(F(" ok, "));
    Serial.print(bdaycount);
    Serial.println(F(" Eintraege"));
  }
  else Serial.println(F(" Fehler"));

  Serial.print(F("Sensoren lesen ..."));
  result = read_cfgfile(sens_filename, 15);                           // Sensorliste aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    for (uint8_t i = 0; i < 12; i ++) {                               // 12 Einträge bearbeiten (nur normale Sensoren)
      if (filedata[i].length() > 0) {                                 // wenn MQTT-Topic vorhanden
        sensorlist[i] = filedata[i].substring(0, filedata[i].length() - 2);      // Eintrag holen und MQTT Topic filtern
        sensordeci[i] = filedata[i].substring(filedata[i].length() - 1).toInt(); // Eintrag holen und Nachkommastelle filtern
        if (sensordeci[i] > 3) sensordeci[i] = 0;                     // wenn Bereich überschritten -> Voreinstellung setzen
      }
    }
    for (uint8_t i = 12; i < 15; i ++) sensorlist[i] = filedata[i];   // 3 spezielle Einträge holen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    for (uint8_t i = 0; i < 12; i ++) {                               // Voreinstellungen setzen
      sensorlist[i] = "";
      sensordeci[i] = 0;
    }
    sensorlist[12] = "Haus/Info/Wetter/aktuell";
    sensorlist[13] = "Haus/Info/Tanken/Preise";
    sensorlist[14] = "Haus/Info/Nachrichten";
    Serial.println(F(" Fehler"));
  }
  for (uint8_t i = 0; i < 15; i ++) {                                 // 15 Zeiger setzen
    if (sensorlist[i].length() > 0) sensorlist_p[i] = sensorlist[i].c_str(); // wenn MQTT-Topic vorhanden -> Zeiger setzen
    else sensorlist_p[i] = nullptr;                                   // sonst Nullzeiger setzen
  }

  Serial.print(F("Datenanzeige lesen ..."));
  result  = read_cfgfile(data_filename, 10);                          // Datenanzeige-Konfiguration aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    for (uint8_t i = 0; i < 10; i ++) datadisp[i] = filedata[i];      // 10 Einträge holen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    for (uint8_t i = 0; i < 10; i ++) datadisp[i] = "";               // Voreinstellungen setzen
    Serial.println(F(" Fehler"));
  }

  Serial.print(F("Alarme lesen ..."));
  result  = read_cfgfile(alms_filename, 16);                          // Alarm-Konfiguration aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    for (uint8_t i = 0; i < 8; i ++) {                                // 8 Alarme bearbeiten
      alarmsound[i] = filedata[i * 2].substring(0, 1).toInt();        // Alarm-Soundnummer holen
      if (alarmsound[i] > 6) alarmsound[i] = 0;                       // wenn Bereich überschritten -> Voreinstellung setzen
      alarmhold[i] = filedata[i * 2].substring(1, 2).toInt();         // Alarm-Haltemodus holen
      alarmtext[i] = filedata[i * 2].substring(2);                    // Alarm-Text holen
      alarmlist[i] = filedata[i * 2 + 1];                             // Alarm-MQTT-Topic holen
    }
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    for (uint8_t i = 0; i < 8; i ++) {                                // Voreinstellungen setzen
      alarmsound[i] = 0;
      alarmhold[i] = false;
      alarmtext[i] = "";
      alarmlist[i] = "";
    }
    Serial.println(F(" Fehler"));
  }
  for (uint8_t i = 0; i < 4; i ++) {                                  // 4 Zeiger setzen (nur für Alarme 1-4 erforderlich)
    if (alarmlist[i].length() > 0) alarmlist_p[i] = alarmlist[i].c_str(); // wenn MQTT-Topic vorhanden -> Zeiger setzen
    else alarmlist_p[i] = nullptr;                                    // sonst Nullzeiger setzen
  }
  for (uint8_t i = 0; i < 8; i ++) {                                  // 8 Alarmtexte prüfen
    if (alarmtext[i] == "Anruf") callfunction = true;                 // wenn Text "Anruf" gefunden -> Anruffunktion aktivieren
  }

  Serial.print(F("Farben lesen ..."));
  result = read_cfgfile(cols_filename, 4);                            // Farb-Konfiguration aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    colorclk = filedata[0].toInt();                                   // Farbe für Urzeit holen
    colordat = filedata[1].toInt();                                   // Farbe für Datum holen
    coloralm = filedata[2].toInt();                                   // Farbe für Alarmmeldungen holen
    coloravo = filedata[3].toInt();                                   // zu meidende Farbe holen
    if (colorclk > 16) colorclk = 7;                                  // wenn Bereich überschritten -> Default-Wert setzen
    if (colordat > 16) colordat = 5;                                  // wenn Bereich überschritten -> Default-Wert setzen
    if (coloralm > 16) coloralm = 1;                                  // wenn Bereich überschritten -> Default-Wert setzen
    if (coloravo > 16) coloravo = 0;                                  // wenn Bereich überschritten -> Default-Wert setzen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    colorclk = 7;                                                     // Voreinstellungen setzen
    colordat = 5;
    coloralm = 1;
    coloravo = 0;
    Serial.println(F(" Fehler"));
  }

  Serial.print(F("Anzeige/Sound lesen ..."));
  result = read_cfgfile(disn_filename, 15);                           // Anzeige-Konfiguration aus Dateisystem lesen
  if (result) {                                                       // wenn Lesen erfolgreich
    chgtime = filedata[0].toInt();                                    // Anzeige-Wechselzeit holen
    showdate = filedata[1].toInt();                                   // Datumanzeige holen
    showday = filedata[2].toInt();                                    // Wochentaganzeige holen
    smallmode = filedata[3].toInt();                                  // Kleinanzeige-Modus holen
    brightchg = filedata[4].toInt();                                  // Helligkeits-Änderung holen
    brightmin = filedata[5].toInt();                                  // Minimale Helligkeit holen
    brightmax = filedata[6].toInt();                                  // Maximale Helligkeit holen
    scrolltime = filedata[7].toInt();                                 // Scroll-Geschwindigkeit holen
    sound_enab = filedata[8].toInt();                                 // Alarmsound-Aktivierung holen
    sound_gong = filedata[9].toInt();                                 // Stundengong-Aktivierung holen
    sound_stim = filedata[10].toInt();                                // Sound-Beginnzeit holen
    sound_etim = filedata[11].toInt();                                // Sound-Endzeit holen
    sound_volu = filedata[12].toInt();                                // Lautstärke holen
    night_stim = filedata[13].toInt();                                // Nacht-Beginnzeit holen
    night_etim = filedata[14].toInt();                                // Nacht-Endezeit holen
    if (chgtime < 2 || chgtime > 4) chgtime = 3;                      // wenn Bereich überschritten -> Voreinstellung setzen
    if (smallmode > 2) smallmode = 2;                                 // wenn Bereich überschritten -> Voreinstellung setzen
    if (brightchg > 3) brightchg = 0;                                 // wenn Bereich überschritten -> Voreinstellung setzen
    if (brightmin > 10) brightmin = 0;                                // wenn Bereich überschritten -> Voreinstellung setzen
    if (brightmax > 15) brightmax = 15;                               // wenn Bereich überschritten -> Voreinstellung setzen
    if (scrolltime > 10) scrolltime = 5;                              // wenn Bereich überschritten -> Voreinstellung setzen
    if (sound_stim > 23) sound_stim = 8;                              // wenn Bereich überschritten -> Voreinstellung setzen
    if (sound_etim > 23) sound_etim = 22;                             // wenn Bereich überschritten -> Voreinstellung setzen
    if (sound_volu > 30) sound_volu = 25;                             // wenn Bereich überschritten -> Voreinstellung setzen
    if (night_stim > 23) night_stim = 0;                              // wenn Bereich überschritten -> Voreinstellung setzen
    if (night_etim > 23) night_etim = 0;                              // wenn Bereich überschritten -> Voreinstellung setzen
    Serial.println(F(" ok"));
  }
  else {                                                              // wenn Fehler beim Lesen
    chgtime = 3;                                                      // Voreinstellungen setzen
    showdate = true;
    showday = true;
    smallmode = 2;
    brightchg = 0;
    brightmin = 0;
    brightmax = 15;
    scrolltime = 5;
    sound_enab = false;
    sound_gong = false;
    sound_stim = 8;
    sound_etim = 22;
    sound_volu = 25;
    night_stim = 0;
    night_etim = 0;
    Serial.println(F(" Fehler"));
  }
  send_volume(sound_volu);                                            // Lautstärke einstellen

  if (callfunction) {                                                 // wenn Anruffunktion aktiviert
    Serial.print(F("Anrufe lesen ..."));
    result = read_cfgfile(call_filename, 6);                          // Anruf-Konfiguration aus Dateisystem lesen
    if (result) {                                                     // wenn Lesen erfolgreich
      call_alarm = filedata[0].toInt();                               // Anruf-Alarmnummer holen
      call_numb = filedata[1];                                        // Anrufanzeige, eigene Nummer holen
      for (uint8_t i = 0; i < 4; i ++) call_list[i] = filedata[i + 2]; // Anrufanzeige, MQTT-Topics der 4 Parameter holen
      Serial.println(F(" ok"));
    }
    else {                                                            // wenn Fehler beim Lesen
      call_alarm = 0;                                                 // Voreinstellungen setzen
      call_numb = "";
      for (uint8_t i = 0; i < 4; i ++) call_list[i] = "";
      Serial.println(F(" Fehler"));
    }
  }
  for (uint8_t i = 0; i < 4; i ++) {                                  // Anrufanzeige, MQTT-Topics der 4 Parameter holen
    if (call_list[i].length() > 0) call_list_p[i] = call_list[i].c_str(); // wenn MQTT-Topic vorhanden -> Zeiger setzen
    else call_list_p[i] = nullptr;                                    // sonst Nullzeiger setzen
  }
  for (uint8_t i = 0; i < 4; i ++) {                                  // Anrufanzeige, MQTT-Topics der 4 Parameter prüfen
    if (!call_list_p[i]) call_alarm = 0;                              // wenn kein MQTT-Topic vorhanden -> Anrufanzeige ausschalten
  }

  // ------------------------------------------------------------------- Hardware und Variablen initialisieren ------------------------------------------------

  HUB75_I2S_CFG::i2s_pins _pins={R1_PIN, G1_PIN, B1_PIN, R2_PIN, G2_PIN, B2_PIN, A_PIN, B_PIN, C_PIN, D_PIN, E_PIN, LAT_PIN, OE_PIN, CLK_PIN};
  HUB75_I2S_CFG mxconfig(PANEL_RES_X, PANEL_RES_Y, PANEL_CHAIN, _pins); // Matrix-Konfiguration einstellen
  switch (matr_clks) {                                                // I2S-Frequenz (Matrix-Frequenz) entsprechend Einstellung setzen
    case 1: mxconfig.i2sspeed = HUB75_I2S_CFG::HZ_10M; break;         // Einstellung 1 -> 10 MHz
    case 2: mxconfig.i2sspeed = HUB75_I2S_CFG::HZ_15M; break;         // Einstellung 2 -> 15 MHz
    case 3: mxconfig.i2sspeed = HUB75_I2S_CFG::HZ_20M; break;         // Einstellung 3 -> 20 MHz
    default: mxconfig.i2sspeed = HUB75_I2S_CFG::HZ_8M; break;         // sonst -> 8 MHz
  }
  mxconfig.driver = HUB75_I2S_CFG::SHIFTREG;                          // Matrix ohne speziellen Treiber-Chip
  mxconfig.latch_blanking = matr_latb;                                // Verzögerung zur Verhinderung von Geisterpixeln
  mxconfig.min_refresh_rate = matr_refr;                              // Bildwiederholfrequenz einstellen
  mxconfig.clkphase = false;                                          // Phase für Taktsignal einstellen
  mxconfig.double_buff = true;                                        // doppelte Pufferung
  display = new MatrixPanel_I2S_DMA(mxconfig);                        // Matrix definieren
  if (matr_driv == 1) init_fm6126a();                                 // wenn FM6126A-Treiber -> Initialisierungs-Sequenz ausgeben
  display->begin();                                                   // Matrix aktivieren
  display->clearScreen();                                             // Matrixinhalt löschen

  WiFi.useStaticBuffers(true);                                        // Statischen WLAN-Puffer verwenden
  WiFi.mode(WIFI_STA);                                                // WLAN-Station (Client-Modus)
  if (netw_enab) WiFi.config(IPaddr, IPgate, IPsubn, IPdns1);         // wenn feste IP-Adresse aktiviert -> IP-Daten einstellen
  WiFi.setAutoReconnect(true);                                        // WLAN-Verbindung bei Trennung automatisch wiederherstellen
  sntp_set_time_sync_notification_cb(timesync);                       // Callback-Funktion für Synchronisierungs-Benachrichtigung der Uhr einrichten

  wifistat = 0;                                                       // WLAN-Verbindung herstellen
  mqttstat = false;                                                   // MQTT-Verbindung herstellen
  syncstat = 0;                                                       // Uhr ist nicht synchronisiert
  timeinfo.tm_year = 2023 - 1900;                                     // Jahr voreinstellen
  timeinfo.tm_mon = 0;                                                // Monat voreinstellen (Januar)
  timeinfo.tm_mday = 1;                                               // Tag voreinstellen
  timeinfo.tm_hour = 0;                                               // Stunde voreinstellen
  timeinfo.tm_min = 0;                                                // Minute voreinstellen
  timeinfo.tm_sec = 0;                                                // Sekunde voreinstellen
  timeinfo.tm_isdst = 0;                                              // Normalzeit voreinstellen
  time_t t = mktime(&timeinfo);                                       // Zeit konvertieren
  struct timeval now = { .tv_sec = t };                               // Zeit als Epoch-Wert (Sekunden seit 1970) verwenden
  settimeofday(&now, NULL);                                           // neue Zeit setzen
  uptime_strings();                                                   // formatierte Systemlaufzeit erstellen
  mqtt_lmsg_p = "offline";                                            // MQTT LWT-Message setzen
  mqtt_smsg_p = "online";                                             // MQTT LWT-Start-Message setzen
  srand(analogRead(ADC_PIN));                                         // Zufallsgenerator mit ADC-Wert vom Helligkeitssensor initialisieren
  color_random();                                                     // neue Zufallsfarben erzeugen
  lastmillis = millis();                                              // aktuellen Millisekundenwert zwischenspeichern (für Hauptschleife initialisieren)
  luptmillis = millis();                                              // aktuellen Millisekundenwert zwischenspeichern (für Emittlung der Laufzeit)
  disptout = SYSSTART;                                                // Anzeige-Timeout auf Zeit für Versionsinformationen setzen
  dispmode = 3;                                                       // Anzeige-Modus auf Versionsinformationen setzen
  daymcount = 0;                                                      // Zähler für die Taganzeige setzen
  lastsec = 0;                                                        // letzten gespeicherten Sekundenwert setzen
  lasthour = 0;                                                       // letzte Stunde für Farbwechsel setzen
  quitcount = 32;                                                     // Quittierungszähler stoppen
  synctout = 255;                                                     // Synchronisierungs-Timeout-Zähler stoppen
  wifitout = 255;                                                     // WLAN-Timeout-Zähler stoppen
  mqtttout = 255;                                                     // MQTT-Timeout-Zähler stoppen
  boottout = 255;                                                     // Neustart-Timeout-Zähler stoppen
  soundtout = 255;                                                    // Sound-Timeout-Zähler stoppen
  nacttout = 255;                                                     // Nachtaktivierungs-Zähler stoppen
  sketch = ESP.getSketchSize();                                       // aktuelle Sketch-Größe speichern

  // ------------------------------------------------------------------- Web-Server-Definitionen --------------------------------------------------------------

  server.on("/", HTTP_GET, [](AsyncWebServerRequest *request) {       // Web-Server, Ausgabe der Hauptseite (Status) definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", stat_html, processor);          // Seite stat_html ausgeben und Variablen bearbeiten
  });

  server.on("/", HTTP_POST, [](AsyncWebServerRequest *request) {      // Web-Server, übergebene Informationen der Hauptseite (Status)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", stat_html, processor);          // Seite stat_html neu ausgeben und Variablen berabeiten
  });

  server.on("/favicon.ico", [](AsyncWebServerRequest *request) {      // Web-Server, Ausgabe des Icon (favicon.ico)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    request->send_P(200, "image/png", favicon, sizeof(favicon));      // favicon.png (32x32 Pixel) ausgeben
  });

  server.on("/stqu", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Hauptseite /stqu (Alarme quittieren)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    ack_alarms();                                                     // Alarme quittieren
    request->send_P(200, "text/html", stat_html, processor);          // Seite stat_html neu ausgeben und Variablen berabeiten
  });

  server.on("/stmu", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Hauptseite /stmu (Stummschaltung)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    if (!mute) mute = true;                                           // wenn Stummschaltung aus -> einschalten
    else mute = false;                                                // sonst ausschalten
    request->send_P(200, "text/html", stat_html, processor);          // Seite stat_html neu ausgeben und Variablen berabeiten
  });

  server.on("/mesg", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /mesg (Nachricht anzeigen)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "message") message = p->value();             // wenn Parameter message übergeben wurde -> Wert als String speichern
      }
    }
    if (message.length() > 0) {                                       // wenn Nachricht vorhanden
      process_msg(true);                                              // Nachricht mit Sound ausgeben
      save = 1;                                                       // OK-Meldung
    }
    request->send_P(200, "text/html", stat_html, processor);          // Seite stat_html neu ausgeben und Variablen berabeiten
  });

  server.on("/bday", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /bday definieren (Geburtstage)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    bdaylister();                                                     // Geburtstagsliste für Web-Seite erstellen
    request->send_P(200, "text/html", bday_html, processor);          // Seite bday_html ausgeben und Variablen bearbeiten
  });

  server.on("/bday", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /bday (Geburtstage)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "bday_date") bdaydate = p->value();          // wenn Parameter bday_date übergeben wurde -> Wert speichern (Datum)
        if (p->name() == "bday_name") bdayname = p->value();          // wenn Parameter bday_name übergeben wurde -> Wert speichern (Name)
      }
    }
    if (bdayname.length() > 0 && bdaydate.length() > 0) {             // wenn Name und Datum eingegeben
      for (uint8_t i = 0; i < MAXBDAYS; i ++) {                       // erstes freies Feld suchen
        if (birthdays[i].length() == 0) {                             // wenn freies Feld gefunden
          birthdays[i] = bdaydate.substring(0, 4) + bdaydate.substring(5, 7) + bdaydate.substring(8) + " " + bdayname; // Datum umwandeln und Name ergänzen
          break;                                                      // Schleife abbrechen
        }
      }
      bdaysort();                                                     // Geburtstags-Datenfeld sortieren
      bdaylister();                                                   // Geburtstagsliste für Web-Seite erstellen
      result = write_bdayfile();                                      // Geburtstagdatei schreiben
      if (result) save = 1;                                           // wenn Speichern erfolgreich -> OK-Meldung
      else save = 2;                                                  // wenn Speichern nicht erfolgreich -> Fehler
    }
    request->send_P(200, "text/html", bday_html, processor);          // Seite bday_html neu ausgeben und Variablen berabeiten
  });

  server.on("/bdel", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /bdel (Geburtstage/Eintrag löschen)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    bdaynumb = 0;                                                     // Eingabe zunächst auf ungültigen Wert setzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "bday_deln") bdaynumb = p->value().toInt();  // wenn Parameter bday_deln übergeben wurde -> Wert speichern (Nummer)
      }
    }
    if (bdaynumb > 0 && bdaynumb <= bdaycount) {                      // wenn gültige Eintragnummer
      birthdays[bdaynumb - 1] = "";                                   // Feldelement löschen
      bdaysort();                                                     // Geburtstags-Datenfeld sortieren
      bdaylister();                                                   // Geburtstagsliste für Web-Seite erstellen
      result = write_bdayfile();                                      // Geburtstagdatei schreiben
      if (result) save = 1;                                           // wenn Speichern erfolgreich -> OK-Meldung
      else save = 2;                                                  // wenn Speichern nicht erfolgreich -> Fehler
    }
    request->send_P(200, "text/html", bday_html, processor);          // Seite bday_html neu ausgeben und Variablen berabeiten
  });

  server.on("/sens", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /sens definieren (Sensoren)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", sens_html, processor);          // Seite sens_html ausgeben und Variablen bearbeiten
  });

  server.on("/sens", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /sens (Sensoren)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "sena") filedata[0] = p->value();            // wenn Parameter sena übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor A)
        if (p->name() == "senb") filedata[1] = p->value();            // wenn Parameter senb übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor B)
        if (p->name() == "senc") filedata[2] = p->value();            // wenn Parameter senc übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor C)
        if (p->name() == "send") filedata[3] = p->value();            // wenn Parameter send übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor D)
        if (p->name() == "sene") filedata[4] = p->value();            // wenn Parameter sene übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor E)
        if (p->name() == "senf") filedata[5] = p->value();            // wenn Parameter senf übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor F)
        if (p->name() == "seng") filedata[6] = p->value();            // wenn Parameter seng übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor G)
        if (p->name() == "senh") filedata[7] = p->value();            // wenn Parameter senh übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor H)
        if (p->name() == "seni") filedata[8] = p->value();            // wenn Parameter seni übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor I)
        if (p->name() == "senj") filedata[9] = p->value();            // wenn Parameter senj übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor J)
        if (p->name() == "senk") filedata[10] = p->value();           // wenn Parameter senk übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor K)
        if (p->name() == "senl") filedata[11] = p->value();           // wenn Parameter senl übergeben wurde -> Wert als String zwischenspeichern (Topic Sensor L)
        if (p->name() == "weat") filedata[12] = p->value();           // wenn Parameter weat übergeben wurde -> Wert als String zwischenspeichern (Topic Wetterdaten)
        if (p->name() == "fuel") filedata[13] = p->value();           // wenn Parameter fuel übergeben wurde -> Wert als String zwischenspeichern (Topic Kraftstoffdaten)
        if (p->name() == "mesg") filedata[14] = p->value();           // wenn Parameter mesg übergeben wurde -> Wert als String zwischenspeichern (Topic Textnachricht)
        if (p->name() == "seda") sensordeci[0] = p->value().toInt();  // wenn Parameter deca übergeben wurde -> Sensor A Nachkommastelle als Zahl speichern
        if (p->name() == "sedb") sensordeci[1] = p->value().toInt();  // wenn Parameter decb übergeben wurde -> Sensor B Nachkommastelle als Zahl speichern
        if (p->name() == "sedc") sensordeci[2] = p->value().toInt();  // wenn Parameter decc übergeben wurde -> Sensor C Nachkommastelle als Zahl speichern
        if (p->name() == "sedd") sensordeci[3] = p->value().toInt();  // wenn Parameter decd übergeben wurde -> Sensor D Nachkommastelle als Zahl speichern
        if (p->name() == "sede") sensordeci[4] = p->value().toInt();  // wenn Parameter dece übergeben wurde -> Sensor E Nachkommastelle als Zahl speichern
        if (p->name() == "sedf") sensordeci[5] = p->value().toInt();  // wenn Parameter decf übergeben wurde -> Sensor F Nachkommastelle als Zahl speichern
        if (p->name() == "sedg") sensordeci[6] = p->value().toInt();  // wenn Parameter decg übergeben wurde -> Sensor G Nachkommastelle als Zahl speichern
        if (p->name() == "sedh") sensordeci[7] = p->value().toInt();  // wenn Parameter dech übergeben wurde -> Sensor H Nachkommastelle als Zahl speichern
        if (p->name() == "sedi") sensordeci[8] = p->value().toInt();  // wenn Parameter deci übergeben wurde -> Sensor I Nachkommastelle als Zahl speichern
        if (p->name() == "sedj") sensordeci[9] = p->value().toInt();  // wenn Parameter decj übergeben wurde -> Sensor J Nachkommastelle als Zahl speichern
        if (p->name() == "sedk") sensordeci[10] = p->value().toInt(); // wenn Parameter deck übergeben wurde -> Sensor K Nachkommastelle als Zahl speichern
        if (p->name() == "sedl") sensordeci[11] = p->value().toInt(); // wenn Parameter decl übergeben wurde -> Sensor L Nachkommastelle als Zahl speichern
      }
    }
    if (mqttstat && mqttClient.connected()) {                         // wenn MQTT-Status online und Server-Verbindung aktiv
      for (uint8_t i = 0; i < 15; i ++) {                             // 15 Datenfelder bearbeiten
        if (sensorlist_p[i]) mqttClient.unsubscribe(sensorlist_p[i]); // wenn Datenfeld ein MQTT-Topic enthält -> Topic abbestellen
      }
    }
    for (uint8_t i = 0; i < 15; i ++) {                               // 15 Datenfelder bearbeiten
      sensorlist[i] = filedata[i];                                    // zwischengespeichertes MQTT-Topic in Sensorliste kopieren
      if (sensorlist[i].length() > 0) sensorlist_p[i] = sensorlist[i].c_str(); // wenn MQTT-Topic vorhanden -> Zeiger setzen
      else sensorlist_p[i] = nullptr;                                 // sonst Nullzeiger setzen
    }
    if (mqttstat && mqttClient.connected()) {                         // wenn MQTT-Status online und Server-Verbindung aktiv
      for (uint8_t i = 0; i < 15; i ++) {                             // 15 Datenfelder bearbeiten
        if (sensorlist_p[i]) mqttClient.subscribe(sensorlist_p[i], 0); // wenn Datenfeld ein MQTT-Topic enthält -> Topic abonnieren
      }
    }
    for (uint8_t i = 0; i < 12; i ++) {                               // 12 Datenfelder bearbeiten (nur normale Sensoren)
      if (filedata[i].length() > 0) filedata[i] += " " + String(sensordeci[i]); // wenn Topic vorhanden -> Nachkommastelle ergänzen
    }
    result = write_cfgfile(sens_filename, 15);                        // Sensorliste ins Dateisystem schreiben
    if (result) save = 1;                                             // wenn Speichern erfolgreich -> OK-Meldung
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", sens_html, processor);          // Seite sens_html neu ausgeben und Variablen berabeiten
  });

  server.on("/seac", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /seac (Sensoren/Aktualisieren)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", sens_html, processor);          // Seite sens_html neu ausgeben und Variablen berabeiten
  });

  server.on("/data", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /data definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", data_html, processor);          // Seite sena_html ausgeben und Variablen bearbeiten
  });

  server.on("/data", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /data
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "dat0") datadisp[0] = p->value();            // wenn Parameter dat0 übergeben wurde -> Wert als String speichern (Datenfeld 1)
        if (p->name() == "dat1") datadisp[1] = p->value();            // wenn Parameter dat1 übergeben wurde -> Wert als String speichern (Datenfeld 2)
        if (p->name() == "dat2") datadisp[2] = p->value();            // wenn Parameter dat2 übergeben wurde -> Wert als String speichern (Datenfeld 3)
        if (p->name() == "dat3") datadisp[3] = p->value();            // wenn Parameter dat3 übergeben wurde -> Wert als String speichern (Datenfeld 4)
        if (p->name() == "dat4") datadisp[4] = p->value();            // wenn Parameter dat4 übergeben wurde -> Wert als String speichern (Datenfeld 5)
        if (p->name() == "dat5") datadisp[5] = p->value();            // wenn Parameter dat5 übergeben wurde -> Wert als String speichern (Datenfeld 6)
        if (p->name() == "dat6") datadisp[6] = p->value();            // wenn Parameter dat6 übergeben wurde -> Wert als String speichern (Datenfeld 7)
        if (p->name() == "dat7") datadisp[7] = p->value();            // wenn Parameter dat7 übergeben wurde -> Wert als String speichern (Datenfeld 8)
        if (p->name() == "dat8") datadisp[8] = p->value();            // wenn Parameter dat8 übergeben wurde -> Wert als String speichern (Datenfeld 9)
        if (p->name() == "dat9") datadisp[9] = p->value();            // wenn Parameter dat9 übergeben wurde -> Wert als String speichern (Datenfeld 10)
      }
    }
    for (uint8_t i = 0; i < 10; i ++) filedata[i] = datadisp[i];      // Datenfelder in Dateipuffer schreiben
    result = write_cfgfile(data_filename, 10);                        // Datenanzeige-Konfiguration ins Dateisystem schreiben
    if (result) save = 1;                                             // wenn Speichern erfolgreich -> OK-Meldung
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", data_html, processor);          // Seite sena_html neu ausgeben und Variablen berabeiten
  });

  server.on("/daac", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /daac (Datenanzeige/Aktualisieren)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", data_html, processor);          // Seite data_html neu ausgeben und Variablen berabeiten
  });

  server.on("/alms", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /alms definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", alms_html, processor);          // Seite alms_html ausgeben und Variablen bearbeiten
  });

  server.on("/alms", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /alms
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    if (params > 0) {                                                 // wenn mindestens ein Parameter übergeben wurde
      for (uint8_t i = 0; i < 8; i ++) alarmhold[i] = false;          // Alarm-Halten ausschalten
    }
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "als0") alarmsound[0] = p->value().toInt();  // wenn Parameter als0 übergeben wurde -> Wert als Zahl speichern (Alarm 1 Sound)
        if (p->name() == "als1") alarmsound[1] = p->value().toInt();  // wenn Parameter als1 übergeben wurde -> Wert als Zahl speichern (Alarm 2 Sound)
        if (p->name() == "als2") alarmsound[2] = p->value().toInt();  // wenn Parameter als2 übergeben wurde -> Wert als Zahl speichern (Alarm 3 Sound)
        if (p->name() == "als3") alarmsound[3] = p->value().toInt();  // wenn Parameter als3 übergeben wurde -> Wert als Zahl speichern (Alarm 4 Sound)
        if (p->name() == "als4") alarmsound[4] = p->value().toInt();  // wenn Parameter als4 übergeben wurde -> Wert als Zahl speichern (Alarm 5 Sound)
        if (p->name() == "als5") alarmsound[5] = p->value().toInt();  // wenn Parameter als5 übergeben wurde -> Wert als Zahl speichern (Alarm 6 Sound)
        if (p->name() == "als6") alarmsound[6] = p->value().toInt();  // wenn Parameter als6 übergeben wurde -> Wert als Zahl speichern (Alarm 7 Sound)
        if (p->name() == "als7") alarmsound[7] = p->value().toInt();  // wenn Parameter als7 übergeben wurde -> Wert als Zahl speichern (Alarm 8 Sound)
        if (p->name() == "alh0") alarmhold[0] = true;                 // wenn Parameter alh0 übergeben wurde -> Option einschalten (Alarm 1 Halten)
        if (p->name() == "alh1") alarmhold[1] = true;                 // wenn Parameter alh1 übergeben wurde -> Option einschalten (Alarm 2 Halten)
        if (p->name() == "alh2") alarmhold[2] = true;                 // wenn Parameter alh2 übergeben wurde -> Option einschalten (Alarm 3 Halten)
        if (p->name() == "alh3") alarmhold[3] = true;                 // wenn Parameter alh3 übergeben wurde -> Option einschalten (Alarm 4 Halten)
        if (p->name() == "alh4") alarmhold[4] = true;                 // wenn Parameter alh4 übergeben wurde -> Option einschalten (Alarm 5 Halten)
        if (p->name() == "alh5") alarmhold[5] = true;                 // wenn Parameter alh5 übergeben wurde -> Option einschalten (Alarm 6 Halten)
        if (p->name() == "alh6") alarmhold[6] = true;                 // wenn Parameter alh6 übergeben wurde -> Option einschalten (Alarm 7 Halten)
        if (p->name() == "alh7") alarmhold[7] = true;                 // wenn Parameter alh7 übergeben wurde -> Option einschalten (Alarm 8 Halten)
        if (p->name() == "atx0") alarmtext[0] = p->value();           // wenn Parameter atx0 übergeben wurde -> Wert als String speichern (Alarm 1 Text)
        if (p->name() == "atx1") alarmtext[1] = p->value();           // wenn Parameter atx1 übergeben wurde -> Wert als String speichern (Alarm 2 Text)
        if (p->name() == "atx2") alarmtext[2] = p->value();           // wenn Parameter atx2 übergeben wurde -> Wert als String speichern (Alarm 3 Text)
        if (p->name() == "atx3") alarmtext[3] = p->value();           // wenn Parameter atx3 übergeben wurde -> Wert als String speichern (Alarm 4 Text)
        if (p->name() == "atx4") alarmtext[4] = p->value();           // wenn Parameter atx4 übergeben wurde -> Wert als String speichern (Alarm 5 Text)
        if (p->name() == "atx5") alarmtext[5] = p->value();           // wenn Parameter atx5 übergeben wurde -> Wert als String speichern (Alarm 6 Text)
        if (p->name() == "atx6") alarmtext[6] = p->value();           // wenn Parameter atx6 übergeben wurde -> Wert als String speichern (Alarm 7 Text)
        if (p->name() == "atx7") alarmtext[7] = p->value();           // wenn Parameter atx7 übergeben wurde -> Wert als String speichern (Alarm 8 Text)
        if (p->name() == "ato0") filedata[0] = p->value();            // wenn Parameter ato0 übergeben wurde -> Wert als String zwischenspeichern (Alarm 1 MQTT Topic)
        if (p->name() == "ato1") filedata[1] = p->value();            // wenn Parameter ato1 übergeben wurde -> Wert als String zwischenspeichern (Alarm 2 MQTT Topic)
        if (p->name() == "ato2") filedata[2] = p->value();            // wenn Parameter ato2 übergeben wurde -> Wert als String zwischenspeichern (Alarm 3 MQTT Topic)
        if (p->name() == "ato3") filedata[3] = p->value();            // wenn Parameter ato3 übergeben wurde -> Wert als String zwischenspeichern (Alarm 4 MQTT Topic)
        if (p->name() == "ato4") filedata[4] = p->value();            // wenn Parameter ato4 übergeben wurde -> Wert als String zwischenspeichern (Alarm 5 MQTT Topic)
        if (p->name() == "ato5") filedata[5] = p->value();            // wenn Parameter ato5 übergeben wurde -> Wert als String zwischenspeichern (Alarm 6 MQTT Topic)
        if (p->name() == "ato6") filedata[6] = p->value();            // wenn Parameter ato6 übergeben wurde -> Wert als String zwischenspeichern (Alarm 7 MQTT Topic)
        if (p->name() == "ato7") filedata[7] = p->value();            // wenn Parameter ato7 übergeben wurde -> Wert als String zwischenspeichern (Alarm 8 MQTT Topic)
      }
    }
    if (mqttstat && mqttClient.connected()) {                         // wenn MQTT-Status online und Server-Verbindung aktiv
      for (uint8_t i = 0; i < 4; i ++) {                              // 4 Datenfelder bearbeiten (nur Alarme 1-4)
        if (alarmlist_p[i]) mqttClient.unsubscribe(alarmlist_p[i]);   // wenn Datenfeld ein MQTT-Topic enthält -> Topic abbestellen
      }
    }
    for (uint8_t i = 0; i < 8; i ++) {                                // 8 Datenfelder bearbeiten
      if (alarmsound[i] > 6) alarmsound[i] = 0;                       // wenn Bereich beim Alarmsound überschritten -> Voreinstellung setzen
      alarmlist[i] = filedata[i];                                     // zwischengespeichertes MQTT-Topic in Alarmliste kopieren
      if (i < 4) {                                                    // wenn Alarm 1-4
        if (alarmlist[i].length() > 0) alarmlist_p[i] = alarmlist[i].c_str(); // wenn MQTT-Topic vorhanden -> Zeiger setzen
        else alarmlist_p[i] = nullptr;                                // sonst Nullzeiger setzen
      }
    }
    if (mqttstat && mqttClient.connected()) {                         // wenn MQTT-Status online und Server-Verbindung aktiv
      for (uint8_t i = 0; i < 4; i ++) {                              // 4 Datenfelder bearbeiten
        if (alarmlist_p[i]) mqttClient.subscribe(alarmlist_p[i], 0);  // wenn Datenfeld ein MQTT-Topic enthält -> Topic abonnieren
      }
    }
    for (uint8_t i = 0; i < 8; i ++) {                                // 8 Alarme bearbeiten
      if (i + 1 == call_alarm) alarmtext[i] = "Anruf";                // wenn Anruffunktion aktiviert -> Alarmtext beim ausgewählten Alarm ersetzen
      filedata[i * 2] = String(alarmsound[i]) + String(alarmhold[i]) + alarmtext[i]; // Alarm-Konfiguration (Soundnummer, Halten, Text) zusammensetzen
      filedata[i * 2 + 1] = alarmlist[i];                             // Alarm-MQTT-Topic in Puffer speichern
    }
    result = write_cfgfile(alms_filename, 16);                        // Alarm-Konfiguration ins Dateisystem schreiben
    if (result) save = 1;                                             // wenn Speichern erfolgreich -> OK-Meldung
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", alms_html, processor);          // Seite alms_html neu ausgeben und Variablen berabeiten
  });

  server.on("/alac", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /alac (Alarme/Aktualisieren)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", alms_html, processor);          // Seite alms_html neu ausgeben und Variablen berabeiten
  });

  server.on("/cols", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /cols definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", cols_html, processor);          // Seite cols_html ausgeben und Variablen bearbeiten
  });

  server.on("/cols", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /cols
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "col1") colorclk = p->value().toInt();       // wenn Parameter col1 übergeben wurde -> Wert speichern (Farbe für Uhrzeit)
        if (p->name() == "col2") colordat = p->value().toInt();       // wenn Parameter col2 übergeben wurde -> Wert speichern (Farbe für Datum)
        if (p->name() == "col3") coloralm = p->value().toInt();       // wenn Parameter col3 übergeben wurde -> Wert speichern (Farbe für Alarmmeldungen)
        if (p->name() == "col4") coloravo = p->value().toInt();       // wenn Parameter col4 übergeben wurde -> Wert speichern (zu meidende Farbe)
      }
    }
    color_random();                                                   // neue Zufallsfarben erzeugen
    filedata[0] = colorclk;                                           // Zeile 1 - Farbe für Uhrzeit
    filedata[1] = colordat;                                           // Zeile 2 - Farbe für Datum
    filedata[2] = coloralm;                                           // Zeile 3 - Farbe für Alarmmeldungen
    filedata[3] = coloravo;                                           // Zeile 4 - Farbe meiden
    result = write_cfgfile(cols_filename, 4);                         // Farb-Konfiguration ins Dateisystem schreiben
    if (result) save = 1;                                             // wenn Speichern erfolgreich -> OK-Meldung
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", cols_html, processor);          // Seite cols_html neu ausgeben und Variablen berabeiten
  });

  server.on("/disn", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /disn definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", disn_html, processor);          // Seite disn_html ausgeben und Variablen bearbeiten
  });

  server.on("/disn", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /disn
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    if (params > 0) {                                                 // wenn mindestens ein Parameter übergeben wurde
      showdate = false;                                               // Datum-Anzeige zunächst deaktivieren
      showday = false;                                                // Wochentag-Anzeige zunächst deaktivieren
      sound_enab = false;                                             // Sound zunächst deaktivieren
      sound_gong = false;                                             // Stunden-Gong zunächst deaktivieren
    }
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "disp_chgt") chgtime = p->value().toInt();   // wenn Parameter disp_chgt übergeben wurde -> Wert speichern (Anzeige-Wechselzeit)
        if (chgtime < 2 || chgtime > 4) chgtime = 3;                  // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        if (p->name() == "disp_sdat") showdate = true;                // wenn Parameter disp_sdat übergeben wurde -> Wert speichern (Datum anzeigen)
        if (p->name() == "disp_sday") showday = true;                 // wenn Parameter disp_sday übergeben wurde -> Wert speichern (Wochentag anzeigen)
        if (p->name() == "disp_daym") smallmode = p->value().toInt(); // wenn Parameter disp_daym übergeben wurde -> Wert speichern (Kleinanzeige-Modus)
        if (smallmode > 2) smallmode = 2;                             // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        if (p->name() == "disp_brch") brightchg = p->value().toInt(); // wenn Parameter disp_brch übergeben wurde -> Wert speichern (Helligkeits-Änderung)
        if (brightchg > 2) brightchg = 0;                             // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        if (p->name() == "disp_bmin") brightmin = p->value().toInt(); // wenn Parameter disp_bmin übergeben wurde -> Wert speichern (minimale Helligkeit)
        if (brightmin > 9) brightmin = 0;                             // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        if (p->name() == "disp_bmax") brightmax = p->value().toInt(); // wenn Parameter disp_bmax übergeben wurde -> Wert speichern (minimale Helligkeit)
        if (brightmax > 14) brightmax = 14;                           // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        if (p->name() == "disp_scrl") scrolltime = p->value().toInt(); // wenn Parameter disp_scrl übergeben wurde -> Wert speichern (Scroll-Geschwindigkeit)
        if (scrolltime > 9) scrolltime = 5;                           // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        if (p->name() == "soun_enab") sound_enab = true;              // wenn Parameter soun_enab übergeben wurde -> Option aktivieren (Sound aktivieren)
        if (p->name() == "soun_gong") sound_gong = true;              // wenn Parameter soun_gong übergeben wurde -> Option aktivieren (Stundengong aktivieren)
        if (p->name() == "soun_stim") sound_stim = p->value().toInt(); // wenn Parameter soun_stim übergeben wurde -> Wert als Zahl speichern (Sound-Beginnzeit)
        if (sound_stim > 23) sound_stim = 8;                          // wenn Bereich überschritten -> Voreinstellung setzen
        if (p->name() == "soun_etim") sound_etim = p->value().toInt(); // wenn Parameter soun_etim übergeben wurde -> Wert als Zahl speichern (Sound-Endzeit)
        if (sound_etim > 23) sound_etim = 22;                         // wenn Bereich überschritten -> Voreinstellung setzen
        if (p->name() == "soun_volu") sound_volu = p->value().toInt(); // wenn Parameter soun_vday übergeben wurde -> Wert als Zahl speichern (Lautstärke)
        if (sound_volu > 30) sound_volu = 25;                         // wenn Bereich überschritten -> Voreinstellung setzen
        send_volume(sound_volu);                                      // Lautstärke einstellen
        if (p->name() == "nigh_stim") night_stim = p->value().toInt(); // wenn Parameter nigh_stim übergeben wurde -> Wert als Zahl speichern (Nacht-Beginnzeit)
        if (night_stim > 23) night_stim = 0;                          // wenn Bereich überschritten -> Voreinstellung setzen
        if (p->name() == "nigh_etim") night_etim = p->value().toInt(); // wenn Parameter nigh_etim übergeben wurde -> Wert als Zahl speichern (Nacht-Endzeit)
        if (night_etim > 23) night_etim = 0;                          // wenn Bereich überschritten -> Voreinstellung setzen
      }
    }
    filedata[0] = chgtime;                                            // Zeile 1 - Anzeige-Wechselzeit
    filedata[1] = showdate;                                           // Zeile 2 - Datum anzeigen
    filedata[2] = showday;                                            // Zeile 3 - Wochentag anzeigen
    filedata[3] = smallmode;                                          // Zeile 4 - Kleinanzeige-Modus
    filedata[4] = brightchg;                                          // Zeile 5 - Helligkeits-Änderung
    filedata[5] = brightmin;                                          // Zeile 6 - minimale Helligkeit
    filedata[6] = brightmax;                                          // Zeile 7 - maximale Helligkeit
    filedata[7] = scrolltime;                                         // Zeile 8 - Scroll-Geschwindigkeit
    filedata[8] = sound_enab;                                         // Zeile 9 - Sound aktivieren
    filedata[9] = sound_gong;                                         // Zeile 10 - Stundengong aktivieren
    filedata[10] = sound_stim;                                        // Zeile 11 - Sound-Beginnzeit
    filedata[11] = sound_etim;                                        // Zeile 12 - Sound-Endzeit
    filedata[12] = sound_volu;                                        // Zeile 13 - Lautstärke
    filedata[13] = night_stim;                                        // Zeile 14 - Nacht-Beginnzeit
    filedata[14] = night_etim;                                        // Zeile 15 - Nacht-Beginnzeit
    result = write_cfgfile(disn_filename, 15);                        // Anzeige-Konfiguration ins Dateisystem schreiben
    if (result) save = 1;                                             // wenn Speichern erfolgreich -> OK-Meldung
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", disn_html, processor);          // Seite disp_html neu ausgeben und Variablen berabeiten
  });

  server.on("/call", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /call definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", call_html, processor);          // Seite call_html ausgeben und Variablen bearbeiten
  });

  server.on("/call", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /call
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "call_alrm") call_alarm = p->value().toInt(); // wenn Parameter call_alrm übergeben wurde -> Wert als Zahl speichern (verwendete Alarmnummer oder aus)
        if (p->name() == "call_numb") call_numb = p->value();         // wenn Parameter call_numb übergeben wurde -> Wert speichern (eigene Nummer)
        if (p->name() == "call_evnt") filedata[2] = p->value();       // wenn Parameter call_evnt übergeben wurde -> Wert zwischenspeichern (MQTT-Topic Anruf-Ereignis)
        if (p->name() == "call_name") filedata[3] = p->value();       // wenn Parameter call_evnt übergeben wurde -> Wert zwischenspeichern (MQTT-Topic Name des Anrufers)
        if (p->name() == "call_extn") filedata[4] = p->value();       // wenn Parameter call_evnt übergeben wurde -> Wert zwischenspeichern (MQTT-Topic Nummer des Anrufers)
        if (p->name() == "call_intn") filedata[5] = p->value();       // wenn Parameter call_evnt übergeben wurde -> Wert zwischenspeichern (MQTT-Topic angerufene Nummer)
      }
    }
    if (mqttstat && mqttClient.connected()) {                         // wenn MQTT-Status online und Server-Verbindung aktiv
      for (uint8_t i = 0; i < 4; i ++) {                              // 4 Datenfelder prüfen
        if (call_list_p[i]) mqttClient.unsubscribe(call_list_p[i]);   // wenn Datenfeld ein MQTT-Topic enthält -> Topic abbestellen
      }
    }
    for (uint8_t i = 0; i < 4; i ++) {                                // 4 Datenfelder kopieren und bearbeiten
      call_list[i] = filedata[i + 2];                                 // zwischengespeichertes MQTT-Topic kopieren
      if (call_list[i].length() > 0) call_list_p[i] = call_list[i].c_str(); // wenn MQTT-Topic vorhanden -> Zeiger setzen
      else {                                                          // sonst
        call_list_p[i] = nullptr;                                     // Nullzeiger setzen
        call_alarm = 0;                                               // Anrufanzeige ausschalten
      }
    }
    if (mqttstat && mqttClient.connected()) {                         // wenn MQTT-Status online und Server-Verbindung aktiv
      for (uint8_t i = 0; i < 4; i ++) {
        if (call_list_p[i]) mqttClient.subscribe(call_list_p[i], 0);  // wenn MQTT-Topic vorhanden -> Topic abonnieren
      }
    }
    if (call_alarm > 8) call_alarm = 0;                               // wenn verwendete Alarmnummer außerhalb des zulässigen Bereiches -> Anrufe ausschalten
    filedata[0] = call_alarm;                                         // Zeile 1 - verwendete Alarmnummer oder aus
    filedata[1] = call_numb;                                          // Zeile 2 - eigene Nummer, Zeilen 3-6 sind bereits fertig
    result = write_cfgfile(call_filename, 6);                         // Anruf-Konfiguration ins Dateisystem schreiben
    if (result) save = 1;                                             // wenn Speichern erfolgreich -> OK-Meldung
    else save = 2;                                                    // sonst Fehler
    request->send_P(200, "text/html", call_html, processor);          // Seite call_html neu ausgeben und Variablen berabeiten
  });

  server.on("/matr", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /matr definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", matr_html, processor);          // Seite matr_html ausgeben und Variablen bearbeiten
  });

  server.on("/matr", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /matr
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "matr_clks") matr_clks = p->value().toInt(); // wenn Parameter matr_clks übergeben wurde -> Wert speichern (Matrix-Taktfrequenz)
        if (p->name() == "matr_driv") matr_driv = p->value().toInt(); // wenn Parameter matr_driv übergeben wurde -> Wert speichern (Matrix-Treiber-Chip)
        if (p->name() == "matr_latb") matr_latb = p->value().toInt(); // wenn Parameter matr_latb übergeben wurde -> Wert speichern (Matrix-Latch-Blanking)
        if (p->name() == "matr_refr") matr_refr = p->value().toInt(); // wenn Parameter matr_refr übergeben wurde -> Wert speichern (Matrix-Bildwiederholfrequenz)
        if (matr_refr < 50) matr_refr = 50;                           // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        if (matr_refr > 200) matr_refr = 200;                         // wenn Wert überschritten -> Maximal-Wert setzen
      }
    }
    filedata[0] = matr_clks;                                          // Zeile 1 - Matrix-Taktfrequenz
    filedata[1] = matr_driv;                                          // Zeile 2 - Matrix-Treiber-Chip
    filedata[2] = matr_latb;                                          // Zeile 3 - Matrix-Latch-Blanking
    filedata[3] = matr_refr;                                          // Zeile 4 - Matrix-Bildwiederholfrequenz
    result = write_cfgfile(matr_filename, 4);                         // Matrix-Einstellungen ins Dateisystem schreiben
    if (result) { save = 1; reboot = true; }                          // wenn Speichern erfolgreich -> OK-Meldung und Neustart anfordern
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", matr_html, processor);          // Seite matr_html neu ausgeben und Variablen berabeiten
  });

  server.on("/wifi", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /wifi definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", wifi_html, processor);          // Seite wifi_html ausgeben und Variablen bearbeiten
  });

  server.on("/wifi", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /wifi
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "wifi_user") {                               // wenn Parameter wifi_user übergeben wurde
          wifi_ssid = p->value();                                     // Wert als String speichern
          wifi_ssid_p = wifi_ssid.c_str();                            // und als WLAN-SSID verwenden
        }
        if (p->name() == "wifi_pass") {                               // wenn Parameter wifi_pass übergeben wurde
          wifi_pass = p->value();                                     // Wert als String speichern
          wifi_pass_p = wifi_pass.c_str();                            // und als WLAN-Passwort verwenden
        }
      }
    }
    filedata[0] = wifi_ssid;                                          // Zeile 1 - WLAN-SSID
    filedata[1] = wifi_pass;                                          // Zeile 2 - WLAN-Passwort
    result = write_cfgfile(wifi_filename, 2);                         // WLAN-Zugangsdaten ins Dateisystem schreiben
    if (result) { save = 1; reboot = true; }                          // wenn Speichern erfolgreich -> OK-Meldung und Neustart anfordern
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", wifi_html, processor);          // Seite wifi_html neu ausgeben und Variablen berabeiten
  });

  server.on("/netw", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /netw definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", netw_html, processor);          // Seite netw_html ausgeben und Variablen bearbeiten
  });

  server.on("/netw", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /netw
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    err_flag = false;                                                 // Fehler-Flag löschen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    if (params > 0) netw_enab = false;                                // wenn mindestens ein Parameter übergeben wurde -> statische IP-Adresse zunächst deaktivieren
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "netw_enab") netw_enab = true;               // wenn Parameter netw_enab übergeben wurde -> Wert speichern (statische IP-Adresse aktivieren)
        if (p->name() == "netw_addr") {                               // wenn Parameter netw_addr übergeben wurde
          netw_addr = p->value();                                     // Wert als String speichern
          ipval = netw_addr.c_str();                                  // Zeiger setzen
          if (!IPaddr.fromString(ipval)) err_flag = true;             // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
          else netw_addr = IPaddr.toString();                         // Ergebnis in String zurückwandeln
        }
        if (p->name() == "netw_subn") {                               // wenn Parameter netw_subn übergeben wurde
          netw_subn = p->value();                                     // Wert als String speichern
          ipval = netw_subn.c_str();                                  // Zeiger setzen
          if (!IPsubn.fromString(ipval)) err_flag = true;             // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
          else netw_subn = IPsubn.toString();                         // Ergebnis in String zurückwandeln
        }
        if (p->name() == "netw_gate") {                               // wenn Parameter netw_gate übergeben wurde
          netw_gate = p->value();                                     // Wert als String speichern
          ipval = netw_gate.c_str();                                  // Zeiger setzen
          if (!IPgate.fromString(ipval)) err_flag = true;             // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
          else netw_gate = IPgate.toString();                         // Ergebnis in String zurückwandeln
        }
        if (p->name() == "netw_dns1") {                               // wenn Parameter netw_dns1 übergeben wurde
          netw_dns1 = p->value();                                     // Wert als String speichern
          ipval = netw_dns1.c_str();                                  // Zeiger setzen
          if (!IPdns1.fromString(ipval)) err_flag = true;             // ins IP-Format konvertieren, Fehler setzen wenn nicht erfolgreich
          else netw_dns1 = IPdns1.toString();                         // Ergebnis in String zurückwandeln
        }
      }
    }
    if (err_flag) netw_enab = false;                                  // wenn Konvertierung fehlgeschlagen ist -> statische IP-Adresse deaktivieren
    if (!err_flag) {                                                  // wenn kein Fehler-Flag gesetzt (IP-Werte sind plausibel)
      filedata[0] = netw_enab;                                        // Zeile 1 - statische IP-Adresse Aktivierung
      filedata[1] = netw_addr;                                        // Zeile 2 - IP-Adresse
      filedata[2] = netw_subn;                                        // Zeile 3 - Subnetzmaske
      filedata[3] = netw_gate;                                        // Zeile 4 - Gateway
      filedata[4] = netw_dns1;                                        // Zeile 5 - DNS
      result = write_cfgfile(netw_filename, 5);                       // IP-Einstellungen ins Dateisystem schreiben
      if (result) {                                                   // wenn Speichern erfolgreich
        save = 1;                                                     // OK-Meldung
        if (netw_enab) reboot = true;                                 // wenn statische IP-Adresse aktiviert -> Neustart anfordern
      }
      else save = 2;                                                  // wenn Speichern nicht erfolgreich -> Fehler
    }
    else save = 2;                                                    // wenn Fehler-Flag gesetzt (IP-Werte sind nicht plausibel) -> Fehler
    request->send_P(200, "text/html", netw_html, processor);          // Seite netw_html neu ausgeben und Variablen berabeiten
  });

  server.on("/mqtt", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /mqtt definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", mqtt_html, processor);          // Seite mqtt_html ausgeben und Variablen bearbeiten
  });

  server.on("/mqtt", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /mqtt
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    err_flag = false;                                                 // Fehler-Flag löschen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    if (params > 0) mqtt_enab = false;                                // wenn mindestens ein Parameter übergeben wurde -> MQTT-Aktivierung zunächst löschen
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "mqtt_enab") mqtt_enab = true;               // wenn Parameter mqtt_enab übergeben wurde -> MQTT aktivieren
        if (p->name() == "mqtt_addr") mqtt_addr = p->value();         // wenn Parameter mqtt_addr übergeben wurde -> Wert als String speichern
        if (mqtt_addr.length() == 0) err_flag = true;                 // wenn keine MQTT-Server-Addresse -> Fehler
        if (p->name() == "mqtt_port") mqtt_port = p->value();         // wenn Parameter mqtt_port übergeben wurde -> Wert als String speichern
        if (mqtt_port.length() == 0) err_flag = true;                 // wenn kein MQTT-Server-Port -> Fehler
        if (p->name() == "mqtt_user") mqtt_user = p->value();         // wenn Parameter mqtt_user übergeben wurde -> Wert als String speichern
        if (p->name() == "mqtt_pass") mqtt_pass = p->value();         // wenn Parameter mqtt_pass übergeben wurde -> Wert als String speichern
        if (p->name() == "mqtt_ltop") mqtt_ltop = p->value();         // wenn Parameter mqtt_ltop übergeben wurde -> Wert als String speichern
        if (p->name() == "mqtt_utop") mqtt_utop = p->value();         // wenn Parameter mqtt_utop übergeben wurde -> Wert als String speichern
        if (p->name() == "mqtt_rtop") mqtt_rtop = p->value();         // wenn Parameter mqtt_rtop übergeben wurde -> Wert als String speichern
        if (p->name() == "mqtt_vali") mqtt_vali = p->value().toInt(); // wenn Parameter mqtt_vald übergeben wurde -> Wert als Zahl speichern
        if (mqtt_vali < 2 || mqtt_vali > 60) mqtt_vali = 10;          // wenn Werte-Gültigkeit außerhalb des Bereiches -> Voreinstellung setzen
      }
    }
    if (err_flag) mqtt_enab = false;                                  // wenn fehlerhafte Werte -> MQTT deaktivieren
    if (mqtt_enab) {                                                  // wenn MQTT aktiviert
      mqtt_addr_p = mqtt_addr.c_str();                                // Zeiger auf MQTT-Adresse setzen
      mqtt_port_i = mqtt_port.toInt();                                // MQTT-Port in Zahl umwandeln
      if (mqtt_user.length() > 0) mqtt_user_p = mqtt_user.c_str();    // wenn MQTT-Username vorhanden -> Zeiger setzen
      else mqtt_user_p = nullptr;                                     // sonst Nullzeiger setzen
      if (mqtt_pass.length() > 0) mqtt_pass_p = mqtt_pass.c_str();    // wenn MQTT-Passwort vorhanden -> Zeiger setzen
      else mqtt_pass_p = nullptr;                                     // sonst Nullzeiger setzen
      if (mqtt_ltop.length() > 0) mqtt_ltop_p = mqtt_ltop.c_str();    // wenn MQTT LWT-Topic vorhanden -> Zeiger setzen
      else mqtt_ltop_p = nullptr;                                     // sonst Nullzeiger setzen
      if (mqtt_utop.length() > 0) mqtt_utop_p = mqtt_utop.c_str();    // wenn MQTT Uptime-Topic vorhanden -> Zeiger setzen
      else mqtt_utop_p = nullptr;                                     // sonst Nullzeiger setzen
      if (mqtt_rtop.length() > 0) mqtt_rtop_p = mqtt_rtop.c_str();    // wenn MQTT RSSI-Topic vorhanden -> Zeiger setzen
      else mqtt_rtop_p = nullptr;                                     // sonst Nullzeiger setzen
    }
    if (!err_flag) {                                                  // wenn kein Fehler-Flag gesetzt
      filedata[0] = mqtt_enab;                                        // Zeile 1 - MQTT Aktivierung
      filedata[1] = mqtt_addr;                                        // Zeile 2 - MQTT Server-Adresse
      filedata[2] = mqtt_port;                                        // Zeile 3 - MQTT Port
      filedata[3] = mqtt_user;                                        // Zeile 4 - MQTT Username
      filedata[4] = mqtt_pass;                                        // Zeile 5 - MQTT Passwort
      filedata[5] = mqtt_ltop;                                        // Zeile 6 - MQTT LWT-Topic
      filedata[6] = mqtt_utop;                                        // Zeile 7 - MQTT Uptime-Topic
      filedata[7] = mqtt_rtop;                                        // Zeile 8 - MQTT RSSI-Topic
      filedata[8] = mqtt_vali;                                        // Zeile 9 - MQTT Werte-Gültigkeit
      result = write_cfgfile(mqtt_filename, 9);                       // MQTT-Einstellungen ins Dateisystem schreiben
      if (result) {                                                   // wenn Speichern erfolgreich
        save = 1;                                                     // OK-Meldung
        if (mqtt_enab) reboot = true;                                 // wenn MQTT aktiviert -> Neustart anfordern
      }
      else save = 2;                                                  // wenn Speichern nicht erfolgreich -> Fehler
    }
    else save = 2;                                                    // wenn Fehler-Flag gesetzt -> Fehler
    request->send_P(200, "text/html", mqtt_html, processor);          // Seite mqtt_html neu ausgeben und Variablen berabeiten
  });

  server.on("/time", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /time definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", time_html, processor);          // Seite time_html ausgeben und Variablen bearbeiten
  });

  server.on("/time", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /time
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    err_flag = false;                                                 // Fehler-Flag löschen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "time_ntp1") {                               // wenn Parameter time_ntp1 übergeben wurde
          time_ntp1 = p->value();                                     // Wert als String speichern
          if (time_ntp1.length() == 0) err_flag = 1;                  // wenn NTP-Server 1 nicht angegeben -> Fehler
        }
        if (p->name() == "time_ntp2") {                               // wenn Parameter time_ntp2 übergeben wurde
          time_ntp2 = p->value();                                     // Wert als String speichern
        }
        if (p->name() == "time_zone") {                               // wenn Parameter time_zone übergeben wurde
          time_zone = p->value();                                     // Wert als String speichern
          if (time_zone.length() == 0) err_flag = 1;                  // wenn Zeitzonen-Information nicht angegeben -> Fehler
        }
        if (p->name() == "time_ival") {                               // wenn Parameter time_ival übergeben wurde
          time_ival = p->value().toInt();                             // Wert als Zahl speichern
          if (time_ival < 5 || time_ival > 60) time_ival = 30;        // wenn Wert außerhalb des Bereiches -> auf Default-Wert setzen
        }
      }
    }
    if (!err_flag) {                                                  // wenn kein Fehler
      filedata[0] = time_ntp1;                                        // Zeile 1 - NTP-Server 1
      filedata[1] = time_ntp2;                                        // Zeile 2 - NTP-Server 2
      filedata[2] = time_zone;                                        // Zeile 3 - Zeitzonen-Information
      filedata[3] = time_ival;                                        // Zeile 4 - Sync-Intervall
      result = write_cfgfile(time_filename, 4);                       // Zeit-Einstellungen ins Dateisystem schreiben
      if (result) { save = 1; reboot = true; }                        // wenn Speichern erfolgreich -> OK-Meldung und Neustart anfordern
      else save = 2;                                                  // wenn Speichern nicht erfolgreich -> Fehler
    }
    else save = 2;                                                    // wenn Fehler-Flag gesetzt -> Fehler
    request->send_P(200, "text/html", time_html, processor);          // Seite time_html neu ausgeben und Variablen berabeiten
  });

  server.on("/http", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /http definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", http_html, processor);          // Seite http_html ausgeben und Variablen bearbeiten
  });

  server.on("/http", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /http
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    if (params > 0) http_enab = false;                                // wenn mindestens ein Parameter übergeben wurde -> HTTP-Aktivierung zunächst löschen
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "http_enab") http_enab = true;               // wenn Parameter http_enab übergeben wurde -> Wert speichern (HTTP-Aktivierung)
        if (p->name() == "http_user") {                               // wenn Parameter http_user übergeben wurde
          http_user = p->value();                                     // Wert als String speichern
          http_user_p = http_user.c_str();                            // und als HTTP-Username verwenden
        }
        if (p->name() == "http_pass") {                               // wenn Parameter http_pass übergeben wurde
          http_pass = p->value();                                     // Wert als String speichern
          http_pass_p = http_pass.c_str();                            // und als HTTP-Passwort verwenden
        }
      }
    }
    filedata[0] = http_enab;                                          // Zeile 1 - HTTP-Aktivierung
    filedata[1] = http_user;                                          // Zeile 2 - HTTP-Username
    filedata[2] = http_pass;                                          // Zeile 3 - HTTP-Passwort
    result = write_cfgfile(http_filename, 3);                         // HTTP-Login-Einstellungen ins Dateisystem schreiben
    if (result) save = 1;                                             // wenn Speichern erfolgreich -> OK-Meldung
    else save = 2;                                                    // wenn Speichern nicht erfolgreich -> Fehler
    request->send_P(200, "text/html", http_html, processor);          // Seite http_html neu ausgeben und Variablen berabeiten
  });

  server.on("/test", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /test definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/temn", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /temn (Test-Funktionen/Normalmodus)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    disptest = 0;                                                     // Anzeige-Testmodus ausschalten
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/temr", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /temr (Test-Funktionen/Pixel rot)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    disptest = 1;                                                     // Anzeige-Testmodus Pixel rot einschalten
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/temg", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /temg (Test-Funktionen/Pixel grün)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    disptest = 2;                                                     // Anzeige-Testmodus Pixel grün einschalten
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/temb", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /temb (Test-Funktionen/Pixel blau)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    disptest = 3;                                                     // Anzeige-Testmodus Pixel blau einschalten
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/temw", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /temw (Test-Funktionen/Pixel weiß)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    disptest = 4;                                                     // Anzeige-Testmodus Pixel weiß einschalten
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/temm", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /temm (Test-Funktionen/Farbmuster)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    disptest = 5;                                                     // Anzeige-Testmodus Farbmuster einschalten
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/tes1", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /tes1 (Test-Funktionen/Sound 1)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    play_sound(0);                                                    // Sound 1 abspielen
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/tes2", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /tes2 (Test-Funktionen/Sound 2)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    play_sound(1);                                                    // Sound 2 abspielen
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/tes3", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /tes3 (Test-Funktionen/Sound 3)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    play_sound(2);                                                    // Sound 3 abspielen
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/tes4", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /tes4 (Test-Funktionen/Sound 4)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    play_sound(3);                                                    // Sound 4 abspielen
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/tes5", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /tes5 (Test-Funktionen/Sound 5)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    play_sound(4);                                                    // Sound 5 abspielen
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/tes6", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /tes6 (Test-Funktionen/Sound 6)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    play_sound(5);                                                    // Sound 6 abspielen
    request->send_P(200, "text/html", test_html, processor);          // Seite test_html ausgeben und Variablen bearbeiten
  });

  server.on("/file", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Ausgabe der Unterseite /file definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    filedir();                                                        // Dateiliste des Hauptverzeichnisses erstellen
    request->send_P(200, "text/html", file_html, processor);          // Seite file_html ausgeben und Variablen bearbeiten
  });

  server.on("/file", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /file (Dateimanager, Download)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    filenumb = 0;                                                     // Eingabe zunächst auf ungültigen Wert setzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "file_numb") filenumb = p->value().toInt();  // wenn Parameter file_numb übergeben wurde -> Wert speichern (Dateinummer)
      }
    }
    if (filenumb > 0 && filenumb <= filecount) {                      // wenn gültige Dateinummer
      filetemp = "/" + filenames[filenumb - 1];                       // Dateiname aus Liste holen
      request->send(LittleFS, filetemp, String(), true);              // Download starten
    }
    else {                                                            // wenn ungültige Dateinummer
      request->send_P(200, "text/html", file_html, processor);        // Seite file_html neu ausgeben und Variablen berabeiten
    }
  });

  server.on("/fdel", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /fdel (Dateimanager, Löschen)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    filenumb = 0;                                                     // Eingabe zunächst auf ungültigen Wert setzen
    int params = request->params();                                   // Anzahl der Parameter ermitteln
    for (int i = 0; i < params; i ++) {                               // Parameter nacheinander bearbeiten
      AsyncWebParameter* p = request->getParam(i);                    // Zeiger auf Parameter setzen
      if (p->isPost()) {                                              // wenn Post-Methode verwendet wird
        if (p->name() == "file_numb") filenumb = p->value().toInt();  // wenn Parameter file_numb übergeben wurde -> Wert speichern (Dateinummer)
      }
    }
    if (filenumb > 0 && filenumb <= filecount) {                      // wenn gültige Dateinummer
      filetemp = "/" + filenames[filenumb - 1];                       // Dateiname aus Liste holen
      result = false;                                                 // Ergebnis zunächst löschen
      if (filestat) LittleFS.remove(filetemp);                        // wenn Dateisystem vorhanden -> Datei löschen
      filedir();                                                      // Dateiliste des Hauptverzeichnisses erstellen
    }
    request->send_P(200, "text/html", file_html, processor);          // Seite file_html neu ausgeben und Variablen berabeiten
  });

  server.on("/upld", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, Upload-Steuerung definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send(200);
  },[](AsyncWebServerRequest *request, String filename, size_t index, uint8_t *data, size_t len, bool final) {
    if (!index) {                                                     // wenn Upload beginnt
      request->_tempFile = LittleFS.open("/" + filename, "w");        // neue Datei erstellen
    }
    if (len) {                                                        // wenn Daten empfangen wurden
      request->_tempFile.write(data, len);                            // in neue Datei schreiben
    }
    if (final) {                                                      // wenn Upload beendet
      request->_tempFile.close();                                     // Datei schließen
      reboot = true;                                                  // Neustart anfordern
      request->redirect("/file");                                     // Datei-Manager-Seite neu ausgeben
    }
  });

  server.on("/fwup", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Unterseite /fwup definieren
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    fwcount = 0;                                                      // Update-Bytezähler löschen
    fwupok = false;                                                   // Firmware-Update-Flag löschen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->send_P(200, "text/html", fwup_html, processor);          // Seite fwup_html ausgeben und Variablen bearbeiten
  });

  server.on("/fwup", HTTP_POST, [](AsyncWebServerRequest *request) {  // Web-Server, übergebene Informationen der Unterseite /fwup
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    if (Update.hasError()) save = 2;                                  // wenn Fehler -> Fehler-Status setzen
    else {                                                            // wenn erfolgreich
      if (fwcount > 0) {                                              // wenn Daten empfangen wurden
        save = 1;                                                     // OK-Meldung
        reboot = true;                                                // Neustart anfordern
      }
    }
    AsyncWebServerResponse *response = request->beginResponse_P(200, "text/html", fwup_html, processor); // Seite fwup_html neu ausgeben und Variablen bearbeiten
    response->addHeader("Connection", "close");                       // Verbindung beenden
    request->send(response);                                          // Daten senden
  },[](AsyncWebServerRequest *request, String filename, size_t index, uint8_t *data, size_t len, bool final){
    if (!index) {                                                     // wenn Upload beginnt
      disptest = 0;                                                   // Anzeige-Testmodus zurücksetzen (sonst keine Fortschrittsanzeige auf dem Display)
      if (nighttime) nacttout = 60;                                   // wenn Nachtzeit -> Display für 60s aktivieren
      Serial.printf("Firmware-Update: %s\n", filename.c_str());       // Start protokollieren
      if (!Update.begin((ESP.getFreeSketchSpace() - 0x1000) & 0xFFFFF000)) { // wenn nicht genügend Speicher vorhanden
        Update.printError(Serial);                                    // Fehlermeldung protokollieren
      }
    }
    if (!Update.hasError()) {                                         // wenn Upload bisher fehlerfrei
      fwcount = index + len;                                          // Update-Bytezähler aktualisieren
      if (Update.write(data, len) != len) {                           // wenn Fehler beim Schreiben der Daten
        Update.printError(Serial);                                    // Fehlermeldung protokollieren
      }
    }
    if (final) {                                                      // wenn Upload beendet
      if (Update.end(true)) {                                         // wenn Upload erfolgreich
        if (fwcount > 0) fwupok = true;                               // wenn Daten empfangen wurden -> Firmware-Update-Flag setzen
        Serial.printf("Firmware-Update ok: %u Bytes\n", index + len); // Upload-Ende protokollieren
      }
      else Update.printError(Serial);                                 // wenn Upload nicht erfolgreich -> Fehlermeldung protokollieren
    }
  });

  server.on("/boot", HTTP_GET, [](AsyncWebServerRequest *request) {   // Web-Server, Ausgabe der Hauptseite (Status) definieren (wird von /boot umgeleitet)
    if (http_enab) if (!request->authenticate(http_user_p, http_pass_p)) return request->requestAuthentication(); // gegebenenfalls Login durchführen
    save = 0;                                                         // Speicherstatus zurücksetzen
    request->redirect("/");                                           // zur Hauptseite wechseln
    boottout = BOOTTOUT;                                              // Neustart-Timer setzen
  });

  server.onNotFound(notFound);                                        // wenn Seite nicht gefunden wird
}

void loop() { // ======================================================= Hauptprogrammschleife ================================================================

  int8_t i, j;                                                        // Zählervariablen
  char hourh, hourl, minuteh, minutel;                                // Zehner/Einer für Stunden und Minuten
  char dayh, dayl;                                                    // Zehner/Einer für Sekunden und Kalendertag

  time(&utc);                                                         // UTC holen
  utcinfo = gmtime(&utc);                                             // (wird später für Ermittlung der Sonnenwerte benötigt)
  getLocalTime(&timeinfo);                                            // aktuelle Zeit holen
  year = timeinfo.tm_year + 1900;                                     // 4-stelliges Jahr ermitteln
  month = timeinfo.tm_mon + 1;                                        // Monat ermitteln (1-12)
  day = timeinfo.tm_mday;                                             // Tag ermitteln (1-31)
  wday = timeinfo.tm_wday + 1;                                        // Wochentag ermitteln (1-7, 1 = Sonntag)
  hour = timeinfo.tm_hour;                                            // Stunde ermitteln (0-23)
  minute = timeinfo.tm_min;                                           // Minute ermitteln (0-59)
  second = timeinfo.tm_sec;                                           // Sekunde ermitteln (0-59)

  if (lastsec != second) {                                            // wenn sich die Sekunde geändert hat
    lastmillis = millis();                                            // aktuellen Millisekundenwert zwischenspeichern
    lastsec = second;                                                 // neuen Sekundenwert zwischenspeichern
    timer1sec();                                                      // Timeout-Zähler 1s bearbeiten
  }
  if (millis() - ms40millis >= 40) {                                  // wenn 40ms vergangen
    ms40millis = millis();                                            // aktuellen Millisekundenwert zwischenspeichern
    timer40ms();                                                      // Timeout-Zähler-Funktion bearbeiten
  }
  if (millis() - scrollmillis >= 60 - scrolltime * 4) {               // wenn Scrollzeit abgelaufen (0-10 wird umgerechnet in 60-20 Millisekunden-Zyklen)
    scrollmillis = millis();                                          // aktuellen Millisekundenwert zwischenspeichern
    if (msgpbpos < msgpbend) msgpbpos += 2;                           // wenn Nachrichtenende noch nicht erreicht -> Zeiger auf nächste Pixelspalte (nächstes Bytepaar)
    else msgpbpos = -128;                                             // sonst auf 64 Pixelspalten vor den Anfang setzen
  }

  if (brightchg == 0 || dispmode == 3) set_bright();                  // wenn Helligkeits-Änderung direkt oder Anzeige im Systemstart-Modus -> Helligkeit einstellen

  // ------------------------------------------------------------------- Display-Ausgabe ----------------------------------------------------------------------

  if (disptest) {                                                     // wenn Anzeige-Testmodus eingeschaltet
    switch (disptest) {                                               // weitere Anzeige entsprechend Testmode
      case 1:                                                         // Modus Pixel rot
        display->fillRect(0, 0, 64, 32, matrix_color(0));             // alle Pixel rot
        break;
      case 2:                                                         // Modus Pixel grün
        display->fillRect(0, 0, 64, 32, matrix_color(4));             // alle Pixel grün
        break;
      case 3:                                                         // Modus Pixel blau
        display->fillRect(0, 0, 64, 32, matrix_color(8));             // alle Pixel blau
        break;
      case 4:                                                         // Modus Pixel weiß
        display->fillRect(0, 0, 64, 32, matrix_color(15));            // alle Pixel weiß
        break;
      case 5:                                                         // Modus Farbmuster
        for (i = 0; i < 8; i ++) {                                    // 8 Farbwerte in einer Reihe ausgeben
          for (j = 0; j < 8; j ++) {                                  // jeweils 8 Pixelbalken für jeden Farbwert
            display->drawLine(i * 8 + j, 0, i * 8 + j, 7, matrix_color(i));       // senkrechte Linie (8 Pixel) mit Farbwert 1-8 im oberen Viertel zeichnen
            display->drawLine(i * 8 + j, 8, i * 8 + j, 15, matrix_color(i + 8));  // senkrechte Linie (8 Pixel) mit Farbwert 9-16 im zweiten Viertel zeichnen
            display->drawLine(i * 8 + j, 16, i * 8 + j, 23, matrix_color(i));     // senkrechte Linie (8 Pixel) mit Farbwert 1-8 im dritten Viertel zeichnen
            display->drawLine(i * 8 + j, 24, i * 8 + j, 31, matrix_color(i + 8)); // senkrechte Linie (8 Pixel) mit Farbwert 9-16 im unteren Viertel zeichnen
          }
        }
        break;
    }
  }
  else {                                                              // wenn Anzeige-Testmodus ausgeschaltet
    hourh = hour / 10;                                                // Stunden-Zehner ermitteln
    hourl = hour % 10;                                                // Stunden-Einer ermitteln
    minuteh = minute / 10;                                            // Minuten-Zehner ermitteln
    minutel = minute % 10;                                            // Minuten-Einer ermitteln
    dayh = day / 10;                                                  // Kalendertag-Zehner ermitteln
    dayl = day % 10;                                                  // Kalendertag-Einer ermitteln
    color = color_clock();                                            // Uhr-Farbwert laden
    posx = 53;                                                        // X-Position für Sekunden
    posy = 0;                                                         // Y-Position für Sekunden
    matrix_digit3(second / 10, color);                                // Sekunden-Zehner ausgeben
    matrix_digit3(second % 10, color);                                // Sekunden-Einer ausgeben
    posx = 0;                                                         // X-Position für Stunden und Minuten
    posy = 0;                                                         // Y-Position für Stunden und Minuten

    if (dispmode == 0) {                                              // wenn normaler Anzeige-Modus aktiv
      if (hourh > 0) matrix_digit1(hourh, color);                     // wenn Zehner > 0 -> große Stunden-Zehner ausgeben
      posx = 12;                                                      // X-Position für Stunden-Einer
      matrix_digit1(hourl, color);                                    // große Stunden-Einer ausgeben
      posx += 4;                                                      // Platz für Doppelpunkt freihalten
      matrix_digit1(minuteh, color);                                  // große Minuten-Zehner ausgeben
      matrix_digit1(minutel, color);                                  // große Minuten-Einer ausgeben
      if (syncstat == 0) color = color_alarm();                       // wenn Uhr noch nicht synchronisiert -> Doppelpunkt hat Alarm-Farbe
      if (syncstat == 1) color = color_date();                        // wenn Sync-Ausfall -> Doppelpunkt hat Datum-Farbe
      if (lastmillis + 500 > millis()) {                              // wenn zweite Sekundenhälfte
        display->drawPixel(24, 5, color);                             // großen Doppelpunkt ausgeben (8 Pixel)
        display->drawPixel(24, 6, color);
        display->drawPixel(25, 5, color);
        display->drawPixel(25, 6, color);
        display->drawPixel(24, 11, color);
        display->drawPixel(24, 12, color);
        display->drawPixel(25, 11, color);
        display->drawPixel(25, 12, color);
        if (!WiFi.isConnected()) {                                    // wenn keine WLAN-Verbindung
          color = color_alarm();                                      // Alarm-Farbwert laden
          display->drawLine(24, 7, 24, 10, color);                    // Doppelpunkt zur Linie verbinden
          display->drawLine(25, 7, 25, 10, color);
        }
      }
      color = color_date();                                           // Datum-Farbwert laden
      posy = 9;                                                       // Y-Position für Kalender- oder Wochentag
      if (syncstat > 0) {                                             // wenn Uhr synchronisiert
        if ((smallmode == 0) || ((smallmode == 2) && (daymcount == 0))) { // wenn Kalendertag-Anzeige gewählt oder Wechselanzeige und Zähler = 0
          posx = 53;                                                  // X-Position für Kalendertag
          if (dayh == 0) posx = 56;                                   // wenn Tag einstellig -> X-Position auf Mitte
          else matrix_chrr(dayh + '0', color);                        // sonst Tag-Zehner ausgeben
          matrix_chrr(dayl + '0', color);                             // Tag-Einer ausgeben
        }
        else {                                                        // wenn Wochentag-Anzeige gewählt oder Wechselanzeige und Zähler = 1
          posx = 58 - strwr2(wday) / 2;                               // X-Position für zentrierten Wochentag (2 Zeichen)
          matrix_strr2(wday, color);                                  // Wochentag ausgeben (2 Zeichen)
        }
      }
      else {                                                          // wenn Uhr noch nicht synchronisiert
        posx = 56;                                                    // X-Position auf Mitte
        matrix_chrr('?', color);                                      // Fragezeichen ausgeben
      }

    }
    else {                                                            // bei allen anderen Anzeigemodi
      if (hourh > 0) matrix_digit2(hourh, color);                     // wenn Stunden-Zehner > 0 -> kleine Stunden-Zehner ausgeben
      posx = 12;                                                      // X-Position für Stunden-Einer
      matrix_digit2(hourl, color);                                    // kleine Stunden-Einer ausgeben
      posx += 4;                                                      // Platz für Doppelpunkt freihalten
      matrix_digit2(minuteh, color);                                  // kleine Minuten-Zehner ausgeben
      matrix_digit2(minutel, color);                                  // kleine Minuten-Einer ausgeben
      if (syncstat == 0) color = color_alarm();                       // wenn Uhr noch nicht synchronisiert -> Doppelpunkt hat Alarm-Farbe
      if (syncstat == 1) color = color_date();                        // wenn Sync-Ausfall -> Doppelpunkt hat Datum-Farbe
      if (lastmillis + 500 > millis()) {                              // wenn zweite Sekundenhälfte
        display->drawPixel(24, 1, color);                             // kleinen Doppelpunkt ausgeben (8 Pixel)
        display->drawPixel(24, 2, color);
        display->drawPixel(25, 1, color);
        display->drawPixel(25, 2, color);
        display->drawPixel(24, 5, color);
        display->drawPixel(24, 6, color);
        display->drawPixel(25, 5, color);
        display->drawPixel(25, 6, color);
        if (!WiFi.isConnected()) {                                    // wenn keine WLAN-Verbindung
          color = color_alarm();                                      // Alarm-Farbe laden
          display->drawLine(24, 3, 24, 4, color);                     // Doppelpunkt zur Linie Verbinden
          display->drawLine(25, 3, 25, 4, color);
        }
      }
    }

    if (dispmode < 3) {                                               // wenn normale, Alarm- oder Nachrichten-Anzeige aktiv
      color = color_date();                                           // Datum-Farbe laden
      posy = 21;                                                      // Y-Position für Datenfeld bei normaler Anzeige
      if (dispmode > 0) posy = 10;                                    // Y-Position für Datenfeld bei Alarm- und Nachrichten-Anzeige
      if (datacount == 0)  {                                          // wenn Datenfeld 0 ausgewählt (Datum)
        if (syncstat < 1) {                                           // wenn noch keine Synchronisierung
          posx = 32 - strw(9) / 2;                                    // X-Position für zentrierten Text "kein Datum"
          matrix_str(9, color, color);                                // Text ausgeben
        }
        else {                                                        // wenn Uhr synchronisiert
          posx = 32 - (chrw('0') * 8 + chrw('.') * 2 + 9) / 2;        // X-Position für zentriertes Datum (8 Ziffern, 2 Punkte und 9 Zwischenräume)
          matrix_chr(dayh + '0', color, color);                       // Tag-Zehner ausgeben
          matrix_chr(dayl + '0', color, color);                       // Tag-Einer ausgeben
          matrix_chr('.', color, color);                              // Punkt ausgeben
          matrix_chr(month / 10 + '0', color, color);                 // Monat-Zehner ausgeben
          matrix_chr(month % 10 + '0', color, color);                 // Monat-Einer ausgeben
          matrix_chr('.', color, color);                              // Punkt ausgeben
          matrix_chr(year / 100 / 10 + '0', color, color);            // Jahrhundert-Zehner ausgeben
          matrix_chr(year / 100 % 10 + '0', color, color);            // Jahrhundert-Einer ausgeben
          matrix_chr(year % 100 / 10 + '0', color, color);            // Jahr-Zehner ausgeben
          matrix_chr(year % 100 % 10 + '0', color, color);            // Jahr-Einer ausgeben
        }
      }
      if (datacount == 1) {                                           // wenn Datenfeld 1 ausgewählt (Wochentag)
        if (syncstat < 1) {                                           // wenn noch keine Synchronisierung
          posx = 32 - strw(10) / 2;                                   // X-Position für zentrierten Text "kein Tag"
          matrix_str(10, color, color);                               // Text ausgeben
        }
        else {                                                        // wenn Uhr synchronisiert
          posx = 32 - strw(wday) / 2;                                 // X-Position für zentrierten Wochentag
          matrix_str(wday, color, color);                             // Wochentag ausgeben
        }
      }
      if ((datacount > 1) && (datacount < 33)) {                      // wenn Datenfeld zwischen 2 und 32 ausgewählt (Sensorwert oder Geburtstag)
        posx = 32 - datafieldw(datacount - 2) / 2;                    // korrigierten Zähler als Index für das Datenfeld verwenden, X-Position für zentrierten Text ermitteln
        matrix_datafield(datacount - 2, color, color);                // Sensorwert oder Geburtstag ausgeben
      }
      if (datacount == 33) {                                          // wenn Datenfeld 33 ausgewählt (keine Daten)
        posx = 32 - strw(11) / 2;                                     // X-Position für zentrierten String "keine Daten"
        matrix_str(11, color, color);                                 // Text ausgeben
      }
      posy = 19;                                                      // Y-Position für Quittierungsanimation oder Stummschaltungszeile bei normaler Anzeige
      if (dispmode > 0) posy = 9;                                     // Y-Position für Quittierungsanimation oder Stummschaltungszeile bei Alarm- und Nachrichten-Anzeige

      if (quitcount < 32) {                                           // wenn Quittierungszähler aktiv
        display->drawLine(quitcount, posy, 63 - quitcount, posy, color_alarm()); // Pixelzeile in Alarmfarbe abhängig vom Quittierungszähler ausgeben (Animation)
      }
      else {                                                          // wenn Quittierungszähler nicht aktiv
        if (fwupok) {                                                 // wenn Firmware-Update erfolgreich
          for (i = 0; i < 32; i ++) {                                 // 32 Pixel ausgeben
            display->drawPixel(i * 2, posy, color_alarm());           // jedes zweite Pixel der Zeile in Alarmfarbe ausgeben
          }
        }
        else {                                                        // wenn Firmware-Update nicht erfolgreich (oder gar nicht aktiv)
          if (fwcount > 0) {                                          // wenn Firmware-Update aktiv
            display->drawLine(0, posy, fwcount * 64 / sketch, posy, color_alarm()); // Pixelzeile als Fortschrittsbalken in Alarm-Farbe ausgeben
          }
          else {                                                      // wenn kein Firmware-Update aktiv
            if (mute) {                                               // wenn Stummschaltung aktiv
              display->drawLine(0, posy, 63, posy, color_alarm());    // Pixelzeile in Alarmfarbe ausgeben
            }
          }
        }
      }
    }

    if (dispmode == 1) {                                              // wenn Alarm-Modus aktiv
      color = color_alarm();                                          // Alarm-Farbe laden
      coloru = color_date();                                          // Datum-Farbe für Unterstreichung laden
      posx = 32 - alarmfieldw(alarmcount) / 2;                        // X-Position für Alarmfeld (zentriert)
      posy = 21;                                                      // Y-Position für Alarmfeld
      if (alarmstat[alarmcount]) matrix_alarmfield(alarmcount, color, color); // wenn Alarm aktiv -> normal ausgeben
      else matrix_alarmfield(alarmcount, color, coloru);              // wenn Alarm nicht mehr aktiv -> Unterstreichung verwenden
    }

    if (dispmode == 2) {                                              // wenn Nachrichten-Modus aktiv
      uint8_t s1, s2;                                                 // Zwischenspeicher für Spaltenbytes
      for (i = 0; i < 64; i ++) {                                     // 64 Pixelspalten ausgeben
        if ((msgpbpos + (i * 2) < 0) || (msgpbpos + (i * 2) + 2 > msgpbend)) { // wenn aktuelle Pixelspalte vor oder nach der Nachricht
          s1 = 0;                                                     // Spaltenbyte 1 löschen
          s2 = 0;                                                     // Spaltenbyte 2 löschen
        }
        else {                                                        // wenn aktuelle Pixelspalte innerhalb der Nachricht
          s1 = msgpbuf[msgpbpos + (i * 2)];                           // Spaltenbyte 1 lesen
          s2 = msgpbuf[msgpbpos + (i * 2) + 1];                       // Spaltenbyte 2 lesen
        }
        for (j = 0; j < 3; j ++) {                                    // Spaltenbyte 1, Pixelzeile 0-2 bearbeiten
          if (s1 & 1) display->drawPixel(i, 21 + 2 - j, color_alarm()); // wenn Pixel gesetzt -> in LED-Matrix setzen
          s1 >>= 1;                                                   // Spaltenbyte auf nächste Bit-Position schieben
        }
        for (j = 0; j < 8; j ++) {                                    // Spaltenbyte 2, Pixelzeile 0-7 (entspricht 3-10) bearbeiten
          if (s2 & 1) display->drawPixel(i, 21 + 10 - j, color_alarm()); // wenn Pixel gesetzt -> in LED-Matrix setzen
          s2 >>= 1;                                                   // Spaltenbyte auf nächste Bit-Position schieben
        }
      }
    }

    if (dispmode == 3) {                                              // wenn Systemstart-Modus aktiv
      color = color_date();                                           // Datum-Farbwert laden
      posx = 32 - strw(8) / 2;                                        // X-Position für Zeile 1 der Versionsinformationen (zentriert)
      posy = 10;                                                      // Y-Position für Zeile 1 der Versionsinformationen
      matrix_str(8, color, color);                                    // "MatrixUhrESP" ausgeben
      posx = 32 - strw(0) / 2;                                        // X-Position für Zeile 2 der Versionsinformationen (zentriert)
      posy = 21;                                                      // Y-Position für Zeile 2 der Versionsinformationen
      color = color_alarm();                                          // Alarm-Farbwert laden
      matrix_str(0, color, color);                                    // Versionsnummer ausgeben
    }
  }
  display->flipDMABuffer();                                           // Display-Puffer umschalten
  display->clearScreen();                                             // Display löschen

  // ------------------------------------------------------------------- Berührungssensor abfragen und auswerten ----------------------------------------------

  if (touchstat && !touchsquit) {                                     // wenn Berührungssensor aktiv und kurze Berührung noch nicht quittiert
    touchsquit = true;                                                // kurze Berührung quittieren
    if (nighttime && nacttout == 255) {                               // wenn Nachtzeit und Timeout nicht aktiv
      nacttout = NACTTOUT;                                            // Nachtaktivierungs-Timeout starten
      set_bright();                                                   // Helligkeit einstellen
    }
    else {                                                            // sonst normale Sensor-Bearbeitung
      if (nighttime) nacttout = NACTTOUT;                             // wenn Nachtzeit -> Nachtaktivierungs-Timeout neu starten
      ack_alarms();                                                   // Alarme quittieren
      if (touchidle > 3 && touchidle < TOUCHIDLE) {                   // wenn zweite Berührung innerhalb der Pausenzeit
        message = F("IP: ");
        message += WiFi.localIP().toString();                         // IP-Adresse in String wandeln und als Textnachricht speichern
        if (WiFi.RSSI() < 0) {                                        // wenn sinnvoller RSSI-Wert
          message += " ";
          message += WiFi.RSSI();                                     // RSSI-Wert ergänzen
          message += F(" dBm");
        }
        process_msg(false);                                           // Textnachricht ohne Soundausgabe bearbeiten
      }
    }
  }
  if (touchlong == TOUCHTOUT && !touchlquit) {                        // wenn lange Berührung und noch nicht quittiert
    touchlquit = true;                                                // lange Berührung quittieren
    if (nighttime) nacttout = NACTTOUT;                               // wenn Nachtzeit -> Nachtaktivierungs-Timeout neu starten
    if (!mute) {                                                      // wenn Stummschaltung deaktiviert
      mute = true;                                                    // Stummschaltung aktivieren
      mincount = 0;                                                   // Minutenzähler zurücksetzen (zur genauen Zeitzählung für die Stummschaltung)
      mutetout = MUTETOUT;                                            // Timeout-Zähler starten
    }
    else mute = false;                                                // wenn Stummschaltung aktiv -> deaktivieren
  }

  // ------------------------------------------------------------------- Timeout-Zähler und Status auswerten --------------------------------------------------

  if (disptout == 0) {                                                // wenn Anzeige-Timeout-Zähler abgelaufen
    disptout = 255;                                                   // Timeout-Zähler stoppen
    dispmode = 0;                                                     // Anzeigemodus auf Normal setzen
    if (alarm_flag) dispmode = 1;                                     // wenn Alarme aktiv -> Anzeigemodus auf Alarm setzen
    if (msg_flag) dispmode = 2;                                       // wenn Nachricht aktiv -> Anzeigemodus auf Nachricht setzen
  }

  if (synctout == 0) {                                                // wenn Synchronisierungs-Timeout-Zähler abgelaufen
    synctout = 255;                                                   // Timeout-Zähler stoppen
    syncstat = 1;                                                     // Synchronisierungs-Status auf Sync-Ausfall setzen
  }

  if (mutetout == 0) {                                                // wenn Stummschaltungs-Timeout-Zähler abgelaufen
    mutetout = 255;                                                   // Timeout-Zähler stoppen
    mute = false;                                                     // Stummschaltung deaktivieren
  }

  if (nacttout == 0) nacttout = 255;                                  // Wenn Nachtaktivierungs-Timeout-Zähler abgelaufen -> stoppen

  if (hour != lasthour) {                                             // wenn Stundenwechsel
    lasthour = hour;                                                  // neue Stunde speichern
    color_random();                                                   // Farbwechsel durchführen
  }

  if (dispmode < 3) {                                                 // wenn normaler, Alarm- oder Nachrichten-Modus
    dispmode = 0;                                                     // Anzeigemodus zunächst auf Normal setzen
    if (alarm_flag) dispmode = 1;                                     // wenn Alarme aktiv -> Anzeigemodus auf Alarm setzen
    if (msg_flag) dispmode = 2;                                       // wenn Nachricht aktiv -> Anzeigemodus auf Nachricht setzen
  }

  if (wifitout == 0) {                                                // wenn WLAN-Timeout-Zähler abgelaufen
    wifitout = 255;                                                   // Timeout-Zähler stoppen
    if ((wifistat == 1) && (WiFi.status() != WL_CONNECTED)) {         // wenn WLAN im Offline-Zustand
      Serial.println(F("WLAN-Verbindung wiederherstellen"));
      WiFi.reconnect();                                               // WLAN-Verbindung wiederherstellen
    }
  }

  if (boottout == 0) {                                                // wenn Reboot-Timeout-Zähler abgelaufen
    Serial.println(F("System-Neustart"));
    WiFi.disconnect();                                                // WLAN-Verbindung trennen
    pinMode(OE_PIN, INPUT);                                           // Display-Ausgänge deaktivieren (Flackern beim Reboot reduzieren)
    delay(100);                                                       // kurze Wartezeit
    ESP.restart();                                                    // System-Neustart
  }

  if (soundtout == 0) {                                               // wenn Sound-Timeout-Zähler abgelaufen
    soundtout = 255;                                                  // Timeout-Zähler stoppen
    soundflags[5] = false;                                            // Stundengong ausschalten (verhindert Mehrfach-Auslösung)
  }

  if (millis() - luptmillis >= 60000) {                               // wenn mindestens eine Minute vergangen ist
    if (millis() >= luptmillis) luptmillis += 60000;                  // wenn Millisekundenwert normal -> Schwellwert auf nächste Minute setzen
    else luptmillis += 60000;                                         // sonst Schwellwert neu setzen (bei Überlauf des Millisekundenwertes)
    uptime_m ++;                                                      // Systemlaufzeit erhöhen
    uptime_strings();                                                 // formatierte Systemlaufzeit erstellen
    rssi = WiFi.RSSI();                                               // WLAN-Empfangssignal speichern
    if (mqttstat && mqttClient.connected()) {                         // wenn MQTT-Verbindung aktiv
      if (mqtt_utop_p) mqttClient.publish(mqtt_utop_p, 0, false, uptime);               // wenn MQTT-Topic für Systemlaufzeit definiert -> senden
      if (mqtt_rtop_p) mqttClient.publish(mqtt_rtop_p, 0, false, String(rssi).c_str()); // wenn MQTT-Topic für WLAN-Empfangssignal definiert -> senden
    }
  }

  if (weatherflag) {                                                  // wenn neue Wetterdaten empfangen wurden
    decode_weather();                                                 // Wetterdaten dekodieren
    weatherflag = false;                                              // Flag wieder löschen
  }
  if (fuelflag) {                                                     // wenn neue Kraftstoffdaten empfangen wurden
    decode_fuel();                                                    // Kraftstoffdaten dekodieren
    fuelflag = false;                                                 // Flag wieder löschen
  }
  for (i = 0; i < 8; i ++) {                                          // 8 Alarm-Flags bearbeiten
    if (alarmflags[i]) {                                              // wenn Alarm-Flag gesetzt (neue Meldung empfangen)
      alarmflags[i] = false;                                          // Alarm-Flag wieder löschen
      process_alarm(i);                                               // Alarm bearbeiten
    }
  }
  if (messageflag) {                                                  // wenn eine Textnachricht empfangen wurde
    process_msg(true);                                                // Textnachricht mit Soundausgabe bearbeiten
    messageflag = false;                                              // Flag wieder löschen
  }

  soundtime = false;                                                  // Sound-Zeit-Flag zunächst löschen
  if (sound_stim < sound_etim) {                                      // wenn Beginnzeit < Endzeit
    if (hour >= sound_stim && hour <= sound_etim) soundtime = true;   // wenn aktuelle Zeit innerhalb der Beginn- und Endzeit -> Sound-Zeit-Flag setzen
  }
  if (sound_stim > sound_etim) {                                      // wenn Beginnzeit > Endzeit
    if (hour >= sound_stim || hour <= sound_etim) soundtime = true;   // wenn aktuelle Zeit nach Beginnzeit oder vor Endzeit -> Sound-Zeit-Flag setzen
  }
  if (hour == sound_etim && minute > 0) soundtime = false;            // wenn Endzeit erreicht und Minute 0 überschritten -> Sound-Zeit-Flag löschen (Sound bleibt noch eine Minute länger aktiv)
  if (sound_stim == sound_etim) soundtime = true;                     // wenn Beginnzeit = Endzeit -> Sound-Zeit-Flag setzen, Sound bleibt ständig aktiv

  if (sound_enab && syncstat > 0 && sound_gong && soundtime &&        // wenn Sound aktiviert, Uhr synchronisiert, Stundengong eingeschaltet, Sound-Zeit-Flag gesetzt,
    !mute && minute == 0 && second == 0) soundflags[5] = true;        // keine Stummschaltung, Minuten = 0 und Sekunden = 0 -> Stundengong auslösen

  if (soundtout == 255) {                                             // wenn Sound-Timeout-Zähler gestoppt
    for (i = 0; i < 6; i ++) {                                        // 6 Sound-Flags prüfen
      if (soundflags[i]) {                                            // wenn Sound-Flag gesetzt
        soundflags[i] = false;                                        // Flag wieder löschen
        soundtout = SOUNDTOUT;                                        // Sound-Timeout starten
        play_sound(i);                                                // Sound abspielen
        break;                                                        // weitere Flags nicht prüfen
      }
    }
  }

  // ------------------------------------------------------------------- WLAN-Status und MQTT-Status auswerten und steuern ------------------------------------

  if (wifistat == 0) {                                                // wenn Verbindungsaufbau gestartet werden soll
    wifistat = 1;                                                     // neuen Status "offline" setzen
    if (WiFi.status() != WL_CONNECTED) {                              // wenn aktuell keine WLAN-Verbindung
      if (((uint8_t) wifi_ssid_p[0] > 0) && ((uint8_t) wifi_pass_p[0] > 0)) { // wenn SSID und Passwort vorhanden
        WiFi.begin(wifi_ssid_p, wifi_pass_p);                                 // Verbindungsaufbau starten
        Serial.println(F("WLAN-Verbindungsaufbau"));
      }
    }
  }
  if ((wifistat == 1) && (WiFi.status() == WL_CONNECTED)) {           // wenn WLAN von offline in den Online-Zustand wechselt
    wifistat = 2;                                                     // neuen Status "online" setzen
    server.begin();                                                   // Server-Dienst starten
    Serial.println(F("WLAN-Verbindung hergestellt"));
    Serial.print(F("IP: "));
    Serial.print(WiFi.localIP());                                     // IP-Adresse ausgeben
    rssi = WiFi.RSSI();
    Serial.print(F("  RSSI: "));
    Serial.println(rssi);
    cnt_wifi ++;
  }

  if ((wifistat == 2) && (WiFi.status() != WL_CONNECTED)) {           // wenn WLAN von online in den Offline-Zustand wechselt
    wifistat = 1;                                                     // neuen Status "offline" setzen
    Serial.println(F("WLAN-Verbindung unterbrochen"));
    wifitout = WIFITOUT;                                              // WLAN-Timeout-Zähler starten und neue Verbindung versuchen
  }

  if (wifistat == 2) {                                                // wenn WLAN-Status "online"
    if (!ntp_ok) {                                                    // wenn NTP-Dienst noch nicht gestartet
      sntp_set_sync_interval(time_ival * 60000);                      // NTP-Zeitsynchronisierungs-Intervall setzen (in Millisekunden)
      Serial.println(F("Synchronisierung wird gestartet"));
      configTime(0, 0, time_ntp1_p, time_ntp2_p);                     // NTP-Zeitsynchronisierung starten
      ntp_ok = true;                                                  // NTP-Dienst wurde gestartet
      cnt_ntp ++;
    }
    if (!mqtt_ok) {                                                   // wenn MQTT-Dienst noch nicht gestartet
      if (mqtt_actv) {                                                // wenn MQTT aktiviert
        mqttClient.onMessage(onMqttMessage);                          // Callback für empfangene MQTT-Nachrichten setzen
        mqttClient.setServer(mqtt_addr_p, mqtt_port_i);               // MQTT-Serverdaten konfigurieren
        mqttClient.setKeepAlive(60);                                  // Verbindungs-Timeout 60 Sekunden
        if (mqtt_user_p && mqtt_pass_p) mqttClient.setCredentials(mqtt_user_p, mqtt_pass_p); // wenn Username und Passwort gesetzt -> Zugangsdaten konfigurieren
        if (mqtt_ltop_p) mqttClient.setWill(mqtt_ltop_p, 0, true, mqtt_lmsg_p);              // wenn LWT-Topic gesetzt -> LWT konfigurieren
      }
      mqtt_ok = true;                                                 // MQTT-Dienst wurde gestartet
      cnt_mqtt ++;
    }
  }

  if ((wifistat == 2) && !mqttstat) {                                 // wenn WLAN im Online-Zustand und keine MQTT-Verbindung
    if (mqtttout == 255) {                                            // wenn Timeout-Zähler inaktiv
      if (mqtt_actv && !reboot) {                                     // wenn MQTT aktiviert und kein Reboot angefordert wurde
        mqttClient.connect();                                         // MQTT-Verbindung herstellen
        mqtttout = MQTTTOUT;                                          // MQTT-Timeout-Zähler starten
        Serial.println(F("MQTT-Verbindungsaufbau"));
      }
    }
  }

  if (mqtttout == 0) {                                                // wenn MQTT-Timeout-Zähler abgelaufen
    mqtttout = 255;                                                   // Timeout-Zähler stoppen
    if (wifistat == 2 && !mqttstat) {                                 // wenn WLAN im Online-Zustand und keine MQTT-Verbindung
      if (mqttClient.connected()) {                                   // wenn MQTT-Verbindung hergestellt
        if (mqtt_ltop_p) mqttClient.publish(mqtt_ltop_p, 0, true, mqtt_smsg_p); // wenn LWT-Topic gesetzt -> LWT-Startnachricht senden
        mqttstat = true;                                              // MQTT-Status auf online setzen
        Serial.println(F("MQTT-Verbindung hergestellt"));
        for (i = 0; i < 15; i ++) {                                   // 15 Datenfelder mit MQTT-Topics bearbeiten
          if (sensorlist_p[i]) mqttClient.subscribe(sensorlist_p[i], 0); // wenn MQTT-Topic vorhanden -> abonnieren
        }
        for (i = 0; i < 4; i ++) {                                    // 4 Alarmfelder mit MQTT-Topics bearbeiten
          if (alarmlist_p[i]) mqttClient.subscribe(alarmlist_p[i], 0); // wenn MQTT-Topic vorhanden -> abonnieren
        }
        if (call_alarm) {                                             // wenn Anrufanzeige aktiviert
          for (i = 0; i < 4; i ++) {                                  // 4 Anruffelder mit MQTT-Topics bearbeiten
            if (call_list_p[i]) mqttClient.subscribe(call_list_p[i], 0); // wenn MQTT-Topic vorhanden -> abonnieren
          }
        }
      }
      else {                                                          // wenn Verbindungsaufbau nicht erfolgreich
        Serial.println(F("MQTT-Fehler "));
      }
    }
  }

  if (mqttstat && !mqttClient.connected()) {                          // wenn MQTT-Status in den Offline-Status wechselt
    mqttstat = false;                                                 // neuen Status "offline" setzen
    Serial.println(F("MQTT-Verbindung unterbrochen"));
    mqtttout = MQTTTOUT;                                              // MQTT-Timeout-Zähler starten und neue Verbindung versuchen
  }

  // ------------------------------------------------------------------- Serielle Schnittstelle abfragen ------------------------------------------------------

  for (i = 0; i < Serial.available(); i ++) {                         // Schleife zum Abholen aller empfangenen Zeichen
    serialchar = Serial.read();                                       // empfangenes Zeichen holen
    if ((serialchar >= 32) && (serialstr.length() < 50)) {            // wenn kein Steuerzeichen und maximale Länge noch nicht erreicht
      serialstr += serialchar;                                        // empfangenes Zeichen an Puffer-String anhängen
      Serial.print(serialchar);                                       // empfangenes Zeichen als Echo wieder ausgeben
    }
    if (serialchar == '\n') {                                         // wenn empfangenes Zeichen Newline (ASCII 10)
      Serial.println();                                               // empfangenes Zeichen als Echo wieder ausgeben
      if (serialstr.length() > 0) {                                   // wenn zuvor Zeichen empfangen wurden
        if (lowercase(serialstr.substring(0, 4)) == "ssid") {         // wenn empfangener String mit "wifi" beginnt
          newssid = serialstr.substring(5);                           // der restliche String enthält die neue SSID
          Serial.print(F("SSID: "));
          Serial.println(newssid);                                    // eingegebene SSID zur Bestätigung ausgeben
        }
        if (lowercase(serialstr.substring(0, 4)) == "pass") {         // wenn empfangener String mit "pass" beginnt
          newpass = serialstr.substring(5);                           // der restliche String enthält das neue Passwort
          Serial.print(F("Pass: "));
          Serial.println(newpass);                                    // eingegebenes Passwort zur Bestätigung ausgeben
        }
        if (lowercase(serialstr) == "list") {                         // wenn empfangener String "list"
          Serial.print(F("SSID: "));
          if (newssid.length() > 0) Serial.println(newssid);          // wenn SSID eingegeben -> wieder ausgeben
          else Serial.println(F("<leer>"));
          Serial.print(F("Pass: "));
          if (newpass.length() > 0) Serial.println(newpass);          // wenn Passwort eingegeben -> wieder ausgeben
          else Serial.println(F("<leer>"));
        }
        if (lowercase(serialstr) == "save") {                         // wenn empfangener String "save"
          if (filestat) {                                             // wenn Dateisystem ok
            if ((newssid.length() > 0) && (newpass.length() > 0)) {   // wenn SSID und Passwort eingegeben
              filedata[0] = newssid;                                  // neue SSID in Dateipuffer legen
              filedata[1] = newpass;                                  // neues Passwort in Dateipuffer legen
              write_cfgfile(wifi_filename, 2);                        // WLAN-Zugangsdaten ins Dateisystem schreiben (2 Zeilen)
              Serial.println(F("Daten sind ok, Neustart"));
              if (filestat) LittleFS.remove(netw_filename);           // wenn Dateisystem vorhanden -> Netzwerkeinstellungen löschen
              boottout = BOOTTOUT;                                    // Neustart-Timer setzen
            }
            else Serial.println(F("Daten sind unvollstaendig"));
          }
          else Serial.println(F("Dateisystemfehler"));
        }
        serialstr = "";                                               // Puffer-String wieder löschen
      }
      else {                                                          // wenn keine Zeichen eingegeben wurden
        Serial.println(F("Kommandos:"));                              // Hilfetext ausgeben
        Serial.println(F("ssid SSID      (WLAN-Name eingeben)"));
        Serial.println(F("pass Passwort  (WLAN-Passwort eingeben)"));
        Serial.println(F("list           (WLAN-Daten zur Kontrolle anzeigen)"));
        Serial.println(F("save           (WLAN-Daten speichern und neu starten)"));
      }
    }
  }
}
