// AkkuTester1z.c
// Scott Falk Hühn
// Version 1.00, 01.11.2014

// Fuse-Bits-Einstellungen
//
// SELFPRGEN = [ ]
// DWEN =      [ ]
// BODLEVEL =  1V8
// RSTDISBL =  [ ]
// SPIEN =     [X]
// EESAVE =    [ ]
// WDTON =     [ ]
// CKDIV8 =    [ ]
// SUT_CKSEL = INTRCOSC_4MHZ8_14CK_0MS
// HIGH =      0xFD
// LOW =       0x71

// Belegung der I/O-Ports
// PB0 - Ausgang rote LED, Low-aktiv
// PB1 - Ausgang grüne LED, Low-aktiv
// PB2 - Ausgang, nicht genutzt
// PB3 - Eingang ADC
// PB4 - Ausgang, nicht genutzt
// PB5 - Ausgang, nicht genutzt

#include <avr/io.h>
#include <util/delay.h>
float vfactor = 4.3;                    // Spannungsteiler-Faktor bei 3,3k / 1k, wird durch folgende Formel errechnet: Faktor = (R1 + R2) / R2
float vlow = 3.8;                       // Spannungsschwelle für Akkuanzeige rot blinkend
float vhigh = 4.0;                      // Spannungsschwelle für Akkuanzeige grün
float volt;                             // ermittelter Spannungswert
uint8_t ledstat = 0;                    // letzter Status der roten LED, wird für Blinken benötigt

int main(void)
{
	DDRB =  (1 << PORTB0) | (1 << PORTB1) | (1 << PORTB2) | (1 << PORTB4) | (1 << PORTB5);  // PB0-PB2, PB4, PB5 auf Ausgang, PB3 auf Eingang setzen
	PORTB = (1 << PORTB0) | (1 << PORTB1);                                                  // PB0 und PB1 auf High setzen (LEDs aus)
	ADMUX = (1 << REFS0) | (1 << ADLAR) | (1 << MUX1) | (1 << MUX0);                        // Interne Referenz 1,1V, ADC-Wert linksbündig, ADC3 (PB3) auswählen
	ADCSRA = (1 << ADEN) | (1 << ADSC) | (1 << ADATE) | (1 << ADPS2) | (1 << ADPS1);	    // ADC aktivieren, Conversion starten, Vorteiler = 64 (75 kHz)
	ADCSRB = 0;														                        // Trigger - Free Running Mode
	DIDR0 = 1 << ADC3D;												                        // Digital-Eingang von ADC3 (PB3) deaktivieren

    while(1)
    {
        _delay_ms(200);                                                                     // ADC-Conversion alle 200ms, bestimmt auch die Blinkfrequenz
        volt = ADCH * 1.1 * vfactor / 256;                                                  // Spannungswert berechnen
        ledstat = PORTB;                                                                    // Status von PortB (speziell rote LED) speichern
        PORTB = (1 << PORTB0) | (1 << PORTB1);                                              // beide LEDs auschalten
        if (volt > vhigh) PORTB = PORTB & ~ (1 << PORTB1);                                  // wenn Spannung im grünen Bereich -> grüne LED einschalten
        else                                                                                // sonst
        {
            PORTB = PORTB & ~ (1 << PORTB0);                                                // rote LED einschalten
            if (volt < vlow)                                                                // wenn Unterspannung
            {
                ledstat = ledstat ^ (1 << PORTB0);                                          // letzten Status der roten LED invertieren
                PORTB = (PORTB & ~ (1 << PORTB0)) | ledstat;                                // rote LED neu setzen (blinken)
            }
        }
    }
}