; ======================================================
; Akku-berwachung fr 2 oder 3 LiPo-Zellen mit ATtiny13
; ======================================================
;
; Version 1.00 (08.03.2008)
;
; Fuse-Bits:	BODLEVEL1=0	\ Spannung
;		BODLEVEL0=1	/ =2,7V
;		CKSEL1=1	\ Interner Oszillator
;		CKSEL0=0	/ =9,6MHz
;		CKDIV8=0	- Vorteiler /8 ein
;		SUT1=1		\ Maximale
;		SUT0=0		/ Startverzgerung
;
; Ports:	B0 - Eingang (Pull-up)	J1 Schwellenoffset 1 (+100mV)
;		B1 - Eingang (Pull-up)	J2 Schwellenoffset 2 (+200mV)
;		B2 - Eingang (Pull-up)	J3 Ton-Modus, ohne 1Hz-Signal
;		B3 - Ausgang (H-aktiv)	LED-Treiber
;		B4 - Eingang (analog)	Messeingang
;		B5 - Eingang (Pull-up)	Reset
;
; Timer:	Timer0, zyklischer Interrupt bei Taktfrequenz
;		1,2MHz, VT=1024, Zhler=75 -> 15,625Hz/64ms
;
.nolist
.include "tn13def.inc"
.list
;
; Der folgende Wert "thresh" muss solange gendert werden, bis die
; Schaltung bei der Unterschreitung der folgenden Schwellen anspricht.
; Ein hherer Wert ergibt eine hhere Spannungsschwelle.
;
; 2 LiPo-Zellen: 6,3V
; 3 LiPo-Zellen: 9,5V
;
.equ	thresh=	890		;anpassen (im Bereich 850-930)
;
; Die folgenden Werte brauchen nicht gendert werden
;
.equ	offs01=	15		;Schwellenoffset 1: 100mV (3Z: 150mV)
.equ	offs02=	30		;Schwellenoffset 2: 200mV (3Z: 300mV)
;
.cseg
.org	0
;
reset:	rjmp	start		;Programm-Beginn
int0ad:	reti			;External Int 0 (nicht genutzt)
pci0ad:	reti			;External IntReq 0 (nicht genutzt)
ovf0ad:	reti			;Timer0 Overflow (nicht genutzt)
erdyad:	reti			;EEPROM Ready (nicht genutzt)
aciadd:	reti			;Analog Comparator (nicht genutzt)
oc0aad:	rjmp	timer0		;Timer0 Compare Match A (alle 64ms)
oc0bad:	reti			;Timer0 Compare Match B (nicht genutzt)
wdtadd:	reti			;Watchdog Time-out (nicht genutzt)
adccad:	reti			;ADC Conversion Complete (nicht gen.)
;
start:	ldi	r16,0b001000		;Port B3 auf Ausgang setzen
	out	ddrb,r16
	ldi	r16,0b101111		;Ausgang=1, Eingnge=1 setzen
	out	portb,r16		;Pull-up fr Reset und Jumper
;
	ldi	r20,3			;3 Wartezyklen je 300ms
sta010:	ldi	r19,2			;\
	ldi	r18,212			; > Zeitkonstanten fr 300ms
	ldi	r17,0			;/
sta020:	dec	r17			;innerer Zhler -1
	brne	sta020			;Schleife
	dec	r18			;mittlerer Zhler -1
	brne	sta020			;Schleife
	dec	r19			;uerer Zhler -1
	brne	sta020			;Schleife
;
	ldi	r17,0b001000		;Maske fr LED-Ausgang
	eor	r16,r17			;LED-Ausgang invertieren
	out	portb,r16		;neuen Portstatus ausgeben
	dec	r20			;weitere Wartezyklen?
	brne	sta010			;nein -> Schleife
;
	clr	r16
	out	tcnt0,r16		;Timer0 Zhler lschen
	ldi	r16,1<<wgm01		;CTC-Modus aktivieren
	out	tccr0a,r16
	ldi	r16,0b101<<cs00		;Vorteiler=1024 setzen
	out	tccr0b,r16

	ldi	r16,74			;Timerwert fr 15,625Hz/64ms
	out	ocr0a,r16		;setzen
	ldi	r16,1<<ocie0a		;Timer0 Compare Match A
	out	timsk0,r16		;Interrupt einschalten
;
	ldi	r16,(1<<refs0)+(0b10<<mux0);interne Referenz und B4
	out	admux,r16		;als Eingang setzen
	ldi	r16,(1<<aden)+(1<<adsc)+(1<<adps2);ADC ein, Start,
	out	adcsra,r16		;Vorteiler=16
	ldi	r16,1<<adc2d		;Digital Input Disable B4
	out	didr0,r16		;setzen
;
	ldi	r16,low(thresh+offs01+offs02)	;maximalen
	ldi	r17,high(thresh+offs01+offs02)	;Schwellwert holen
	mov	r0,r16
	mov	r1,r17			;Tabellenplatz 0 voreinstellen
	mov	r2,r16
	mov	r3,r17			;Tabellenplatz 1 voreinstellen
	mov	r4,r16
	mov	r5,r17			;Tabellenplatz 2 voreinstellen
	mov	r6,r16
	mov	r7,r17			;Tabellenplatz 3 voreinstellen
;
	clr	r25			;Interrupt-Zhler lschen
	clr	r24			;Zyklus-Zhler lschen
	wdr				;Watchdog-Timer zurcksetzen
	ldi	r16,(1<<wde)+(0b111<<wdp0);Watchdog ein, 256k Teiler
	out	wdtcr,r16		;setzen (Zykluszeit=2s)
	sei				;Interrupt aktivieren
;
main:	rjmp	main			;Endlos-Schleife
;
; Timer0 Compare Match A Interrupt (15,625Hz/64ms)
;
timer0:	mov	r6,r4
	mov	r7,r5			;Wert in Tabelle verschieben
	mov	r4,r2
	mov	r5,r3			;Wert in Tabelle verschieben
	mov	r2,r0
	mov	r3,r1			;Wert in Tabelle verschieben
	in	r0,adcl
	in	r1,adch			;neuen ADC-Wert holen
;
	mov	r18,r0
	mov	r19,r1			;ADC-Wert aus Tabelle holen
	add	r18,r2
	adc	r19,r3			;nchsten Wert addieren
	add	r18,r4
	adc	r19,r5			;nchsten Wert addieren
	add	r18,r6
	adc	r19,r7			;nchsten Wert addieren
	lsr	r19
	ror	r18			;Ergebnis halbieren
	lsr	r19
	ror	r18			;Ergebnis nochmals halbieren
;
	sbi	adcsra,adsc		;neue Conversion starten
	ldi	r16,low(thresh)
	ldi	r17,high(thresh)	;Schwellwert holen
	in	r8,pinb			;Jumper-Ports einlesen
;
	bst	r8,0			;J1 (100mV Offset) gesetzt?
	brts	tim010			;nein -> Addition berspringen
	ldi	r20,low(offs01)
	ldi	r21,high(offs01)	;Offset-Wert fr 100mV holen
	add	r16,r20
	adc	r17,r21			;Offset-Wert addieren
;
tim010:	bst	r8,1			;J2 (200mV Offset) gesetzt?
	brts	tim020			;nein -> Addition berspringen
	ldi	r20,low(offs02)
	ldi	r21,high(offs02)	;Offset-Wert fr 200mV holen
	add	r16,r20
	adc	r17,r21			;Offset-Wert addieren
;
tim020:	sub	r18,r16			;Schwellwert unterschritten?
	sbc	r19,r17			;Ergebnis in Carry
;
; Spannung normal: LED-Blitzen mit 1Hz (64ms Impulse)
; Spannung unterschritten: LED-Blinken mit 8Hz (64ms/64ms)
; Ton-Ausgabe nur bei Spannungs-Unterschreitung
;
	inc	r25			;Interrupt-Zhler holen
	andi	r25,0x01		;Wert begrenzen
	breq	tim040			;war Zhler=0? ja -> LED ein
;
tim030:	breq	tim060			;falls Zyklus=0 -> LED ein
	ldi	r16,0b100111		;sonst LED ausschalten
	rjmp	tim070			;Portdaten ausgeben
;
tim040:	wdr				;Watchdog-Timer zurcksetzen
	inc	r24			;sonst nchster Wartezyklus
	andi	r24,0x07		;Wert begrenzen
	bst	r8,2			;Ton-Modus gesetzt?
	brts	tim050			;nein -> Schwelle auswerten
	clz				;sonst Zero-Flag lschen
tim050:	brcc	tim030			;war Schwelle ok? -> LED aus
;
tim060:	ldi	r16,0b101111		;sonst LED einschalten
tim070:	out	portb,r16		;neuen Portstatus ausgeben
	reti
;
; Speicherung des Spannungsschwellwertes, hat fr die Funktion keine
; Bedeutung
;
.db	low(thresh),high(thresh)
