;	Bigben-Gong
;
;	Version 1.04, letzte Bearbeitung am 26.02.2009
;
;	Quarzfrequenz 4,433619 MHz ermglicht eine relativ genaue
;	Erzeugung der Samplefrequenz von 22050 Hz (22056 Hz)
;
;	Belegung der I/O-Ports:
;
;	PortD0: EPROM-Adresse A0
;	PortD1: EPROM-Adresse A1
;	PortD2: EPROM-Adresse A2
;	PortD3: EPROM-Adresse A3
;	PortD4: EPROM-Adresse A4
;	PortD5: EPROM-Adresse A5
;	PortD6: EPROM-Adresse A6
;	PortD7: EPROM-Adresse A7
;
;	PortC0: EPROM-Adresse A8
;	PortC1: EPROM-Adresse A9
;	PortC2: EPROM-Adresse A10
;	PortC3: EPROM-Adresse A11
;	PortC4: EPROM-Adresse A12
;	PortC5: EPROM-Adresse A13
;
;	PortB0: EPROM-Adresse A14
;	PortB1: EPROM-Adresse A15
;	PortB2: EPROM-Adresse A16
;	PortB3: EPROM-Adresse A17 (ungenutzt bei 27C1001)
;	PortB4: LED zur Betriebskontrolle (0=LED ein)
;	PortB5: Steuer-Eingang mit Pull-up (0=Start)
;
.include "2333def.inc"
;
.cseg
.org	0x0000
;
reset:	rjmp	start			;Programmstart
exint0:	reti				;nicht genutzt
exint1:	reti				;nicht genutzt
t1capt:	reti				;nicht genutzt
t1comp:	reti				;nicht genutzt
t1ovfl:	reti				;nicht genutzt
t0ovfl:	reti				;nicht genutzt
spistc:	reti				;nicht genutzt
uartrx:	reti				;nicht genutzt
uartem:	reti				;nicht genutzt
uarttx:	reti				;nicht genutzt
adccom:	reti				;nicht genutzt
ee_rdy:	reti				;nicht genutzt
ancomp:	reti				;nicht genutzt
;
;	Initialisierung
;
start:	cli				;Interrupts sperren
	wdr				;Watchdogtimer zurcksetzen
	ldi	r16,0b00001110		;Watchdog aktivieren (1000ms)
	out	wdtcr,r16
	ldi	r16,low(ramend)
	out	spl,r16			;Stackpointer setzen
	ldi	r16,0xff
	out	ddrd,r16		;PortD, alles Ausgnge (8)
	ldi	r16,0x3f
	out	ddrc,r16		;PortC, alles Ausgnge (6)
	ldi	r16,0x1f
	out	ddrb,r16		;PortB, B5=Eingang, Rest Ausgnge
	clr	r16
	out	portd,r16		;PortD, alle Ausgnge auf 0
	out	portc,r16		;PortC, alle Ausgnge auf 0
	ldi	r16,0x30		;PortB, EPROM-Ausgnge auf 0,
	out	portb,r16		;LED (B4) und Pullup (B5) auf 1
;
;	Warteschleife 2s
;
	ldi	r18,200
	rcall	wait10
;
;	Warten auf Startsignal, LED-Blinken 20ms/1980ms (2s)
;
read:	ldi	r16,0x20		;LED einschalten
	out	portb,r16		;ausgeben
	in	r16,pinb		;PortB einlesen
	bst	r16,5			;Startsignal (0)?
	brtc	gong			;ja -> Gong starten
	ldi	r18,1			;Warteschleife 10ms
	rcall	wait10
	in	r16,pinb		;PortB einlesen
	bst	r16,5			;Startsignal (0)?
	brtc	gong			;ja -> Gong starten
	ldi	r18,1			;Warteschleife 10ms
	rcall	wait10
;
	ldi	r16,0x30		;LED ausschalten
	out	portb,r16		;ausgeben
	ldi	r22,198			;Zhler fr 1980ms setzen
read1:	in	r16,pinb		;PortB einlesen
	bst	r16,5			;Startsignal (0)?
	brtc	gong			;ja -> Gong starten
	ldi	r18,1			;Warteschleife 10ms
	rcall	wait10
	dec	r22			;198 Zyklen beendet?
	brne	read1			;nein -> Schleife
	rjmp	read			;sonst neuer Zyklus
;
;	Gongausgabe, Zykluszeit=45,335s =22059Hz, (normal: 22050Hz)
;
gong:	ldi	r16,0x30		;LED ausschalten
	out	portb,r16		;ausgeben
	clr	r16			;Zhler(L)=0, H+M+L ergeben
	clr	r17			;Zhler(M)=0, zusammen einen
	clr	r18			;Zhler(H)=0, 18-Bit-Zhler
	clr	r19			;wird zur Zhlung bentigt
	ldi	r20,0x30		;PortB gesetzte Bits (B4,B5)
loop1:	mov	r0,r17			;Zhler(M) zwischenspeichern
	mov	r1,r18			;Zhler(H) zwischenspeichern
	clc				;Carry lschen
	rol	r0
	rol	r1			;obere 2 Bits von Zhler(M)
	rol	r0			;in untere 2 Bits von Zhler(H)
	rol	r1			;schieben
	or	r1,r20			;gesetzte Bits von PortB ergnzen
	out	portd,r16		;Bits 0-7 ausgeben
	out	portc,r17		;Bits 8-13 ausgeben
	out	portb,r1		;Bits 14-17 ausgeben
	sec				;Carry setzen
	adc	r16,r19			;Zhler(L) erhhen
	adc	r17,r19			;Zhler(M) korrigieren
	adc	r18,r19			;Zhler(H) korrigieren
	wdr				;Watchdogtimer zurcksetzen
	nop
	nop
	ldi	r21,60
loop2:	dec	r21			;Warteschleife zur Anpassung
	brne	loop2			;Frequenz von ca. 22050 Hz
;	cpi	r18,4			;Ende erreicht (bei 27C2001)?
	cpi	r18,2			;Ende erreicht (bei 27C1001)?
	brcs	loop1			;ja -> Schleife
;
;	Warten auf Ende des Startsignals
;
	ldi	r20,0x30		;PortB-Status LED aus
	out	portd,r16		;alle Bits zurcksetzen
	out	portc,r17		;(EPROM-Adresse=0)
	out	portb,r20
	clr	r19			;Wartezhler lschen
read2:	in	r16,pinb		;PortB einlesen
	bst	r16,5			;Startsignal noch aktiv (0)?
	brtc	read3			;ja -> weiter
	inc	r19			;sonst Wartezhler erhhen
	ldi	r16,0x30		;und LED ausschalten
	rjmp	read4
read3:	clr	r19			;Wartezhler zurcksetzen
	ldi	r16,0x20		;und LED einschalten
read4:	out	portb,r16
	ldi	r18,1			;Warteschleife 10ms
	rcall	wait10
	cpi	r19,100			;Taste 1s losgelassen?
	brcs	read2			;nein -> weiter testen
	rjmp	read			;zurck in die Hauptschleife
;
;	Warteschleife 10 ms (r18 enthlt Anzahl der Zyklen)
;
wait10:	clr	r16
wait11:	ldi	r17,57
wait12:	dec	r16
	brne	wait12
	wdr				;Watchdogtimer zurcksetzen
	dec	r17
	brne	wait12
	dec	r18
	brne	wait11
	ret
;
